/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eps.scene;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.cp.eps.scene.ISceneService;
import com.kingdee.eas.cp.eps.search.SearchParameters;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class AbstractSceneService
implements ISceneService {
    protected Context ctx;
    protected int totalCount = 0;
    protected String queryKey;
    protected SearchParameters sp;
    protected EntityViewInfo entityViewInfo;

    public Context getContext() {
        return this.ctx;
    }

    public void init(Context ctx, SearchParameters sp) {
        this.ctx = ctx;
        this.sp = sp;
    }

    protected abstract IMetaDataPK getQueryPK();

    protected abstract String getUrl(IRowSet var1);

    protected abstract Map getRowResult(IRowSet var1);

    public List getAllData() {
        this.queryKey = this.sp.getKey();
        LinkedList<Map> pageList = new LinkedList<Map>();
        try {
            IQueryExecutor QueryExecutor = this.getQueryExecutor();
            IRowSet rs = QueryExecutor.executeQuery();
            if (rs != null) {
                this.totalCount = rs.size();
                while (rs.next()) {
                    pageList.add(this.getRowResult(rs));
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return pageList;
    }

    public List getData() {
        LinkedList<Map> pageList;
        block5: {
            this.queryKey = this.sp.getKey();
            int start = this.sp.getStartNum();
            int limit = this.sp.getPageSize();
            pageList = new LinkedList<Map>();
            try {
                IQueryExecutor QueryExecutor = this.getQueryExecutor();
                QueryExecutor.option().pageCount = limit;
                IRowSet rs = QueryExecutor.executeQuery();
                if (rs == null) break block5;
                this.totalCount = rs.size();
                int number = 0;
                while (rs.next()) {
                    if (number < start) continue;
                    if (number < start + limit) {
                        pageList.add(this.getRowResult(rs));
                        ++number;
                        continue;
                    }
                    break;
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return pageList;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    public IQueryExecutor getQueryExecutor() throws BOSException {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)this.ctx, (IMetaDataPK)this.getQueryPK());
        exec.setObjectView(this.getEntityViewInfo());
        exec.option().isIgnoreOrder = false;
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    public EntityViewInfo getEntityViewInfo() {
        if (this.entityViewInfo == null) {
            this.entityViewInfo = new EntityViewInfo();
            this.entityViewInfo.setFilter(this.getFilterInfo());
        }
        return this.entityViewInfo;
    }

    public abstract FilterInfo getFilterInfo();
}

