/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.mc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IFormatter;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.workflow.metas.IProcDef;
import com.kingdee.bos.workflow.metas.ProcDefFactory;
import com.kingdee.bos.workflow.metas.ProcDefInfo;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.NewOrgUnitHelper;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewOrgF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.mc.ProcSelectedInfo;
import com.kingdee.eas.cp.eip.mc.client.AbstractDelegateUI;
import com.kingdee.eas.cp.eip.mc.client.ProcF7Selector;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class DelegateUI
extends AbstractDelegateUI {
    private static final long serialVersionUID = 6649678181814020602L;
    private static final Logger logger = CoreUIObject.getLogger(DelegateUI.class);
    private OrgUnitInfo orgUnitInfo = null;
    private Date effectDate1 = null;
    private Date planInvalidDate1 = null;
    private ProcF7Selector procF7 = new ProcF7Selector((Component)((Object)this));

    public DelegateUI() throws Exception {
        this.F7Init();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.addListenerInit();
    }

    public void initData() throws Exception {
        this.F7Init();
    }

    public boolean verify() {
        Date date1 = (Date)this.kDDatePicker1.getValue();
        Date date2 = (Date)this.kDDatePicker2.getValue();
        if (date1 != null && date2 != null && date2.before(date1)) {
            this.kDDatePicker2.requestFocusInWindow();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.cp.eip.mc.JobDelegateException", (String)"dateNotRight"));
            return false;
        }
        return super.verify();
    }

    private void F7Init() throws EASBizException, BOSException {
        NewOrgF7 orgf7 = new NewOrgF7((IUIObject)this);
        orgf7.setMultiSelect(false);
        this.prmtOrg.setSelector((KDPromptSelector)orgf7);
        this.prmtOrg.setDisplayFormat("$name$");
        this.prmtOrg.setEditFormat("$name$");
        this.prmtOrg.setEnabledMultiSelection(false);
        this.prmtOrg.setCommitFormat("$id$");
        this.prmtPro.setSelector((KDPromptSelector)this.procF7);
        this.prmtPro.setDisplayFormatter((IFormatter)new MyFormatter());
        this.prmtPro.setEditFormatter((IFormatter)new MyFormatter());
        this.prmtPro.setCommitFormat("$id$");
        this.kDDatePicker1.setDatePattern("yyyy-MM-dd HH:mm:ss");
        this.kDDatePicker1.setTimeEnabled(true);
        this.kDDatePicker2.setDatePattern("yyyy-MM-dd HH:mm:ss");
        this.kDDatePicker2.setTimeEnabled(true);
    }

    private void addListenerInit() {
        this.prmtOrg.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                Object newValue = eventObj.getNewValue();
                if (newValue == null) {
                    String[] orgFilter = new String[]{""};
                    DelegateUI.this.procF7.setFliter(orgFilter);
                    DelegateUI.this.proName.setEnabled(false);
                    DelegateUI.this.prmtPro.setValue(null);
                } else {
                    OrgUnitInfo info = (OrgUnitInfo)newValue;
                    String[] orgType = NewOrgUnitHelper.getBizOrgUnitTypes((OrgUnitInfo)info);
                    String[] orgFilter = new String[1];
                    StringBuffer str = new StringBuffer("");
                    for (int k = 0; k <= orgType.length - 1; ++k) {
                        str.append(orgType[k]);
                        str.append(".");
                    }
                    if (info.isIsCU()) {
                        str.append("ControlUnit");
                    }
                    orgFilter[0] = str.toString();
                    DelegateUI.this.procF7.setFliter(orgFilter);
                    DelegateUI.this.proName.setEnabled(true);
                    DelegateUI.this.prmtPro.setValue(null);
                }
            }
        });
        this.proName.setEnabled(false);
    }

    public void clear() {
        this.prmtOrg.setValue(null);
        this.prmtPro.setValue(null);
        this.kDDatePicker1.setValue(null);
        this.kDDatePicker2.setValue(null);
    }

    public void setCustomerParams(CustomerParams cp) {
        Date cDate;
        SimpleDateFormat df;
        this.prmtOrg.setValue(null);
        this.prmtPro.setValue(null);
        this.kDDatePicker1.setValue(null);
        this.kDDatePicker2.setValue(null);
        if (cp == null) {
            return;
        }
        if (cp.getCustomerParam("orgId") != null) {
            OrgUnitInfo info = null;
            try {
                IFullOrgUnit iOrg = FullOrgUnitFactory.getRemoteInstance();
                info = iOrg.getOrgUnitInfo((IObjectPK)new ObjectUuidPK(cp.getCustomerParam("orgId")));
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            this.prmtOrg.setValue((Object)info);
        }
        if (cp.getCustomerParam("procId") != null) {
            ProcSelectedInfo proInfo = null;
            ProcDefInfo defInfo = null;
            try {
                IProcDef dinfo = ProcDefFactory.getRemoteInstance();
                defInfo = dinfo.getValue((IObjectPK)new ObjectUuidPK(cp.getCustomerParam("procId")));
                proInfo = new ProcSelectedInfo();
                proInfo.setName(defInfo.getName());
                proInfo.setProcDefId(defInfo.getProcdefID().toString());
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            this.prmtPro.setValue(proInfo);
        }
        if (cp.getCustomerParam("effectDate") != null) {
            df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            cDate = new Date();
            try {
                cDate = df.parse(cp.getCustomerParam("effectDate"));
            }
            catch (ParseException e) {
                try {
                    cDate = df.parse(cp.getCustomerParam("effectDate") + " 00:00:00");
                }
                catch (ParseException e1) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    logger.error((Object)e1.getMessage(), (Throwable)e1);
                }
            }
            this.kDDatePicker1.setValue((Object)cDate);
        }
        if (cp.getCustomerParam("planInvalidDate") != null) {
            df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            cDate = new Date();
            try {
                cDate = df.parse(cp.getCustomerParam("planInvalidDate"));
            }
            catch (ParseException e) {
                try {
                    cDate = df.parse(cp.getCustomerParam("planInvalidDate") + " 59:59:59");
                }
                catch (ParseException e1) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    logger.error((Object)e1.getMessage(), (Throwable)e1);
                }
            }
            this.kDDatePicker2.setValue((Object)cDate);
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        String org = "";
        String proc = "";
        String user = "";
        String effectDate = "";
        String invalidDate = "";
        this.effectDate1 = (Date)this.kDDatePicker1.getValue();
        this.planInvalidDate1 = (Date)this.kDDatePicker2.getValue();
        SimpleDateFormat dateformat1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (this.effectDate1 != null && !"".equals(this.effectDate1)) {
            effectDate = dateformat1.format((Date)this.kDDatePicker1.getValue());
        }
        if (this.planInvalidDate1 != null && !"".equals(this.planInvalidDate1)) {
            invalidDate = dateformat1.format((Date)this.kDDatePicker2.getValue());
        }
        if (this.prmtOrg.getValue() != null) {
            this.orgUnitInfo = (OrgUnitInfo)this.prmtOrg.getValue();
            org = this.orgUnitInfo.getId().toString();
        }
        if (this.prmtPro.getValue() != null) {
            HashMap a = (HashMap)this.prmtPro.getValue();
            Iterator it = a.values().iterator();
            while (it.hasNext()) {
                if (StringUtils.isEmpty((String)proc)) {
                    proc = it.next().toString();
                    continue;
                }
                proc = proc + ";" + it.next().toString();
            }
        }
        if (!org.equals("")) {
            cp.addCustomerParam("orgId", org);
        }
        if (!proc.equals("")) {
            cp.addCustomerParam("procId", proc);
        }
        if (!user.equals("")) {
            // empty if block
        }
        if (!effectDate.equals("")) {
            cp.addCustomerParam("effectDate", effectDate.substring(0, 19));
        }
        if (!invalidDate.equals("")) {
            cp.addCustomerParam("planInvalidDate", invalidDate.substring(0, 19));
        }
        return cp;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void prmtPro_mouseClicked(MouseEvent e) throws Exception {
        super.prmtPro_mouseClicked(e);
    }

    @Override
    protected void prmtPro_stateChanged(ChangeEvent e) throws Exception {
        super.prmtPro_stateChanged(e);
    }

    public static class DelegateConditionSearchParam
    implements Serializable {
        public static final String user = "user";
        public static final String effectDate = "effectDate";
        public static final String planInvalidDate = "planInvalidDate";
        public static final String procId = "procId";
        public static final String orgId = "orgId";
    }

    class MyFormatter
    implements IFormatter {
        MyFormatter() {
        }

        public void applyPattern(String pattern) {
        }

        public String valueToString(Object o) {
            if (o != null) {
                StringBuffer proc = new StringBuffer("");
                Iterator it = ((HashMap)o).values().iterator();
                while (it.hasNext()) {
                    if (StringUtils.isEmpty((String)proc.toString())) {
                        proc.append(it.next().toString());
                        continue;
                    }
                    proc.append(";").append(it.next().toString());
                }
                return proc.toString();
            }
            return "";
        }
    }
}

