/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.mc.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.AssignmentMessage;
import com.kingdee.bos.workflow.define.enhanced.EMessage;
import com.kingdee.bos.workflow.define.enhanced.IEMessageActivity;
import com.kingdee.bos.workflow.define.enhanced.IMessageActivity;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.multiapprove.ApproveResult;
import com.kingdee.eas.base.multiapprove.IMultiApprove;
import com.kingdee.eas.base.multiapprove.MultiApproveCollection;
import com.kingdee.eas.base.multiapprove.MultiApproveFactory;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.base.multiapprove.MultiApproveStatusEnum;
import com.kingdee.eas.cp.eip.mc.web.BizMultiApproveInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class WorkFlowUtil {
    protected static final Logger logger = Logger.getLogger(WorkFlowUtil.class);

    public static IRowSet getHostoryData(String billId, Context ctx) {
        if (StringUtils.isEmpty((String)billId)) {
            return null;
        }
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.base.multiapprove.app", "MultiApproveQuery");
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("(billId='" + billId + "')");
            buffer.append(" and (status=" + MultiApproveStatusEnum.SUBMIT.getValue() + ")");
            String oqlFilter = buffer.toString();
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo(oqlFilter);
            entityViewInfo.setFilter(filterInfo);
            SorterItemInfo itemInfo = new SorterItemInfo("lastUpdateTime");
            itemInfo.setSortType(SortType.DESCEND);
            entityViewInfo.getSorter().add(itemInfo);
            IQueryExecutor exec = null;
            exec = WorkFlowUtil.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
            IRowSet rs = exec.executeQuery();
            return rs;
        }
        catch (Exception e) {
            logger.error((Object)"getHostoryData failed", (Throwable)e);
            return null;
        }
    }

    public static MultiApproveInfo getMultiApprove(String assignmentId, Context ctx) {
        MultiApproveInfo minfo = null;
        if (StringUtils.isEmpty((String)assignmentId)) {
            throw new IllegalArgumentException(assignmentId);
        }
        try {
            IMultiApprove multiApprove = MultiApproveFactory.getLocalInstance((Context)ctx);
            StringBuffer buffer = new StringBuffer();
            buffer.append("where");
            buffer.append(" (assignment='" + assignmentId + "')");
            String oql = buffer.toString();
            MultiApproveCollection multiApproves = multiApprove.getMultiApproveCollection(oql);
            if (multiApproves == null || multiApproves.size() <= 0) {
                minfo = new MultiApproveInfo();
                minfo.setIsPass(ApproveResult.PASS);
                minfo.setOpinion("");
                minfo.setHandlerOpinion(0);
                return minfo;
            }
            return multiApproves.get(0);
        }
        catch (Exception e) {
            logger.error((Object)"getMultiApprove failed", (Throwable)e);
            return null;
        }
    }

    public static IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo, Context context) throws Exception {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    public static BizMultiApproveInfo getMultiApproveMessage(String assignId, Context context) throws BOSException {
        BizMultiApproveInfo approveInfo = new BizMultiApproveInfo();
        IEnactmentService service = EnactmentServiceProxy.getEnacementService((Context)context);
        AssignmentInfo wholeInfo = service.getAssignmentById(assignId);
        String actInstId = wholeInfo.getActInstId();
        ActivityInstInfo actInstInfo = service.getActivityInstByActInstId(actInstId);
        ProcessInstInfo procInstInfo = service.getProcessInstInfo(actInstInfo.getProcInstId());
        ActivityDef actDef = service.getActDefByActInstInfo(actInstInfo);
        if (actDef instanceof IMessageActivity) {
            AssignmentMessage msg = ((IMessageActivity)actDef).getMessage();
            if (msg != null && msg.isSendMail()) {
                approveInfo.setMailNotifyNext(true);
            } else {
                approveInfo.setMailNotifyNext(false);
            }
        }
        if (actDef instanceof IEMessageActivity) {
            EMessage emsg = ((IEMessageActivity)actDef).getEMessage();
            if (emsg != null && emsg.isEnable()) {
                approveInfo.setMobelNotifyNext(true);
            } else {
                approveInfo.setMobelNotifyNext(false);
            }
        }
        approveInfo.setMultiApproveSubject(wholeInfo.getSubject(context.getLocale()));
        return approveInfo;
    }

    public static IRowSet getApproveOpinionByProcinstID(Context ctx, String ProcinstID) {
        String billID = "";
        IRowSet returnRS = null;
        try {
            String BillIDSql = "select top 1 fbizobjid from T_WFR_ASSIGN where FProcinstID ='";
            BillIDSql = BillIDSql + ProcinstID + "'";
            IRowSet BillRS = DbUtil.executeQuery((Context)ctx, (String)BillIDSql);
            if (BillRS != null && BillRS.next()) {
                billID = BillRS.getString("fbizobjid");
            }
            if (billID == null || billID.trim().length() == 0) {
                BillIDSql = "select top 1 fbizobjid from T_WFR_ASSIGNDETAIL where FProcinstID ='";
                BillRS = DbUtil.executeQuery((Context)ctx, (String)(BillIDSql = BillIDSql + ProcinstID + "'"));
                if (BillRS != null && BillRS.next()) {
                    billID = BillRS.getString("fbizobjid");
                }
            }
            if (billID != null && billID.trim().length() > 0) {
                returnRS = WorkFlowUtil.getHostoryData(billID, ctx);
            }
        }
        catch (Exception e) {
            logger.error((Object)"getApproveOpinionByProcinstID failed", (Throwable)e);
        }
        return returnRS;
    }

    public static IRowSet getApproveOpinionByAssignID(Context ctx, String AssignID) {
        String billID = "";
        IRowSet returnRS = null;
        try {
            String BillIDSql = "select top 1 fbizobjid from T_WFR_ASSIGN where FAssignID ='";
            BillIDSql = BillIDSql + AssignID + "'";
            IRowSet BillRS = DbUtil.executeQuery((Context)ctx, (String)BillIDSql);
            if (BillRS != null && BillRS.next()) {
                billID = BillRS.getString("fbizobjid");
            }
            if (billID != null && billID.trim().length() > 0) {
                returnRS = WorkFlowUtil.getHostoryData(billID, ctx);
            }
        }
        catch (Exception e) {
            logger.error((Object)"getApproveOpinionByAssignID failed", (Throwable)e);
        }
        return returnRS;
    }
}

