/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.mc.web.service;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.spi.SPManager;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.IOrgRange;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.eip.mc.util.ReceiverSelectUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import net.buffalo.server.BuffaloService;
import org.apache.log4j.Logger;

public class AdminOrgWebService
extends BuffaloService {
    private static Logger logger = Logger.getLogger((String)AdminOrgWebService.class.getName());

    public String[][] getRosStr(String orgid) {
        try {
            HttpServletRequest request = (HttpServletRequest)this.getRequest();
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
            MetaDataPK mainQueryPK = null;
            boolean ishasEas = SPManager.isSPInstalled((String)"ReceiverPersonSelectImp");
            mainQueryPK = ishasEas ? new MetaDataPK("com.kingdee.eas.basedata.person.app", "PersonReceiverQuery") : new MetaDataPK("com.kingdee.eas.basedata.person.app", "PersonQuery");
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            FilterItemCollection fic = filterInfo.getFilterItems();
            fic.add(new FilterItemInfo("AdminOrgUnit.id", (Object)orgid));
            fic.add(new FilterItemInfo("Deletedstatus", (Object)new Integer(1), CompareType.EQUALS));
            if (ishasEas) {
                fic.add(new FilterItemInfo("employeeType.inService", (Object)new Integer(1), CompareType.EQUALS));
            }
            entityViewInfo.setFilter(filterInfo);
            IQueryExecutor exec = null;
            exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
            IRowSet rowSet = exec.executeQuery();
            ArrayList personCandidates = new ArrayList();
            personCandidates = ReceiverSelectUtil.recordSet2ArrayList(rowSet, null, false);
            personCandidates = ReceiverSelectUtil.mergeRows(personCandidates, "id", new String[]{"AdminOrgUnit.name"});
            String[][] rowDataArray = new String[personCandidates.size()][8];
            for (int i = 0; i < personCandidates.size(); ++i) {
                HashMap map = new HashMap();
                map = (HashMap)personCandidates.get(i);
                rowDataArray[i][0] = map.get("id").toString();
                rowDataArray[i][1] = map.get("number").toString();
                rowDataArray[i][2] = map.get("name").toString();
                rowDataArray[i][3] = map.get("AdminOrgUnit.name").toString();
                rowDataArray[i][4] = (String)map.get("email");
                rowDataArray[i][5] = (String)map.get("homePhone");
                rowDataArray[i][6] = (String)map.get("officePhone");
                rowDataArray[i][7] = (String)map.get("cell");
            }
            return rowDataArray;
        }
        catch (Exception e) {
            logger.error((Object)("--getRosStr--" + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public String[][] getRosStrUser(String orgid) {
        try {
            HttpServletRequest request = (HttpServletRequest)this.getRequest();
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
            MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.base.permission.app", "UserListQuery");
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)orgid));
            filter.getFilterItems().add(new FilterItemInfo("type", (Object)Integer.valueOf("20"), CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("isForbidden", (Object)new Boolean(false)));
            filter.getFilterItems().add(new FilterItemInfo("isLocked", (Object)new Boolean(false)));
            filter.getFilterItems().add(new FilterItemInfo("isDelete", (Object)new Boolean(false)));
            filter.setMaskString("#0 and #1 and #2 and #3 and #4");
            entityViewInfo.setFilter(filter);
            IQueryExecutor exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
            IRowSet rowSet = exec.executeQuery();
            String[][] rowDataArray = new String[rowSet.size()][4];
            int i = 0;
            while (rowSet.next()) {
                rowDataArray[i][0] = rowSet.getString("ID");
                rowDataArray[i][1] = rowSet.getString("NUMBER");
                rowDataArray[i][2] = rowSet.getString("NAME");
                rowDataArray[i][3] = rowSet.getString("CU.name");
                ++i;
            }
            return rowDataArray;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    public String[][] getOrgChilder(String orgid) {
        try {
            HttpServletRequest request = (HttpServletRequest)this.getRequest();
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
            AdminOrgUnitInfo info = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)orgid)));
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("longNumber", (Object)info.getLongNumber()));
            fi.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(info.getLongNumber() + "!%"), CompareType.LIKE));
            fi.setMaskString("#0 or #1");
            viewInfo.setFilter(fi);
            MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.NewAdminTreeQuery");
            IRowSet rowSet = this.getQueryExecutor((IMetaDataPK)queryPK, viewInfo, ctx).executeQuery();
            String[][] rowDataArray = new String[rowSet.size()][2];
            int i = 0;
            while (rowSet.next()) {
                rowDataArray[i][0] = rowSet.getString("ID");
                rowDataArray[i][1] = rowSet.getString("NAME");
                ++i;
            }
            return rowDataArray;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    public String[][] fastQuery(String cboKey, String txtValue, boolean chkLike) {
        return this.fastQueryWithFilter(cboKey, txtValue, chkLike, false);
    }

    public String[][] fastQueryWithFilter(String cboKey, String txtValue, boolean chkLike, boolean isAdminFilter) {
        if (StringUtils.isEmpty((String)cboKey) || StringUtils.isEmpty((String)txtValue)) {
            return null;
        }
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        IQueryExecutor exec = null;
        MetaDataPK mainQueryPK = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if ("name".equals(cboKey)) {
            if (chkLike) {
                filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)("%" + txtValue.trim() + "%"), CompareType.LIKE));
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)txtValue.trim()));
            }
        } else if (chkLike) {
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)("%" + txtValue.trim() + "%"), CompareType.LIKE));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)txtValue.trim()));
        }
        if (isAdminFilter && this.isFilterByUserAdminOrgRange(ctx)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", (Object)AdminOrgWebService.getCurrentUserAdminOrgRange(ctx), CompareType.INCLUDE));
        }
        mainQueryPK = new MetaDataPK("com.kingdee.eas.basedata.person.app", "PersonQuery");
        try {
            entityViewInfo.setFilter(filterInfo);
            exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
            IRowSet rowSet = exec.executeQuery();
            ArrayList personCandidates = new ArrayList();
            personCandidates = ReceiverSelectUtil.recordSet2ArrayList(rowSet, null, false);
            personCandidates = ReceiverSelectUtil.mergeRows(personCandidates, "id", new String[]{"AdminOrgUnit.name"});
            String[][] rowDataArray = new String[personCandidates.size()][8];
            for (int i = 0; i < personCandidates.size(); ++i) {
                HashMap map = new HashMap();
                map = (HashMap)personCandidates.get(i);
                rowDataArray[i][0] = map.get("id").toString();
                rowDataArray[i][1] = map.get("number").toString();
                rowDataArray[i][2] = map.get("name").toString();
                rowDataArray[i][3] = map.get("AdminOrgUnit.name").toString();
                rowDataArray[i][4] = (String)map.get("email");
                rowDataArray[i][5] = (String)map.get("homePhone");
                rowDataArray[i][6] = (String)map.get("officePhone");
                rowDataArray[i][7] = (String)map.get("cell");
            }
            return rowDataArray;
        }
        catch (Exception e) {
            logger.error((Object)"-fastQueryWithFilter error!-", (Throwable)e);
            return null;
        }
    }

    public String[][] DeliverfastQuery(String cboKey, String txtValue, boolean chkLike) {
        if (StringUtils.isEmpty((String)cboKey) || StringUtils.isEmpty((String)txtValue)) {
            return null;
        }
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        IQueryExecutor exec = null;
        MetaDataPK mainQueryPK = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if ("name".equals(cboKey)) {
            if (chkLike) {
                filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)("%" + txtValue.trim() + "%"), CompareType.LIKE));
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)txtValue.trim()));
            }
        } else if (chkLike) {
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)("%" + txtValue.trim() + "%"), CompareType.LIKE));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)txtValue.trim()));
        }
        mainQueryPK = new MetaDataPK("com.kingdee.eas.basedata.person.app", "PersonQuery");
        String cuID = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cuID));
        filterInfo.setMaskString("#0 and #1");
        try {
            entityViewInfo.setFilter(filterInfo);
            exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
            IRowSet rowSet = exec.executeQuery();
            String[][] rowDataArray = new String[rowSet.size()][4];
            int i = 0;
            while (rowSet.next()) {
                rowDataArray[i][0] = rowSet.getString("ID");
                rowDataArray[i][1] = rowSet.getString("NUMBER");
                rowDataArray[i][2] = rowSet.getString("NAME");
                rowDataArray[i][3] = rowSet.getString("AdminOrgUnit.name");
                ++i;
            }
            return rowDataArray;
        }
        catch (Exception e) {
            logger.error((Object)"-DeliverfastQuery error-", (Throwable)e);
            return null;
        }
    }

    public String[][] queryUserByIds(String ids) {
        try {
            HttpServletRequest request = (HttpServletRequest)this.getRequest();
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
            UserInfo info = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(ids));
            String[][] rowDataArray = new String[1][4];
            rowDataArray[0][0] = info.getId().toString();
            rowDataArray[0][1] = info.getNumber();
            rowDataArray[0][2] = info.getName();
            CtrlUnitInfo cinfo = CtrlUnitFactory.getRemoteInstance().getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(info.getCU().getId().toString()));
            rowDataArray[0][3] = cinfo.getName();
            return rowDataArray;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    public String[][] queryByIds(String ids) {
        if (StringUtils.isEmpty((String)ids)) {
            return null;
        }
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        IQueryExecutor exec = null;
        MetaDataPK mainQueryPK = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        mainQueryPK = new MetaDataPK("com.kingdee.eas.basedata.person.app", "PersonQuery");
        filterInfo.setMaskString("#0");
        try {
            entityViewInfo.setFilter(filterInfo);
            exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
            IRowSet rowSet = exec.executeQuery();
            ArrayList personCandidates = new ArrayList();
            personCandidates = ReceiverSelectUtil.recordSet2ArrayList(rowSet, null, false);
            personCandidates = ReceiverSelectUtil.mergeRows(personCandidates, "id", new String[]{"AdminOrgUnit.name"});
            String[][] rowDataArray = new String[personCandidates.size()][8];
            for (int i = 0; i < personCandidates.size(); ++i) {
                HashMap map = new HashMap();
                map = (HashMap)personCandidates.get(i);
                rowDataArray[i][0] = map.get("id").toString();
                rowDataArray[i][1] = map.get("number").toString();
                rowDataArray[i][2] = map.get("name").toString();
                rowDataArray[i][3] = map.get("AdminOrgUnit.name").toString();
                rowDataArray[i][4] = (String)map.get("email");
                rowDataArray[i][5] = (String)map.get("homePhone");
                rowDataArray[i][6] = (String)map.get("officePhone");
                rowDataArray[i][7] = (String)map.get("cell");
            }
            return rowDataArray;
        }
        catch (Exception e) {
            logger.error((Object)"-queryByIds error-", (Throwable)e);
            return null;
        }
    }

    private IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo, Context context) throws Exception {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    public static Set getCurrentUserAdminOrgRange(Context ctx) {
        ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        HashSet<String> result = new HashSet<String>();
        try {
            IOrgRange orgRange = OrgRangeFactory.getLocalInstance((Context)ctx);
            OrgRangeCollection coll = orgRange.findFullOrgCol((IObjectPK)userPK, OrgRangeType.ADMIN_ORG_TYPE);
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                result.add(coll.get(i).getOrg().getId().toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean isFilterByUserAdminOrgRange(Context ctx) {
        try {
            ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
            if (Administrator.isCUAdmin((Context)ctx, (IObjectPK)userPK)) {
                return false;
            }
            String paramValue = ParamManager.getParamValue((Context)ctx, null, (String)"isReceiverFilterByAdminRange");
            return Boolean.valueOf(paramValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

