/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.mc.web.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.MD5Util;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ExtendedAttributeCollection;
import com.kingdee.bos.workflow.define.ExtendedAttributeDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.extended.MessageActivityDef;
import com.kingdee.bos.workflow.ext.ConfigLoader;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.monitor.StartProcesProgressUtil;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.bos.workflow.store.util.StoreUtils;
import com.kingdee.bos.workflow.util.ProcessParamUtils;
import com.kingdee.eas.base.attachment.AttachmentCollection;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentHandleFacadeFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.IAttachmentHandleFacade;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.base.message.AssignReadFactory;
import com.kingdee.eas.base.message.AssignReadInfo;
import com.kingdee.eas.base.message.BMCMessageFactory;
import com.kingdee.eas.base.message.BMCMessageHistoryFactory;
import com.kingdee.eas.base.message.BMCMessageInfo;
import com.kingdee.eas.base.message.BaseMessageException;
import com.kingdee.eas.base.message.IAssignRead;
import com.kingdee.eas.base.message.IBMCMessage;
import com.kingdee.eas.base.message.IBMCMessageHistory;
import com.kingdee.eas.base.message.IMessageCenter;
import com.kingdee.eas.base.message.IMsgSendRecord;
import com.kingdee.eas.base.message.IMsgSendRecordHst;
import com.kingdee.eas.base.message.IWebServiceMessage;
import com.kingdee.eas.base.message.MessageCenterFactory;
import com.kingdee.eas.base.message.MessageViewConfig;
import com.kingdee.eas.base.message.MsgSendRecordFactory;
import com.kingdee.eas.base.message.MsgSendRecordHstFactory;
import com.kingdee.eas.base.message.MsgSendRecordInfo;
import com.kingdee.eas.base.message.MsgStatus;
import com.kingdee.eas.base.message.MsgType;
import com.kingdee.eas.base.message.URLInfo;
import com.kingdee.eas.base.message.WebServiceMessageFactory;
import com.kingdee.eas.base.message.WebServiceMessageInfo;
import com.kingdee.eas.base.message.app.msgcount.ClassificationStatCacheManager;
import com.kingdee.eas.base.message.util.JSONUtil;
import com.kingdee.eas.base.message.util.ProcessCenterUtil;
import com.kingdee.eas.base.message.web.MessageCenterWebService;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.wssc.BillImageFacadeFactory;
import com.kingdee.eas.base.wssc.IBillImageFacade;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.mc.CustomizedProcConfigFactory;
import com.kingdee.eas.cp.eip.mc.CustomizedProcConfigInfo;
import com.kingdee.eas.cp.eip.mc.ICustomizedProcConfig;
import com.kingdee.eas.cp.eip.mc.util.PortalContextUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.log4j.Logger;

public class ProcessWebService {
    private static Logger logger = Logger.getLogger((String)ProcessWebService.class.getName());
    public static final String MCRESOURCES = "com.kingdee.eas.cp.eip.mc.MessageCenter";
    public static final String EASPORTAL_PATH = "/easportal";
    public static final String EASWEB_PATH = "/easweb";
    private static String FAILURE = "failure";
    private static String SUCCESS = "success";
    private static String LOG = "log";
    private Context ctx;
    private String key = "";

    public ProcessWebService(HttpServletRequest request) {
        Context ctx = PortalContextUtil.getEasContext(request);
        if (request.getSession().getAttribute("md5_key") != null) {
            this.key = (String)request.getSession().getAttribute("md5_key");
        }
        this.ctx = ctx;
    }

    public String getbillOpenningUrlByAssignId(String isWebSupport, String assignId) {
        String url = "";
        if ("true".equals(isWebSupport)) {
            url = this.openWebBill(assignId);
        }
        if (StringUtils.isEmpty((String)url)) {
            url = this.openWebfullyBill(assignId);
        }
        url = this.getnewurl(url);
        return url;
    }

    public String getBillEditUrlById(String id) {
        URLInfo urlInfo = new URLInfo();
        String url = "";
        urlInfo = ProcessCenterUtil.getEditUrlInfoById((String)id, (Context)this.ctx);
        if (urlInfo != null && !StringUtils.isEmpty((String)urlInfo.getURL())) {
            url = urlInfo.getURL();
        }
        url = this.getnewurl(url);
        return url;
    }

    public String getBillViewUrlByProcInstId(String procInstId, String billState, String actInstId, String billId) {
        URLInfo urlInfo = new URLInfo();
        String url = "";
        if (!StringUtils.isEmpty((String)actInstId) && actInstId.endsWith("WFATINST")) {
            url = this.getMessageActUrl(actInstId, billId);
        }
        if (StringUtils.isEmpty((String)url)) {
            urlInfo = ProcessCenterUtil.getBillViewUrlByProcInstId((String)procInstId, (Context)this.ctx, (String)billState);
        }
        if (urlInfo != null && !StringUtils.isEmpty((String)urlInfo.getURL())) {
            url = urlInfo.getURL();
        }
        url = this.getnewurl(url);
        return url;
    }

    public String getMessageActUrl(String actInstId, String billId) {
        String url = "";
        try {
            ExtendedAttributeDef waf2UiPK;
            IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
            ActivityInstInfo actInstInfo = svc.getActivityInstByActInstId(actInstId);
            ActivityDef actDef = svc.getActDefByActInstInfo(actInstInfo);
            if (!(actDef instanceof MessageActivityDef)) {
                return null;
            }
            MessageActivityDef msgActDef = (MessageActivityDef)actDef;
            ExtendedAttributeCollection extendAttrs = msgActDef.getActivityHeader().getExtendedAttributes();
            ExtendedAttributeDef WebBillApproveUrlAttr = extendAttrs.get("WebBillApproveUrl");
            if (WebBillApproveUrlAttr != null && !StringUtils.isEmpty((String)WebBillApproveUrlAttr.getValue())) {
                url = WebBillApproveUrlAttr.getValue();
            }
            if ((waf2UiPK = extendAttrs.get("Waf2UIPK")) != null && !StringUtils.isEmpty((String)waf2UiPK.getValue())) {
                StringBuffer sb = new StringBuffer("/dynamicForm.do");
                this.appendParam(sb, "method", "initalize", false);
                this.appendParam(sb, "event", "initialize", false);
                this.appendParam(sb, "uipk", waf2UiPK.getValue(), true);
                url = sb.toString();
            }
            if (!StringUtils.isEmpty((String)url)) {
                url = url.indexOf("/shr/") >= 0 ? url + "&pureWFBillUrl=true" : EASWEB_PATH + url;
                url = url + "&billId=" + URLEncoder.encode(billId, "UTF-8") + "&operateState=VIEW";
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return url;
    }

    public String getProcInstIdByAssignId(String assignId) {
        String procInstId = ProcessCenterUtil.getProcInstIdByAssignId((String)assignId, (Context)this.ctx);
        return procInstId;
    }

    public String getEditUrlInfoByAssign(String assignId) {
        URLInfo urlInfo = new URLInfo();
        urlInfo = ProcessCenterUtil.getEditUrlInfoByAssign((String)assignId, (Context)this.ctx);
        String userId = this.ctx.getCaller().toString();
        urlInfo.setUserId(userId);
        String jsonStr = JSONUtil.getJson4Object((Object)urlInfo, null);
        return jsonStr;
    }

    public String getEditUrlInfoByProcInst(String procInstID) {
        URLInfo info = new URLInfo();
        info = ProcessCenterUtil.getEditUrlInfoByProcInst((String)procInstID, (Context)this.ctx);
        String url = this.getnewurl(info.getURL());
        info.setURL(url);
        String jsonStr = JSONUtil.getJson4Object((Object)info, null);
        return jsonStr;
    }

    private String getnewurl(String url) {
        if (url.indexOf("uipk=") != -1) {
            String para = url.substring(url.indexOf("uipk=") + 5);
            String uipkkey = "";
            uipkkey = para.indexOf("&") != -1 ? para.substring(0, para.indexOf("&")) + this.key : para + this.key;
            String code = MD5Util.getMD5String((String)uipkkey);
            url = url + "&md5_code=" + code;
        }
        return url;
    }

    public boolean setReadStatus(String idStr, int status, int msgType) {
        boolean result = ProcessCenterUtil.setReadStatus((String)idStr, (int)status, (int)msgType, (Context)this.ctx);
        return result;
    }

    public String getUnreadMsgCount() {
        HashMap result = new HashMap();
        Map map = new HashMap();
        String userId = this.ctx.getCaller().toString();
        ClassificationStatCacheManager msgCountCacheManager = ClassificationStatCacheManager.get((Context)this.ctx);
        map = msgCountCacheManager.getStat(userId);
        try {
            result.put("instantmsg", map.get("instantmsg"));
            Map<String, Integer> untreatedMap = this.getUnreadCount();
            if (untreatedMap != null && untreatedMap.size() > 0) {
                result.put("reminderTaskCount", untreatedMap.get("reminderTaskCount"));
                result.put("pendingassign", untreatedMap.get("pendingassign"));
                result.put("allPendingTask", untreatedMap.get("pendingassign") + untreatedMap.get("reminderTaskCount"));
                result.put("receiveCirculation", untreatedMap.get("receiveCirculation"));
                result.put("workflowCC", untreatedMap.get("workflowCC"));
                result.put("notice", untreatedMap.get("notice"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return ProcessCenterUtil.mapToString(result);
    }

    private Map<String, Integer> getUnreadCount() throws EASBizException, BOSException, SQLException {
        String userId = this.ctx.getCaller().toString();
        String sql = "select count(*) num from t_bas_message a  join t_wfr_assign b on a.FSOURCEID=b.FASSIGNID  where a.FRECEIVER=? ";
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql, (Object[])new Object[]{userId});
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (rs != null && rs.next()) {
            map.put("reminderTaskCount", rs.getInt("num"));
        }
        if ((rs = DbUtil.executeQuery((Context)this.ctx, (String)(sql = "SELECT count(*) num from T_WFR_Assign a inner join T_BAS_AssignRead b on a.FASSIGNID = b.FASSIGNID where a.FSTATE in(1,2) and a.FIsSendMsg=1 and a.FPERSONUSERID = ? "), (Object[])new Object[]{userId})) != null && rs.next()) {
            map.put("pendingassign", rs.getInt("num"));
        }
        if ((rs = DbUtil.executeQuery((Context)this.ctx, (String)(sql = "select count(*) num from t_bas_message a where a.FRECEIVER=? and a.fBizType=80 and a.FStatus=0  "), (Object[])new Object[]{userId})) != null && rs.next()) {
            map.put("workflowCC", rs.getInt("num"));
        }
        if ((rs = DbUtil.executeQuery((Context)this.ctx, (String)(sql = "SELECT COUNT(*) num FROM T_BAS_Message WHERE FReceiver = ? AND FType = 0 AND FStatus = 0 AND FBizType != 80 and ((FSOURCEIDS not like 'PASS%' or FSOURCEIDS is null) and (ftitle_l2 not like '\u4f20\u9605\u53cd\u9988%' or ftitle_l1 not like 'Reply%' or ftitle_l3 not like '\u50b3\u95b1\u53cd\u994b%') and not exists (select 'x' from t_wfr_assign where t_wfr_assign.FASSIGNID=T_BAS_Message.FSOURCEID) and not exists (select 'x' from t_wfr_AssignDetail where t_wfr_AssignDetail.FASSIGNID=T_BAS_Message.FSOURCEID))"), (Object[])new Object[]{userId})) != null && rs.next()) {
            map.put("notice", rs.getInt("num"));
        }
        if ((rs = DbUtil.executeQuery((Context)this.ctx, (String)(sql = "SELECT COUNT(*) num FROM t_wfr_receiveCirculate_view where FRECEIVER = ? and num = 0"), (Object[])new Object[]{userId})) != null && rs.next()) {
            map.put("receiveCirculation", rs.getInt("num"));
        }
        return map;
    }

    public String getAssignmentReadInfoArrayByIds(String ids) {
        String arrayJsonStr = "";
        if (!StringUtils.isEmpty((String)ids)) {
            try {
                ArrayList list = new ArrayList();
                IAssignRead iAssignRead = AssignReadFactory.getLocalInstance((Context)this.ctx);
                IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)this.ctx);
                String[] idArray = ids.split(";");
                for (int i = 0; i < idArray.length; ++i) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    AssignReadInfo info = null;
                    info = idArray[i].endsWith("WFWKITEM") ? iAssignRead.getAssignReadInfo("where assignID = '" + idArray[i] + "'") : iAssignRead.getAssignReadInfo((IObjectPK)new ObjectStringPK(idArray[i]));
                    AssignmentInfo assignInfo = service.getAssignmentById(info.getAssignID().toString());
                    map.put("status", String.valueOf(info.getStatus().getValue()));
                    map.put("bizFunction", assignInfo.getBizFunction());
                    map.put("assignID", info.getAssignID().toString());
                    map.put("isWebSupport", info.isIsWebSupport());
                    map.put("assignReadId", info.getId().toString());
                    list.add(map);
                }
                arrayJsonStr = JSONUtil.getJson4List(list, null);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return arrayJsonStr;
    }

    public String getAssignDisposeUrlInfoByAssignIdAndAssignType(String assignIds, String assignType, String isWebSupport) {
        String url = "";
        if (!StringUtils.isEmpty((String)assignIds)) {
            String[] assignArray = assignIds.split(";");
            if (assignArray.length > 1) {
                url = this.getUrlByDealingWithAssignment(assignIds, isWebSupport, "");
            } else {
                URLInfo urlInfo = new URLInfo();
                if ("approve".equalsIgnoreCase(assignType)) {
                    String defaultURL = "/easweb/workflow/approve.jsp";
                    url = ConfigLoader.getConfig4Server().getString("default.multiapprove.url", "", defaultURL);
                    if (defaultURL.equals(url)) {
                        StringBuffer buffer = new StringBuffer();
                        buffer.append(url).append("?assignmentId=").append(assignIds);
                        urlInfo.setURL(buffer.toString());
                        url = JSONUtil.getJson4Object((Object)urlInfo, null);
                    } else {
                        logger.error((Object)("customer url :" + url));
                        String billEditUrl = null;
                        StringBuffer buffer = new StringBuffer();
                        buffer.append(url);
                        this.appendParam(buffer, "assignmentId", assignIds, true);
                        try {
                            String billId;
                            IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
                            AssignmentInfo assign = svc.getAssignmentById(assignIds);
                            Map argumentMap = svc.getAssignmentArgument(assignIds, true);
                            String editUIName = (String)argumentMap.get("UIClassName");
                            if (editUIName != null && editUIName.length() > 0) {
                                billEditUrl = ProcessWebService.getURLfromEditUI(this.ctx, editUIName);
                            }
                            if (StringUtils.isEmpty(billEditUrl) && !StringUtils.isEmpty((String)(billId = assign.getBizObjectIds()))) {
                                billEditUrl = this.getEditUrl(this.ctx, billId);
                            }
                            if (url.indexOf("WFApproveServlet") >= 0 && (StringUtils.isEmpty((String)billEditUrl) || billEditUrl.toUpperCase().indexOf("FORMID") < 0)) {
                                buffer = new StringBuffer();
                                url = defaultURL;
                                buffer.append(url).append("?assignmentId=").append(assignIds);
                                urlInfo.setURL(buffer.toString());
                                return JSONUtil.getJson4Object((Object)urlInfo, null);
                            }
                            if (url.indexOf("WFApproveServlet") >= 0) {
                                this.appendParam(buffer, "v", "750", false);
                            } else {
                                this.appendParam(buffer, "custom", "1", false);
                            }
                            if (!StringUtils.isEmpty((String)billEditUrl)) {
                                ActivityInstInfo instInfo = svc.getActivityInstByActInstId(assign.getActInstId());
                                ActivityDef def = svc.getActDefByActInstInfo(instInfo);
                                ExtendedAttributeCollection extendAttrCol = def.getActivityHeader().getExtendedAttributes();
                                ExtendedAttributeDef value = extendAttrCol.get("customUIStatus");
                                if (value != null) {
                                    billEditUrl = billEditUrl.indexOf("?") < 0 ? billEditUrl + "?operateState=" + value.getValue() : billEditUrl + "&operateState=" + value.getValue();
                                }
                                this.appendParam(buffer, "billEditUrl", billEditUrl, true);
                            }
                        }
                        catch (Exception e) {
                            logger.error((Object)e);
                        }
                        urlInfo.setURL(buffer.toString());
                        url = JSONUtil.getJson4Object((Object)urlInfo, null);
                    }
                } else if ("manualDecision".equalsIgnoreCase(assignType)) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(EASWEB_PATH).append("/workflow/manualDecision.jsp?assignmentId=").append(assignIds);
                    urlInfo.setURL(buffer.toString());
                    url = JSONUtil.getJson4Object((Object)urlInfo, null);
                } else {
                    url = this.getUrlByDealingWithAssignment("", isWebSupport, assignIds);
                }
            }
        }
        return url;
    }

    public void appendParam(StringBuffer buffer, String key, String value, boolean encode) {
        if (value == null) {
            return;
        }
        try {
            if (encode) {
                value = URLEncoder.encode(value, "utf-8");
            }
            buffer.append(buffer.indexOf("?") < 0 ? "?" : "&");
            buffer.append(key + "=" + value);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public String getEditUrl(Context ctx, String billId) {
        BOSUuid id = BOSUuid.read((String)billId);
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo billObject = loader.getEntity(id.getType());
        if (billObject == null) {
            throw new IllegalArgumentException("BillObject is null");
        }
        try {
            String url = "";
            IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)ctx);
            ProcessInstInfo[] instInfos = svc.getProcessInstanceByHoldedObjectId(billId);
            logger.info((Object)("instInfos.length = " + instInfos.length));
            if (instInfos.length == 0) {
                instInfos = svc.getAllProcessInstancesByBizobjId(billId);
            }
            boolean flag = false;
            for (int k = 0; k < instInfos.length; ++k) {
                String hashValue = instInfos[k].getProcDefHashValue();
                ProcessDef def = svc.getProcessDefByDefineHashValue(hashValue);
                ActivityCollection ac = def.getActivitys();
                ActivityDef actDef = null;
                for (int i = 0; i < ac.size(); ++i) {
                    actDef = ac.get(i);
                    ExtendedAttributeDef extend = actDef.getActivityHeader().getExtendedAttributes().get("isWebBillApprove");
                    if (extend == null || !"true".equalsIgnoreCase(extend.getValue())) continue;
                    ExtendedAttributeDef extend1 = actDef.getActivityHeader().getExtendedAttributes().get("WebBillApproveUrl");
                    String string = url = extend1 != null ? extend1.getValue() : "";
                    if (StringUtils.isEmpty((String)url)) continue;
                    flag = true;
                    break;
                }
                if (flag) break;
            }
            if (!StringUtils.isEmpty((String)url)) {
                return url;
            }
            String editUiPk = billObject.getExtendedProperty("webEditPage");
            if (editUiPk == null || editUiPk.length() == 0) {
                editUiPk = billObject.getExtendedProperty("webEditUI");
            }
            String web_dynamic = billObject.getExtendedProperty("web_dynamic");
            if (billObject.isDynamic() && !"1".equalsIgnoreCase(web_dynamic) && !StringUtils.isEmpty((String)editUiPk)) {
                url = "/winlet/edit/editUIProxy.jsf?uipk=" + editUiPk;
            } else {
                String editUi;
                if (!StringUtils.isEmpty((String)editUiPk)) {
                    url = StoreUtils.webUIName2URL((String)editUiPk);
                }
                if (StringUtils.isEmpty((String)url) && !StringUtils.isEmpty((String)(editUi = billObject.getExtendedProperty("editUI")))) {
                    url = ProcessWebService.getURLfromEditUI(ctx, editUi);
                }
            }
            if (StringUtils.isEmpty((String)url)) {
                return "webviews/workflow/nobill.html";
            }
            return url;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return "webviews/workflow/nobill.html";
        }
    }

    private static String getURLfromEditUI(Context ctx, String editUi) throws BOSException {
        String o = null;
        MetaDataPK metaPK = MetaDataPK.create((String)editUi);
        IObjectValue objVal = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).get(MetaDataTypeList.UIOBJECT, (IMetaDataPK)metaPK);
        if (objVal != null) {
            o = objVal.getExtendedProperty("url");
        }
        String url = o == null ? "" : o.toString().trim();
        return url;
    }

    public String getUrlByDealingWithAssignment(String combineIds, String isWebSupport, String assignmentId) {
        URLInfo urlInfo;
        StringBuffer url;
        block12: {
            url = new StringBuffer();
            urlInfo = null;
            try {
                if (!StringUtils.isEmpty((String)combineIds)) {
                    if (isWebSupport.equals("true") && !StringUtils.isEmpty((String)(urlInfo = this.getUrlInfo(combineIds)).getURL())) {
                        url.append(EASPORTAL_PATH).append("/workflow/WFServlet?assignmentIds=").append(URLEncoder.encode(combineIds, "UTF-8"));
                    }
                    break block12;
                }
                if (isWebSupport.equals("true") || this.canGetWebUrl(assignmentId)) {
                    urlInfo = this.getUrlInfo(assignmentId);
                    if (urlInfo == null) break block12;
                    boolean isApprove = false;
                    try {
                        IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)this.ctx);
                        String fn = service.getAssignmentById(assignmentId).getBizFunction();
                        isApprove = "MultiApproveUIFunction".equals(fn);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    if (isApprove) {
                        url.append("/easweb/workflow/approve.jsp?assignmentId=").append(URLEncoder.encode(assignmentId, "UTF-8"));
                    } else {
                        String objUrl = urlInfo.getURL();
                        String customBillUrl = this.getCustomBillUrlInManPower(assignmentId);
                        if (customBillUrl != null) {
                            objUrl = customBillUrl;
                        }
                        objUrl = this.getnewurl(objUrl);
                        objUrl = objUrl.replace("$$##DynamicWebActivity", "");
                        url.append(EASPORTAL_PATH).append("/workflow/WFServlet?UIStatus=").append(urlInfo.getUIStatus()).append("&forwordURL=").append(URLEncoder.encode(objUrl, "UTF-8")).append("&assignmentID=").append(URLEncoder.encode(assignmentId, "UTF-8")).append("&billID=").append(URLEncoder.encode(urlInfo.getBillID(), "UTF-8"));
                    }
                    break block12;
                }
                String procName = ProcessCenterUtil.getWebfullyBillProcName((String)assignmentId, (Context)this.ctx);
                if (!StringUtils.isEmpty((String)procName)) {
                    url.append(EASPORTAL_PATH).append("/BillWebAuditServlet?assigmentId=").append(URLEncoder.encode(assignmentId, "UTF-8")).append("&proName=").append(URLEncoder.encode(procName, "UTF-8")).append("&forwordURL=/html/portlet/messagecenter/msgViewers/BillwebAudit.jsp");
                }
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        String urlStr = this.getnewurl(url.toString());
        if (urlInfo == null) {
            urlInfo = new URLInfo();
        }
        urlInfo.setURL(urlStr);
        String jsonStr = JSONUtil.getJson4Object((Object)urlInfo, null);
        return jsonStr;
    }

    private String getCustomBillUrlInManPower(String assignmentId) {
        try {
            if (assignmentId != null && assignmentId.length() > 0) {
                IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)this.ctx);
                AssignmentInfo assInfo = service.getAssignmentById(assignmentId);
                ActivityInstInfo instInfo = service.getActivityInstByActInstId(assInfo.getActInstId());
                ActivityDef def = service.getActDefByActInstInfo(instInfo);
                ExtendedAttributeCollection extendAttrCol = ((ManpowerActivityDef)def).getRelatedApplication().getExtendedAttributes();
                ExtendedAttributeDef CustomWebBillUrlDef = extendAttrCol.get("CustomWebBillUrl");
                return CustomWebBillUrlDef.getValue();
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u4eba\u5de5\u8282\u70b9\u83b7\u53d6\u5355\u636e\u81ea\u5b9a\u4e49url\u5931\u8d25\uff1a" + e));
            return null;
        }
        return null;
    }

    public String getImgurlByBillId(String billID) {
        StringBuffer url = new StringBuffer();
        Object urlInfo = null;
        try {
            IBillImageFacade billimage = BillImageFacadeFactory.getLocalInstance((Context)this.ctx);
            String imgurl = billimage.getImageURL(null, billID);
            String imageState = billimage.getImageState(null, billID).getValue();
            urlInfo.setURL(imgurl);
            if (imageState == "2") {
                urlInfo.setUIStatus("true");
            } else {
                urlInfo.setUIStatus("false");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        String jsonStr = JSONUtil.getJson4Object(urlInfo, null);
        return jsonStr;
    }

    public boolean canGetWebUrl(String assignId) {
        boolean result = false;
        result = ProcessCenterUtil.canGetWebUrl((String)assignId, (Context)this.ctx);
        return result;
    }

    public URLInfo getUrlInfo(String assignmentIDs) {
        URLInfo info = new URLInfo();
        info = ProcessCenterUtil.getUrlInfos((String)assignmentIDs, (Context)this.ctx);
        return info;
    }

    public String billOpenningByBillId(String billId) {
        String url = "";
        StringBuffer billUrl = new StringBuffer();
        URLInfo urlInfo = new URLInfo();
        urlInfo = ProcessCenterUtil.getEditUrlInfoByBillId((String)billId, (Context)this.ctx);
        try {
            if (urlInfo != null && !StringUtils.isEmpty((String)urlInfo.getURL())) {
                url = urlInfo.getURL();
                if (url.indexOf("pureWFBillUrl") > -1) {
                    billUrl.append(url);
                    billUrl.append("&billId=");
                    billUrl.append(URLEncoder.encode(billId, "UTF-8"));
                } else if (url.indexOf("dynamicForm.do?") > 0) {
                    billUrl.append(url).append("&operateState=VIEW");
                } else if (url.indexOf("/shr/") > -1) {
                    billUrl.append(url).append("&id=").append(URLEncoder.encode(urlInfo.getBillID(), "UTF-8"));
                } else if (url.endsWith(".do") || url.endsWith(".jsp")) {
                    billUrl.append(url.endsWith("Page.do") ? EASWEB_PATH : EASPORTAL_PATH).append(url).append(url.endsWith("Page.do") ? "?billId=" : "?id=").append(URLEncoder.encode(urlInfo.getBillID(), "UTF-8"));
                } else if (url.indexOf(".do?") > 0 || url.indexOf(".jsp?") > 0) {
                    billUrl.append(url.indexOf("Page.do?") > 0 ? EASWEB_PATH : EASPORTAL_PATH).append(url).append(url.indexOf("Page.do?") > 0 ? "&billId=" : "&id=").append(URLEncoder.encode(urlInfo.getBillID(), "UTF-8"));
                } else if (url.indexOf(".jsf") > 0) {
                    if (url.indexOf(".jsf?") > 0) {
                        billUrl.append(EASWEB_PATH).append(url).append("&billId=").append(URLEncoder.encode(urlInfo.getBillID(), "UTF-8"));
                    } else {
                        billUrl.append(EASWEB_PATH).append(url).append("?billId=").append(URLEncoder.encode(urlInfo.getBillID(), "UTF-8"));
                    }
                } else {
                    billUrl.append(EASWEB_PATH).append(url);
                }
                urlInfo.setURL(this.getnewurl(billUrl.toString()));
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            urlInfo.setErrorMsg(e.getMessage());
        }
        String jsonStr = JSONUtil.getJson4Object((Object)urlInfo, null);
        return jsonStr;
    }

    public String openWebBill(String sourceId) {
        String url;
        StringBuffer billUrl;
        block19: {
            billUrl = new StringBuffer();
            URLInfo urlInfo = new URLInfo();
            urlInfo = ProcessCenterUtil.getEditUrlInfoById((String)sourceId, (Context)this.ctx);
            try {
                if (urlInfo != null) {
                    if (!StringUtils.isEmpty((String)urlInfo.getErrorMsg())) {
                        return "";
                    }
                    if (!StringUtils.isEmpty((String)urlInfo.getURL())) {
                        url = urlInfo.getURL();
                        String billId = urlInfo.getBillID();
                        if (url.indexOf("/shr/") >= 0) {
                            StringBuffer tUrl = new StringBuffer(url);
                            this.appendParam(tUrl, "pureWFBillUrl", "true", false);
                            url = tUrl.toString();
                        }
                        if (url.indexOf("pureWFBillUrl") > -1) {
                            billUrl.append(url);
                            billUrl.append("&billId=");
                            billUrl.append(URLEncoder.encode(billId, "UTF-8"));
                            billUrl.append("&assigmentId=");
                            billUrl.append(URLEncoder.encode(sourceId, "UTF-8"));
                        } else if (url.indexOf("dynamicForm.do?") > -1) {
                            billUrl.append(EASWEB_PATH).append("/").append(url).append("&billId=").append(URLEncoder.encode(billId, "UTF-8")).append("&operateState=VIEW");
                        } else if (url.endsWith(".do") || url.endsWith(".jsp")) {
                            billUrl.append(url.endsWith("Page.do") ? EASWEB_PATH : EASPORTAL_PATH).append(url).append(url.endsWith("Page.do") ? "?billId=" : "?id=").append(URLEncoder.encode(billId, "UTF-8"));
                        } else if (url.indexOf(".do?") > 0 || url.indexOf(".jsp?") > 0) {
                            billUrl.append(url.indexOf("Page.do?") > 0 ? EASWEB_PATH : EASPORTAL_PATH).append(url).append(url.indexOf("Page.do?") > 0 ? "&billId=" : "&id=").append(URLEncoder.encode(billId, "UTF-8"));
                        } else {
                            String wafURL = EASWEB_PATH + url;
                            boolean isFind = true;
                            int queryStringIdx = wafURL.indexOf("?");
                            if (queryStringIdx <= 0) {
                                isFind = false;
                            }
                            String prefix = wafURL.substring(0, queryStringIdx + 1);
                            String queryString = wafURL.substring(queryStringIdx + 1);
                            billUrl.append(EASPORTAL_PATH).append("/html/portlet/messagecenter/msgViewers/Bill.jsp?assigmentId=").append(URLEncoder.encode(sourceId, "UTF-8")).append("&iswaf=true&wafURL=");
                            if (isFind) {
                                billUrl.append(URLEncoder.encode(prefix, "UTF-8")).append(queryString);
                            } else {
                                billUrl.append(URLEncoder.encode(wafURL, "UTF-8"));
                            }
                        }
                    }
                    break block19;
                }
                return "";
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        url = billUrl.toString();
        if (url.indexOf("operateState") == -1) {
            url = url + "&operateState=VIEW";
        }
        if (url.indexOf("inwafpage") == -1) {
            url = url + "&inwafpage=true";
        }
        return url;
    }

    public String openWebfullyBill(String sourceId) {
        StringBuffer billUrl = new StringBuffer();
        String proName = ProcessCenterUtil.getWebfullyBillProcName((String)sourceId, (Context)this.ctx);
        if (!StringUtils.isEmpty((String)proName)) {
            try {
                billUrl.append(EASPORTAL_PATH).append("/html/portlet/messagecenter/msgViewers/Bill.jsp?assigmentId=").append(URLEncoder.encode(sourceId, "UTF-8")).append("&proName=").append(URLEncoder.encode(proName, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return billUrl.toString();
    }

    public String isBillSupportWeb(String assignId) {
        String result = "false";
        result = ProcessCenterUtil.isBillSupportWeb((String)assignId, (Context)this.ctx);
        return result;
    }

    public void setMessageOrg(boolean isOrg) {
        ProcessCenterUtil.setMessageOrg((boolean)isOrg);
    }

    public void setMessageCombine(boolean isCombine) {
        ProcessCenterUtil.setMessageCombine((boolean)isCombine);
    }

    public boolean deleteSendInstantMsg(String msgIds, String ifHistory) {
        boolean result = ProcessCenterUtil.deleteSendInstantMsg((String)msgIds, (String)ifHistory, (Context)this.ctx);
        this.clearClear();
        return result;
    }

    public void delReceiveInstantMsg(String msgIds, String ifHistory) {
        ProcessCenterUtil.delReceiveInstantMsg((String)msgIds, (String)ifHistory, (Context)this.ctx);
        this.clearClear();
    }

    public boolean delBMCMessage(String msgIds, String ifHistory) {
        this.clearClear();
        return ProcessCenterUtil.delBMCMessage((String)msgIds, (String)ifHistory, (Context)this.ctx);
    }

    private void clearClear() {
        ClassificationStatCacheManager manager = ClassificationStatCacheManager.get((Context)this.ctx);
        manager.expire(this.ctx.getCaller().toString());
    }

    public boolean delOfficeMsg(String msgIds, String ifHistory) {
        this.clearClear();
        return ProcessCenterUtil.delOfficeMsg((String)msgIds, (String)ifHistory, (Context)this.ctx);
    }

    public boolean setOfficeMsgReadStatus(String msgId, String ifHistory, String status) {
        return ProcessCenterUtil.setOfficeMsgReadStatus((String)msgId, (String)ifHistory, (String)status, (Context)this.ctx);
    }

    public String getEditUrlInfoByBillId(String billID) {
        URLInfo urlInfo = new URLInfo();
        urlInfo = ProcessCenterUtil.getEditUrlInfoByBillId((String)billID, (Context)this.ctx);
        String arrayJsonStr = JSONUtil.getJson4Object((Object)urlInfo, null);
        return arrayJsonStr;
    }

    public String getMessageViewConfig(String msgId, String sourceIds) {
        String[] info = ProcessCenterUtil.getMessageViewConfig((String)msgId, (String)sourceIds, (Context)this.ctx);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < info.length; ++i) {
            list.add(info[i]);
        }
        String arrayJsonStr = JSONUtil.getJson4List(list, null);
        return arrayJsonStr;
    }

    public String getMessage(String msgIds) {
        if (StringUtils.isEmpty((String)msgIds)) {
            return null;
        }
        List<Map<String, String>> list = this.getBMCMessageInfo(this.ctx, msgIds);
        String arrayJsonStr = JSONUtil.getJson4List(list, null);
        return arrayJsonStr;
    }

    private List<Map<String, String>> getBMCMessageInfo(Context ctx, String msgIds) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        if (StringUtils.isEmpty((String)msgIds)) {
            return list;
        }
        String[] msgIdArray = msgIds.split(";");
        BMCMessageInfo msgInfo = null;
        String msgId = null;
        try {
            IBMCMessage msgService = BMCMessageFactory.getLocalInstance((Context)ctx);
            for (int i = 0; i < msgIdArray.length; ++i) {
                msgId = msgIdArray[i];
                if (!BOSUuid.isValid((String)msgId, (boolean)true)) continue;
                String userId = ctx.getCaller().toString();
                msgInfo = msgService.getBMCMessageInfo("where id='" + msgId + "' and ( sender='" + userId + "' or receiver='" + userId + "') ");
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", msgInfo.getId().toString());
                map.put("sourceID", msgInfo.getSourceID());
                String sourceids = msgInfo.getSourceIDs();
                if (!StringUtils.isEmpty((String)sourceids)) {
                    sourceids = sourceids.replaceAll("[|]", "^!^");
                }
                map.put("sourceIDs", sourceids);
                map.put("bizType", String.valueOf(msgInfo.getBizType().getValue()));
                map.put("sender", msgInfo.getSender(ctx.getLocale()));
                map.put("receiver", msgInfo.getReceiver());
                list.add(map);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public String getMessageHst(String msgIds) {
        if (StringUtils.isEmpty((String)msgIds)) {
            return null;
        }
        List list = ProcessCenterUtil.getMessagesHst((String)msgIds, (Context)this.ctx);
        String arrayJsonStr = JSONUtil.getJson4List((List)list, null);
        return arrayJsonStr;
    }

    public List getPendingAssignment(String assignIds) {
        if (StringUtils.isEmpty((String)assignIds)) {
            return null;
        }
        List list = null;
        list = ProcessCenterUtil.getPendingAssignments((String)assignIds, (Context)this.ctx);
        return list;
    }

    public List getAlreadyAssignment(String assignIds) {
        if (StringUtils.isEmpty((String)assignIds)) {
            return null;
        }
        List list = new ArrayList();
        list = ProcessCenterUtil.getAlreadyAssignments((String)assignIds, (Context)this.ctx);
        return list;
    }

    public List getAlreadyAssignmentHst(String assignIds) {
        if (StringUtils.isEmpty((String)assignIds)) {
            return null;
        }
        List list = new ArrayList();
        list = ProcessCenterUtil.getAlreadyAssignmentsHst((String)assignIds, (Context)this.ctx);
        return list;
    }

    public List getMySketch(String sketchIds) {
        if (StringUtils.isEmpty((String)sketchIds)) {
            return null;
        }
        List list = new ArrayList();
        list = ProcessCenterUtil.getMySketchs((String)sketchIds, (Context)this.ctx);
        return list;
    }

    public List getMyUrgentInfoByProcInst(String procInstId) {
        if (StringUtils.isEmpty((String)procInstId)) {
            return null;
        }
        List list = new ArrayList();
        list = ProcessCenterUtil.getMyUrgentInfoByProcInst((String)procInstId, (Context)this.ctx);
        return list;
    }

    public String getUrgentAssignIdByProcInstId(String procInstId) {
        List list = new ArrayList();
        StringBuffer result = new StringBuffer();
        list = ProcessCenterUtil.getUrgentAssignIdByProcInstId((String)procInstId, (Context)this.ctx);
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                if (i == 0) {
                    result.append(list.get(0).toString());
                    continue;
                }
                result.append(";").append(list.get(i).toString());
            }
        }
        return result.toString();
    }

    public String getMyUrgentInfosByAssignIds(String assignIds) {
        String jsonStr = "";
        if (!StringUtils.isEmpty((String)assignIds)) {
            List list = ProcessCenterUtil.getMyUrgentInfosByAssignIds((String)assignIds, (Context)this.ctx);
            jsonStr = JSONUtil.getJson4List((List)list, null);
        }
        return jsonStr;
    }

    public String startProc(String procDefId) {
        String url = null;
        try {
            url = StartProcesProgressUtil.getURLFromProcessDef((String)procDefId, (Context)this.ctx);
        }
        catch (EASBizException e) {
            logger.error((Object)("eas\u83b7\u53d6\u542f\u52a8\u6d41\u7a0burl\u65f6\u51fa\u9519" + e.getMessage()), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)("bos\u83b7\u53d6\u542f\u52a8\u6d41\u7a0burl\u65f6\u51fa\u9519" + e.getMessage()), (Throwable)e);
        }
        return url;
    }

    public void deleteSketch(String sketchIds) {
        this.clearClear();
        ProcessCenterUtil.deleteSketches((String)sketchIds, (Context)this.ctx);
    }

    public List getAttachment(String msgIds) {
        if (StringUtils.isEmpty((String)msgIds)) {
            return null;
        }
        List list = new ArrayList();
        list = ProcessCenterUtil.getAttachments((String)msgIds, (Context)this.ctx);
        return list;
    }

    public String getBillIdByProcInst(String procInstId) {
        String billId = "";
        billId = ProcessCenterUtil.getBillIdByProcInstId((String)procInstId, (Context)this.ctx);
        return billId;
    }

    public Message createDefaultUrgentMessage(AssignmentInfo assignInfo, String title, String body) {
        Locale locale = this.ctx.getLocale();
        Locale locale1 = new Locale("l1", "");
        Locale locale2 = new Locale("l2", "");
        Locale locale3 = new Locale("l3", "");
        Message message = MessageFactory.newMessage((String)"kingdee.workflow");
        String urgencyStr = ResourceBase.getString((String)MCRESOURCES, (String)"urgency", (Locale)locale) + ":";
        message.setLocaleStringHeader("title", urgencyStr + title, locale1);
        message.setLocaleStringHeader("title", urgencyStr + title, locale2);
        message.setLocaleStringHeader("title", urgencyStr + title, locale3);
        message.setLocaleStringHeader("body", urgencyStr + body, locale1);
        message.setLocaleStringHeader("body", urgencyStr + body, locale2);
        message.setLocaleStringHeader("body", urgencyStr + body, locale3);
        String userName = "";
        try {
            IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
            Person person = svc.getPersonByUserID(this.ctx.getCaller().toString());
            userName = person.getUserName(locale);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        message.setLocaleStringHeader("sender", userName, locale);
        message.setStringHeader("receiver", assignInfo.getUserId());
        message.setStringHeader("databaseCenter", this.ctx.getAIS());
        message.setStringHeader("solution", this.ctx.getSolution());
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 40);
        message.setIntHeader("sourceStatus", 0);
        message.setIntHeader("priority", 10);
        message.setStringHeader("sourceID", assignInfo.getAssignmentId());
        try {
            IAssignRead iAssignRead = AssignReadFactory.getLocalInstance((Context)this.ctx);
            AssignReadInfo assignReadInfo = iAssignRead.getAssignReadInfo("where assignID = '" + assignInfo.getAssignmentId() + "'");
            if (assignReadInfo.isIsWebSupport()) {
                message.setStringHeader("webSupport", "true");
            } else {
                message.setStringHeader("webSupport", "false");
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return message;
    }

    public boolean sendUrgentMsg(String actInstId, String receiver, String title, String content) throws BOSException, EASBizException {
        boolean result = false;
        if (StringUtils.isEmpty((String)actInstId) || StringUtils.isEmpty((String)receiver)) {
            return result;
        }
        IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)this.ctx);
        AssignmentInfo[] assignArray = service.getAssignmentByActInstId(actInstId, WfAssignmentState.ASSIGNED);
        List receiverList = Arrays.asList((Object[])receiver.split(";"));
        ArrayList<Message> messageList = new ArrayList<Message>();
        for (int i = 0; i < assignArray.length; ++i) {
            String userId = assignArray[i].getUserId();
            if (!receiverList.contains(userId)) continue;
            messageList.add(this.createDefaultUrgentMessage(assignArray[i], title, content));
        }
        result = ProcessCenterUtil.sendUrgentMessage(messageList, (Context)this.ctx);
        return result;
    }

    private String getUrgentAssignIdsByActInstIdAndOwners(String actInstId, String employeeIds) throws BaseException {
        StringBuffer buffer = new StringBuffer();
        IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)this.ctx);
        AssignmentInfo[] assignArray = service.getAssignmentByActInstId(actInstId, WfAssignmentState.ASSIGNED);
        List receiverList = Arrays.asList((Object[])employeeIds.split(";"));
        ArrayList messageList = new ArrayList();
        for (int i = 0; i < assignArray.length; ++i) {
            String employeeId = assignArray[i].getEmployeeId();
            if (!receiverList.contains(employeeId)) continue;
            if (buffer.length() > 0) {
                buffer.append(";");
            }
            buffer.append(assignArray[i].getAssignmentId());
        }
        return buffer.toString();
    }

    public Map sendUrgentMobile(String actInstId, String employeeIds, String content, String priority) throws BaseException {
        String assignIds = this.getUrgentAssignIdsByActInstIdAndOwners(actInstId, employeeIds);
        Map<String, String> resultMap = new HashMap<String, String>();
        resultMap.put(SUCCESS, "0");
        resultMap.put(FAILURE, "0");
        resultMap.put(LOG, "");
        String returnLog = "";
        String sendSuccess = ResourceBase.getString((String)MCRESOURCES, (String)"sendSuccess", (Locale)this.ctx.getLocale());
        String sendFailed = ResourceBase.getString((String)MCRESOURCES, (String)"sendFailed", (Locale)this.ctx.getLocale());
        if (StringUtils.isEmpty((String)assignIds)) {
            logger.error((Object)"sendUrgentMobile:assignIds are null");
            resultMap.put(LOG, sendFailed);
            return resultMap;
        }
        if (assignIds.indexOf(";") < 0) {
            boolean success = false;
            success = ProcessCenterUtil.sendUrgentMobile((String)assignIds, (String)content, (String)priority, (Context)this.ctx);
            if (success) {
                resultMap.put(SUCCESS, "1");
                resultMap.put(LOG, sendSuccess);
                return resultMap;
            }
            resultMap.put(FAILURE, "1");
            resultMap.put(LOG, sendFailed);
            return resultMap;
        }
        Object[] assignIdArray = assignIds.split(";");
        List assignIdList = new ArrayList();
        assignIdList = Arrays.asList((Object[])assignIdArray);
        resultMap = ProcessCenterUtil.sendUrgentMobile(assignIdList, (String)content, (String)priority, (Context)this.ctx);
        return resultMap;
    }

    public String checkMobileSendLimit(String content) {
        String body = "";
        Map<String, String> result = new HashMap();
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        try {
            body = URLDecoder.decode(content, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("\u68c0\u67e5\u77ed\u4fe1\u53d1\u9001\u6570\u91cf\u53c2\u6570\u9650\u5236\u51fa?:" + e.getMessage()), (Throwable)e);
            result.put("sendSuccess", "false");
            result.put("log", ResourceBase.getString((String)MCRESOURCES, (String)"sendFailed", (Locale)this.ctx.getLocale()));
            list.add(result);
            return JSONUtil.getJson4List(list, null);
        }
        result = ProcessCenterUtil.checkMobileSendLimit((String)body, (Context)this.ctx);
        list.add(result);
        String jsonStr = JSONUtil.getJson4List(list, null);
        return jsonStr;
    }

    public Map sendUrgentMail(String actInstId, String employeeIds, String title, String content) throws BaseException {
        String assignIds = this.getUrgentAssignIdsByActInstIdAndOwners(actInstId, employeeIds);
        String returnLog = "";
        String sendSuccess = ResourceBase.getString((String)MCRESOURCES, (String)"sendSuccess", (Locale)this.ctx.getLocale());
        String sendFailed = ResourceBase.getString((String)MCRESOURCES, (String)"sendFailed", (Locale)this.ctx.getLocale());
        Map<String, String> resultMap = new HashMap<String, String>();
        HashMap<String, String> failMap = new HashMap<String, String>();
        failMap.put(SUCCESS, "0");
        failMap.put(FAILURE, "0");
        failMap.put(LOG, sendFailed);
        if (StringUtils.isEmpty((String)assignIds)) {
            logger.error((Object)"sendUrgentMail:assignIds are null");
            return failMap;
        }
        if (assignIds.indexOf(";") < 0) {
            boolean success = false;
            success = ProcessCenterUtil.sendUrgentMail((String)assignIds, (String)title, (String)content, (Context)this.ctx);
            if (success) {
                resultMap.put(SUCCESS, "1");
                resultMap.put(FAILURE, "0");
                resultMap.put(LOG, sendSuccess);
                return resultMap;
            }
            resultMap.put(SUCCESS, "0");
            resultMap.put(FAILURE, "1");
            resultMap.put(LOG, sendFailed);
            return resultMap;
        }
        Object[] assignIdArray = assignIds.split(";");
        List assignIdList = new ArrayList();
        assignIdList = Arrays.asList((Object[])assignIdArray);
        resultMap = ProcessCenterUtil.sendUrgentMail(assignIdList, (String)title, (String)content, (Context)this.ctx);
        return resultMap;
    }

    public void addMyProcess(String procDefIds) {
        if (StringUtils.isEmpty((String)procDefIds)) {
            return;
        }
        String[] procDefIdArray = procDefIds.split(";");
        ICustomizedProcConfig iMyProc = null;
        CustomizedProcConfigInfo myProcInfo = new CustomizedProcConfigInfo();
        try {
            iMyProc = CustomizedProcConfigFactory.getLocalInstance(this.ctx);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        for (int i = 0; i < procDefIdArray.length; ++i) {
            myProcInfo.setProcDefId(BOSUuid.read((String)procDefIdArray[i]));
            myProcInfo.setUserId(BOSUuid.read((String)this.ctx.getCaller().toString()));
            myProcInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
            boolean ifExists = false;
            try {
                ifExists = iMyProc.exists("where procDefId='" + procDefIdArray[i] + "' and userId = '" + this.ctx.getCaller().toString() + "'");
                if (ifExists) continue;
                iMyProc.addnew(myProcInfo);
                continue;
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                continue;
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void deleteMyProcess(String procDefIds) {
        if (StringUtils.isEmpty((String)procDefIds)) {
            return;
        }
        String[] procDefIdArray = procDefIds.split(";");
        ICustomizedProcConfig iMyProc = null;
        try {
            iMyProc = CustomizedProcConfigFactory.getLocalInstance(this.ctx);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        for (int i = 0; i < procDefIdArray.length; ++i) {
            try {
                iMyProc.delete("where procDefId='" + procDefIdArray[i] + "' and userId = '" + this.ctx.getCaller().toString() + "'");
                continue;
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                continue;
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public String sendInstantMsg(String receiverId, String priorty, String title, String content, String msgBosID) {
        if (StringUtils.isEmpty((String)priorty)) {
            priorty = "10";
        }
        Map returnValue = new HashMap();
        returnValue = ProcessCenterUtil.sendInstantMsg((String)receiverId, (String)priorty, (String)title, (String)content, (String)msgBosID, (Context)this.ctx);
        ArrayList list = new ArrayList();
        list.add(returnValue);
        return JSONUtil.getJson4List(list, null);
    }

    public boolean ifHasAttachment(String msgId) {
        if (StringUtils.isEmpty((String)msgId)) {
            return false;
        }
        IAttachmentHandleFacade iAttachHandler = null;
        List list = new ArrayList();
        try {
            iAttachHandler = AttachmentHandleFacadeFactory.getLocalInstance((Context)this.ctx);
            if (iAttachHandler != null) {
                list = iAttachHandler.getWebAttachment(msgId);
            }
            return list != null && list.size() > 0;
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public String getAttachmentsJson(String msgId) {
        ArrayList list = new ArrayList();
        if (StringUtils.isEmpty((String)msgId)) {
            return "";
        }
        List attachInfos = new ArrayList();
        attachInfos = ProcessCenterUtil.getAttachInfoByBoID((Context)this.ctx, (String)msgId);
        for (int i = 0; i < attachInfos.size(); ++i) {
            HashMap<String, String> map = new HashMap<String, String>();
            AttachmentInfo info = (AttachmentInfo)attachInfos.get(i);
            map.put("attachID", info.getAttachID());
            map.put("fileName", info.getName(this.ctx.getLocale()));
            map.put("suffix", info.getSimpleName());
            map.put("size", info.getSize());
            list.add(map);
        }
        return JSONUtil.getJson4List(list, null);
    }

    public String getProcInstStateById(String procInstId) {
        String state = "";
        try {
            IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)this.ctx);
            ProcessInstInfo info = service.getProcessInstInfo(procInstId);
            state = info.getState();
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return state;
    }

    public String getSendUrgentMessageJsonDataByProcInstId(String procInstId) {
        String jsonStr = "";
        try {
            List list = new ArrayList();
            IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)this.ctx);
            list = ProcessCenterUtil.getUrgentAssignIdByProcInstId((String)procInstId, (Context)this.ctx);
            HashMap map = new HashMap();
            IUser userService = UserFactory.getLocalInstance((Context)this.ctx);
            for (int i = 0; i < list.size(); ++i) {
                HashMap<String, Object> actInstMap = new HashMap<String, Object>();
                List<HashMap<String, String>> userList = new ArrayList();
                List employeeList = new ArrayList();
                ArrayList<String> filterEmployeeList = new ArrayList<String>();
                String id = list.get(i).toString();
                AssignmentInfo assignInfo = service.getAssignmentById(id);
                if (map.containsKey(assignInfo.getActInstId()) && assignInfo.getActInstId() != null) {
                    Map oldactInstMap = (Map)map.get(assignInfo.getActInstId());
                    if (oldactInstMap.get("employeeArray") != null) {
                        employeeList = (List)oldactInstMap.get("employeeArray");
                    }
                    if (oldactInstMap.get("userArray") != null) {
                        userList = (List)oldactInstMap.get("userArray");
                    }
                }
                HashMap<String, String> userMap = new HashMap<String, String>();
                userMap.put("id", assignInfo.getUserId());
                String name = "";
                try {
                    UserInfo userInfo = userService.getUserByID((IObjectPK)new ObjectStringPK(assignInfo.getUserId()));
                    name = userInfo.getNumber() + "(" + userInfo.getName(this.ctx.getLocale()) + ")";
                }
                catch (EASBizException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                userMap.put("name", StringUtils.isEmpty((String)name) ? assignInfo.getUserName(this.ctx.getLocale()) : name);
                HashMap<String, String> employeeMap = new HashMap<String, String>();
                userList.add(userMap);
                if (!filterEmployeeList.contains(assignInfo.getEmployeeId())) {
                    employeeMap.put("id", assignInfo.getEmployeeId());
                    employeeMap.put("name", assignInfo.getEmployeeName(this.ctx.getLocale()) != null ? assignInfo.getEmployeeName(this.ctx.getLocale()) : "\u672a\u547d\u540d");
                    employeeList.add(employeeMap);
                    filterEmployeeList.add(assignInfo.getEmployeeId());
                }
                actInstMap.put("subject", assignInfo.getSubject(this.ctx.getLocale()) != null ? assignInfo.getSubject(this.ctx.getLocale()) : "");
                actInstMap.put("content", assignInfo.getBody(this.ctx.getLocale()) != null ? assignInfo.getBody(this.ctx.getLocale()) : "");
                if (userList.size() <= 0 || employeeList.size() <= 0) continue;
                actInstMap.put("userArray", userList);
                actInstMap.put("employeeArray", employeeList);
                actInstMap.put("actDefName", assignInfo.getAssignInfo().get("actdefname_" + this.ctx.getLocale().toString()));
                actInstMap.put("actInstId", assignInfo.getActInstId());
                map.put(assignInfo.getActInstId(), actInstMap);
            }
            jsonStr = JSONUtil.getJson4Object(map, null);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return jsonStr;
    }

    public String submitUrgentMessage_actionPerformer(String msgType, String actInstId, String receivers, String title, String body, String priority) {
        String result = "";
        Map<String, String> returnMap = new HashMap<String, String>();
        ArrayList list = new ArrayList();
        String sendSuccess = ResourceBase.getString((String)MCRESOURCES, (String)"sendSuccess", (Locale)this.ctx.getLocale());
        String sendFailed = ResourceBase.getString((String)MCRESOURCES, (String)"sendFailed", (Locale)this.ctx.getLocale());
        HashMap<String, String> failMap = new HashMap<String, String>();
        failMap.put(SUCCESS, "0");
        failMap.put(FAILURE, "0");
        failMap.put(LOG, sendFailed);
        try {
            actInstId = URLDecoder.decode(actInstId, "utf-8");
            receivers = URLDecoder.decode(receivers, "utf-8");
            title = URLDecoder.decode(title, "utf-8");
            body = URLDecoder.decode(body, "utf-8");
        }
        catch (UnsupportedEncodingException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
            list.add(failMap);
            result = JSONUtil.getJson4List(list, null);
            return result;
        }
        try {
            if (msgType.equals("msg")) {
                boolean success = this.sendUrgentMsg(actInstId, receivers, title, body);
                if (success) {
                    returnMap.put(SUCCESS, "1");
                    returnMap.put(FAILURE, "0");
                    returnMap.put(LOG, sendSuccess);
                    list.add(returnMap);
                } else {
                    list.add(failMap);
                }
            } else if (msgType.equals("mobile")) {
                returnMap = this.sendUrgentMobile(actInstId, receivers, body, priority);
                list.add(returnMap);
            } else if (msgType.equals("mail")) {
                returnMap = this.sendUrgentMail(actInstId, receivers, title, body);
                list.add(returnMap);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            list.add(failMap);
            result = JSONUtil.getJson4List(list, null);
            return result;
        }
        result = JSONUtil.getJson4List(list, null);
        return result;
    }

    public Map getReplyOrTransmitMsg(String msgId, String instantType, String msgFunction) {
        String result = "";
        String mcRes = MCRESOURCES;
        String msg_title = "";
        String msg_priority = "";
        int msg_priority_int = 10;
        String msg_senderName = "";
        String msg_receiverTime = "";
        String msg_Nreceivers = "";
        String msg_body = "";
        String senderId = "";
        StringBuffer msg_result = new StringBuffer("");
        if (!StringUtils.isEmpty((String)msgId)) {
            block20: {
                if (instantType.equals("receive")) {
                    String senderUserId;
                    BMCMessageInfo msgInfo = null;
                    IBMCMessage iBMCMessage = null;
                    try {
                        iBMCMessage = BMCMessageFactory.getLocalInstance((Context)this.ctx);
                    }
                    catch (BOSException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    try {
                        msgInfo = iBMCMessage.getBMCMessageInfo("where id='" + msgId + "'");
                    }
                    catch (BaseMessageException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    catch (EASBizException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    catch (BOSException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    msg_priority = msgInfo.getPriority().getAlias();
                    msg_priority_int = msgInfo.getPriority().getValue();
                    msg_senderName = msgInfo.getSender();
                    msg_receiverTime = msgInfo.getReceiveTime().toString();
                    msg_Nreceivers = msgInfo.getNreceivers();
                    msg_title = msgInfo.getTitle();
                    msg_body = msgInfo.getBody();
                    String string = senderUserId = msgInfo.getSenderId() != null ? msgInfo.getSenderId() : "";
                    if (!StringUtils.isEmpty((String)senderUserId)) {
                        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)senderUserId));
                        try {
                            IUser iUser = UserFactory.getRemoteInstance();
                            UserInfo userInfo = iUser.getUserInfo((IObjectPK)pk);
                            if (userInfo.getPerson() == null) {
                                senderId = senderUserId;
                                break block20;
                            }
                            senderId = userInfo.getPerson().getId().toString();
                        }
                        catch (Exception e) {
                            logger.error((Object)e.getMessage(), (Throwable)e);
                            senderId = "";
                        }
                    }
                } else if (instantType.equals("send")) {
                    IMsgSendRecord iSendMsg = null;
                    MsgSendRecordInfo sendInfo = null;
                    IUser iUser = null;
                    UserInfo userInfo = null;
                    try {
                        iSendMsg = MsgSendRecordFactory.getLocalInstance((Context)this.ctx);
                        sendInfo = iSendMsg.getSendInfo(msgId);
                        iUser = UserFactory.getLocalInstance((Context)this.ctx);
                        userInfo = iUser.getUserInfo((IObjectPK)new ObjectUuidPK(sendInfo.getSenderID()));
                    }
                    catch (BOSException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    catch (EASBizException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    msg_priority = String.valueOf(sendInfo.getPriority().getAlias());
                    msg_senderName = userInfo.getName();
                    msg_receiverTime = sendInfo.getSendTime().toString();
                    msg_Nreceivers = sendInfo.getReciever();
                    msg_body = sendInfo.getBody();
                    msg_title = sendInfo.getTitle();
                }
            }
            if (msgFunction.equals("transmit")) {
                msg_title = ResourceBase.getString((String)mcRes, (String)"transmit", (Locale)this.ctx.getLocale()) + ":" + msg_title;
            } else if (msgFunction.equals("reply")) {
                msg_title = ResourceBase.getString((String)mcRes, (String)"reply", (Locale)this.ctx.getLocale()) + ":" + msg_title;
            }
            msg_result.append("\r\n\r\n\r\n---------------------------------------------------\r\n").append(ResourceBase.getString((String)mcRes, (String)"sender", (Locale)this.ctx.getLocale())).append(msg_senderName).append("\r\n").append(ResourceBase.getString((String)mcRes, (String)"sendTime", (Locale)this.ctx.getLocale())).append(msg_receiverTime).append("\r\n").append(ResourceBase.getString((String)mcRes, (String)"reciever", (Locale)this.ctx.getLocale())).append(":").append(msg_Nreceivers).append("\r\n").append(ResourceBase.getString((String)mcRes, (String)"title", (Locale)this.ctx.getLocale())).append(msg_title).append("\r\n\r\n").append(msg_body).append("\r\n");
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("title", msg_title);
        resultMap.put("content", msg_result.toString());
        resultMap.put("priorityValue", msg_priority_int);
        resultMap.put("priorityName", msg_priority);
        resultMap.put("senderName", msg_senderName == null ? "" : msg_senderName);
        resultMap.put("senderId", senderId);
        return resultMap;
    }

    public String createMsgIdForSendInstantMsg(String selectedIDs, String msgFunction) {
        String msgBosID = "";
        if (!StringUtils.isEmpty((String)selectedIDs)) {
            BMCMessageInfo msgInfo = new BMCMessageInfo();
            msgInfo.setId(BOSUuid.read((String)selectedIDs));
            String[] attachmentIds = null;
            if (msgFunction.equals("transmit")) {
                try {
                    attachmentIds = BoAttchAssoFactory.getRemoteInstance().getAttchIDsByBoID(selectedIDs);
                }
                catch (BOSException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (null != attachmentIds && attachmentIds.length > 0) {
                AttachmentServerManager aManager = AttachmentManagerFactory.getServerManager((Context)this.ctx);
                String msgBosID1 = msgInfo.getId().toString();
                msgInfo.setId(BOSUuid.create((BOSObjectType)msgInfo.getBOSType()));
                String msgBosID2 = msgInfo.getId().toString();
                try {
                    aManager.copyBizAttachmentFiles(msgBosID1, msgBosID2);
                }
                catch (EASBizException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (BOSException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                msgBosID = msgBosID2;
            } else {
                msgInfo.setId(BOSUuid.create((BOSObjectType)msgInfo.getBOSType()));
                msgBosID = msgInfo.getId().toString();
            }
        } else {
            BMCMessageInfo msgInfo = new BMCMessageInfo();
            BOSUuid msgBosIDUU = null;
            msgBosIDUU = msgInfo.getId() == null ? BOSUuid.create((BOSObjectType)msgInfo.getBOSType()) : msgInfo.getId();
            msgBosID = msgBosIDUU.toString();
        }
        return msgBosID;
    }

    public String allowForward(String assignmentIds) {
        String result = "";
        boolean allowForward = false;
        String[] ids = StringUtils.split((String)assignmentIds, (String)";");
        ArrayList<String> idStr = new ArrayList<String>();
        for (int i = 0; i < ids.length; ++i) {
            if (StringUtils.isEmpty((String)ids[i])) continue;
            String tmp = ids[i].toString();
            idStr.add(tmp);
        }
        String[] assignIds = idStr.toArray(new String[1]);
        IEnactmentService enactServe = null;
        try {
            enactServe = EnactmentServiceFactory.createEnactService((Context)this.ctx);
            allowForward = enactServe.allowForward(assignIds);
            result = String.valueOf(allowForward);
        }
        catch (WfException e) {
            logger.error((Object)("EnactmentService allowForward \u51fa\u9519" + e.getMessage()), (Throwable)e);
            result = "Function allowForward of EnactmentService is error";
        }
        catch (BOSException e) {
            logger.error((Object)("EnactmentService\u521b\u5efa\u8fdc\u7a0b\u63a5\u53e3\u51fa\u9519\u51fa\u9519" + e.getMessage()), (Throwable)e);
            result = "createEnactService error";
        }
        return result;
    }

    public String getOpenBillConfig(String idStr, String sourceIds) {
        String jsonStr = "";
        MessageCenterWebService msgCenterWebServ = new MessageCenterWebService();
        jsonStr = msgCenterWebServ.getMessageViewConfig(idStr, sourceIds);
        return jsonStr;
    }

    public String getBillConfigByMsgId(String idStr, String isHistory) {
        String jsonStr = "";
        MessageCenterWebService msgCenterWebServ = new MessageCenterWebService();
        jsonStr = msgCenterWebServ.getOpenBillConfigByMsgId(idStr, isHistory);
        return jsonStr;
    }

    public String getAssignStateByMsgId(String msgId) {
        String msgSourceStatus = "";
        msgSourceStatus = ProcessCenterUtil.getAssignStateByMsgId((String)msgId, (Context)this.ctx);
        return msgSourceStatus;
    }

    public String getMessageViewConfigByMsgId(String idStr, String ifHistory) {
        String sourceIds = "";
        String result = "";
        try {
            BMCMessageInfo msgInfo;
            if (!StringUtils.isEmpty((String)ifHistory) && ifHistory.equals("true")) {
                msgInfo = BMCMessageHistoryFactory.getRemoteInstance().getBMCMessageHistoryInfo("where id='" + idStr + "'");
                sourceIds = msgInfo.getSourceIDs();
            } else {
                msgInfo = BMCMessageFactory.getRemoteInstance().getBMCMessageInfo("where id='" + idStr + "'");
                sourceIds = msgInfo.getSourceIDs();
            }
        }
        catch (Exception e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
            return null;
        }
        ArrayList list = new ArrayList();
        HashMap<String, String> resultMap = new HashMap<String, String>();
        String openway = "";
        String[] info = new String[]{"", "", "", "", ""};
        if (sourceIds.indexOf("::") > -1) {
            String prefix = sourceIds.substring(0, sourceIds.indexOf("::"));
            Object obj = MessageViewConfig.getInstance((boolean)true).getConfigByPrefix(prefix);
            if (obj != null) {
                HashMap map = (HashMap)obj;
                if (map.get("web") != null) {
                    info[0] = map.get("web").toString();
                    resultMap.put("web", map.get("web").toString());
                } else {
                    resultMap.put("web", "");
                }
                if (map.get("viewweb") != null) {
                    Map tempMap = (Map)map.get("viewweb");
                    if (tempMap.get("pageparams") != null) {
                        resultMap.put("pageparams", (String)tempMap.get("pageparams"));
                    }
                    if (tempMap.get("model") != null) {
                        openway = tempMap.get("model").toString().equalsIgnoreCase("true") ? "0" : "2";
                        resultMap.put("openway", openway);
                    }
                } else {
                    if (map.get("width") != null && map.get("height") != null) {
                        resultMap.put("width", map.get("width").toString());
                        resultMap.put("height", map.get("height").toString());
                    } else {
                        resultMap.put("width", "");
                        resultMap.put("height", "");
                    }
                    if (map.get("model") != null) {
                        openway = map.get("model").toString().equalsIgnoreCase("true") ? "0" : "2";
                        resultMap.put("openway", openway);
                    } else {
                        resultMap.put("openway", "2");
                    }
                }
                logger.info((Object)("--getMessageViewConfig--webUrl--" + map.get("web")));
                logger.info((Object)("--getMessageViewConfig--sourceIds--" + sourceIds));
            } else {
                resultMap.put("web", "");
                resultMap.put("pageparams", "");
                resultMap.put("openway", "2");
                resultMap.put("errorlog", "no message view config");
            }
            list.add(resultMap);
            result = JSONUtil.getJson4List(list, null);
            try {
                IMessageCenter messageCenter = MessageCenterFactory.getLocalInstance((Context)this.ctx);
                messageCenter.setReadStatus("'" + idStr + "'", MsgStatus.getEnum((int)10), MsgType.getEnum((int)0));
            }
            catch (Exception e) {
                logger.error((Object)"getMessageViewConfig\u8bbe\u7f6e\u6d88\u606f\u9605\u8bfb\u72b6\u6001\u62a5\u9519", (Throwable)e);
            }
        }
        return result;
    }

    public String checkMsgContentLengthLimit(int contentLength) {
        ArrayList list = new ArrayList();
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("ifExceed", "false");
        resultMap.put("log", "");
        int contentLengthLimit = 500;
        contentLengthLimit = ProcessCenterUtil.getMsgContentLengthLimit((Context)this.ctx);
        logger.info((Object)("\u6d88\u606f\u5185\u5bb9\u6700\u5927\u5b57\u7b26\u6570=" + contentLengthLimit));
        if (contentLength > contentLengthLimit) {
            resultMap.put("ifExceed", "true");
            String log = MessageFormat.format(ResourceBase.getString((String)MCRESOURCES, (String)"contentLengthExceedLimit", (Locale)this.ctx.getLocale()), contentLengthLimit);
            resultMap.put("log", log);
        }
        list.add(resultMap);
        String result = JSONUtil.getJson4List(list, null);
        logger.info((Object)result);
        return result;
    }

    public String getReceivedIM(String msgId, String isHistory) {
        BMCMessageInfo msgInfo;
        ArrayList list = new ArrayList();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (isHistory.equals("false")) {
            msgInfo = null;
            try {
                IBMCMessage iBMCMessage = BMCMessageFactory.getLocalInstance((Context)this.ctx);
                msgInfo = iBMCMessage.getBMCMessageInfo("where id='" + msgId + "' and receiver='" + this.ctx.getCaller().toString() + "'");
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            resultMap.put("title", msgInfo.getTitle(this.ctx.getLocale()));
            resultMap.put("content", msgInfo.getBody(this.ctx.getLocale()));
            resultMap.put("priority", msgInfo.getPriority().getAlias(this.ctx.getLocale()));
            resultMap.put("priorityVal", msgInfo.getPriority().getValue());
            resultMap.put("senderName", msgInfo.getSender(this.ctx.getLocale()));
        } else if (isHistory.equals("true")) {
            msgInfo = null;
            try {
                IBMCMessageHistory iBMCMessage = BMCMessageHistoryFactory.getLocalInstance((Context)this.ctx);
                msgInfo = iBMCMessage.getBMCMessageHistoryInfo("where id='" + msgId + "' and receiver='" + this.ctx.getCaller().toString() + "'");
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            resultMap.put("title", msgInfo.getTitle(this.ctx.getLocale()));
            resultMap.put("content", msgInfo.getBody(this.ctx.getLocale()));
            resultMap.put("priority", msgInfo.getPriority().getAlias(this.ctx.getLocale()));
            resultMap.put("priorityVal", msgInfo.getPriority().getValue());
            resultMap.put("senderName", msgInfo.getSender(this.ctx.getLocale()));
        }
        list.add(resultMap);
        String result = JSONUtil.getJson4List(list, null);
        logger.info((Object)result);
        return result;
    }

    public List getAttachInfoForInstantMsg(String messageId) {
        ArrayList attachList = new ArrayList();
        HashMap<String, String> attachInfoMap = null;
        Locale local = this.ctx.getLocale();
        try {
            IBoAttchAsso iBoAttchAsso = BoAttchAssoFactory.getLocalInstance((Context)this.ctx);
            String[] attachmentIds = iBoAttchAsso.getAttchIDsByBoID(messageId);
            AttachmentCollection attachementColl = new AttachmentCollection();
            if (null != attachmentIds && attachmentIds.length > 0) {
                IAttachment iAttachment = AttachmentFactory.getLocalInstance((Context)this.ctx);
                int j = attachmentIds.length;
                for (int i = 0; i < j; ++i) {
                    AttachmentInfo attaInfo = iAttachment.getAttachmentInfo((IObjectPK)new ObjectUuidPK(attachmentIds[i]));
                    attachementColl.add(attaInfo);
                }
            }
            int size = 0;
            if (null != attachementColl && (size = attachementColl.size()) > 0) {
                AttachmentInfo attaInfo = null;
                String assoType = "";
                for (int i = 0; i < size; ++i) {
                    attaInfo = attachementColl.get(i);
                    assoType = " ";
                    if (null != attaInfo.getBoAttchAsso() && null != attaInfo.getBoAttchAsso().get(0) && null != attaInfo.getBoAttchAsso().get(0).getAssoType(local)) {
                        assoType = attaInfo.getBoAttchAsso().get(0).getAssoType(local);
                    }
                    if (null == attaInfo) continue;
                    attachInfoMap = new HashMap<String, String>();
                    attachInfoMap.put("Id", attaInfo.getId().toString());
                    attachInfoMap.put("attachId", attaInfo.getAttachID());
                    attachInfoMap.put("assoType", assoType);
                    attachInfoMap.put("name", attaInfo.getName(local) == null ? "" : attaInfo.getName(local));
                    attachInfoMap.put("type", attaInfo.getSimpleName());
                    attachInfoMap.put("size", attaInfo.getSize());
                    attachInfoMap.put("description", attaInfo.getDescription(local) == null ? "" : attaInfo.getDescription(local));
                    attachInfoMap.put("sharedDesc", attaInfo.getSharedDesc(local) == null ? "" : attaInfo.getSharedDesc(local));
                    attachInfoMap.put("createTime", attaInfo.getCreateTime().toString().substring(0, 19));
                    attachList.add(attachInfoMap);
                }
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return attachList;
    }

    public String getHTMLForDisplayAttach(String msgId) {
        return this.getHTMLForDisplayAttachInner(msgId, true);
    }

    public String getHTMLForDisplayAttach2(String msgId) {
        return this.getHTMLForDisplayAttachInner(msgId, false);
    }

    public String getHTMLForDisplayAttachInner(String msgId, boolean isNewProcessCenter) {
        StringBuffer result = new StringBuffer();
        List attachList = this.getAttachInfoForInstantMsg(msgId);
        if (attachList != null && attachList.size() > 0) {
            result.append("<ul class=\"ul_attach\">");
            for (int i = 0; i < attachList.size(); ++i) {
                Map map = (Map)attachList.get(i);
                String type = map.get("type").toString();
                String typeImgPath = this.getTypeImgPath(type);
                StringBuffer fileName = new StringBuffer();
                fileName.append(map.get("name").toString()).append(".").append(type).append("(").append(map.get("size").toString()).append(")");
                String _fileName = this.replacedByEllipsis(fileName.toString(), "40", null);
                result.append("<li class=\"li_attach\" >").append("<span class='filetypeSpan'><img class='filetypeImg' src='").append(typeImgPath).append("'/></span><span class='filename'>");
                if (isNewProcessCenter) {
                    result.append("<a id='").append(map.get("Id").toString()).append("' class='fileLink").append("' download='").append(map.get("name").toString()).append(".").append(type);
                    result.append("' href='/easweb/webviews/workflow/download.jsp?bosID=").append(map.get("Id").toString()).append("' onmouseover='javascript:_self.mouseOverLink(this);' onmouseout='javascript:_self.mouseOutLink(this);'>");
                    result.append(StringEscapeUtils.escapeHtml4((String)_fileName)).append("</a></span></li>");
                    continue;
                }
                result.append("<a id='").append(map.get("Id").toString()).append("' class='fileLink").append("' download='").append(map.get("name").toString()).append(".").append(type);
                result.append("' href='../../download.jsp?bosID=").append(map.get("Id").toString()).append("' onmouseover='javascript:mouseOverLink(this);' onmouseout='javascript:mouseOutLink(this);'>");
                result.append(StringEscapeUtils.escapeHtml4((String)_fileName)).append("</a></span></li>");
            }
            result.append("</ul>");
        }
        return result.toString();
    }

    private String getTypeImgPath(String type) {
        String typeStr = "chm;doc;docx;exe;htm;html;pdf;ppt;pptx;rar;txt;xls;xlsx;zip;";
        if (typeStr.indexOf(type) < 0) {
            type = "unknow";
        }
        StringBuffer path = new StringBuffer();
        path.append("/easweb/wf-portal/img/filetype/").append(type).append(".gif");
        return path.toString();
    }

    public String replacedByEllipsis(String text, String length, String ellipsis) {
        String result = "";
        String _length = StringUtils.isEmpty((String)length) ? "20" : length;
        int __length = Integer.parseInt(_length);
        String _ellipsis = StringUtils.isEmpty((String)ellipsis) ? "..." : ellipsis;
        result = ProcessCenterUtil.getSubString((String)text, (int)0, (int)__length, (String)_ellipsis);
        return result;
    }

    public String getSentIM(String msgId, String isHistory) {
        MsgSendRecordInfo msgInfo;
        ArrayList list = new ArrayList();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (isHistory.equals("false")) {
            msgInfo = null;
            try {
                IMsgSendRecord msgSendRecord = MsgSendRecordFactory.getLocalInstance((Context)this.ctx);
                msgInfo = msgSendRecord.getMsgSendRecordInfo("where id='" + msgId + "' and senderid='" + this.ctx.getCaller().toString() + "'");
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            resultMap.put("title", msgInfo.getTitle(this.ctx.getLocale()));
            resultMap.put("content", msgInfo.getBody(this.ctx.getLocale()));
            resultMap.put("priority", msgInfo.getPriority().getAlias(this.ctx.getLocale()));
            resultMap.put("priorityVal", msgInfo.getPriority().getValue());
            resultMap.put("receiverName", msgInfo.getReciever(this.ctx.getLocale()));
        } else if (isHistory.equals("true")) {
            msgInfo = null;
            try {
                IMsgSendRecordHst msgSendRecordHst = MsgSendRecordHstFactory.getLocalInstance((Context)this.ctx);
                msgInfo = msgSendRecordHst.getMsgSendRecordHstInfo("where id='" + msgId + "' and senderid='" + this.ctx.getCaller().toString() + "'");
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            resultMap.put("title", msgInfo.getTitle(this.ctx.getLocale()));
            resultMap.put("content", msgInfo.getBody(this.ctx.getLocale()));
            resultMap.put("priority", msgInfo.getPriority().getAlias(this.ctx.getLocale()));
            resultMap.put("priorityVal", msgInfo.getPriority().getValue());
            resultMap.put("receiverName", msgInfo.getReciever(this.ctx.getLocale()));
        }
        list.add(resultMap);
        String result = JSONUtil.getJson4List(list, null);
        logger.info((Object)result);
        return result;
    }

    public boolean setOtherSysMsgReadStatus(String idStr, int status) {
        boolean result = false;
        String[] idArray = idStr.split(",");
        ObjectUuidPK pk = null;
        WebServiceMessageInfo info = null;
        try {
            IWebServiceMessage iwsm = WebServiceMessageFactory.getLocalInstance((Context)this.ctx);
            for (int i = 0; i < idArray.length; ++i) {
                pk = new ObjectUuidPK(idArray[i]);
                info = (WebServiceMessageInfo)iwsm.getValue((IObjectPK)pk);
                info.setStatus(MsgStatus.getEnum((int)status));
                iwsm.update((IObjectPK)pk, (CoreBaseInfo)info);
            }
            result = true;
        }
        catch (Exception e) {
            logger.error((Object)"\u8bbe\u7f6e\u7b2c\u4e09\u65b9\u6d88\u606f\u7684\u5df2\u8bfb\u672a\u8bfb\u72b6\u6001\u51fa\u9519", (Throwable)e);
        }
        return result;
    }

    public boolean deleteOtherSysMsg(String idStr) {
        boolean result = false;
        String[] idArray = idStr.split(",");
        ObjectUuidPK pk = null;
        try {
            IWebServiceMessage iwsm = WebServiceMessageFactory.getLocalInstance((Context)this.ctx);
            for (int i = 0; i < idArray.length; ++i) {
                pk = new ObjectUuidPK(idArray[i]);
                iwsm.delete((IObjectPK)pk);
            }
            result = true;
        }
        catch (Exception e) {
            logger.error((Object)"\u5220\u9664\u7b2c\u4e09\u65b9\u6d88\u606f\u51fa\u9519", (Throwable)e);
        }
        return result;
    }

    public boolean refreshInstantMsg() {
        boolean result = false;
        ClassificationStatCacheManager msgCountCacheManager = ClassificationStatCacheManager.get((Context)this.ctx);
        msgCountCacheManager.expire(this.ctx.getCaller().toString());
        return result;
    }

    private boolean isDisableUrgentMoileDecision() {
        try {
            String mode = ParamManager.getParamValue(null, null, (String)"DisableUrgentMobileApprove");
            return Boolean.valueOf(mode);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            return false;
        }
    }

    public String getCurrentUserAssignIdByProcInstId(String procinstId) {
        String assignId = "";
        try {
            String subactinst;
            AssignmentInfo[] assigninfo;
            String subprocinst;
            ActivityInstInfo[] preactinfo;
            IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
            ActivityInstInfo[] actinfo = svc.getActInstMetaArrayByProcInstIdAndActInstState(procinstId, "open.not_running.not_started");
            if (actinfo.length == 0 && (preactinfo = svc.getActInstMetaArrayByProcInstIdAndActInstState(procinstId, "open.running")).length > 0 && !StringUtils.isEmpty((String)(subprocinst = preactinfo[0].getSubProcInstId()))) {
                actinfo = svc.getActInstMetaArrayByProcInstIdAndActInstState(subprocinst, "open.not_running.not_started");
            }
            if (actinfo.length > 0 && (assigninfo = svc.getAssignmentByActInstId(subactinst = actinfo[0].getActInstId())).length > 0) {
                assignId = assigninfo[0].getAssignmentId();
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return assignId;
    }

    public String getUndisposRow() {
        int count = 0;
        try {
            IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
            String userid = this.ctx.getCaller().toString();
            Map counts = svc.getUndisposRow(userid);
            count = (Integer)counts.get("count");
        }
        catch (BOSException e) {
            logger.error((Object)"\u83b7\u53d6\u95e8\u6237\u5de6\u4e0a\u89d2\u672a\u8bfb\u6570\u62a5\u9519", (Throwable)e);
        }
        return String.valueOf(count);
    }

    public String isApproveUrlNew(String id) {
        String isNew = null;
        try {
            IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
            String procdefid = null;
            if (id.endsWith("WFWKITEM")) {
                isNew = "false:false";
                AssignmentInfo assign = svc.getAssignmentById(id);
                procdefid = assign.getProcDefId();
                String[] approveStyleParam = ProcessParamUtils.getParamValues((Context)this.ctx, (String)procdefid, (String)"ApproveStyle");
                boolean approveStyle = false;
                if (approveStyleParam != null && "2".equals(approveStyleParam[0])) {
                    approveStyle = true;
                }
                boolean isOpenNewTab = ProcessParamUtils.isSatisfyThisParam((Context)this.ctx, (String)procdefid, (String)"ApprovalOpeningWay");
                isNew = approveStyle + ":" + isOpenNewTab;
            } else if (id.endsWith("WFPCINST")) {
                isNew = "false";
                ProcessInstInfo procInstInfo = svc.getProcessInstInfo(id);
                procdefid = procInstInfo.getProcDefId();
                boolean isOpenNewTab = ProcessParamUtils.isSatisfyThisParam((Context)this.ctx, (String)procdefid, (String)"ApprovalOpeningWay");
                isNew = String.valueOf(isOpenNewTab);
            }
        }
        catch (BOSException e) {
            logger.error((Object)"\u83b7\u53d6\u914d\u7f6e\u53c2\u6570\u62a5\u9519", (Throwable)e);
        }
        return isNew;
    }

    public String isOpenApprovePage(String assignId) {
        try {
            IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
            AssignmentInfo assign = svc.getAssignmentById(assignId);
            String curUser = this.ctx.getCaller().toString();
            if (!curUser.equals(assign.getUserId())) {
                return "false";
            }
            if (assign.getState() == WfAssignmentState.ACCEPTED || assign.getState() == WfAssignmentState.ASSIGNED) {
                return "true";
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return "false";
    }
}

