/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.mc.web.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationCollection;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.SubmitAssignResult;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ExtendedAttributeDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.WebBillManpowerActivityDef;
import com.kingdee.bos.workflow.define.extended.ApproveActivityDef;
import com.kingdee.bos.workflow.define.extended.ManualDecisionActivityDef;
import com.kingdee.bos.workflow.metas.DataTypeEnum;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.bos.workflow.store.util.StoreUtils;
import com.kingdee.eas.base.message.util.ProcessCenterUtil;
import com.kingdee.eas.base.message.web.WebMessageUtils;
import com.kingdee.eas.base.multiapprove.ApproveResult;
import com.kingdee.eas.base.multiapprove.DecisionItemInfo;
import com.kingdee.eas.base.multiapprove.IMultiApprove;
import com.kingdee.eas.base.multiapprove.ManualDecisionInfo;
import com.kingdee.eas.base.multiapprove.MultiApproveFactory;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.base.multiapprove.MultiApproveStatusEnum;
import com.kingdee.eas.base.multiapprove.OptionEnum;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.eip.mc.web.URLInfo;
import com.kingdee.eas.cp.eip.pc.IProcUtilFacade;
import com.kingdee.eas.cp.eip.pc.ProcCatalogException;
import com.kingdee.eas.cp.eip.pc.ProcUtilFacadeFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.buffalo.server.BuffaloService;
import org.apache.log4j.Logger;

public class WebWorkFlowService
extends BuffaloService {
    private static Logger logger = Logger.getLogger((String)WebWorkFlowService.class.getName());
    private static String URLNAME = "url";
    private static final String RESOURCE = "com.kingdee.eas.base.message.MessageCenter";
    private HashMap localeMap = new HashMap();
    private static Locale locale = ContextUtils.getLocaleFromEnv();
    private static final String[] MULTIAPPROVE_MANUALDECISION_TYPES = new String[]{EASCommonResource.getString((String)"com.kingdee.eas.base.message.MessageCenter", (String)"agree", (Locale)locale), EASCommonResource.getString((String)"com.kingdee.eas.base.message.MessageCenter", (String)"unagree", (Locale)locale), EASCommonResource.getString((String)"com.kingdee.eas.base.message.MessageCenter", (String)"all", (Locale)locale)};

    public String save(String id, String assignMentID, String billID, String isPass, String opinion, int cOpinion, String opinionDesc) {
        try {
            IMultiApprove multiApprove = MultiApproveFactory.getRemoteInstance();
            MultiApproveInfo mInfo = null;
            ObjectUuidPK pk = null;
            if (StringUtils.isEmpty((String)id)) {
                mInfo = new MultiApproveInfo();
                mInfo.setAssignment(assignMentID);
                mInfo.setBillId(BOSUuid.read((String)billID));
                mInfo.setIsPass(ApproveResult.getEnum((String)isPass));
                mInfo.setOpinion(opinion);
                mInfo.setHandlerOpinion(cOpinion);
                mInfo.setHandlerContent(opinionDesc);
                pk = multiApprove.addnew((CoreBaseInfo)mInfo);
            } else {
                pk = new ObjectUuidPK(id);
                mInfo = multiApprove.getMultiApproveInfo((IObjectPK)pk);
                mInfo.setAssignment(assignMentID);
                mInfo.setBillId(BOSUuid.read((String)billID));
                mInfo.setIsPass(ApproveResult.getEnum((String)isPass));
                mInfo.setOpinion(opinion);
                mInfo.setHandlerOpinion(cOpinion);
                mInfo.setHandlerContent(opinionDesc);
                multiApprove.update((IObjectPK)pk, (CoreBaseInfo)mInfo);
            }
            if (pk != null) {
                return pk.toString();
            }
        }
        catch (Exception e) {
            logger.error((Object)"save audit info error", (Throwable)e);
        }
        return "";
    }

    public String submit(String id, String assignMentID, String billID, String isPass, String opinion, int cOpinion, String opinionDesc) {
        try {
            IMultiApprove multiApprove = MultiApproveFactory.getRemoteInstance();
            MultiApproveInfo mInfo = null;
            ObjectUuidPK pk = null;
            if (StringUtils.isEmpty((String)id)) {
                mInfo = new MultiApproveInfo();
                mInfo.setAssignment(assignMentID);
                mInfo.setBillId(BOSUuid.read((String)billID));
                mInfo.setIsPass(ApproveResult.getEnum((String)isPass));
                mInfo.setOpinion(opinion);
                mInfo.setHandlerOpinion(cOpinion);
                mInfo.setHandlerContent(opinionDesc);
                mInfo.setExtendedProperty("assignmentID", assignMentID);
                mInfo.setExtendedProperty("isAddNew", "isAddNew");
                mInfo.setExtendedProperty("businuessObjectId", billID);
                pk = multiApprove.submit((CoreBaseInfo)mInfo);
            } else {
                pk = new ObjectUuidPK(id);
                mInfo = multiApprove.getMultiApproveInfo((IObjectPK)pk);
                mInfo.setAssignment(assignMentID);
                mInfo.setBillId(BOSUuid.read((String)billID));
                mInfo.setIsPass(ApproveResult.getEnum((String)isPass));
                mInfo.setOpinion(opinion);
                mInfo.setHandlerOpinion(cOpinion);
                mInfo.setHandlerContent(opinionDesc);
                mInfo.setExtendedProperty("assignmentID", assignMentID);
                mInfo.setExtendedProperty("isAddNew", "isAddNew");
                mInfo.setExtendedProperty("businuessObjectId", billID);
                multiApprove.submit((CoreBaseInfo)mInfo);
            }
            if (pk != null) {
                return pk.toString();
            }
        }
        catch (Exception e) {
            logger.error((Object)"submit audit info error", (Throwable)e);
        }
        return "";
    }

    public String submitAssign(String id, String assignMentID, String billID, String isPass, String opinion, int cOpinion, String opinionDesc, String sendMail, String sendMsg) {
        try {
            IMultiApprove multiApprove = MultiApproveFactory.getRemoteInstance();
            MultiApproveInfo mInfo = null;
            ObjectUuidPK pk = null;
            if (StringUtils.isEmpty((String)id)) {
                mInfo = new MultiApproveInfo();
                mInfo.setAssignment(assignMentID);
                mInfo.setBillId(BOSUuid.read((String)billID));
                mInfo.setIsPass(ApproveResult.getEnum((String)isPass));
                mInfo.setOpinion(opinion);
                mInfo.setHandlerOpinion(cOpinion);
                mInfo.setIsMailNotifyNext(Boolean.valueOf(sendMail).booleanValue());
                mInfo.setIsMobelNotifyNext(Boolean.valueOf(sendMsg).booleanValue());
                mInfo.setHandlerContent(opinionDesc);
                mInfo.setExtendedProperty("assignmentID", assignMentID);
                mInfo.setExtendedProperty("isAddNew", "isAddNew");
                mInfo.setExtendedProperty("businuessObjectId", billID);
                pk = multiApprove.submit((CoreBaseInfo)mInfo);
            } else {
                pk = new ObjectUuidPK(id);
                mInfo = multiApprove.getMultiApproveInfo((IObjectPK)pk);
                mInfo.setAssignment(assignMentID);
                mInfo.setBillId(BOSUuid.read((String)billID));
                mInfo.setIsPass(ApproveResult.getEnum((String)isPass));
                mInfo.setOpinion(opinion);
                mInfo.setIsMailNotifyNext(Boolean.valueOf(sendMail).booleanValue());
                mInfo.setIsMobelNotifyNext(Boolean.valueOf(sendMsg).booleanValue());
                mInfo.setHandlerOpinion(cOpinion);
                mInfo.setHandlerContent(opinionDesc);
                mInfo.setExtendedProperty("assignmentID", assignMentID);
                mInfo.setExtendedProperty("isAddNew", "isAddNew");
                mInfo.setExtendedProperty("businuessObjectId", billID);
                multiApprove.submit((CoreBaseInfo)mInfo);
            }
            if (pk != null) {
                return pk.toString();
            }
        }
        catch (Exception e) {
            logger.error((Object)"submit audit info error", (Throwable)e);
        }
        return "";
    }

    public String save_new(String id, String assignMentID, String billID, String isPass, String opinion, int cOpinion, boolean sendMessage, boolean sendMail, String opinionDesc) {
        try {
            IMultiApprove multiApprove = MultiApproveFactory.getRemoteInstance();
            MultiApproveInfo mInfo = null;
            ObjectUuidPK pk = null;
            if (StringUtils.isEmpty((String)id)) {
                mInfo = new MultiApproveInfo();
                mInfo.setAssignment(assignMentID);
                mInfo.setBillId(BOSUuid.read((String)billID));
                mInfo.setIsPass(ApproveResult.getEnum((String)isPass));
                mInfo.setOpinion(opinion);
                mInfo.setStatus(MultiApproveStatusEnum.TEMPORARILYSAVE);
                mInfo.setHandlerOpinion(cOpinion);
                mInfo.setHandlerContent(opinionDesc);
                mInfo.setIsMailNotifyNext(sendMail);
                mInfo.setIsMobelNotifyNext(sendMessage);
                pk = multiApprove.addnew((CoreBaseInfo)mInfo);
            } else {
                pk = new ObjectUuidPK(id);
                mInfo = multiApprove.getMultiApproveInfo((IObjectPK)pk);
                mInfo.setStatus(MultiApproveStatusEnum.TEMPORARILYSAVE);
                mInfo.setAssignment(assignMentID);
                mInfo.setBillId(BOSUuid.read((String)billID));
                mInfo.setIsPass(ApproveResult.getEnum((String)isPass));
                mInfo.setOpinion(opinion);
                mInfo.setHandlerOpinion(cOpinion);
                mInfo.setHandlerContent(opinionDesc);
                mInfo.setIsMailNotifyNext(sendMail);
                mInfo.setIsMobelNotifyNext(sendMessage);
                multiApprove.update((IObjectPK)pk, (CoreBaseInfo)mInfo);
            }
            if (pk != null) {
                return pk.toString();
            }
        }
        catch (Exception e) {
            logger.error((Object)"save audit info error", (Throwable)e);
        }
        return "";
    }

    public String submit_new(String id, String assignMentID, String billID, String isPass, String opinion, boolean sendMessage, boolean sendMail, int cOpinion, String opinionDesc) {
        try {
            IMultiApprove multiApprove = MultiApproveFactory.getRemoteInstance();
            MultiApproveInfo mInfo = null;
            ObjectUuidPK pk = null;
            if (StringUtils.isEmpty((String)id)) {
                mInfo = new MultiApproveInfo();
                mInfo.setStatus(MultiApproveStatusEnum.SUBMIT);
                mInfo.setAssignment(assignMentID);
                mInfo.setBillId(BOSUuid.read((String)billID));
                mInfo.setIsPass(ApproveResult.getEnum((String)isPass));
                mInfo.setOpinion(opinion);
                mInfo.setHandlerOpinion(cOpinion);
                mInfo.setHandlerContent(opinionDesc);
                mInfo.setExtendedProperty("assignmentID", assignMentID);
                mInfo.setExtendedProperty("isAddNew", "isAddNew");
                mInfo.setExtendedProperty("businuessObjectId", billID);
                mInfo.setIsMailNotifyNext(sendMail);
                mInfo.setIsMobelNotifyNext(sendMessage);
                pk = multiApprove.submit((CoreBaseInfo)mInfo);
            } else {
                pk = new ObjectUuidPK(id);
                mInfo = multiApprove.getMultiApproveInfo((IObjectPK)pk);
                mInfo.setStatus(MultiApproveStatusEnum.SUBMIT);
                mInfo.setAssignment(assignMentID);
                mInfo.setBillId(BOSUuid.read((String)billID));
                mInfo.setIsPass(ApproveResult.getEnum((String)isPass));
                mInfo.setOpinion(opinion);
                mInfo.setHandlerOpinion(cOpinion);
                mInfo.setHandlerContent(opinionDesc);
                mInfo.setExtendedProperty("assignmentID", assignMentID);
                mInfo.setExtendedProperty("isAddNew", "isAddNew");
                mInfo.setExtendedProperty("businuessObjectId", billID);
                mInfo.setIsMailNotifyNext(sendMail);
                mInfo.setIsMobelNotifyNext(sendMessage);
                multiApprove.submit((CoreBaseInfo)mInfo);
            }
            if (pk != null) {
                return pk.toString();
            }
        }
        catch (Exception e) {
            logger.error((Object)"submit audit info error", (Throwable)e);
        }
        return "";
    }

    public boolean decideSubmit(String assignmentID, String decideName, int decideCount, String decideID, String decideItemStr, String decideStr, String desc) {
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        try {
            EnactmentServiceProxy iEnactmentService = new EnactmentServiceProxy(ctx);
            AssignmentInfo assInfo = iEnactmentService.getAssignmentById(assignmentID);
            String bizPackgeName = assInfo.getBizPackage();
            String bizFunName = assInfo.getBizFunction();
            String bizOperation = assInfo.getBizOperation();
            String userID = assInfo.getUserId();
            ManualDecisionInfo decisionInfo = new ManualDecisionInfo();
            decisionInfo.setName(decideName);
            decisionInfo.setSelectItemCount(decideCount);
            decisionInfo.setSelectedIndices(decideID);
            decisionInfo.setSelectedItems(decideStr);
            decisionInfo.setSelectItems(decideItemStr);
            decisionInfo.setDescription(desc);
            String newId = BOSUuid.create((BOSObjectType)decisionInfo.getBOSType()).toString();
            decisionInfo.setId(BOSUuid.read((String)newId));
            HashMap<String, ManualDecisionInfo> map = new HashMap<String, ManualDecisionInfo>();
            map.put(newId, decisionInfo);
            SubmitAssignResult result = iEnactmentService.submitAssignment(map, userID, bizPackgeName, bizFunName, bizOperation, assInfo, null);
            return result.getStatus();
        }
        catch (Exception e) {
            logger.error((Object)"decision node submit workflow error", (Throwable)e);
            return false;
        }
    }

    public URLInfo isManualDecision(String assignmentID) {
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        URLInfo info = new URLInfo();
        try {
            EnactmentServiceProxy iEnactmentService = new EnactmentServiceProxy(ctx);
            AssignmentInfo assInfo = iEnactmentService.getAssignmentById(assignmentID);
            String bizOperation = assInfo.getBizOperation();
            String bizPackgeName = assInfo.getBizPackage();
            String bizFunName = assInfo.getBizFunction();
            String[] bizObjectID = assInfo.getBizObjectIdArray();
            String billID = "";
            if (bizFunName.equals("ManualDecisionUIFunction")) {
                MetaDataPK metaPK = new MetaDataPK(bizPackgeName, bizFunName);
                FunctionObjectInfo function = MetaDataLoaderFactory.getRemoteMetaDataLoader().getFunction((IMetaDataPK)metaPK);
                OperationInfo oper = this.getOperation(bizOperation, function);
                if (oper == null || oper.getUiActionRef() == null) {
                    throw new WfException("UI is null");
                }
                if (bizObjectID != null && bizObjectID[0] != null) {
                    billID = bizObjectID[0];
                    info.setBillID(billID);
                }
                Map map = null;
                String assignUrl = this.getWebBillURL(ctx, billID);
                UIObjectInfo ui = oper.getUiActionRef().getUIObjectRef();
                if (ui != null && StringUtils.isEmpty((String)assignUrl)) {
                    map = ui.getExtendedProperties();
                } else {
                    info.setURL(assignUrl);
                }
                if (map != null && map.size() > 0) {
                    info.setURL((String)map.get("url"));
                    info.setHeight((String)map.get("height"));
                    info.setWidth((String)map.get("width"));
                    info.setOpenWay((String)map.get("openWay"));
                }
                String cusStatus = null;
                String actInstId = assInfo.getActInstId();
                ActivityInstInfo actInstInfo = iEnactmentService.getActivityInstByActInstId(actInstId);
                ActivityDef actDef = iEnactmentService.getActDefByActInstInfo(actInstInfo);
                if (actDef != null && actDef.getActivityHeader().getExtendedAttributes().get("customUIStatus") != null) {
                    ExtendedAttributeDef attrDef = actDef.getActivityHeader().getExtendedAttributes().get("customUIStatus");
                    cusStatus = attrDef.getValue();
                }
                info.setUIStatus(cusStatus);
                String decisionItems = "";
                if (actDef instanceof ApproveActivityDef) {
                    decisionItems = WebWorkFlowService.getCustomDecisiones(actDef, "manualDecisionItems");
                    info.setDecisionItems(decisionItems);
                }
            } else {
                info = null;
            }
        }
        catch (Exception e) {
            logger.error((Object)"isManualDecision error", (Throwable)e);
        }
        return info;
    }

    public URLInfo getUrlInfos(String assignmentIDs) {
        URLInfo info = new URLInfo();
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String[] idArray = assignmentIDs.split(";");
        boolean isMultiAssign = false;
        try {
            String url = "";
            String bizPackgeName = "";
            String bizFunName = "";
            String bizOperation = "";
            MetaDataPK metaPK = null;
            OperationInfo oper = null;
            FunctionObjectInfo function = null;
            UIObjectInfo ui = null;
            Map map = new HashMap();
            String assignUrl = "";
            String[] bizObjectID = null;
            String billID = "";
            IMetaDataLoader dataLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            EnactmentServiceProxy iEnactmentService = new EnactmentServiceProxy(ctx);
            AssignmentInfo[] assInfos = null;
            if (idArray.length > 1) {
                assInfos = iEnactmentService.getAssignmentById(idArray, DataTypeEnum.RUNTIME);
                isMultiAssign = true;
            } else {
                AssignmentInfo assInfo = iEnactmentService.getAssignmentById(assignmentIDs);
                assInfos = new AssignmentInfo[]{assInfo};
            }
            for (int i = 0; i < assInfos.length; ++i) {
                Map m;
                Object act;
                bizPackgeName = assInfos[i].getBizPackage();
                bizFunName = assInfos[i].getBizFunction();
                bizOperation = assInfos[i].getBizOperation();
                bizObjectID = assInfos[i].getBizObjectIdArray();
                if (WfAssignmentState.CANCELED.equals((Object)assInfos[i].getState())) {
                    info.setErrorMsg(EASCommonResource.getString((String)RESOURCE, (String)"taskcancel", (Locale)this.getLocale(ctx)));
                    return info;
                }
                if (WfAssignmentState.REJECTED.equals((Object)assInfos[i].getState())) {
                    info.setErrorMsg(EASCommonResource.getString((String)RESOURCE, (String)"taskreject", (Locale)this.getLocale(ctx)));
                    return info;
                }
                if (WfAssignmentState.COMPLETED.equals((Object)assInfos[i].getState())) {
                    info.setErrorMsg(EASCommonResource.getString((String)RESOURCE, (String)"taskcomplete", (Locale)this.getLocale(ctx)));
                    return info;
                }
                if (bizObjectID != null && bizObjectID[0] != null) {
                    billID = bizObjectID[0];
                }
                if ((act = (m = iEnactmentService.getActivityDefAndActivityInstInfo(assInfos[i].getAssignmentId())).get("ACTIVITYDEF")) instanceof WebBillManpowerActivityDef) {
                    String webUrl = ((WebBillManpowerActivityDef)act).getUrl();
                    if (webUrl != null && !webUrl.equals("")) {
                        assignUrl = "/easweb" + webUrl;
                        info.setURL(assignUrl);
                        String uistatus = ((WebBillManpowerActivityDef)act).getUiState();
                        info.setUIStatus(uistatus == null ? "VIEW" : uistatus);
                        info.setWidth("1280");
                        info.setHeight("1024");
                    }
                } else {
                    metaPK = new MetaDataPK(bizPackgeName, bizFunName);
                    function = dataLoader.getFunction((IMetaDataPK)metaPK);
                    oper = this.getOperation(bizOperation, function);
                    if (oper == null || oper.getUiActionRef() == null) {
                        throw new WfException("UI is null");
                    }
                    if (!StringUtils.isEmpty((String)billID)) {
                        assignUrl = this.getWebBillURL(ctx, billID);
                    }
                    if ((ui = oper.getUiActionRef().getUIObjectRef()) != null) {
                        map = ui.getExtendedProperties();
                        if (StringUtils.isEmpty((String)assignUrl)) {
                            assignUrl = (String)map.get(URLNAME);
                        }
                    }
                    if ("09DEC9DC".equals(BOSUuid.read((String)billID).getType().toString())) {
                        IEnactmentService service = EnactmentServiceProxy.getEnacementService((Context)ctx);
                        if (assignUrl != null && bizFunName.equals("MultiApproveUIFunction")) {
                            Map argumentMap = service.getAssignmentArgument(assInfos[i].getAssignmentId(), true);
                            String editUIName = (String)argumentMap.get("UIClassName");
                            if (StringUtils.isEmpty((String)billID)) {
                                billID = (String)argumentMap.get("ID");
                            }
                            String[] editURlStr = null;
                            if (!StringUtils.isEmpty((String)billID) && StringUtils.isEmpty((String)editUIName)) {
                                editUIName = ProcessCenterUtil.getEditUIClassByBillId((String)billID, (Context)ctx);
                            }
                            if ((editURlStr = ProcessCenterUtil.getURLByClassName((String)editUIName, (Context)ctx))[0] == null || "".equals(editURlStr[0])) {
                                assignUrl = "";
                            }
                        }
                    } else if (StringUtils.isEmpty((String)assignUrl)) {
                        assignUrl = StoreUtils.getWebUIurl((String)billID, (Context)ctx);
                    }
                    if (map != null) {
                        if (assignUrl != null) {
                            if (i == 0) {
                                info.setURL(assignUrl);
                                url = assignUrl;
                            } else if (assignUrl != null && !assignUrl.equals(url)) {
                                info.setErrorMsg(EASCommonResource.getString((String)RESOURCE, (String)"notSameType", (Locale)this.getLocale(ctx)));
                                return info;
                            }
                        }
                        if (!isMultiAssign) {
                            if (map.get("height") != null) {
                                info.setHeight((String)map.get("height"));
                            }
                            if (map.get("width") != null) {
                                info.setWidth((String)map.get("width"));
                            }
                            if (map.get("openWay") != null) {
                                info.setOpenWay((String)map.get("openWay"));
                            }
                            if (map.get("editpage") != null) {
                                info.setEditPage((String)map.get("editpage"));
                            }
                        }
                    }
                }
                if (isMultiAssign) continue;
                info.setBillID(billID);
                String cusStatus = null;
                String actInstId = assInfos[i].getActInstId();
                ActivityInstInfo actInstInfo = iEnactmentService.getActivityInstByActInstId(actInstId);
                ActivityDef actDef = iEnactmentService.getActDefByActInstInfo(actInstInfo);
                if (actDef != null && actDef.getActivityHeader().getExtendedAttributes().get("customUIStatus") != null) {
                    ExtendedAttributeDef attrDef = actDef.getActivityHeader().getExtendedAttributes().get("customUIStatus");
                    cusStatus = attrDef.getValue();
                }
                info.setUIStatus(cusStatus == null ? "VIEW" : cusStatus);
                String decisionItems = "";
                if (!(actDef instanceof ApproveActivityDef)) continue;
                decisionItems = WebWorkFlowService.getCustomDecisiones(actDef, "manualDecisionItems");
                info.setDecisionItems(decisionItems);
            }
        }
        catch (WfException we) {
            logger.error((Object)"WfException", (Throwable)we);
            info.setErrorMsg(EASCommonResource.getString((String)RESOURCE, (String)"getPageError", (Locale)this.getLocale(ctx)));
        }
        catch (BOSException be) {
            logger.error((Object)"BOSException", (Throwable)be);
            info.setErrorMsg(EASCommonResource.getString((String)RESOURCE, (String)"getPageError", (Locale)this.getLocale(ctx)));
        }
        catch (Exception e) {
            logger.error((Object)EASCommonResource.getString((String)RESOURCE, (String)"getPageError", (Locale)this.getLocale(ctx)), (Throwable)e);
            info.setErrorMsg(EASCommonResource.getString((String)RESOURCE, (String)"getPageError", (Locale)this.getLocale(ctx)));
        }
        return info;
    }

    private Locale getLocale(Context ctx) {
        if (ctx == null) {
            return locale;
        }
        if (ctx.getLocale() == null) {
            return locale;
        }
        return ctx.getLocale();
    }

    public boolean isWebSupportBill(String assignmentID) {
        boolean support = false;
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        try {
            String[] editURlStr;
            EnactmentServiceProxy iEnactmentService = new EnactmentServiceProxy(ctx);
            AssignmentInfo assInfo = iEnactmentService.getAssignmentById(assignmentID);
            Map argumentMap = iEnactmentService.getAssignmentArgument(assignmentID, true);
            String editUIName = (String)argumentMap.get("UIClassName");
            String billID = assInfo.getBizObjectIdArray()[0];
            if (StringUtils.isEmpty((String)editUIName)) {
                editUIName = ProcessCenterUtil.getEditUIClassByBillId((String)billID, (Context)ctx);
            }
            if (!StringUtils.isEmpty((String)(editURlStr = ProcessCenterUtil.getURLByClassName((String)editUIName, (Context)ctx))[0])) {
                support = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)EASCommonResource.getString((String)RESOURCE, (String)"getPageError", (Locale)this.getLocale(ctx)), (Throwable)e);
        }
        return support;
    }

    public URLInfo getUrlInfo(String assignmentID) {
        return this.getUrlInfos(assignmentID);
    }

    private String getWebBillURL(Context ctx, String billID) {
        String[] dynamicEditUrl = ProcessCenterUtil.getDynamicEditURLByBillId((String)billID, (Context)ctx);
        if (dynamicEditUrl != null && dynamicEditUrl.length == 2) {
            StringBuffer urlStr = new StringBuffer(dynamicEditUrl[0]);
            if (!StringUtils.isEmpty((String)dynamicEditUrl[1])) {
                urlStr.append(urlStr.indexOf("?") < 0 ? "?" : "&").append("uipk").append("=").append(dynamicEditUrl[1]);
            }
            logger.info((Object)("getWebBillURL-urlStr.toString()= " + urlStr.toString()));
            return urlStr.toString();
        }
        String webUIurl = StoreUtils.getWebUIurl((String)billID, (Context)ctx);
        if (webUIurl != null) {
            logger.info((Object)("getWebBillURL-webUIurl= " + webUIurl));
            return webUIurl;
        }
        return "";
    }

    public String RollBackToWeb(String assignid) throws BOSException {
        try {
            String sourceId = assignid;
            HttpServletRequest request = (HttpServletRequest)this.getRequest();
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
            IEnactmentService service = EnactmentServiceFactory.createRemoteEnactService();
            AssignmentInfo assInfo = service.getAssignmentById(assignid);
            service.rollbackActInst(assInfo.getActInstId());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            return "\u4e0d\u80fd\u56de\u9000";
        }
        return "\u56de\u9000\u6210\u529f";
    }

    public URLInfo getEditUrlInfoByAssign(String assignid) {
        URLInfo info = new URLInfo();
        if (!assignid.endsWith("WFWKITEM")) {
            return info;
        }
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        try {
            ExtendedAttributeDef extend;
            ManualDecisionActivityDef actDef;
            ExtendedAttributeDef extend1;
            Map m;
            Object act;
            EnactmentServiceProxy iEnactmentService = new EnactmentServiceProxy(ctx);
            AssignmentInfo assInfo = iEnactmentService.getAssignmentById(assignid);
            String[] bizObjectID = assInfo.getBizObjectIdArray();
            String billID = "";
            if (bizObjectID != null && bizObjectID[0] != null) {
                billID = bizObjectID[0];
                info.setBillID(billID);
            }
            if (billID != null) {
                billID = billID.replaceAll(" ", "+");
            }
            if ((act = (m = iEnactmentService.getActivityDefAndActivityInstInfo(assInfo.getAssignmentId())).get("ACTIVITYDEF")) instanceof WebBillManpowerActivityDef) {
                Map argumentMap = iEnactmentService.getAssignmentArgument(assInfo.getAssignmentId(), true);
                StringBuffer webUrl = new StringBuffer(((WebBillManpowerActivityDef)act).getUrl());
                if (webUrl.length() > 0) {
                    Iterator it = argumentMap.keySet().iterator();
                    while (it.hasNext()) {
                        String paraName = it.next().toString();
                        if (!"formid".equalsIgnoreCase(paraName)) continue;
                        String paraValue = null;
                        try {
                            paraValue = StringUtils.replace((String)URLEncoder.encode(String.valueOf(argumentMap.get(paraName)), "utf-8"), (String)"+", (String)"%2B");
                        }
                        catch (Exception ex) {
                            paraValue = "";
                        }
                        webUrl.append(webUrl.indexOf("?") < 0 ? "?" : "&").append(paraName).append("=").append(paraValue);
                        break;
                    }
                    logger.info((Object)("WebBillManpowerActivityDef webUrl = " + webUrl.toString()));
                    info.setURL(webUrl.toString());
                }
            } else if (act instanceof ApproveActivityDef) {
                ExtendedAttributeDef extend12;
                ApproveActivityDef approDef = (ApproveActivityDef)act;
                ExtendedAttributeDef extend2 = approDef.getActivityHeader().getExtendedAttributes().get("isWebBillApprove");
                if (extend2 != null && "true".equalsIgnoreCase(extend2.getValue()) && (extend12 = approDef.getActivityHeader().getExtendedAttributes().get("WebBillApproveUrl")) != null && !StringUtils.isEmpty((String)extend12.getValue())) {
                    info.setURL(extend12.getValue());
                    logger.info((Object)("ApproveActivityDef url = " + extend12.getValue()));
                }
            } else if (act instanceof ManualDecisionActivityDef && (extend1 = (actDef = (ManualDecisionActivityDef)act).getActivityHeader().getExtendedAttributes().get("isWebBillManualDecision")) != null && "true".equalsIgnoreCase(extend1.getValue()) && (extend = actDef.getActivityHeader().getExtendedAttributes().get("WebBillManualDecisionUrl")) != null && !StringUtils.isEmpty((String)extend.getValue())) {
                info.setURL(extend.getValue());
            }
            if (StringUtils.isEmpty((String)info.getURL())) {
                String myUrl = this.getWebBillURL(ctx, billID);
                if (!StringUtils.isEmpty((String)myUrl)) {
                    info.setURL(myUrl);
                    logger.info((Object)("getEditUrlInfoByAssign1 myUrl = " + info.getURL()));
                    return info;
                }
                String editUIName = null;
                if (!StringUtils.isEmpty((String)billID) && "09DEC9DC".equals(BOSUuid.read((String)billID).getType().toString())) {
                    IEnactmentService service = EnactmentServiceProxy.getEnacementService((Context)ctx);
                    Map argumentMap = service.getAssignmentArgument(assInfo.getAssignmentId(), true);
                    editUIName = (String)argumentMap.get("UIClassName");
                }
                if (StringUtils.isEmpty(editUIName)) {
                    editUIName = ProcessCenterUtil.getEditUIClassByBillId((String)billID, (Context)ctx);
                }
                String[] results = ProcessCenterUtil.getURLByClassName(editUIName, (Context)ctx);
                info.setURL(results[0]);
                info.setHeight(results[1]);
                info.setWidth(results[2]);
                info.setOpenWay(results[3]);
            }
        }
        catch (Exception e) {
            logger.error((Object)EASCommonResource.getString((String)RESOURCE, (String)"getPageError", (Locale)this.getLocale(ctx)), (Throwable)e);
        }
        logger.info((Object)("getEditUrlInfoByAssign1 url = " + info.getURL()));
        return info;
    }

    public URLInfo getEditUrlInfo(String billID) {
        URLInfo info = new URLInfo();
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        try {
            if (billID != null) {
                billID = billID.replaceAll(" ", "+");
            }
            info.setBillID(billID);
            EnactmentServiceProxy iEnactmentService = new EnactmentServiceProxy(ctx);
            ProcessInstInfo[] instInfos = iEnactmentService.getProcessInstanceByHoldedObjectId(billID);
            logger.info((Object)("instInfos.length = " + instInfos.length));
            if (instInfos.length == 0) {
                instInfos = iEnactmentService.getAllProcessInstancesByBizobjId(billID);
            }
            logger.info((Object)("instInfos.length 2 = " + instInfos.length));
            for (int k = 0; k < instInfos.length; ++k) {
                String hashValue = instInfos[k].getProcDefHashValue();
                ProcessDef def = iEnactmentService.getProcessDefByDefineHashValue(hashValue);
                ActivityCollection actColl = def.getActivitys();
                logger.info((Object)("actColl.size() = " + actColl.size()));
                for (int i = 0; i < actColl.size(); ++i) {
                    ApproveActivityDef approDef;
                    ExtendedAttributeDef extend;
                    ActivityDef act = actColl.get(i);
                    if (act instanceof WebBillManpowerActivityDef) {
                        StringBuffer webUrl = new StringBuffer(((WebBillManpowerActivityDef)act).getUrl());
                        logger.info((Object)("webUrl = " + webUrl));
                        if (webUrl.length() <= 0) continue;
                        if (webUrl.indexOf("?") > 0) {
                            webUrl.append("&pk=").append(StringUtils.replace((String)billID, (String)"+", (String)"%2B"));
                        } else {
                            webUrl.append("?pk=").append(StringUtils.replace((String)billID, (String)"+", (String)"%2B"));
                        }
                        logger.info((Object)("WebBillManpowerActivityDef webUrl = " + webUrl));
                        info.setURL(webUrl.toString());
                        return info;
                    }
                    if (!(act instanceof ApproveActivityDef) || (extend = (approDef = (ApproveActivityDef)act).getActivityHeader().getExtendedAttributes().get("isWebBillApprove")) == null || !"true".equalsIgnoreCase(extend.getValue())) continue;
                    ExtendedAttributeDef extend1 = approDef.getActivityHeader().getExtendedAttributes().get("WebBillApproveUrl");
                    logger.info((Object)("extend1.getValue() = " + extend1.getValue()));
                    if (extend1 == null || StringUtils.isEmpty((String)extend1.getValue())) continue;
                    String url = extend1.getValue();
                    if (url.indexOf("?") > 0) {
                        url = url + "&pk=";
                        url = url + StringUtils.replace((String)billID, (String)"+", (String)"%2B");
                    } else {
                        url = url + "?pk=";
                        url = url + StringUtils.replace((String)billID, (String)"+", (String)"%2B");
                    }
                    info.setURL(url);
                    logger.info((Object)("ApproveActivityDef url by billid = " + url));
                    return info;
                }
            }
            String myUrl = this.getWebBillURL(ctx, billID);
            if (!StringUtils.isEmpty((String)myUrl)) {
                info.setURL(myUrl);
                logger.info((Object)("getEditUrlInfo myUrl = " + info.getURL()));
                return info;
            }
            String className = ProcessCenterUtil.getEditUIClassByBillId((String)billID, (Context)ctx);
            logger.info((Object)("className = " + className));
            String[] results = ProcessCenterUtil.getURLByClassName((String)className, (Context)ctx);
            info.setURL(results[0]);
            info.setHeight(results[1]);
            info.setWidth(results[2]);
            info.setOpenWay(results[3]);
        }
        catch (Exception e) {
            logger.error((Object)EASCommonResource.getString((String)RESOURCE, (String)"getPageError", (Locale)this.getLocale(ctx)), (Throwable)e);
        }
        logger.info((Object)("getEditUrlInfo1 url = " + info.getURL()));
        return info;
    }

    public URLInfo getEditUrlInfoByProcInst(String procInstID) {
        int len;
        boolean isIncludeHst = false;
        boolean isCanUrgent = false;
        if (procInstID.startsWith("nIncludeHis~!~")) {
            isIncludeHst = true;
            procInstID = procInstID.substring(14);
        }
        if (procInstID.endsWith("~!~1")) {
            isCanUrgent = true;
            len = procInstID.length();
            procInstID = procInstID.substring(0, len - 4);
        } else if (procInstID.endsWith("~!~0")) {
            isCanUrgent = false;
            len = procInstID.length();
            procInstID = procInstID.substring(0, len - 4);
        }
        String billID = "";
        HashMap bizObjmap = new HashMap();
        URLInfo info = new URLInfo();
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        try {
            IProcUtilFacade iProcUtil = ProcUtilFacadeFactory.getRemoteInstance();
            bizObjmap = iProcUtil.getBizObjIdByProcInst(procInstID, isCanUrgent, isIncludeHst);
            if (bizObjmap.size() <= 0) {
                throw new ProcCatalogException(ProcCatalogException.VIEWBILLFAIL);
            }
            if (bizObjmap.size() >= 1) {
                billID = (String)bizObjmap.keySet().toArray()[0];
            }
            if (billID != null) {
                billID = billID.replaceAll(" ", "+");
                info.setBillID(billID);
            }
            info = this.getEditUrlInfo(billID);
        }
        catch (Exception e) {
            logger.error((Object)EASCommonResource.getString((String)RESOURCE, (String)"getPageError", (Locale)this.getLocale(ctx)), (Throwable)e);
        }
        logger.info((Object)("getEditUrlInfoByProcInst url = " + info.getURL()));
        return info;
    }

    private OperationInfo getOperation(String bizOperation, FunctionObjectInfo function) {
        OperationInfo oper = null;
        OperationCollection operCol = function.getOperation();
        for (int i = 0; i < operCol.size(); ++i) {
            if (!StringUtils.equalsIgnoreCase((String)operCol.get(i).getName(), (String)bizOperation)) continue;
            oper = operCol.get(i);
            break;
        }
        return oper;
    }

    public static String getCustomDecisiones(ActivityDef actDef, String propertyKey) {
        ExtendedAttributeDef att = actDef.getActivityHeader().getExtendedAttributes().get(propertyKey);
        String propertyValue = "";
        if (att != null) {
            propertyValue = att.getValue();
        }
        if (StringUtils.isEmpty((String)propertyValue)) {
            ApproveActivityDef temp = null;
            if (actDef instanceof ApproveActivityDef) {
                temp = (ApproveActivityDef)actDef;
                propertyValue = temp.getManualDecisionItems(locale);
            }
        }
        return propertyValue;
    }

    public static List getCustomDecisiones(ActivityDef actDef, String propertyKey, boolean approveType) {
        ExtendedAttributeDef att = actDef.getActivityHeader().getExtendedAttributes().get(propertyKey);
        String propertyValue = "";
        if (att != null) {
            propertyValue = att.getValue();
        }
        if (StringUtils.isEmpty((String)propertyValue)) {
            ApproveActivityDef temp = null;
            if (actDef instanceof ApproveActivityDef) {
                temp = (ApproveActivityDef)actDef;
                propertyValue = temp.getManualDecisionItems(locale);
            }
        }
        return WebWorkFlowService.getFilterDecisionItemList(propertyValue, approveType);
    }

    public static List getFilterDecisionItemList(String decisionItemsString, boolean approveType) {
        List decisionItems = WebWorkFlowService.getDecisionItemList(decisionItemsString);
        ArrayList<DecisionItemInfo> filteList = new ArrayList<DecisionItemInfo>();
        for (int i = 0; i < decisionItems.size(); ++i) {
            DecisionItemInfo item = (DecisionItemInfo)decisionItems.get(i);
            if (approveType) {
                if (item.getType().trim().equalsIgnoreCase(MULTIAPPROVE_MANUALDECISION_TYPES[1])) continue;
                filteList.add(item);
                continue;
            }
            if (item.getType().trim().equalsIgnoreCase(MULTIAPPROVE_MANUALDECISION_TYPES[0])) continue;
            filteList.add(item);
        }
        if (filteList.size() == 0) {
            Iterator it = OptionEnum.iterator();
            while (it.hasNext()) {
                OptionEnum option = (OptionEnum)it.next();
                DecisionItemInfo info = new DecisionItemInfo();
                info.setKey(option.getValue());
                info.setValue(option.getAlias());
                info.setType(MULTIAPPROVE_MANUALDECISION_TYPES[2]);
                filteList.add(info);
            }
        }
        return filteList;
    }

    public static List getDecisionItemList(String decisionItemsString) {
        ArrayList<DecisionItemInfo> decisionItems = new ArrayList<DecisionItemInfo>();
        if (decisionItemsString != null && decisionItemsString.trim().length() > 0) {
            String[] items = StringUtils.split((String)decisionItemsString, (String)":");
            String[] itemRows = new String[3];
            for (int i = 0; i < items.length; ++i) {
                itemRows = StringUtils.split((String)items[i], (String)";");
                DecisionItemInfo info = new DecisionItemInfo();
                info.setKey(Integer.parseInt(itemRows[0]));
                info.setValue(itemRows[1]);
                if (itemRows.length == 2) {
                    info.setType(MULTIAPPROVE_MANUALDECISION_TYPES[2]);
                } else {
                    info.setType(itemRows[2].trim());
                }
                decisionItems.add(info);
            }
        }
        return decisionItems;
    }

    public String submitDeliver(String deliverPerson, String deliverOpinion, String assignId) {
        String userID = null;
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        try {
            IUser user = UserFactory.getRemoteInstance();
            IObjectPK pk = ctx.getCaller();
            UserInfo info = user.getUserInfo(pk);
            String currentPerson = info.getName();
            Locale local = ctx.getLocale();
            deliverOpinion = deliverOpinion + "\n" + ResourceBase.getString((String)RESOURCE, (String)"deliver.user", (Locale)local) + currentPerson;
            this.localeMap.put(local, deliverOpinion);
            if (!user.exists(" where person ='" + deliverPerson + "'")) {
                return "noSuchUser";
            }
            UserCollection users = user.getUserCollection(" where person ='" + deliverPerson + "'");
            int size = users.size();
            userID = users.get(size - 1).getId().toString();
            WebMessageUtils.forwardAssignmentWithOpinion((Context)ctx, (String)assignId, (String)userID, (HashMap)this.localeMap);
        }
        catch (Exception e) {
            logger.error((Object)EASCommonResource.getString((String)RESOURCE, (String)"deliverTaskFail", (Locale)this.getLocale(ctx)), (Throwable)e);
        }
        return "";
    }

    public String canHandleAssignment(String assignmentID) {
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        if (!WebWorkFlowService.canForwardAssignment(ctx, assignmentID)) {
            return "no";
        }
        return "yes";
    }

    public String getSourceIds(String messgeId) {
        String sourceIds = null;
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String sql = "select FSourceIDs from T_BAS_Message where FID=? union all  select FSourceIDs from T_BAS_MessageHst where FID=?";
        Object[] param = new String[]{messgeId, messgeId};
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param);
            if (rowSet.next()) {
                sourceIds = rowSet.getString("FSourceIDs");
            }
        }
        catch (Exception e) {
            logger.error((Object)"getSourceIds error", (Throwable)e);
        }
        return sourceIds;
    }

    private static boolean canForwardAssignment(Context ctx, String assignmentId) {
        AssignmentInfo assignmentInfo = null;
        try {
            IEnactmentService service = EnactmentServiceProxy.getEnacementService((Context)ctx);
            boolean allowForward = WebWorkFlowService.allowForward(service, assignmentId);
            if (!allowForward) {
                return false;
            }
            assignmentInfo = service.getAssignmentById(assignmentId);
        }
        catch (Exception e) {
            logger.error((Object)"canForwardAssignment error", (Throwable)e);
            return false;
        }
        return assignmentInfo.getState().equals((Object)WfAssignmentState.ASSIGNED) || assignmentInfo.getState().equals((Object)WfAssignmentState.ACCEPTED);
    }

    private static boolean allowForward(IEnactmentService service, String assignmentId) throws Exception {
        if (service == null) {
            throw new IllegalArgumentException();
        }
        if (assignmentId == null || assignmentId.length() <= 0) {
            throw new IllegalArgumentException();
        }
        AssignmentInfo assignmentInfo = service.getAssignmentById(assignmentId);
        String procInstId = assignmentInfo.getProcInstId();
        String actDefId = assignmentInfo.getActDefId();
        ProcessInstInfo processInstInfo = service.getProcessInstInfo(procInstId);
        ProcessDef processDef = null;
        processDef = service.getRuntimeProcessDef(processInstInfo.getProcDefHashValue());
        if (processDef == null) {
            logger.error((Object)"The process define is not existing ");
            return false;
        }
        ActivityDef activityDef = processDef.getActivityDef(actDefId);
        if (!(activityDef instanceof ManpowerActivityDef)) {
            return false;
        }
        ManpowerActivityDef manpowerActivityDef = (ManpowerActivityDef)activityDef;
        return manpowerActivityDef.getAllowAssignNextPerformer();
    }
}

