/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.mrm;

import com.kingdee.eas.cp.mrm.DayEnum;
import com.kingdee.eas.cp.mrm.MRApplyUtil;
import com.kingdee.eas.cp.mrm.MRMRegularInteval;
import com.kingdee.eas.cp.mrm.MRRegularInfo;
import com.kingdee.eas.cp.mrm.MonthTypeEnum;
import com.kingdee.eas.cp.mrm.WeekEnum;
import com.kingdee.eas.cp.mrm.WeekNumEnu;
import com.kingdee.eas.cp.mrm.WeekTypeEnum;
import com.kingdee.util.DateTimeUtils;
import java.sql.Time;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class MRRegularIntevalCenter {
    public static MRMRegularInteval getCurInteval(MRRegularInfo regular, Date curDate) {
        MRMRegularInteval retInteval = null;
        if (MRApplyUtil.compareDate(regular.getRepEndDate(), curDate) < 0) {
            retInteval = null;
        }
        if (MRApplyUtil.compareDateMinute((retInteval = MRRegularIntevalCenter.getFirstAvaInteval(regular, curDate)).getMeetBeginDate(), curDate) < 0) {
            if (null == (retInteval = MRRegularIntevalCenter.getNextInteval(retInteval))) {
                return null;
            }
            while (MRApplyUtil.compareDateMinute(retInteval.getMeetBeginDate(), curDate) < 0) {
                if (null != (retInteval = MRRegularIntevalCenter.getNextInteval(retInteval))) continue;
                return null;
            }
        }
        Date repEndDate = regular.getRepEndDate();
        if (MRApplyUtil.compareDate(retInteval.getMeetEndDate(), repEndDate) > 0) {
            retInteval = null;
        }
        return retInteval;
    }

    public static MRMRegularInteval getFirstAvaInteval(MRRegularInfo regular, Date curDate) {
        MRMRegularInteval inteval = new MRMRegularInteval(regular, curDate);
        Date intevalDate = null;
        Date beginDate = regular.getRepStartDate();
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(beginDate);
        if (regular.getRepeatType().getValue().equals("0")) {
            WeekEnum weekWeekEnu = regular.getWeek_weekNum();
            c.set(7, Integer.valueOf(weekWeekEnu.getValue()));
            if (MRApplyUtil.compareDate(c.getTime(), beginDate) < 0) {
                ((Calendar)c).add(6, 7);
            }
            intevalDate = c.getTime();
        } else if (regular.getMonthSetting().getValue().equals("0")) {
            WeekNumEnu monWeek_weekNum = regular.getMonWeek_weekNum();
            WeekEnum monWeek_weekDay = regular.getMonWeek_weekDay();
            int weekNum = Integer.parseInt(monWeek_weekNum.getValue());
            int weekDay = Integer.parseInt(monWeek_weekDay.getValue());
            intevalDate = MRRegularIntevalCenter.getMonthWeekDay(c.getTime(), weekNum, weekDay);
        } else {
            DayEnum monDay_day = regular.getMonDay_day();
            int day = Integer.parseInt(monDay_day.getValue());
            intevalDate = MRRegularIntevalCenter.getMonthDay(c.getTime(), day);
        }
        inteval.setMeetBeginDate(MRRegularIntevalCenter.getDateByDateAndTime(intevalDate, regular.getStartTime()));
        inteval.setMeetEndDate(MRRegularIntevalCenter.getDateByDateAndTime(inteval.getMeetBeginDate(), regular.getEndTime()));
        inteval.setGenEndDate(inteval.getMeetBeginDate());
        inteval.setGenBeginDate(MRApplyUtil.getDay(DateTimeUtils.addDay((Date)inteval.getGenEndDate(), (long)(0 - regular.getMrGenAhead()))));
        inteval.setIntevalBeginDate(inteval.getMeetBeginDate());
        inteval.setIntevalEndDate(inteval.getMeetEndDate());
        return inteval;
    }

    public static MRMRegularInteval getNextInteval(MRMRegularInteval inteval) {
        MRMRegularInteval next = new MRMRegularInteval(inteval.getRegular(), inteval.getCurDate());
        MRRegularInfo regular = inteval.getRegular();
        Date intevalDate = MRRegularIntevalCenter.getNextIntevalDate(inteval.getMeetBeginDate(), regular);
        if (MRApplyUtil.compareDate(intevalDate, regular.getRepEndDate()) > 0) {
            return null;
        }
        next.setMeetBeginDate(MRRegularIntevalCenter.getDateByDateAndTime(intevalDate, regular.getStartTime()));
        next.setMeetEndDate(MRRegularIntevalCenter.getDateByDateAndTime(intevalDate, regular.getEndTime()));
        next.setGenEndDate(next.getMeetBeginDate());
        next.setGenBeginDate(MRApplyUtil.getDay(DateTimeUtils.addDay((Date)next.getGenEndDate(), (long)(0 - regular.getMrGenAhead()))));
        next.setIntevalBeginDate(next.getMeetBeginDate());
        next.setIntevalEndDate(next.getMeetEndDate());
        return next;
    }

    private static Date getNextIntevalDate(Date date, MRRegularInfo regular) {
        Date intevalDate = null;
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        if (regular.getRepeatType().getValue().equals("0")) {
            WeekTypeEnum weekWeekType = regular.getWeek_weekType();
            if (weekWeekType.getValue().equals("0")) {
                c.set(3, c.get(3) + 1);
            } else {
                c.set(3, c.get(3) + 2);
            }
            intevalDate = c.getTime();
        } else if (regular.getMonthSetting().getValue().equals("0")) {
            MonthTypeEnum monWeek_monType = regular.getMonWeek_monType();
            WeekNumEnu monWeek_weekNum = regular.getMonWeek_weekNum();
            WeekEnum monWeek_weekDay = regular.getMonWeek_weekDay();
            String monType = monWeek_monType.getValue();
            int weekNum = Integer.parseInt(monWeek_weekNum.getValue());
            int weekDay = Integer.parseInt(monWeek_weekDay.getValue());
            intevalDate = MRRegularIntevalCenter.getNextMonthWeekDay(date, weekNum, weekDay, monType);
        } else {
            MonthTypeEnum monDay_monType = regular.getMonDay_monType();
            DayEnum monDay_day = regular.getMonDay_day();
            int day = Integer.parseInt(monDay_day.getValue());
            String monType = monDay_monType.getValue();
            intevalDate = MRRegularIntevalCenter.getNextMonthDay(date, day, monType);
        }
        return intevalDate;
    }

    private static Date getMonthWeekDay(Date date, int weekNum, int dayNum) {
        Date retDate = null;
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(5, 15);
        cal.set(7, dayNum);
        if (weekNum == Integer.parseInt("5")) {
            weekNum = MRRegularIntevalCenter.getWeekNumLastValue(cal.getTime());
        }
        cal.set(8, weekNum);
        while (MRApplyUtil.compareDate(cal.getTime(), date) < 0) {
            ((Calendar)cal).add(2, 1);
            cal.set(5, 15);
            cal.set(7, dayNum);
            if (weekNum == Integer.parseInt("5")) {
                weekNum = MRRegularIntevalCenter.getWeekNumLastValue(cal.getTime());
            }
            cal.set(8, weekNum);
        }
        retDate = cal.getTime();
        return retDate;
    }

    private static Date getNextMonthWeekDay(Date date, int weekNum, int dayNum, String monType) {
        Date retDate = null;
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        if ("1".equals(monType)) {
            ((Calendar)cal).add(2, 2);
        } else {
            ((Calendar)cal).add(2, 1);
        }
        cal.set(5, 15);
        cal.set(7, dayNum);
        if (weekNum == Integer.parseInt("5")) {
            weekNum = MRRegularIntevalCenter.getWeekNumLastValue(cal.getTime());
        }
        cal.set(8, weekNum);
        retDate = cal.getTime();
        return retDate;
    }

    private static Date getMonthDay(Date date, int dayNum) {
        Date retDate = null;
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        if (dayNum == Integer.parseInt("-1")) {
            retDate = MRApplyUtil.getLastDay(cal.getTime());
        } else {
            cal.set(5, dayNum);
            if (MRApplyUtil.compareDate(cal.getTime(), date) < 0) {
                ((Calendar)cal).add(2, 1);
            }
            while (dayNum != cal.get(5)) {
                cal.set(5, dayNum);
            }
            retDate = cal.getTime();
        }
        return retDate;
    }

    private static Date getNextMonthDay(Date date, int dayNum, String monType) {
        Date retDate = null;
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        if ("1".equals(monType)) {
            ((Calendar)cal).add(2, 2);
        } else {
            ((Calendar)cal).add(2, 1);
        }
        if (dayNum == Integer.parseInt("-1")) {
            retDate = MRApplyUtil.getLastDay(cal.getTime());
        } else {
            cal.set(5, dayNum);
            while (dayNum != cal.get(5)) {
                cal.set(5, dayNum);
            }
            retDate = cal.getTime();
        }
        return retDate;
    }

    private static Date getDateByDateAndTime(Date date, Time time) {
        Calendar cDate = Calendar.getInstance();
        cDate.setTime(date);
        Calendar cTime = Calendar.getInstance();
        cTime.setTime(new Date(time.getTime()));
        Calendar c = Calendar.getInstance();
        c.set(1, cDate.get(1));
        c.set(2, cDate.get(2));
        c.set(5, cDate.get(5));
        c.set(11, cTime.get(11));
        c.set(12, cTime.get(12));
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    private static int getWeekNumLastValue(Date date) {
        int weekNum = 0;
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(8, 5);
        GregorianCalendar cal2 = new GregorianCalendar();
        cal2.setTime(date);
        weekNum = cal.get(2) == cal2.get(2) ? 5 : 4;
        return weekNum;
    }
}

