/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.pc.client;

import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.eip.pc.ConfigurationItemFactory;
import com.kingdee.eas.cp.eip.pc.CustomizedConfigurationFactory;
import com.kingdee.eas.cp.eip.pc.IConfigurationItem;
import com.kingdee.eas.cp.eip.pc.ICustomizedConfiguration;
import com.kingdee.eas.cp.eip.pc.IProcCatalog;
import com.kingdee.eas.cp.eip.pc.ProcCatalogFactory;
import com.kingdee.eas.cp.eip.pc.ProcCatalogInfo;
import com.kingdee.eas.cp.eip.pc.ProcCatalogNode;
import com.kingdee.eas.cp.eip.pc.client.AbstractConfigurationItemUI;
import com.kingdee.eas.cp.eip.pc.client.util.BuildTreeNode;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class ConfigurationItemUI
extends AbstractConfigurationItemUI {
    private static final Logger logger = Logger.getLogger((String)ConfigurationItemUI.class.getName());
    private final String procCatalogResource = "com.kingdee.eas.cp.eip.pc.ProcCatalogResource";
    private BuildTreeNode buildTreeNode = null;

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionCloseProc.setEnabled(true);
        this.setButtonState(true);
    }

    private void setButtonState(boolean bFlag) {
        this.actionAddAll.setEnabled(bFlag);
        this.actionAddOne.setEnabled(bFlag);
        this.actionRemoveAll.setEnabled(bFlag);
        this.actionRemoveOne.setEnabled(bFlag);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.buildTreeNode = new BuildTreeNode();
        this.kDContainer1.setEnableActive(false);
        logger.debug((Object)"BuildTreeNode success");
        this.initTreeData();
        logger.debug((Object)"initTreeData success");
        this.initProcData();
        logger.debug((Object)"initTreeData success");
    }

    private void initTreeData() throws Exception {
        IProcCatalog procCatalog = ProcCatalogFactory.getRemoteInstance();
        KDTreeNode rootNode = this.buildTreeNode.buildProcCatalogTree();
        KingdeeTreeModel model = new KingdeeTreeModel((TreeNode)rootNode);
        this.kdtProcCatalogTree.setModel((TreeModel)model);
        this.kdtProcCatalogTree.setRootVisible(false);
        this.kdtProcCatalogTree.setRowHeight(20);
        this.kdtProcCatalogTree.getSelectionModel().setSelectionMode(1);
    }

    private void initProcData() throws Exception {
        KDTreeNode rootNode = this.buildTreeNode.buildProcInitCatAlogTreeFromWF();
        KingdeeTreeModel model = new KingdeeTreeModel((TreeNode)rootNode);
        this.kdTreeSelecting.setModel((TreeModel)model);
        this.kdTreeSelecting.setRootVisible(false);
        this.kdTreeSelecting.setRowHeight(20);
    }

    @Override
    protected void kdtProcCatalogTree_valueChanged(TreeSelectionEvent e) throws Exception {
        super.kdtProcCatalogTree_valueChanged(e);
        this.kdlSelectedItem.removeAllElements();
        KDTreeNode treeNode = (KDTreeNode)this.kdtProcCatalogTree.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
            this.kDLabelContainer2.setBoundLabelText(((ProcCatalogInfo)treeNode.getUserObject()).getName());
            this.kDLabelContainer2.setBoundLabelUnderline(true);
            if (treeNode.getChildCount() == 0) {
                IConfigurationItem configurationItem = ConfigurationItemFactory.getRemoteInstance();
                ArrayList listConfigItem = configurationItem.getConfigurationItem(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), ((ProcCatalogInfo)treeNode.getUserObject()).getId().toString());
                if (treeNode.isLeaf()) {
                    if (listConfigItem.size() > 0) {
                        treeNode.setCustomIcon(EASResource.getIcon((String)"imgTree_folder_open"));
                    } else {
                        treeNode.setCustomIcon(EASResource.getIcon((String)"imgTree_folder_close"));
                    }
                }
                if (listConfigItem != null) {
                    int nSize = listConfigItem.size();
                    for (int i = 0; i < nSize; ++i) {
                        this.kdlSelectedItem.addElement(listConfigItem.get(i));
                    }
                }
            }
        }
    }

    @Override
    protected void kdTreeSelecting_mouseClicked(MouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            KDTreeNode treeNode = (KDTreeNode)this.kdTreeSelecting.getLastSelectedPathComponent();
            if (!treeNode.isLeaf()) {
                return;
            }
            if (treeNode != null && treeNode.getUserObject() instanceof ProcCatalogNode) {
                this.addOneItem();
            }
        }
    }

    @Override
    protected void kdTreeSelecting_valueChanged(TreeSelectionEvent e) throws Exception {
        super.kdTreeSelecting_valueChanged(e);
    }

    @Override
    public void actionAddOne_actionPerformed(ActionEvent e) throws Exception {
        this.addOneItem();
    }

    private void addOneItem() throws Exception {
        int i;
        KDTreeNode treeNode = (KDTreeNode)this.kdtProcCatalogTree.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
            if (treeNode.getChildCount() != 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.cp.eip.pc.ProcCatalogResource", (String)"noAddProcessToParent"));
                return;
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.cp.eip.pc.ProcCatalogResource", (String)"noSelectTreeNode"));
            return;
        }
        ProcCatalogInfo procCatalogInfo = (ProcCatalogInfo)treeNode.getUserObject();
        int nSize = 0;
        ArrayList listIDs = new ArrayList();
        ArrayList<Object> listProcDef = new ArrayList<Object>();
        TreePath[] selectTreePath = this.kdTreeSelecting.getSelectionPaths();
        Object object = null;
        if (selectTreePath != null && selectTreePath.length > 0) {
            boolean nNum = false;
            Object childNode = null;
            nSize = selectTreePath.length;
            for (i = 0; i < nSize; ++i) {
                treeNode = (KDTreeNode)selectTreePath[i].getLastPathComponent();
                object = treeNode.getUserObject();
                if (!(object instanceof ProcCatalogNode)) continue;
                ProcCatalogNode tempCacalog = (ProcCatalogNode)object;
                if (tempCacalog.getId() == null) {
                    this.getProcNotAddByCatalog(treeNode, listIDs, listProcDef);
                    continue;
                }
                listIDs.add(((ProcCatalogNode)object).getId());
                listProcDef.add(object);
                this.kdTreeSelecting.removeNodeFromParent((MutableTreeNode)treeNode);
            }
        }
        if ((nSize = listIDs.size()) <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.cp.eip.pc.ProcCatalogResource", (String)"selectedProcess"));
            return;
        }
        listIDs.add(0, procCatalogInfo);
        listIDs.add(1, procCatalogInfo.getSolution());
        IConfigurationItem configurationItem = ConfigurationItemFactory.getRemoteInstance();
        listIDs = configurationItem.addBatch(listIDs);
        nSize = listIDs.size();
        ProcCatalogNode proNode = null;
        for (i = 0; i < nSize; ++i) {
            proNode = (ProcCatalogNode)listProcDef.get(i);
            proNode.setCatalogId(listIDs.get(i).toString());
            this.kdlSelectedItem.addElement((Object)proNode);
        }
    }

    private boolean getProcNotAddByCatalog(KDTreeNode treeNode, ArrayList listIDs, ArrayList listProcDef) {
        boolean isDeleteLeafe = false;
        ProcCatalogNode catalogNode = (ProcCatalogNode)treeNode.getUserObject();
        if (catalogNode.getId() != null) {
            listIDs.add(catalogNode.getId());
            listProcDef.add(catalogNode);
            this.kdTreeSelecting.removeNodeFromParent((MutableTreeNode)treeNode);
            isDeleteLeafe = true;
        } else {
            int childCount = treeNode.getChildCount();
            int i = 0;
            int j = 0;
            while (i < childCount) {
                KDTreeNode nodeTemp = (KDTreeNode)treeNode.getChildAt(j);
                ++i;
                ++j;
                if (!this.getProcNotAddByCatalog(nodeTemp, listIDs, listProcDef)) continue;
                --j;
            }
        }
        return isDeleteLeafe;
    }

    @Override
    public void actionAddAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddAll_actionPerformed(e);
        KDTreeNode treeNode = (KDTreeNode)this.kdtProcCatalogTree.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
            if (treeNode.getChildCount() != 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.cp.eip.pc.ProcCatalogResource", (String)"noAddProcessToParent"));
                return;
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.cp.eip.pc.ProcCatalogResource", (String)"noSelectTreeNode"));
            return;
        }
        ArrayList list = new ArrayList();
        ArrayList listProc = new ArrayList();
        ProcCatalogInfo procCatalogInfo = (ProcCatalogInfo)treeNode.getUserObject();
        list.add(procCatalogInfo);
        list.add(procCatalogInfo.getSolution());
        KDTreeNode rootNode = this.buildTreeNode.rootNodeWF;
        Object childNode = null;
        Object parentNode = null;
        Object object = null;
        int nSize = rootNode.getChildCount();
        boolean nNum = false;
        this.getProcNotAddByCatalog(rootNode, list, listProc);
        if (list.size() < 2) {
            return;
        }
        IConfigurationItem configurationItem = ConfigurationItemFactory.getRemoteInstance();
        list = configurationItem.addBatch(list);
        ProcCatalogNode procNode = null;
        nSize = list.size();
        for (int i = 0; i < nSize; ++i) {
            procNode = (ProcCatalogNode)listProc.get(i);
            procNode.setCofigurationItemId(list.get(i).toString());
            this.kdlSelectedItem.addElement((Object)procNode);
        }
    }

    @Override
    protected void kdlSelectedItem_mouseDbClicked(MouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.removeAlreadySelectItem();
        }
    }

    @Override
    public void actionRemoveOne_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveOne_actionPerformed(e);
        this.removeAlreadySelectItem();
    }

    private void removeAlreadySelectItem() throws Exception {
        int nResponse;
        ICustomizedConfiguration customizedConfiguration = CustomizedConfigurationFactory.getRemoteInstance();
        ArrayList<String> custList = new ArrayList<String>();
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer strBf = new StringBuffer();
        strBf.append(EASResource.getString((String)"com.kingdee.eas.cp.eip.pc.ProcCatalogResource", (String)"existCustItem"));
        strBf.append("\n");
        int[] nSelectIndexes = this.kdlSelectedItem.getSelectedIndices();
        int nSize = nSelectIndexes.length;
        ProcCatalogNode procNode = null;
        ArrayList<ProcCatalogNode> procNodeList = new ArrayList<ProcCatalogNode>();
        int item = 1;
        for (int i = 0; i < nSize; ++i) {
            procNode = (ProcCatalogNode)this.kdlSelectedItem.getElement(nSelectIndexes[i]);
            if (customizedConfiguration.existCustomizedConfig(procNode.getCofigurationItemId())) {
                custList.add(procNode.getId());
                strBf.append(Integer.toString(item));
                strBf.append(".");
                strBf.append(procNode.getName());
                strBf.append("\n");
                ++item;
            }
            list.add(procNode.getCofigurationItemId());
            procNodeList.add(procNode);
        }
        if (nSize == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.cp.eip.pc.ProcCatalogResource", (String)"selectedProcess"));
            return;
        }
        if (custList.size() > 0 && (nResponse = MsgBox.showConfirm2((Component)((Object)this), (String)strBf.toString())) == 2) {
            return;
        }
        IConfigurationItem configurationItem = ConfigurationItemFactory.getRemoteInstance();
        configurationItem.delBatch(list);
        nSize = nSelectIndexes.length;
        Object packageName = null;
        Object childNode = null;
        KDTreeNode nodeTemp = this.buildTreeNode.rootNodeWF;
        KingdeeTreeModel model = (KingdeeTreeModel)this.kdTreeSelecting.getModel();
        this.delNodeFromSelToProc(model, procNodeList, nodeTemp);
        this.kdTreeSelecting.updateUI();
        this.kdTreeSelecting.repaint();
        this.kdTreeSelecting.validate();
        for (int i = nSize - 1; i >= 0; --i) {
            this.kdlSelectedItem.removeElementAt(nSelectIndexes[i]);
        }
    }

    private void delNodeFromSelToProc(KingdeeTreeModel model, List procNodeList, KDTreeNode nodeTemp) {
        ProcCatalogNode procNodeTemp = null;
        KDTreeNode node = null;
        int size = procNodeList.size();
        Iterator itertaor = procNodeList.iterator();
        if (nodeTemp != null && nodeTemp.getUserObject() != null) {
            procNodeTemp = (ProcCatalogNode)nodeTemp.getUserObject();
            while (itertaor.hasNext()) {
                ProcCatalogNode procNodeFromList = (ProcCatalogNode)itertaor.next();
                if (!procNodeTemp.getPackageName().equalsIgnoreCase(procNodeFromList.getPackageName()) || procNodeTemp.getId() != null) continue;
                KDTreeNode nodeNew = new KDTreeNode((Object)procNodeFromList.getName());
                nodeNew.setUserObject((Object)procNodeFromList);
                procNodeList.remove(node);
                --size;
                this.kdTreeSelecting.addNodeInto((MutableTreeNode)nodeNew, (MutableTreeNode)nodeTemp);
                model.nodeChanged((TreeNode)nodeNew);
                procNodeTemp.setHasProc(true);
            }
            Enumeration children = nodeTemp.children();
            while (children.hasMoreElements()) {
                node = (KDTreeNode)children.nextElement();
                this.delNodeFromSelToProc(model, procNodeList, node);
            }
        }
    }

    @Override
    public void actionRemoveAll_actionPerformed(ActionEvent e) throws Exception {
        int nResponse;
        super.actionRemoveAll_actionPerformed(e);
        ICustomizedConfiguration customizedConfiguration = CustomizedConfigurationFactory.getRemoteInstance();
        ArrayList<String> custList = new ArrayList<String>();
        ArrayList<String> list = new ArrayList<String>();
        int nSize = this.kdlSelectedItem.getElementCount();
        ProcCatalogNode procNode = null;
        ArrayList<ProcCatalogNode> procNodeList = new ArrayList<ProcCatalogNode>();
        for (int i = 0; i < nSize; ++i) {
            procNode = (ProcCatalogNode)this.kdlSelectedItem.getElement(i);
            if (customizedConfiguration.existCustomizedConfig(procNode.getCofigurationItemId())) {
                custList.add(procNode.getName());
            }
            list.add(procNode.getCofigurationItemId());
            procNodeList.add(procNode);
        }
        nSize = custList.size();
        if (nSize > 0 && (nResponse = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.cp.eip.pc.ProcCatalogResource", (String)"existCustItem"))) == 2) {
            return;
        }
        IConfigurationItem configurationItem = ConfigurationItemFactory.getRemoteInstance();
        configurationItem.delBatch(list);
        nSize = this.kdlSelectedItem.getElementCount();
        KDTreeNode nodeTemp = this.buildTreeNode.rootNodeWF;
        KingdeeTreeModel model = (KingdeeTreeModel)this.kdtProcCatalogTree.getModel();
        this.delNodeFromSelToProc(model, procNodeList, nodeTemp);
        this.kdtProcCatalogTree.repaint();
        this.kdtProcCatalogTree.updateUI();
        this.kdtProcCatalogTree.validate();
        this.kdlSelectedItem.removeAllElements();
    }

    @Override
    public void actionCloseProc_actionPerformed(ActionEvent e) throws Exception {
        super.actionCloseProc_actionPerformed(e);
        this.actionExitCurrent_actionPerformed(e);
    }
}

