/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.pc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.eip.pc.IProcStatFacade;
import com.kingdee.eas.cp.eip.pc.ProcCatalogException;
import com.kingdee.eas.cp.eip.pc.ProcCatalogNode;
import com.kingdee.eas.cp.eip.pc.ProcStatFacadeFactory;
import com.kingdee.eas.cp.eip.pc.client.AbstractPersonStatConditionUI;
import com.kingdee.eas.cp.eip.pc.client.ProcessChooseTreeF7;
import com.kingdee.eas.cp.eip.pc.client.ProcessChooseTreeList;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class PersonStatConditionUI
extends AbstractPersonStatConditionUI {
    private static final Logger logger = CoreUIObject.getLogger(PersonStatConditionUI.class);
    private static final String EXCEPTION = "com.kingdee.eas.cp.eip.pc.ProcCatalogException";
    private Component container = null;
    private static Map cacheMap;

    public void setCacheMap() {
        cacheMap = new HashMap();
        if (this.kDBizPromptBoxProcessArea.getValue() != null) {
            cacheMap.put(PersonStatConditionParam.processArea, this.kDBizPromptBoxProcessArea.getValue());
        }
        if (this.kdbpbUser.getValue() != null) {
            cacheMap.put(PersonStatConditionParam.user, this.kdbpbUser.getValue());
        }
        if (this.kddpStartDate.getValue() != null) {
            cacheMap.put(PersonStatConditionParam.startDate, this.kddpStartDate.getValue());
        }
        if (this.kddpEndDate.getValue() != null) {
            cacheMap.put(PersonStatConditionParam.endDate, this.kddpEndDate.getValue());
        }
    }

    public void initData() throws Exception {
        if (cacheMap != null && cacheMap.size() > 0) {
            if (cacheMap.get(PersonStatConditionParam.user) != null) {
                this.kdbpbUser.setValue(cacheMap.get(PersonStatConditionParam.user));
            }
            if (cacheMap.get(PersonStatConditionParam.startDate) != null) {
                this.kddpStartDate.setValue(cacheMap.get(PersonStatConditionParam.startDate));
            }
            if (cacheMap.get(PersonStatConditionParam.endDate) != null) {
                this.kddpEndDate.setValue(cacheMap.get(PersonStatConditionParam.endDate));
            }
            if (cacheMap.get(PersonStatConditionParam.processArea) != null) {
                this.kDBizPromptBoxProcessArea.setValue(cacheMap.get(PersonStatConditionParam.processArea));
            }
            return;
        }
        this.kdbpbUser.setValue((Object)SysContext.getSysContext().getCurrentUserInfo());
        String endTime = DateTimeUtils.defaultDateString((java.util.Date)new Timestamp(System.currentTimeMillis())).substring(0, 10);
        this.kddpEndDate.setValue((Object)Date.valueOf(endTime));
        this.kddpStartDate.setValue((Object)DateTimeUtils.addMonth((java.util.Date)Date.valueOf(endTime), (int)-1));
    }

    public PersonStatConditionUI() throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        this.kdbpbUser.setEntityViewInfo(viewInfo);
        IProcStatFacade iProc = ProcStatFacadeFactory.getRemoteInstance();
        boolean isProcessAdmin = iProc.isProcessAdmin(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        if (!isProcessAdmin) {
            this.kdbpbUser.setEditable(false);
            this.kdbpbUser.setEnabled(false);
        }
        this.kdbpbUser.setEditable(false);
        ProcessChooseTreeF7 processChooseTreeF7 = new ProcessChooseTreeF7((IUIObject)this, true, true);
        this.kDBizPromptBoxProcessArea.setSelector((KDPromptSelector)processChooseTreeF7);
        this.initData();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    public void show() {
        super.show();
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    public void clear() {
        this.kdbpbUser.setValue((Object)SysContext.getSysContext().getCurrentUserInfo());
        String endTime = DateTimeUtils.defaultDateString((java.util.Date)new Timestamp(System.currentTimeMillis())).substring(0, 10);
        this.kddpEndDate.setValue((Object)Date.valueOf(endTime));
        this.kddpStartDate.setValue((Object)DateTimeUtils.addMonth((java.util.Date)Date.valueOf(endTime), (int)-1));
        this.kDBizPromptBoxProcessArea.setValue(null);
    }

    public void setParam(Object param) {
        Map result = (Map)param;
        boolean nSize = false;
        this.kdbpbUser.setValue(result.get(PersonStatConditionParam.user));
        this.kddpEndDate.setValue(result.get(PersonStatConditionParam.endDate));
        this.kddpStartDate.setValue(result.get(PersonStatConditionParam.startDate));
        this.kDBizPromptBoxProcessArea.setValue(result.get(PersonStatConditionParam.processArea));
    }

    public Object getParam() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Object object = null;
        object = this.kdbpbUser.getValue();
        result.put(PersonStatConditionParam.user, object);
        object = this.kddpEndDate.getValue();
        result.put(PersonStatConditionParam.endDate, object);
        object = this.kddpStartDate.getValue();
        result.put(PersonStatConditionParam.startDate, object);
        object = this.kDBizPromptBoxProcessArea.getValue();
        result.put(PersonStatConditionParam.processArea, object);
        return result;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        HashMap result = new HashMap();
        Object object = null;
        object = this.kdbpbUser.getValue();
        if (object != null && ((UserInfo)object).getId() != null) {
            cp.addCustomerParam(PersonStatConditionParam.user, ((UserInfo)object).getId().toString());
        }
        object = this.kddpEndDate.getValue();
        cp.putDate(PersonStatConditionParam.endDate, (java.util.Date)object);
        object = this.kddpStartDate.getValue();
        cp.putDate(PersonStatConditionParam.startDate, (java.util.Date)object);
        object = this.kDBizPromptBoxProcessArea.getValue();
        if (object != null) {
            ProcessChooseTreeList treeList = (ProcessChooseTreeList)object;
            cp.addCustomerParam("idList", treeList.getIdList());
            cp.addCustomerParam("stringList", treeList.toString());
        } else {
            cp.addCustomerParam("idList", null);
            cp.addCustomerParam("stringList", null);
        }
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        if (cp == null) {
            return;
        }
        String id = cp.getCustomerParam(PersonStatConditionParam.user);
        IObjectValue value = null;
        try {
            if (id != null) {
                value = DynamicObjectFactory.getRemoteInstance().getValue(BOSUuid.read((String)id).getType(), (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
            }
            this.kdbpbUser.setValue(value);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.kddpEndDate.setValue((Object)cp.getDate(PersonStatConditionParam.endDate));
        this.kddpStartDate.setValue((Object)cp.getDate(PersonStatConditionParam.startDate));
        this.kDBizPromptBoxProcessArea.setValue(this.getProcessList(cp));
    }

    private Object getProcessList(CustomerParams cp) {
        ProcessChooseTreeList treeList = new ProcessChooseTreeList();
        ProcCatalogNode node = null;
        String str = cp.getCustomerParam("idList");
        if (str == null || "".equals(str)) {
            return null;
        }
        String[] idLists = str.split(",");
        String str1 = cp.getCustomerParam("stringList");
        if (str1 == null || "".equals(str1)) {
            return null;
        }
        String[] nameLists = str1.split(",");
        for (int i = 0; i < idLists.length; ++i) {
            node = new ProcCatalogNode();
            node.setId(idLists[i]);
            if (i < nameLists.length) {
                node.setName(nameLists[i]);
            }
            treeList.add(node);
        }
        return treeList;
    }

    protected boolean checkBeforeWindowClosing() {
        System.currentTimeMillis();
        return super.checkBeforeWindowClosing();
    }

    public boolean verify() {
        try {
            this.checkError();
            return true;
        }
        catch (ProcCatalogException ite) {
            MsgBox.showInfo((String)ite.getMessage());
            return false;
        }
    }

    private void checkError() throws ProcCatalogException {
        if (this.kdbpbUser.getValue() == null) {
            this.kdbpbUser.requestFocus();
            throw new ProcCatalogException(ProcCatalogException.APPLICATION_NOT_NULL);
        }
        if (this.kddpStartDate.getValue() == null) {
            this.kddpStartDate.requestFocus();
            throw new ProcCatalogException(ProcCatalogException.BEGINTIME_NOTNULL);
        }
        if (this.kddpEndDate.getValue() == null) {
            this.kddpEndDate.requestFocus();
            throw new ProcCatalogException(ProcCatalogException.END_TIME_NOTNULL);
        }
        Date dtFrom = this.kddpStartDate.getSqlDate();
        Date dtTo = this.kddpEndDate.getSqlDate();
        if (dtFrom.toString().compareTo(dtTo.toString()) > 0) {
            this.kddpEndDate.setValue(null);
            this.kddpEndDate.requestFocus();
            throw new ProcCatalogException(ProcCatalogException.STARTTIME_MUST_BIGGER_THAN_ENDTIME);
        }
    }

    public String getQuerySql() {
        StringBuffer strSql = new StringBuffer();
        Object objectTemp = null;
        objectTemp = this.kdbpbUser.getValue();
        if (objectTemp != null && objectTemp instanceof UserInfo) {
            strSql.append(((UserInfo)objectTemp).getId());
        }
        strSql.append("~!~").append(this.kdbpbUser.getText()).append("~!~");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        objectTemp = this.kddpStartDate.getValue();
        if (objectTemp != null) {
            strSql.append(format.format(objectTemp));
        }
        strSql.append("~!~");
        objectTemp = this.kddpEndDate.getValue();
        if (objectTemp != null) {
            strSql.append(format.format(objectTemp));
        }
        strSql.append("~!~");
        objectTemp = this.kDBizPromptBoxProcessArea.getValue();
        if (objectTemp != null) {
            String idList = ((ProcessChooseTreeList)objectTemp).getIdList();
            strSql.append(idList);
            strSql.append("~!~");
            String nameList = ((ProcessChooseTreeList)objectTemp).toString();
            strSql.append(nameList);
        }
        logger.info((Object)("strSql:" + strSql));
        return strSql.toString();
    }

    public FilterInfo getFilterInfo() {
        this.filterInfo = new FilterInfo();
        StringBuffer maskString = new StringBuffer("");
        FilterItemCollection fic = this.filterInfo.getFilterItems();
        fic.add(new FilterItemInfo("name", (Object)this.getQuerySql()));
        return this.filterInfo;
    }

    public static class PersonStatConditionParam
    implements Serializable {
        public static String processArea = "processArea";
        public static String user = "user";
        public static String startDate = "startDate";
        public static String endDate = "endDate";
    }
}

