/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.pc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.AdminF7;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.eip.pc.ProcCatalogException;
import com.kingdee.eas.cp.eip.pc.ProcCatalogNode;
import com.kingdee.eas.cp.eip.pc.client.AbstractProEfficencyStatConditionUI;
import com.kingdee.eas.cp.eip.pc.client.ProcessChooseTreeF7;
import com.kingdee.eas.cp.eip.pc.client.ProcessChooseTreeList;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ProEfficencyStatConditionUI
extends AbstractProEfficencyStatConditionUI {
    private static final Logger logger = CoreUIObject.getLogger(ProEfficencyStatConditionUI.class);
    protected FilterInfo filterInfo = new FilterInfo();
    private static Map cacheMap;

    public void setCacheMap() {
        cacheMap = new HashMap();
        if (this.kdbpbAdmin.getValue() != null) {
            cacheMap.put(ProEfficencyStatConditionParam.admin, this.kdbpbAdmin.getValue());
        }
        if (this.kddpStartDate.getValue() != null) {
            cacheMap.put(ProEfficencyStatConditionParam.startDate, this.kddpStartDate.getValue());
        }
        if (this.kddpEndDate.getValue() != null) {
            cacheMap.put(ProEfficencyStatConditionParam.endDate, this.kddpEndDate.getValue());
        }
        if (this.kdbpbProcess.getValue() != null) {
            cacheMap.put(ProEfficencyStatConditionParam.process, this.kdbpbProcess.getValue());
        }
        if (this.kDCheckBoxIsIncludeChildOrg.isSelected()) {
            cacheMap.put(ProEfficencyStatConditionParam.isIncludeChildOrg, true);
        }
    }

    public void initData() throws Exception {
        if (cacheMap != null && cacheMap.size() > 0) {
            if (cacheMap.get(ProEfficencyStatConditionParam.admin) != null) {
                this.kdbpbAdmin.setValue(cacheMap.get(ProEfficencyStatConditionParam.admin));
            }
            if (cacheMap.get(ProEfficencyStatConditionParam.startDate) != null) {
                this.kddpStartDate.setValue(cacheMap.get(ProEfficencyStatConditionParam.startDate));
            }
            if (cacheMap.get(ProEfficencyStatConditionParam.endDate) != null) {
                this.kddpEndDate.setValue(cacheMap.get(ProEfficencyStatConditionParam.endDate));
            }
            if (cacheMap.get(ProEfficencyStatConditionParam.process) != null) {
                this.kdbpbProcess.setValue(cacheMap.get(ProEfficencyStatConditionParam.process));
            }
            if (cacheMap.get(ProEfficencyStatConditionParam.isIncludeChildOrg) != null) {
                this.kDCheckBoxIsIncludeChildOrg.setSelected(((Boolean)cacheMap.get(ProEfficencyStatConditionParam.isIncludeChildOrg)).booleanValue());
            }
            return;
        }
        this.kdbpbAdmin.setValue((Object)SysContext.getSysContext().getCurrentAdminUnit());
        String endTime = DateTimeUtils.defaultDateString((java.util.Date)new Timestamp(System.currentTimeMillis())).substring(0, 10);
        this.kddpEndDate.setValue((Object)Date.valueOf(endTime));
        this.kddpStartDate.setValue((Object)DateTimeUtils.addMonth((java.util.Date)Date.valueOf(endTime), (int)-1));
    }

    public ProEfficencyStatConditionUI() throws Exception {
        this.kdbpbProcess.setRequired(true);
        AdminF7 adminBox = new AdminF7();
        adminBox.setMultiSelect(false);
        adminBox.setIsCUFilter(true);
        adminBox.disablePerm();
        adminBox.setRootUnitID(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        this.kdbpbAdmin.setDisplayFormat("$name$");
        this.kdbpbAdmin.setEditFormat("$number$");
        this.kdbpbAdmin.setCommitFormat("$number$");
        this.kdbpbAdmin.setSelector((KDPromptSelector)adminBox);
        ProcessChooseTreeF7 processChooseF7 = new ProcessChooseTreeF7((IUIObject)this, false, true);
        this.kdbpbProcess.setSelector((KDPromptSelector)processChooseF7);
        this.initData();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    public void clear() {
        this.kdbpbAdmin.setValue((Object)SysContext.getSysContext().getCurrentAdminUnit());
        this.kdbpbProcess.setValue(null);
        String endTime = DateTimeUtils.defaultDateString((java.util.Date)new Timestamp(System.currentTimeMillis())).substring(0, 10);
        this.kddpEndDate.setValue((Object)Date.valueOf(endTime));
        this.kddpStartDate.setValue((Object)DateTimeUtils.addMonth((java.util.Date)Date.valueOf(endTime), (int)-1));
    }

    public Object getParam() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Object object = null;
        object = this.kdbpbAdmin.getValue();
        result.put(ProEfficencyStatConditionParam.admin, object);
        object = this.kdbpbProcess.getValue();
        result.put(ProEfficencyStatConditionParam.process, object);
        object = this.kddpEndDate.getValue();
        result.put(ProEfficencyStatConditionParam.endDate, object);
        object = this.kddpStartDate.getValue();
        result.put(ProEfficencyStatConditionParam.startDate, object);
        object = this.kDCheckBoxIsIncludeChildOrg.isSelected();
        result.put(ProEfficencyStatConditionParam.isIncludeChildOrg, object);
        return result;
    }

    public boolean verify() {
        try {
            this.checkError();
            return true;
        }
        catch (ProcCatalogException ite) {
            MsgBox.showInfo((String)ite.getMessage());
            return false;
        }
    }

    private void checkError() throws ProcCatalogException {
        if (this.kdbpbAdmin.getValue() == null) {
            this.kdbpbAdmin.requestFocus();
            throw new ProcCatalogException(ProcCatalogException.ADMIN_NOT_NULL);
        }
        if (this.kdbpbProcess.getValue() == null) {
            this.kdbpbProcess.requestFocus();
            throw new ProcCatalogException(ProcCatalogException.PROCESSNAME_NOT_NULL);
        }
        if (this.kddpStartDate.getValue() == null) {
            this.kddpStartDate.requestFocus();
            throw new ProcCatalogException(ProcCatalogException.BEGINTIME_NOTNULL);
        }
        if (this.kddpEndDate.getValue() == null) {
            this.kddpEndDate.requestFocus();
            throw new ProcCatalogException(ProcCatalogException.END_TIME_NOTNULL);
        }
        Date dtFrom = this.kddpStartDate.getSqlDate();
        Date dtTo = this.kddpEndDate.getSqlDate();
        if (dtFrom.toString().compareTo(dtTo.toString()) > 0) {
            this.kddpEndDate.setValue(null);
            this.kddpEndDate.requestFocus();
            throw new ProcCatalogException(ProcCatalogException.STARTTIME_MUST_BIGGER_THAN_ENDTIME);
        }
    }

    public String getQuerySql() {
        StringBuffer strSql = new StringBuffer();
        Object objectTemp = null;
        String longnumber = "";
        objectTemp = this.kdbpbAdmin.getValue();
        if (objectTemp != null && objectTemp instanceof AdminOrgUnitInfo) {
            strSql.append(((AdminOrgUnitInfo)objectTemp).getId().toString());
            longnumber = ((AdminOrgUnitInfo)objectTemp).getLongNumber();
        }
        strSql.append("~!~").append(this.kdbpbAdmin.getText()).append("~!~");
        objectTemp = this.kdbpbProcess.getValue();
        if (objectTemp != null && objectTemp instanceof ProcessChooseTreeList) {
            ProcessChooseTreeList list = (ProcessChooseTreeList)objectTemp;
            String procID = null;
            if (list != null && list.size() > 0) {
                ProcCatalogNode node = (ProcCatalogNode)list.get(0);
                procID = node.getId();
            }
            strSql.append(procID);
        }
        strSql.append("~!~").append(this.kdbpbProcess.getText()).append("~!~");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        objectTemp = this.kddpStartDate.getValue();
        if (objectTemp != null) {
            strSql.append(format.format(objectTemp));
        }
        strSql.append("~!~");
        objectTemp = this.kddpEndDate.getValue();
        if (objectTemp != null) {
            strSql.append(format.format(objectTemp));
        }
        strSql.append("~!~").append(longnumber).append("~!~");
        boolean isSelected = this.kDCheckBoxIsIncludeChildOrg.isSelected();
        String isIncludeChild = "false";
        if (isSelected) {
            isIncludeChild = "true";
        }
        strSql.append(isIncludeChild).append("~!~");
        return strSql.toString();
    }

    public void setParam(Object param) {
        Map result = (Map)param;
        boolean nSize = false;
        this.kdbpbAdmin.setValue(result.get(ProEfficencyStatConditionParam.admin));
        this.kdbpbProcess.setValue(result.get(ProEfficencyStatConditionParam.process));
        this.kddpEndDate.setValue(result.get(ProEfficencyStatConditionParam.endDate));
        this.kddpStartDate.setValue(result.get(ProEfficencyStatConditionParam.startDate));
        this.kDCheckBoxIsIncludeChildOrg.setSelected(((Boolean)result.get(ProEfficencyStatConditionParam.isIncludeChildOrg)).booleanValue());
    }

    public CustomerParams getCustomerParams() {
        List list;
        CustomerParams cp = new CustomerParams();
        HashMap result = new HashMap();
        Object object = null;
        object = this.kdbpbAdmin.getValue();
        if (object != null && ((CoreBaseInfo)object).getId() != null) {
            cp.addCustomerParam(ProEfficencyStatConditionParam.admin, ((CoreBaseInfo)object).getId().toString());
        }
        if ((list = (List)(object = this.kdbpbProcess.getValue())) != null && list.size() > 0) {
            ProcCatalogNode node = (ProcCatalogNode)list.get(0);
            cp.addCustomerParam("nodeId", node.getId());
            cp.addCustomerParam("nodeName", node.getName());
        }
        object = this.kddpEndDate.getValue();
        cp.putDate(ProEfficencyStatConditionParam.endDate, (java.util.Date)object);
        object = this.kddpStartDate.getValue();
        cp.putDate(ProEfficencyStatConditionParam.startDate, (java.util.Date)object);
        cp.putBoolean(ProEfficencyStatConditionParam.isIncludeChildOrg, this.kDCheckBoxIsIncludeChildOrg.isSelected());
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        if (cp == null) {
            return;
        }
        String id = cp.getCustomerParam(ProEfficencyStatConditionParam.admin);
        IObjectValue value = null;
        try {
            if (id != null) {
                value = DynamicObjectFactory.getRemoteInstance().getValue(new AdminOrgUnitInfo().getBOSType(), (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
            }
            this.kdbpbAdmin.setValue(value);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String nodeId = cp.getCustomerParam("nodeId");
        if (nodeId != null) {
            String nodeName = cp.getCustomerParam("nodeName");
            ProcCatalogNode node = new ProcCatalogNode();
            node.setId(nodeId);
            node.setName(nodeName);
            ProcessChooseTreeList treeList = new ProcessChooseTreeList();
            treeList.add(node);
            this.kdbpbProcess.setValue((Object)treeList);
        }
        this.kddpEndDate.setValue((Object)cp.getDate(ProEfficencyStatConditionParam.endDate));
        this.kddpStartDate.setValue((Object)cp.getDate(ProEfficencyStatConditionParam.startDate));
        this.kDCheckBoxIsIncludeChildOrg.setSelected(cp.getBoolean(ProEfficencyStatConditionParam.isIncludeChildOrg));
    }

    public FilterInfo getFilterInfo() {
        this.filterInfo = new FilterInfo();
        StringBuffer maskString = new StringBuffer("");
        FilterItemCollection fic = this.filterInfo.getFilterItems();
        fic.add(new FilterItemInfo("name", (Object)this.getQuerySql()));
        return this.filterInfo;
    }

    public static class ProEfficencyStatConditionParam
    implements Serializable {
        public static String admin = "admin";
        public static String process = "process";
        public static String startDate = "startDate";
        public static String endDate = "endDate";
        public static String isIncludeChildOrg = "isIncludeChildOrg";
    }
}

