/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.pc.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.eip.pc.client.AbstractUpdateMessageUI;
import com.kingdee.eas.cp.eip.pc.client.UpdateMessageException;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class UpdateMessageUI
extends AbstractUpdateMessageUI {
    private static final Logger logger = CoreUIObject.getLogger(UpdateMessageUI.class);
    private String receiver = null;
    private Map title = null;
    private Map content = null;
    private IUser iUser = null;
    private boolean cancel = true;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.cancel = false;
        this.checkError();
        this.changeParentUIContext();
        this.actionExitCurrent_actionPerformed(e);
    }

    private void checkError() throws Exception {
        if (this.receiver == null) {
            throw new UpdateMessageException(UpdateMessageException.RECEIVER_NOT_NULL);
        }
        List langList = KDBizMultiLangBox.getLanguageList();
        Iterator iter = langList.iterator();
        LanguageInfo languageInfo = null;
        while (iter.hasNext()) {
            languageInfo = (LanguageInfo)iter.next();
            MultiLangItem name = this.txtTitle.getItemBy(languageInfo);
            String nameData = (String)name.getData();
            if (nameData == null || nameData.trim().length() < 1) {
                this.txtTitle.requestFocus();
                this.txtTitle.setSelectedLanguage(languageInfo);
                throw new UpdateMessageException(UpdateMessageException.TITLE_NOTNULL);
            }
            if (nameData.trim().length() > 255) {
                this.txtTitle.requestFocus();
                this.txtTitle.setSelectedLanguage(languageInfo);
                throw new UpdateMessageException(UpdateMessageException.TITLE_NOT_BIGGER_255);
            }
            name = this.txtContent.getItemBy(languageInfo);
            nameData = (String)name.getData();
            if (nameData == null || nameData.trim().length() < 1) {
                this.txtContent.requestFocus();
                this.txtContent.setSelectedLanguage(languageInfo);
                throw new UpdateMessageException(UpdateMessageException.CONTENT_NOT_NULL);
            }
            if (nameData.trim().length() <= 500) continue;
            this.txtTitle.requestFocus();
            this.txtTitle.setSelectedLanguage(languageInfo);
            throw new UpdateMessageException(UpdateMessageException.CONTENT_NOT_BIGGER_THAN500);
        }
    }

    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.cancel = true;
        this.actionExitCurrent_actionPerformed(e);
    }

    protected void btnSave_actionPerformed(ActionEvent e) throws Exception {
        this.cancel = false;
        this.checkError();
        this.changeParentUIContext();
        this.actionExitCurrent_actionPerformed(e);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.toolBar.setVisible(false);
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    UpdateMessageUI.this.btnSave_actionPerformed(e);
                }
                catch (Exception exc) {
                    UpdateMessageUI.this.handUIException(exc);
                }
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    UpdateMessageUI.this.btnCancel_actionPerformed(e);
                }
                catch (Exception exc) {
                    UpdateMessageUI.this.handUIException(exc);
                }
            }
        });
        Map context = this.getUIContext();
        this.receiver = (String)context.get("updatemessage.receiver");
        this.title = (Map)context.get("updatemessage.title");
        this.content = (Map)context.get("updatemessage.content");
        if (this.receiver != null) {
            this.iUser = UserFactory.getRemoteInstance();
            UserInfo user = this.iUser.getUserInfo((IObjectPK)new ObjectUuidPK(this.receiver));
            this.kdpmtReceiver.setData((Object)user);
        }
        List langList = KDBizMultiLangBox.getLanguageList();
        Iterator iter = langList.iterator();
        LanguageInfo languageInfo = null;
        Locale locale = null;
        while (iter.hasNext()) {
            languageInfo = (LanguageInfo)iter.next();
            locale = languageInfo.getLocale();
            this.txtTitle.setItemData(languageInfo, this.title.get(locale.toString()));
            this.txtContent.setItemData(languageInfo, this.content.get(locale.toString()));
        }
        this.txtTitle.getEditorComponent().addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                List langList = KDBizMultiLangBox.getLanguageList();
                Iterator iter = langList.iterator();
                LanguageInfo languageInfo = null;
                while (iter.hasNext()) {
                    languageInfo = (LanguageInfo)iter.next();
                    MultiLangItem name = UpdateMessageUI.this.txtTitle.getItemBy(languageInfo);
                    String nameData = (String)name.getData();
                    if (nameData == null || nameData.trim().length() <= 70) continue;
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.cp.eip.pc.client.CPPC", (String)"TITILE_ISBIGGER_THAN70"));
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
    }

    private int setSelectLanguage() {
        int nTemp = 0;
        List langList = KDBizMultiLangBox.getLanguageList();
        Iterator iter = langList.iterator();
        LanguageInfo languageInfo = null;
        LanguageInfo currentLang = new LanguageInfo(SysContext.getSysContext().getLocale());
        while (iter.hasNext()) {
            languageInfo = (LanguageInfo)iter.next();
            if (currentLang.getLocale().toString().equals(languageInfo.getLocale().toString())) break;
            ++nTemp;
        }
        return nTemp;
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        Map context = this.getUIContext();
        HashMap map = (HashMap)context.get("this.is.save.message.to.me.when.child.change.data");
        map.put("updatemessage.cancel", this.cancel);
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    private void changeParentUIContext() {
        Map context = this.getUIContext();
        HashMap map = (HashMap)context.get("this.is.save.message.to.me.when.child.change.data");
        this.receiver = ((UserInfo)this.kdpmtReceiver.getData()).getId().toString();
        HashMap<String, String> mapTemp = new HashMap<String, String>();
        HashMap<String, String> mapContent = new HashMap<String, String>();
        List langList = KDBizMultiLangBox.getLanguageList();
        Iterator iter = langList.iterator();
        LanguageInfo languageInfo = null;
        Locale local = null;
        while (iter.hasNext()) {
            languageInfo = (LanguageInfo)iter.next();
            local = languageInfo.getLocale();
            MultiLangItem name = this.txtTitle.getItemBy(languageInfo);
            String nameData = (String)name.getData();
            mapTemp.put(local.toString(), nameData);
            MultiLangItem nameContent = this.txtContent.getItemBy(languageInfo);
            String contentData = (String)nameContent.getData();
            mapContent.put(local.toString(), contentData);
        }
        this.title = mapTemp;
        this.content = mapContent;
        map.put("updatemessage.receiver", this.receiver);
        map.put("updatemessage.title", this.title);
        map.put("updatemessage.content", this.content);
    }
}

