/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.pc.web;

import com.kingdee.bos.ctrl.swing.KDChart;
import com.kingdee.bos.ctrl.swing.chart.ChartType;
import com.kingdee.bos.ctrl.swing.chart.data.CommonChartData;
import com.kingdee.bos.ctrl.swing.chart.data.GanttChartData;
import com.kingdee.bos.ctrl.swing.chart.data.IChartData;
import com.kingdee.bos.ctrl.swing.chart.data.PieChartData;
import com.kingdee.eas.cp.eip.pc.web.IProcessStatChartData;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import org.jfree.chart.plot.PiePlot;

public class ProcessStatChartServlet
extends HttpServlet {
    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        req.setCharacterEncoding("UTF-8");
        String className = req.getParameter("dssrc");
        String width = req.getParameter("width");
        String height = req.getParameter("height");
        String title = req.getParameter("title");
        System.out.println("---ProcessStatChartServlet-title=" + title);
        int h = 300;
        int w = 400;
        try {
            if (width == null) {
                width = "400";
            }
            if (height == null) {
                height = "300";
            }
            w = Integer.parseInt(width);
            h = Integer.parseInt(height);
        }
        catch (NumberFormatException numEx) {
            numEx.printStackTrace();
        }
        res.setContentType("image/jpeg;charset=utf-8");
        try {
            PieChartData pieChartData = null;
            CommonChartData commonChartData = null;
            GanttChartData ganttChartData = null;
            Class<?> c = Class.forName(className);
            Constructor<?> con = c.getConstructor(null);
            Object obj = con.newInstance(null);
            IProcessStatChartData data = (IProcessStatChartData)obj;
            ArrayList list = data.getParameters(req, res);
            if (list == null) {
                list = new ArrayList();
            }
            data.setList(list);
            KDChart chart = new KDChart();
            chart.setChartType(data.getChartType());
            if (data.getDataType().equals("PieChartData")) {
                pieChartData = (PieChartData)data.getData();
                chart.addChartData((IChartData)pieChartData);
                chart.setPieChartSectionLabelType(0);
                PiePlot plot = (PiePlot)chart.getDelegate().getPlot();
                plot.setPercentFormatString("#,###0.0#%");
            } else if (data.getDataType().equals("GanttChartData")) {
                ganttChartData = (GanttChartData)data.getData();
                chart.addChartData((IChartData)ganttChartData);
                if (list.size() > 4) {
                    String[] strTemp = (String[])list.get(3);
                    w = strTemp.length * 90;
                    w = w > 730 ? w : 730;
                    h = strTemp.length * 30;
                    h = h > 300 ? h : 300;
                }
            } else {
                commonChartData = (CommonChartData)data.getData();
                chart.addChartData((IChartData)commonChartData);
                if (list.size() > 3) {
                    String[] seriesName = (String[])list.get(3);
                    int maxLen = 0;
                    int length = seriesName.length;
                    for (int i = 0; i < length; ++i) {
                        if (maxLen > seriesName[i].length()) continue;
                        maxLen = seriesName[i].length();
                    }
                    String[] strTemp = (String[])list.get(2);
                    w = strTemp.length * 50 + maxLen * 10 + 1;
                    w = w > 400 ? w : 400;
                }
            }
            chart.setLegendAnchor(2);
            this.setChartTitle(chart, title);
            chart.writeChartAsJPEG((OutputStream)res.getOutputStream(), 100.0f, chart.getDelegate(), w, h, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void setChartTitle(KDChart chart, String title) {
        chart.getChartTitle().setText(title);
    }

    protected void setChartType(KDChart chart, ChartType type) {
        chart.setChartType(type);
    }
}

