/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.sm;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.message.common.KDMessageAttachment;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.service.message.agent.SenderAgent;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.perf.app.PfServerUtils;
import com.kingdee.eas.mobile.msg.util.MsgUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class MessageCenterUtil {
    public static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.sm.MessageCenterUtil");

    public static void sendMessage(Context ctx, PersonInfo personInfo, String titleStr, String senderName, String bodyStr, String billID) throws BOSException, EASBizException {
        ArrayList<PersonInfo> personColl = new ArrayList<PersonInfo>();
        personColl.add(personInfo);
        MessageCenterUtil.sendMessage(ctx, personColl, titleStr, senderName, bodyStr, billID);
    }

    public static void sendMessage(Context ctx, Collection personColl, String titleStr, String senderName, String bodyStr, String billID) throws BOSException, EASBizException {
        if (personColl == null || personColl.isEmpty()) {
            return;
        }
        List userIdList = MessageCenterUtil.getUserIdList(ctx, personColl);
        if (!userIdList.isEmpty()) {
            MessageCenterUtil.sendMessage(ctx, userIdList.toArray(new String[userIdList.size()]), titleStr, senderName, bodyStr, billID);
        }
    }

    public static List getUserIdList(Context ctx, Collection personColl) throws BOSException, EASBizException {
        ArrayList<String> userIdList = new ArrayList<String>();
        Set set = MessageCenterUtil.getPersonIdSet(personColl);
        IUser iuser = UserFactory.getLocalInstance((Context)ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)set, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("id"));
        UserCollection uc = iuser.getUserCollection(evi);
        if (uc.size() != 0) {
            Iterator iter = uc.iterator();
            for (int i = 0; i < uc.size(); ++i) {
                String userId = uc.get(i).getId().toString();
                if (userId == null) continue;
                userIdList.add(userId);
            }
        }
        return userIdList;
    }

    public static void sendMessage(Context ctx, String[] ids, String titleStr, String senderName, String bodyStr, String billID) throws BOSException, EASBizException {
        SenderAgent senderAgent = SenderAgent.getSenderAgent();
        Locale[] lcla = MessageCenterUtil.getContextLocales(ctx);
        Locale locale2 = null;
        if (ids == null || ids.length == 0) {
            return;
        }
        Message message = MessageFactory.newMessage((String)"kingdee.workflow");
        for (Locale locale2 : lcla) {
            message.setLocaleStringHeader("title", titleStr, locale2);
            message.setLocaleStringHeader("sender", senderName, locale2);
            if (bodyStr == null) {
                if (billID != null) {
                    message.setLocaleStringHeader("body", billID, locale2);
                    continue;
                }
                message.setLocaleStringHeader("body", titleStr, locale2);
                continue;
            }
            message.setLocaleStringHeader("body", bodyStr, locale2);
        }
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 20);
        message.setIntHeader("sourceStatus", 0);
        message.setIntHeader("priority", 10);
        message.setStringHeader("databaseCenter", ctx.getAIS());
        message.setStringHeader("solution", ctx.getSolution());
        message.setStringHeader("bizPackage", "com.kingdee.eas.cp.sm.app");
        message.setStringHeader("realBizPackage", "com.kingdee.eas.cp.sm.app");
        message.setStringHeader("sourceID", "");
        String billURL = "/easweb/cp/sm/schedulePlanEdit.jsf?billId=" + billID;
        StringBuffer sourceIdsSB = new StringBuffer("CPOVMSG::billPassURL:null;billURL:");
        sourceIdsSB.append(billURL);
        sourceIdsSB.append(";billID:");
        sourceIdsSB.append(billID);
        message.setStringHeader("sourceIDs", sourceIdsSB.toString());
        int n = ids.length;
        for (int i = 0; i < n; ++i) {
            if (PfServerUtils.objectIsNull((Object)ids[i])) continue;
            message.setStringHeader("receiver", ids[i]);
            senderAgent.sendMessage(message);
        }
    }

    public static void sendMail(Context ctx, PersonInfo personInfo, String title, String content, String secretReceiver, String copyReceiver, KDMessageAttachment[] attachment) throws BOSException, EASBizException {
        ArrayList<PersonInfo> personColl = new ArrayList<PersonInfo>();
        personColl.add(personInfo);
        MessageCenterUtil.sendMail(ctx, personColl, title, content, secretReceiver, copyReceiver, attachment);
    }

    public static void sendMail(Context ctx, Collection personColl, String title, String content, String secretReceiver, String copyReceiver, KDMessageAttachment[] attachment) throws BOSException, EASBizException {
        String receiver = MessageCenterUtil.getMailPersonStr(ctx, personColl);
        MessageCenterUtil.sendMail(ctx, title, content, receiver, secretReceiver, copyReceiver, attachment);
    }

    public static String getMailPersonStr(Context ctx, Collection personList) throws BOSException {
        String retStr = "";
        StringBuffer sb = new StringBuffer();
        if (personList != null && !personList.isEmpty()) {
            Set set = MessageCenterUtil.getPersonIdSet(personList);
            IPerson ip = PersonFactory.getLocalInstance((Context)ctx);
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
            evi.setFilter(filter);
            evi.getSelector().add(new SelectorItemInfo("email"));
            PersonCollection pc = ip.getPersonCollection(evi);
            int size = pc.size();
            for (int i = 0; i < size; ++i) {
                String mail = pc.get(i).getEmail();
                if (mail == null || mail.trim().length() == 0) continue;
                sb.append(mail).append(",");
            }
        }
        return (retStr = sb.toString()).length() > 0 ? retStr.substring(0, retStr.length() - 1) : retStr;
    }

    public static void sendMail(Context ctx, String title, String content, String receiver, String secretReceiver, String copyReceiver, KDMessageAttachment[] attachment) throws BOSException, EASBizException {
        logger.info((Object)("MessageCenterUtil::sendMail()-----begin---title = " + title + ",content = " + content + ",receiver = " + receiver + ",secretReceiver = " + secretReceiver + ",copyReceiver= " + copyReceiver));
        boolean result = MsgUtil.msgMailDerect((Context)ctx, (String)title, (String)content, (String)receiver, (String)secretReceiver, (String)copyReceiver, (KDMessageAttachment[])attachment);
        logger.info((Object)("MessageCenterUtil::sendMail()-----end---result = " + result));
    }

    public static void sendSMS(Context ctx, PersonInfo personInfo, String content) throws EASBizException, BOSException {
        ArrayList<PersonInfo> personList = new ArrayList<PersonInfo>();
        personList.add(personInfo);
        MessageCenterUtil.sendSMS(ctx, personList, content);
    }

    public static void sendSMS(Context ctx, Collection personList, String content) throws EASBizException, BOSException {
        logger.info((Object)("MessageCenterUtil::sendSMS()--------content = " + content));
        if (null == personList) {
            logger.info((Object)"MessageCenterUtil::sendSMS()--------personList == null");
        }
        if (personList != null || !personList.isEmpty()) {
            logger.info((Object)("MessageCenterUtil::sendSMS()--------personList.size = " + personList.size()));
            String receiver = MessageCenterUtil.getCellNumberStr(ctx, personList);
            logger.info((Object)("MessageCenterUtil::sendSMS()--------receiver = " + receiver));
            if (receiver.length() > 0) {
                MessageCenterUtil.sendSMS(ctx, content, receiver);
            }
        }
    }

    public static String getCellNumberStr(Context ctx, Collection personList) throws EASBizException, BOSException {
        logger.info((Object)"MessageCenterUtil::getCellNumberStr()---begin");
        Set set = MessageCenterUtil.getPersonIdSet(personList);
        IPerson ip = PersonFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("email"));
        evi.getSelector().add(new SelectorItemInfo("cell"));
        PersonCollection pc = ip.getPersonCollection(evi);
        StringBuffer sb = new StringBuffer();
        HashMap<String, String> map = new HashMap<String, String>();
        PersonInfo person = null;
        int size = pc.size();
        for (int i = 0; i < size; ++i) {
            person = pc.get(i);
            if (person.getCell() == null || person.getCell().trim().length() == 0) {
                if (null == person.getId()) continue;
                logger.info((Object)("MessageCenterUtil::getCellNumberStr()---ing---person.getCell() ==null, person.id = " + person.getId().toString()));
                continue;
            }
            map.put(person.getCell(), person.getCell());
        }
        Iterator iter = map.values().iterator();
        while (iter.hasNext()) {
            if (sb.toString().length() > 0) {
                sb.append(",");
            }
            sb.append(iter.next().toString());
        }
        logger.info((Object)("MessageCenterUtil::getCellNumberStr()---end---personTelnumber = " + sb.toString()));
        return sb.toString();
    }

    public static void sendSMS(Context ctx, String content, String receiver) throws EASBizException, BOSException {
        logger.info((Object)("MessageCenterUtil::sendSMS()-----begin---content = " + content + ",receiver = " + receiver));
        if (content == null || "".equals(content) || receiver == null || "".equals(receiver)) {
            return;
        }
        logger.info((Object)("MessageCenterUtil::sendSMS()-----begin---content = " + content + ",receiver = " + receiver));
        boolean result = MsgUtil.mobileMsgSend((Context)ctx, (String)content, (int)10, (boolean)false, (String)content, (String)receiver.trim(), null);
        logger.info((Object)("MessageCenterUtil::sendSMS()-----end---result = " + result));
    }

    public static Locale[] getContextLocales(Context ctx) {
        LanguageCollection langs;
        Locale[] locales = null;
        SolutionInfo solu = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getSolution();
        if (solu != null && (langs = solu.getLanguages()) != null) {
            locales = new Locale[langs.size()];
            for (int i = 0; i < langs.size(); ++i) {
                locales[i] = langs.get(i).getLocale();
            }
        }
        return locales;
    }

    public static Set getPersonIdSet(Collection personList) {
        HashSet<String> set = new HashSet<String>();
        PersonInfo person = null;
        Iterator ite = personList.iterator();
        int i = 0;
        while (ite.hasNext()) {
            person = (PersonInfo)ite.next();
            set.add(person.getId().toString());
            logger.info((Object)("MessageCenterUtil::getPersonIdSet()---person " + i + " ,id =" + person.getId().toString()));
        }
        return set;
    }
}

