/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.sm.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.sm.CurrentStateEnum;
import com.kingdee.eas.cp.sm.IInvitedDepartment4OrgUnit;
import com.kingdee.eas.cp.sm.IInvitedPerson2Person;
import com.kingdee.eas.cp.sm.ISchedule4PersonVisableConfig;
import com.kingdee.eas.cp.sm.IScheduleEditConfig;
import com.kingdee.eas.cp.sm.ISchedulePersonShareConfig;
import com.kingdee.eas.cp.sm.InvitedDepartment4OrgUnitCollection;
import com.kingdee.eas.cp.sm.InvitedDepartment4OrgUnitFactory;
import com.kingdee.eas.cp.sm.InvitedDepartment4OrgUnitInfo;
import com.kingdee.eas.cp.sm.InvitedPerson2PersonCollection;
import com.kingdee.eas.cp.sm.InvitedPerson2PersonFactory;
import com.kingdee.eas.cp.sm.InvitedPerson2PersonInfo;
import com.kingdee.eas.cp.sm.Schedule4PersonVisableConfigFactory;
import com.kingdee.eas.cp.sm.Schedule4PersonVisableConfigInfo;
import com.kingdee.eas.cp.sm.ScheduleEditConfigCollection;
import com.kingdee.eas.cp.sm.ScheduleEditConfigFactory;
import com.kingdee.eas.cp.sm.ScheduleEditConfigInfo;
import com.kingdee.eas.cp.sm.SchedulePersonShareConfigCollection;
import com.kingdee.eas.cp.sm.SchedulePersonShareConfigFactory;
import com.kingdee.eas.cp.sm.SchedulePersonShareConfigInfo;
import com.kingdee.eas.cp.sm.SchedulePlanInfo;
import com.kingdee.eas.cp.sm.util.DateUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class CommonDataUtil {
    public static List query(Context ctx, IMetaDataPK queryPK, EntityViewInfo evi) throws SQLException, BOSException {
        return CommonDataUtil.query(queryPK, evi, ctx);
    }

    public static List query(IMetaDataPK queryPK, EntityViewInfo evi, Context ctx) throws SQLException, BOSException {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        exec.setObjectView(evi);
        exec.option().isAutoTranslateEnum = true;
        exec.option().isIgnorePermissionCheck = false;
        IRowSet set = exec.executeQuery();
        return CommonDataUtil.recordSet2ArrayList2LowCase(set);
    }

    public static List recordSet2ArrayList(IRowSet set) throws SQLException {
        ArrayList list = new ArrayList(set.size());
        if (set.first()) {
            ResultSetMetaData meta = set.getMetaData();
            do {
                int count = meta.getColumnCount();
                HashMap<String, Object> item = new HashMap<String, Object>(count);
                for (int i = 1; i <= count; ++i) {
                    item.put(meta.getColumnName(i), set.getObject(i));
                }
                list.add(item);
            } while (set.next());
        }
        return list;
    }

    public static List recordSet2ArrayList2LowCase(IRowSet set) throws SQLException {
        ArrayList list = new ArrayList(set.size());
        if (set.first()) {
            ResultSetMetaData meta = set.getMetaData();
            do {
                int count = meta.getColumnCount();
                HashMap<String, Object> item = new HashMap<String, Object>(count);
                for (int i = 1; i <= count; ++i) {
                    item.put(meta.getColumnName(i).toLowerCase(), set.getObject(i));
                }
                list.add(item);
            } while (set.next());
        }
        return list;
    }

    public static List getPersonByDep(Context ctx, List invitedDepartmentList) {
        ArrayList<PersonInfo> retList = new ArrayList<PersonInfo>();
        try {
            if (invitedDepartmentList != null && !invitedDepartmentList.isEmpty()) {
                HashSet<String> depIdSet = new HashSet<String>();
                AdminOrgUnitInfo admin = null;
                int size = invitedDepartmentList.size();
                for (int i = 0; i < size; ++i) {
                    admin = (AdminOrgUnitInfo)invitedDepartmentList.get(i);
                    depIdSet.add(admin.getId().toString());
                }
                EntityViewInfo entityViewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", depIdSet, CompareType.INCLUDE));
                entityViewInfo.setFilter(filterInfo);
                MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.cp.base.app.PersonQuery");
                List dataList = CommonDataUtil.query((IMetaDataPK)queryPK, entityViewInfo, ctx);
                if (dataList != null && !dataList.isEmpty()) {
                    for (int i = 0; i < dataList.size(); ++i) {
                        HashMap data = (HashMap)dataList.get(i);
                        PersonInfo personInfo = new PersonInfo();
                        personInfo.setId(BOSUuid.read((String)((String)data.get("id"))));
                        personInfo.setName((String)data.get("name"));
                        retList.add(personInfo);
                    }
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return retList;
    }

    public static Schedule4PersonVisableConfigInfo getPersonVisableConfig(Context ctx) {
        Schedule4PersonVisableConfigInfo personVisiableConfig = null;
        PersonInfo psn = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        String sql = "select isCancelVisable,isDeletedVisable,isShowMessage where person.id ='" + psn.getId().toString() + "'";
        try {
            ISchedule4PersonVisableConfig iScheduleConfig = Schedule4PersonVisableConfigFactory.getLocalInstance(ctx);
            if (iScheduleConfig.exists(sql)) {
                personVisiableConfig = iScheduleConfig.getSchedule4PersonVisableConfigInfo(sql);
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return personVisiableConfig;
    }

    public static Schedule4PersonVisableConfigInfo getPersonVisableConfig(Context ctx, String psnId) {
        Schedule4PersonVisableConfigInfo personVisiableConfig = null;
        String sql = "select isCancelVisable,isDeletedVisable,isShowMessage where person.id ='" + psnId + "'";
        try {
            ISchedule4PersonVisableConfig iScheduleConfig = Schedule4PersonVisableConfigFactory.getLocalInstance(ctx);
            if (iScheduleConfig.exists(sql)) {
                personVisiableConfig = iScheduleConfig.getSchedule4PersonVisableConfigInfo(sql);
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return personVisiableConfig;
    }

    public static SchedulePersonShareConfigInfo getSchedulePersonShareConfigInfo(Context ctx) {
        SchedulePersonShareConfigInfo configInfo = null;
        try {
            ISchedulePersonShareConfig service = SchedulePersonShareConfigFactory.getLocalInstance(ctx);
            SchedulePersonShareConfigCollection coll = service.getSchedulePersonShareConfigCollection();
            if (coll != null && !coll.isEmpty()) {
                configInfo = coll.get(0);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return configInfo;
    }

    public static String getJoinerStr(String scheduleId, Context ctx) {
        String retStr = "";
        StringBuffer builder = new StringBuffer();
        InvitedDepartment4OrgUnitCollection adminOrgColl = CommonDataUtil.getInvitedDepartment4OrgUnitCollection(scheduleId, ctx);
        InvitedDepartment4OrgUnitInfo dep4OrgInfo = null;
        int size = adminOrgColl.size();
        for (int i = 0; i < size; ++i) {
            dep4OrgInfo = adminOrgColl.get(i);
            builder.append(dep4OrgInfo.getOrgUnit().getName()).append(";");
        }
        InvitedPerson2PersonCollection invitedPersonColl = CommonDataUtil.getInvitedPerson2PersonCollection(scheduleId, ctx);
        InvitedPerson2PersonInfo p2pInfo = null;
        int size2 = invitedPersonColl.size();
        for (int i = 0; i < size2; ++i) {
            p2pInfo = invitedPersonColl.get(i);
            builder.append(p2pInfo.getPerson().getName()).append(";");
        }
        if (builder.length() > 0) {
            retStr = builder.substring(0, builder.length() - 1);
        }
        return retStr;
    }

    private static InvitedDepartment4OrgUnitCollection getInvitedDepartment4OrgUnitCollection(String scheduleId, Context ctx) {
        InvitedDepartment4OrgUnitCollection adminOrgColl = new InvitedDepartment4OrgUnitCollection();
        IInvitedDepartment4OrgUnit iinvitedDpt = null;
        EntityViewInfo invitedOrgView = new EntityViewInfo();
        invitedOrgView.getSelector().add(new SelectorItemInfo("orgUnit.id"));
        invitedOrgView.getSelector().add(new SelectorItemInfo("orgUnit.name"));
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("schedule", (Object)scheduleId));
        invitedOrgView.setFilter(filter);
        try {
            iinvitedDpt = InvitedDepartment4OrgUnitFactory.getLocalInstance(ctx);
            adminOrgColl = iinvitedDpt.getInvitedDepartment4OrgUnitCollection(invitedOrgView);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return adminOrgColl;
    }

    private static InvitedPerson2PersonCollection getInvitedPerson2PersonCollection(String scheduleId, Context ctx) {
        InvitedPerson2PersonCollection invitedPersonColl = new InvitedPerson2PersonCollection();
        EntityViewInfo invitedPersonView = new EntityViewInfo();
        invitedPersonView.getSelector().add(new SelectorItemInfo("person.id"));
        invitedPersonView.getSelector().add(new SelectorItemInfo("person.name"));
        FilterInfo invitedPersonFilter = new FilterInfo();
        invitedPersonFilter.getFilterItems().add(new FilterItemInfo("schedule", (Object)scheduleId));
        invitedPersonFilter.getFilterItems().add(new FilterItemInfo("makeIsAdmin", (Object)"PERSON"));
        invitedPersonView.setFilter(invitedPersonFilter);
        IInvitedPerson2Person iinvitedPerson = null;
        try {
            iinvitedPerson = InvitedPerson2PersonFactory.getLocalInstance(ctx);
            invitedPersonColl = iinvitedPerson.getInvitedPerson2PersonCollection(invitedPersonView);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return invitedPersonColl;
    }

    public static boolean isSchedulePlanInTime(Context ctx, SchedulePlanInfo info) {
        boolean retFlag = true;
        CurrentStateEnum stateEnum = info.getState();
        Date eventEndDate = info.getEventEndDate();
        ScheduleEditConfigInfo configInfo = CommonDataUtil.getEditConfig(ctx);
        if ((stateEnum == null || "UNDO".equals(stateEnum.getValue())) && !DateUtil.isInTime(eventEndDate, configInfo.getMaxUndoEditConfig())) {
            retFlag = false;
        }
        if ("FINISHED".equals(stateEnum.getValue()) && !DateUtil.isInTime(eventEndDate, configInfo.getMaxFinishEditConfig())) {
            retFlag = false;
        }
        return retFlag;
    }

    public static ScheduleEditConfigInfo getEditConfig(Context ctx) {
        ScheduleEditConfigInfo retInfo = null;
        try {
            IScheduleEditConfig editConfigService = ScheduleEditConfigFactory.getLocalInstance(ctx);
            ScheduleEditConfigCollection coll = editConfigService.getScheduleEditConfigCollection();
            if (coll != null && coll.size() == 1) {
                retInfo = coll.get(0);
            } else {
                retInfo = new ScheduleEditConfigInfo();
                retInfo.setMaxFinishEditConfig(3);
                retInfo.setMaxUndoEditConfig(3);
                retInfo.setUndoNotifyConfig(12);
                retInfo.setIsMail(true);
                retInfo.setIsMessage(true);
                retInfo.setIsSms(false);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return retInfo;
    }

    public static Date getNotifyFinishDate(Date eventEndDate, ScheduleEditConfigInfo editConfigInfo) {
        int maxUndoEditConfig = editConfigInfo.getMaxUndoEditConfig();
        int undoNotifyHours = editConfigInfo.getUndoNotifyConfig();
        Date notifyFinishDate = DateUtil.getNotifyFinishDate(eventEndDate, maxUndoEditConfig, undoNotifyHours);
        return notifyFinishDate;
    }

    public static List getSharePersonList(Context ctx, String sql) {
        ArrayList<PersonInfo> list = new ArrayList<PersonInfo>();
        try {
            IRowSet rowData = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowData != null) {
                while (rowData.next()) {
                    PersonInfo person = new PersonInfo();
                    person.setId(BOSUuid.read((String)rowData.getString("id")));
                    person.setName(rowData.getString("name"));
                    person.setNumber(rowData.getString("number"));
                    list.add(person);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static int getSharePersonListCount(Context ctx, String sql) {
        int number = 0;
        try {
            IRowSet rowData = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowData != null && rowData.next()) {
                number = rowData.getInt("personCount");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return number;
    }
}

