/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.taskmng.plugins;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.form.DAOHelper;
import com.kingdee.eas.base.form.app.BusinessSeviceUtil;
import com.kingdee.eas.base.form.core.OpenModeEnum;
import com.kingdee.eas.base.form.metadata.FormOperation;
import com.kingdee.eas.base.form.model.IFormApplication;
import com.kingdee.eas.base.form.model.bill.BillApplication;
import com.kingdee.eas.base.form.model.bill.BillApplicationHelper;
import com.kingdee.eas.base.form.model.bill.OpenBillParameter;
import com.kingdee.eas.base.form.model.command.BeforeCommandArg;
import com.kingdee.eas.base.form.model.command.BeforeDeleteArg;
import com.kingdee.eas.base.form.model.command.BeforeQueryArg;
import com.kingdee.eas.base.form.model.list.ListPlugin;
import com.kingdee.eas.base.form.model.list.OpenListParameter;
import com.kingdee.eas.base.form.util.FormActionUtil;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.taskmng.AbstractTaskInfo;
import com.kingdee.eas.cp.taskmng.CheckTaskCollection;
import com.kingdee.eas.cp.taskmng.CheckTaskFactory;
import com.kingdee.eas.cp.taskmng.ICheckTask;
import com.kingdee.eas.cp.taskmng.ITask;
import com.kingdee.eas.cp.taskmng.ITaskReport;
import com.kingdee.eas.cp.taskmng.ITaskTeamActor;
import com.kingdee.eas.cp.taskmng.TaskCollection;
import com.kingdee.eas.cp.taskmng.TaskFactory;
import com.kingdee.eas.cp.taskmng.TaskInfo;
import com.kingdee.eas.cp.taskmng.TaskReportCollection;
import com.kingdee.eas.cp.taskmng.TaskReportFactory;
import com.kingdee.eas.cp.taskmng.TaskState;
import com.kingdee.eas.cp.taskmng.TaskTeamActorCollection;
import com.kingdee.eas.cp.taskmng.TaskTeamActorFactory;
import com.kingdee.eas.cp.taskmng.TaskTeamActorInfo;
import com.kingdee.eas.cp.taskmng.TaskTeamInfo;
import com.kingdee.eas.cp.taskmng.util.StringUtil;
import com.kingdee.eas.cp.taskmng.util.TmHelpUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.HashMap;
import java.util.Map;

public class TasksListPlugin
extends ListPlugin {
    private Context ctx;
    private boolean isNext = true;
    private String taskTeamPK;
    private PersonInfo person;

    public boolean onInitialize(OpenListParameter param) throws EASBizException, BOSException {
        this.ctx = this.application.getContext();
        param.singleSelect = true;
        this.taskTeamPK = StringUtil.url2Str(param.getCustomParameter("taskTeamID"));
        TmHelpUtil.setTaskTeamPk(this.taskTeamPK);
        return super.onInitialize(param);
    }

    public void onLoad() {
        try {
            this.application.getListView().listenRowSelectionChange();
            this.person = ContextUtil.getCurrentUserInfo((Context)this.ctx).getPerson();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.onLoad();
    }

    public void onBeforeQuery(BeforeQueryArg arg) {
        boolean isQout = false;
        try {
            ITaskTeamActor actorService = TaskTeamActorFactory.getLocalInstance(this.ctx);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("parent", (Object)this.taskTeamPK, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("actorName", (Object)this.person.getId().toString(), CompareType.EQUALS));
            view.setFilter(filter);
            TaskTeamActorCollection actorColl = actorService.getTaskTeamActorCollection(view);
            for (int i = 0; i < actorColl.size(); ++i) {
                TaskTeamActorInfo actorInfo = actorColl.get(i);
                if (!actorInfo.isViewTask()) {
                    ITask taskService = TaskFactory.getLocalInstance(this.ctx);
                    StringBuffer filterBy = new StringBuffer();
                    filterBy.append("FTaskTeamID='" + this.taskTeamPK + "' and ( FDutyPersonID='" + this.person.getId().toString());
                    filterBy.append("' or FEnlistPersonID='" + this.person.getId().toString());
                    filterBy.append("' or FGiveInPersonID='" + this.person.getId().toString());
                    filterBy.append("' or FCheckPersonID='" + this.person.getId().toString() + "' ");
                    if (actorInfo.isIsAscend()) {
                        TaskCollection taskColl = taskService.getTaskCollection("select * where  TaskTeam.id='" + this.taskTeamPK + "' and dutyPerson.id='" + this.person.getId().toString() + "' or enlistPerson.id='" + this.person.getId().toString() + "' or giveInPerson.id='" + this.person.getId().toString() + "' or checkPerson.id='" + this.person.getId().toString() + "'");
                        for (int j = 0; j < taskColl.size(); ++j) {
                            if (j == 0) {
                                filterBy.append("or FCustomNumber in ('" + taskColl.get(j).getCustomNumber() + "'");
                            } else {
                                filterBy.append(",'" + taskColl.get(j).getCustomNumber() + "'");
                            }
                            if (taskColl.get(j).getCustomNumber().length() <= 1) continue;
                            if (taskColl.get(j).getCustomNumber().indexOf(".") == -1) {
                                filterBy.append(",'" + taskColl.get(j).getCustomNumber() + "'");
                                continue;
                            }
                            filterBy.append(",'" + taskColl.get(j).getCustomNumber().substring(0, taskColl.get(j).getCustomNumber().lastIndexOf(".")) + "'");
                        }
                        if (taskColl.size() > 0) {
                            filterBy.append(")");
                        }
                    }
                    int index = 1;
                    if (actorInfo.isCreateTask()) {
                        TaskCollection infoColl = taskService.getTaskCollection("select customNumber where TaskTeam.id='" + this.taskTeamPK + "' and creator.id='" + ContextUtil.getCurrentUserInfo((Context)this.ctx).getId().toString() + "'");
                        filterBy.append(" or t1.FCreatorID ='" + ContextUtil.getCurrentUserInfo((Context)this.ctx).getId().toString() + "'");
                        for (int j = 0; j < infoColl.size(); ++j) {
                            filterBy.append(" or FCustomNumber like '" + infoColl.get(j).getCustomNumber() + "%'");
                        }
                        if (infoColl.size() > 0) {
                            isQout = false;
                            ++index;
                        }
                    } else {
                        this.application.getListView().setBarItemDisabled("mnuAdd", true);
                        this.application.getListView().setBarItemDisabled("tbButton", true);
                    }
                    filterBy.append(")");
                    arg.setFilterBy(filterBy.toString());
                    continue;
                }
                arg.setFilterBy("FTaskTeamID='" + this.taskTeamPK + "'");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        arg.setOrderBy(" t1.FCustomNumber asc ");
        super.onBeforeQuery(arg);
    }

    public void beforeBarItemClick(BeforeCommandArg beforeCommandArg) throws EASBizException, BOSException {
        String key = beforeCommandArg.getKey();
        String[] task = this.application.getListView().getSelectedBillIds();
        this.ctx.put((Object)"f7TaskId", (Object)this.taskTeamPK);
        if ("mnuAdd".equalsIgnoreCase(key)) {
            if (task.length > 0) {
                String taskSourcePk = task[0];
                this.ctx.put((Object)"taskSourcePk", (Object)taskSourcePk);
            }
            this.ctx.put((Object)"taskTeamPK", (Object)this.taskTeamPK);
        } else if ("tbButton_5".equals(key)) {
            this.disuseTask();
        } else if ("tbButton_1".equals(key)) {
            this.updateTask();
        } else if ("tbButton_2".equals(key)) {
            if (task == null || task.length == 0) {
                this.application.showMessage("\u8bf7\u9009\u62e9\u4e00\u884c");
                return;
            }
        } else if ("mnuEditView".equals(key)) {
            this.taskView();
        } else if ("tbButton".equals(key)) {
            ITask taskService = TaskFactory.getLocalInstance(this.ctx);
            TaskInfo info = (TaskInfo)this.application.getBillValue();
            if (info == null) {
                this.application.showMessage("\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e");
            } else {
                BOSUuid pk = BOSUuid.create((BOSObjectType)info.getBOSType());
                String oql = info.getCustomNumber().lastIndexOf(".") == -1 ? "select customNumber where TaskTeam.id='" + info.getTaskTeam().getId().toString() + "'" : "select customNumber where TaskTeam.id='" + info.getTaskTeam().getId().toString() + "'" + " and customNumber like '" + info.getCustomNumber().substring(0, info.getCustomNumber().lastIndexOf(".")) + ".%'";
                TaskCollection coll = taskService.getTaskCollection(oql);
                int index = 1;
                for (int j = 0; j < coll.size(); ++j) {
                    TaskInfo taskInfo = coll.get(j);
                    if (taskInfo.getCustomNumber().length() != info.getCustomNumber().length()) continue;
                    ++index;
                }
                info.setId(pk);
                if (info.getCustomNumber().length() == 1) {
                    info.setCustomNumber(index + "");
                } else {
                    info.setCustomNumber(info.getCustomNumber().substring(0, info.getCustomNumber().lastIndexOf(".")) + "." + index);
                }
                info.setName("&nbsp;&nbsp;\u590d\u5236   " + info.getName());
                info.setState(TaskState.getEnum("0"));
                taskService.addnew((CoreBaseInfo)info);
                this.application.getListView().refresh();
            }
        }
        super.beforeBarItemClick(beforeCommandArg);
    }

    private void updateTask() throws BOSException, EASBizException {
        String pk = this.getSelectedPK();
        if (pk == null) {
            this.application.showMessage("\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\uff01");
            return;
        }
        String taskSourcePk = pk;
        this.ctx.put((Object)"taskSourcePk", (Object)taskSourcePk);
    }

    private void submitFlow(String formId, String pk) throws BOSException, EASBizException, Exception {
        OpenBillParameter param = new OpenBillParameter();
        param.setFormId(formId);
        param.billPk = pk;
        BillApplicationHelper helper = BillApplicationHelper.getInstance((Context)this.application.getContext(), (OpenBillParameter)param, null);
        BillApplication billApp = helper.newBillApplication();
        String[] strid = new String[]{pk};
        helper.loadData(strid);
        FormActionUtil.invokeBillFunction((IFormApplication)billApp, (String)"Submit", null);
    }

    private TaskTeamInfo getTaskTeamById(String pk) {
        AbstractTaskInfo info = null;
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)pk));
            SelectorItemCollection coll = new SelectorItemCollection();
            coll.add("TaskTeam.*");
            view.setFilter(filterInfo);
            view.setSelector(coll);
            ITask taskService = TaskFactory.getLocalInstance(this.ctx);
            CoreBaseCollection collection = taskService.getCollection(view);
            if (collection != null && collection.size() > 0) {
                info = (TaskInfo)collection.get(0);
            }
            return info.getTaskTeam();
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void submitFlow(String pk) throws BOSException, EASBizException {
        IObjectValue objectValue = DAOHelper.getDAO().load(this.application.getContext(), pk, null);
        String formId = this.application.getListModel().getFormId();
        String billName = StringUtil.throwOffBlank(objectValue.getString("name"));
        String billNumber = objectValue.getString("number");
        String sourcePK = objectValue.get("id").toString();
        TaskTeamInfo taskTeamInfo = this.getTaskTeamById(pk);
        String processDefID = (String)taskTeamInfo.get("relatingWf");
        if (StringUtil.isEmpty((String)processDefID)) {
            this.application.showMessage("\u5f53\u524d\u5c0f\u7ec4\u6ca1\u6709\u5173\u8054\u6d41\u7a0b\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            return;
        }
        if (processDefID != null) {
            String userId = this.application.getContext().getCaller().toString();
            IEnactmentService wfService = EnactmentServiceProxy.getEnacementService((Context)this.application.getContext());
            HashMap<String, String> invokeContext = new HashMap<String, String>();
            invokeContext.put("billidString", pk);
            invokeContext.put("formId", formId);
            invokeContext.put("billName", billName);
            invokeContext.put("billNo", billNumber);
            wfService.createAndCompleteFiristActivity(processDefID, invokeContext, userId);
            this.application.showMessage("\u63d0\u4ea4\u6210\u529f\uff01");
            this.application.getListView().refresh();
            return;
        }
        BusinessSeviceUtil.triggerWfEvent((Context)this.application.getContext(), (BOSObjectType)objectValue.getBOSType(), (String)"Submit", (String)pk, (String)formId, (String)billName, (String)billNumber);
    }

    public boolean beforeOperation(FormOperation operation) throws EASBizException, BOSException {
        String[] pks = null;
        try {
            pks = this.application.getListView().getSelectedBillIds();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        TaskInfo info = (TaskInfo)this.application.getBillValue();
        ITask iTask = TaskFactory.getLocalInstance(this.ctx);
        if ("\u67e5\u770b".equals(operation.toString())) {
            if (info != null && info.getState().getValue() != "0") {
                return false;
            }
        } else {
            if ("\u63d0\u4ea4".equals(operation.toString())) {
                if (pks == null || pks.length == 0) {
                    this.application.showMessage("\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\uff01");
                    return false;
                }
                if (pks.length > 1) {
                    this.application.showMessage("\u4e0d\u80fd\u9009\u62e9\u591a\u884c\u6570\u636e\uff01");
                    return false;
                }
                if (info != null) {
                    if (info.getState() != TaskState.giveIn) {
                        if (info.getState() == TaskState.executed) {
                            if (info.getSchedule().doubleValue() < 100.0) {
                                this.application.showMessage("\u4efb\u52a1\u8fd8\u672a\u6267\u884c\u5b8c\u6bd5\uff0c\u4e0d\u80fd\u63d0\u4ea4");
                                return false;
                            }
                            info.setState(TaskState.getEnum("2"));
                        } else {
                            this.application.showMessage("\u8be5\u4efb\u52a1\u5df2\u63d0\u4ea4\uff0c\u4e0d\u80fd\u91cd\u590d\u6b64\u64cd\u4f5c\uff01");
                            return false;
                        }
                    }
                    TmHelpUtil.setTaskPK(info.getId().toString());
                }
                try {
                    TaskInfo frontTaskInfo;
                    info = TmHelpUtil.getTaskInfo(this.ctx, "select * where id='" + info.getId().toString() + "'");
                    if ("true".equals(info.getIsDepend().trim()) && (frontTaskInfo = info.getFrontageTask()) != null) {
                        frontTaskInfo = TmHelpUtil.getTaskInfo(this.ctx, "select * where id='" + frontTaskInfo.getId().toString() + "'");
                        this.application.setValue("FTaskSourse1", (Object)StringUtil.throwOffBlank(frontTaskInfo.getName()), 0);
                        if (!frontTaskInfo.getSchedule().toString().equals("100.0000000000")) {
                            this.application.showMessage("\u540d\u79f0\u4e3a" + StringUtil.throwOffBlank(frontTaskInfo.getName()) + "\u7684\u4efb\u52a1\u6682\u65f6\u672a\u5b8c\u6210\uff01");
                            return false;
                        }
                    }
                    TmHelpUtil.setBillId(pks[0]);
                    this.submitFlow(pks[0]);
                    return false;
                }
                catch (Exception e) {
                    this.application.showMessage("\u8be5\u6d41\u7a0b\u5355\u636e\u63d0\u4ea4\u5931\u8d25\uff01");
                    e.printStackTrace();
                    return false;
                }
            }
            if ("\u4fee\u6539".equals(operation.toString()) && (pks == null || pks.length == 0)) {
                this.application.showMessage("\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\uff01");
                return false;
            }
        }
        return super.beforeOperation(operation);
    }

    public void afterOperation(FormOperation operation) throws EASBizException, BOSException {
        if ("\u63d0\u4ea4".equals(operation.getName())) {
            // empty if block
        }
        super.afterOperation(operation);
    }

    public void onBeforeDelete(BeforeDeleteArg arg) {
        super.onBeforeDelete(arg);
    }

    public void rowSelectionChange(String[] billIds) throws EASBizException, BOSException {
        if (billIds.length <= 0) {
            return;
        }
        ITask taskService = TaskFactory.getLocalInstance(this.ctx);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("creator.*"));
        TaskInfo info = taskService.getTaskInfo((IObjectPK)new ObjectUuidPK(billIds[0]), selector);
        TaskState state = info.getState();
        boolean isCreatePerson = false;
        if (info.getCreator() != null) {
            isCreatePerson = this.person.equalsPK((IObjectValue)info.getCreator().getPerson());
        }
        boolean isDutyPerson = this.person.equals((Object)info.getDutyPerson());
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("edit", Boolean.TRUE);
        map.put("del", Boolean.TRUE);
        map.put("submit", Boolean.TRUE);
        map.put("disabled", Boolean.TRUE);
        if (TaskState.giveIn == state) {
            if (isCreatePerson) {
                map.put("edit", Boolean.FALSE);
                String oql = "select * where TaskTeam.id='" + this.taskTeamPK + "' and customNumber like '" + info.getCustomNumber() + ".%'";
                TaskCollection taskColl = taskService.getTaskCollection(oql);
                if (taskColl.size() <= 0) {
                    map.put("del", Boolean.FALSE);
                }
                map.put("submit", Boolean.FALSE);
                map.put("disabled", Boolean.FALSE);
            }
        } else if (TaskState.executed == state ? isDutyPerson : (TaskState.check == state ? isDutyPerson : TaskState.overstepTerm == state || TaskState.notAccomplish == state || TaskState.accomplish == state || TaskState.disuse == state)) {
            // empty if block
        }
        this.setBtnDisabled(map);
        super.rowSelectionChange(billIds);
    }

    private String getSelectedPK() throws BOSException {
        String[] pk = this.application.getListView().getSelectedBillIds();
        if (pk.length == 0) {
            return null;
        }
        return pk[0];
    }

    private void taskView() throws BOSException, EASBizException {
        TaskInfo info = (TaskInfo)this.application.getBillValue();
        if (info.getState() != null) {
            if (info.getState().getValue() == "1") {
                String pk = this.getSelectedPK();
                if (pk == null) {
                    this.application.showMessage("\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\uff01");
                    return;
                }
                this.ctx.put((Object)"TaskPK", (Object)pk);
                String url = "/easweb/servlet/BillServlet?status=VIEW&formID=ktam1%2bNUQgWKsbVi6mtSxJp%2brpI%3d";
                this.application.popupWindow(url, OpenModeEnum.OpenNewWindow.getValue(), "flowMap", "\u67e5\u770b\u4efb\u52a1", 860, 780);
            } else if (info.getState().getValue() == "2" || info.getState().getValue() == "5") {
                String pk = this.getSelectedPK();
                if (pk == null) {
                    this.application.showMessage("\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\uff01");
                    return;
                }
                this.ctx.put((Object)"TaskPK", (Object)pk);
                String url = "/easweb/servlet/BillServlet?status=VIEW&formID=duwRUSXYQ8ClkXs8OpbKlZp%2brpI%3d";
                this.application.popupWindow(url, OpenModeEnum.OpenNewWindow.getValue(), "flowMap", "\u67e5\u770b\u4efb\u52a1", 860, 788);
            }
        }
    }

    private void checkTask() throws BOSException, EASBizException {
        ITaskReport taskReportService;
        TaskReportCollection coll;
        String pk = this.getSelectedPK();
        if (pk == null) {
            this.application.showMessage("\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\uff01");
            this.isNext = false;
        }
        if ((coll = (taskReportService = TaskReportFactory.getLocalInstance(this.ctx)).getTaskReportCollection("select * where Task.id='" + pk + "'")).size() > 0 && coll.get(0).getSchedule().doubleValue() >= 100.0) {
            TaskInfo info = (TaskInfo)this.application.getBillValue();
            ITask taskService = TaskFactory.getLocalInstance(this.ctx);
            info.setState(TaskState.getEnum("2"));
            taskService.save((CoreBaseInfo)info);
            this.application.getListView().refresh();
            this.ctx.put((Object)"TaskPK", (Object)pk);
        } else {
            this.application.showMessage("\u4efb\u52a1\u8fd8\u672a\u6267\u884c\u5b8c\u6bd5\uff0c\u4e0d\u80fd\u8fdb\u884c\u9a8c\u6536");
            this.isNext = false;
        }
    }

    private void disuseTask() throws BOSException, EASBizException {
        ITask taskService = TaskFactory.getLocalInstance(this.ctx);
        String pk = this.getSelectedPK();
        if (pk == null) {
            this.application.showMessage("\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\uff01");
            return;
        }
        TaskInfo info = taskService.getTaskInfo((IObjectPK)new ObjectUuidPK(pk));
        CoreBaseCollection coll = taskService.getCollection("select * where customNumber like '" + info.getCustomNumber() + ".%' and TaskTeam.id='" + info.getTaskTeam().getId() + "'");
        if (coll.size() > 0) {
            this.application.showMessage("\u8be5\u4efb\u52a1\u4e0b\u5b58\u5728\u5b50\u4efb\u52a1\uff0c\u5fc5\u987b\u5148\u5e9f\u5f03\u5b50\u4efb\u52a1\u518d\u5e9f\u5f03\u7236\u4efb\u52a1");
            return;
        }
        info.setState(TaskState.getEnum("6"));
        taskService.update((IObjectPK)new ObjectUuidPK(pk), (CoreBaseInfo)info);
        this.application.showMessage("\u5e9f\u5f03\u6210\u529f");
        this.application.getListView().refresh();
    }

    private void reportTask() throws BOSException, EASBizException {
        ICheckTask checkTaskService;
        CheckTaskCollection coll;
        String pk = this.getSelectedPK();
        if (pk == null) {
            this.application.showMessage("\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\uff01");
            this.isNext = false;
        }
        if ((coll = (checkTaskService = CheckTaskFactory.getLocalInstance(this.ctx)).getCheckTaskCollection("select * where Task.id='" + pk + "'")).size() > 0) {
            this.application.showMessage("\u8be5\u4efb\u52a1\u5df2\u7ecf\u9a8c\u6536\u4e0d\u80fd\u518d\u6c47\u62a5");
            this.isNext = false;
            return;
        }
        TaskInfo info = (TaskInfo)this.application.getBillValue();
        ITask taskService = TaskFactory.getLocalInstance(this.ctx);
        info.setState(TaskState.getEnum("1"));
        taskService.save((CoreBaseInfo)info);
        this.application.getListView().refresh();
        this.ctx.put((Object)"TaskPK", (Object)pk);
    }

    private void setBtnDisabled(Map map) throws BOSException {
        this.application.getListView().setBarItemDisabled("tbButton_1", ((Boolean)map.get("edit")).booleanValue());
        this.application.getListView().setBarItemDisabled("tbButton_2", ((Boolean)map.get("del")).booleanValue());
        this.application.getListView().setBarItemDisabled("tbButton_4", ((Boolean)map.get("submit")).booleanValue());
        this.application.getListView().setBarItemDisabled("tbButton_5", ((Boolean)map.get("disabled")).booleanValue());
    }
}

