/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.wfm.plugins;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.form.DAOHelper;
import com.kingdee.eas.base.form.extend.flow.ITemplate;
import com.kingdee.eas.base.form.extend.flow.TemplateCollection;
import com.kingdee.eas.base.form.extend.flow.TemplateFactory;
import com.kingdee.eas.base.form.extend.flow.TemplateInfo;
import com.kingdee.eas.base.form.metadata.BusinessInfo;
import com.kingdee.eas.base.form.metadata.Entity;
import com.kingdee.eas.base.form.metadata.Field;
import com.kingdee.eas.base.form.metadata.FormOperation;
import com.kingdee.eas.base.form.model.DynamicFormApplication;
import com.kingdee.eas.base.form.model.OperationStatus;
import com.kingdee.eas.base.form.model.bill.BillBusinessUtil;
import com.kingdee.eas.base.form.model.bill.BillModel;
import com.kingdee.eas.base.form.model.bill.IDList;
import com.kingdee.eas.base.form.model.bill.OpenBillParameter;
import com.kingdee.eas.base.form.plugin.AbstractBillPlugin;
import com.kingdee.eas.base.form.util.ExpressionUtil;
import com.kingdee.eas.base.form.web.WebBillEditPanel;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.config.Property;
import com.kingdee.eas.dynbusiness.config.PropertyCheckConfigItems;
import com.kingdee.eas.ep.CoreBillBaseCustomEntryCollection;
import com.kingdee.eas.ep.CoreBillBaseCustomEntryInfo;
import com.kingdee.eas.ep.CoreBillBaseCustomInfo;
import com.kingdee.eas.framework.batchaction.ActionCommonException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.LinkedList;

public abstract class AbstractDetailBillPlugin
extends AbstractBillPlugin {
    protected static final String NODECONTROLBOSTYPE = "30551B26";
    protected static final String CHECK_REQUIRED = "checkRequired";
    protected static final String EMPTY_EXPRESSION_NULL = "@this == null";
    protected String formId;
    protected String nodeId;
    protected String seq;
    protected String flowId;
    protected String layoutId;
    protected String entryBosType;
    protected String entryTableName;
    protected String billType;
    protected String checkNameUrl;
    protected String distributeHistoryUrl = "/easweb/cp/wfm/materialDistributeHistory.jsf";
    protected String operationSaveEntry = "saveEntry";
    protected String operationSaveAndAdd = "saveAndAdd";
    protected String operationColseWindow = "colseWindow";
    protected String operationPreviousdata = "previousdata";
    protected String operationNextdata = "nextdata";
    protected String operationCheckName = "checkName";
    protected String operationDistributeHistory = "distributeHistory";
    protected String targetbidKey = "targetbid";
    private String currentBillID;

    protected abstract void initParams();

    public void onLoad() {
        super.onLoad();
        this.currentBillID = this.application.getBillValue().getString("id");
        this.loadIdList();
    }

    public void loadIdList() {
        ((WebBillEditPanel)this.application.getBillView()).setIdList(this.getIdList());
    }

    private IDList getIdList() {
        LinkedList<String> ids = new LinkedList<String>();
        this.currentBillID = this.application.getBillValue().getString("id");
        StringBuffer str = new StringBuffer(" select fid from " + this.entryTableName + "  where  Fbill1ID in (select Fbill1ID from " + this.entryTableName + " where fid = '" + this.currentBillID + "') order by fseq");
        try {
            IRowSet rows = DbUtil.executeQuery((Context)this.application.getContext(), (String)str.toString());
            while (rows.next()) {
                ids.add(rows.getString("fid"));
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return new IDList(ids, this.currentBillID);
    }

    public void afterOperation(FormOperation operation) throws EASBizException, BOSException {
        this.application.getBillView().setParentRefresh(true);
        super.afterOperation(operation);
    }

    public void afterCreateNewData() throws EASBizException, BOSException {
        CoreBillBaseCustomEntryInfo info = (CoreBillBaseCustomEntryInfo)this.application.getBillModel().getBillValue();
        info.setBOSUuid("id", BOSUuid.create((String)this.entryBosType));
    }

    public boolean onInitialize(OpenBillParameter param) throws EASBizException, BOSException {
        this.initParams();
        this.nodeId = (String)this.application.getCustomParameter("nodeId");
        this.seq = (String)this.application.getCustomParameter("seq");
        this.flowId = (String)this.application.getCustomParameter("flowId");
        this.formId = (String)this.application.getCustomParameter("formID");
        return super.onInitialize(param);
    }

    public boolean beforeOperation(FormOperation operation) throws EASBizException, BOSException {
        if (operation.getOperation().equalsIgnoreCase("save")) {
            return false;
        }
        return super.beforeOperation(operation);
    }

    public void afterBindData() throws EASBizException, BOSException {
        super.afterBindData();
        this.setNodeControlPolicy();
    }

    public void beforeValidate(PropertyCheckConfigItems checkItems) throws EASBizException, BOSException {
        super.beforeValidate(checkItems);
        BusinessInfo business = this.application.getBillModel().getBusinessInfo();
        if (checkItems == null) {
            checkItems = PropertyCheckConfigItems.defineForRequiredValidation((String)business.getForm().getBosType());
        }
        String pk = this.getPk();
        IObjectValue objectValue = null;
        if (pk != null) {
            objectValue = DAOHelper.getDAO().load(this.application.getContext(), pk, null);
            for (IObjectValue rowData : (IObjectCollection)objectValue.get("fieldEntrys")) {
                Object key = rowData.get("key");
                if (key == null) continue;
                boolean isMustInput = rowData.getBoolean("isMustInput");
                Field field = business.getField(key.toString());
                if (!isMustInput || field.isMustInput()) continue;
                Property property = new Property(field.getKey(), this.getLongPropertyName(business, field));
                if (field.getZeroEmpty() == 1) {
                    property.setEmptyExpression(EMPTY_EXPRESSION_NULL);
                }
                checkItems.addRequiredProperty(property);
            }
        }
    }

    protected boolean validateBeforeSaveOrSubmit() {
        boolean result = false;
        try {
            if (this.application.getBillView().getLayoutInfo().getFormAppearance().isValidateBeforeSaving()) {
                PropertyCheckConfigItems checkItems = null;
                try {
                    if (this.application.getBillModel().getBusinessInfo().getCheckItems() != null) {
                        checkItems = (PropertyCheckConfigItems)this.application.getBillModel().getBusinessInfo().getCheckItems().clone();
                    }
                }
                catch (CloneNotSupportedException e) {
                    throw new BOSException((Throwable)e);
                }
                this.beforeValidate(checkItems);
                BillBusinessUtil.validateAtSave((PropertyCheckConfigItems)checkItems, (String)this.application.getForm().getBosType(), (DynamicFormApplication)this.application, (IObjectValue)this.application.getBillValue());
            }
            result = true;
        }
        catch (ActionCommonException e) {
            this.application.showMessage(e.getMessage());
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    protected boolean saveEntry() throws DataAccessException {
        WebBillEditPanel panel = (WebBillEditPanel)this.application.getDynamicFormView().getParentFormView();
        CoreBillBaseCustomInfo customInfo = (CoreBillBaseCustomInfo)panel.getBillModel().getBillValue();
        CoreBillBaseCustomEntryCollection coll = (CoreBillBaseCustomEntryCollection)customInfo.get("entries1");
        CoreBillBaseCustomEntryInfo entryInfo = (CoreBillBaseCustomEntryInfo)this.application.getBillValue();
        if (coll != null) {
            if (this.seq != null && !"".equals(this.seq)) {
                coll.insertObject(Integer.valueOf(this.seq) - 1, (IObjectValue)entryInfo);
                this.seq = "";
            } else {
                coll.add(entryInfo);
            }
        } else {
            CoreBillBaseCustomEntryCollection entryCollection = new CoreBillBaseCustomEntryCollection();
            entryCollection.add(entryInfo);
            customInfo.put("entries1", (Object)entryCollection);
        }
        DAOHelper.getDAO().update(this.application.getContext(), (IObjectValue)customInfo);
        this.loadIdList();
        return true;
    }

    protected void afterSaveEntry(boolean isCreateNew) {
    }

    public void doCustomOperation(String operation) throws EASBizException, BOSException {
        block38: {
            String oldStatus = this.application.getBillView().getOperationStatus().getStatus();
            if (this.operationCheckName.equals(operation)) {
                CoreBillBaseCustomEntryInfo customInfo = (CoreBillBaseCustomEntryInfo)this.application.getBillModel().getBillValue();
                String name = customInfo.getString("name_l1");
                name = name == null ? "" : name;
                String url = "";
                try {
                    url = this.checkNameUrl + "?billType=" + this.billType + "&name=" + URLEncoder.encode(name, "UTF-8");
                }
                catch (UnsupportedEncodingException e1) {
                    e1.printStackTrace();
                }
                this.application.popupWindow(url, "openDialog", "update", "\u8be6\u7ec6\u4fe1\u606f", 750, 450);
            } else if (this.operationDistributeHistory.equalsIgnoreCase(operation)) {
                String targetbid = this.application.getBillValue().getString(this.targetbidKey);
                if (StringUtils.isEmpty((String)targetbid)) {
                    this.application.showMessage("\u5355\u636e\u672a\u5bfc\u5165\u5230\u57fa\u7840\u6570\u636e\uff0c\u6ca1\u6709\u5206\u914d\u5386\u53f2\u6570\u636e\u3002");
                    return;
                }
                try {
                    String url = this.distributeHistoryUrl + "?billType=" + this.billType + "&dataBaseDID=" + URLEncoder.encode(targetbid, "UTF-8");
                    this.application.popupWindow(url, "openDialog", "distributeHistory", "\u67e5\u770b\u5206\u914d\u5386\u53f2", 750, 450);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            } else if (this.operationSaveEntry.equalsIgnoreCase(operation)) {
                try {
                    if (this.validateBeforeSaveOrSubmit() && this.saveEntry()) {
                        this.application.showMessage("\u4fdd\u5b58\u64cd\u4f5c\u6210\u529f\u3002");
                        ((BillModel)this.application.getBillModel()).setChanged(false);
                        this.afterSaveEntry(false);
                    }
                }
                catch (DataAccessException da) {
                    this.application.showMessage("\u4fdd\u5b58\u64cd\u4f5c\u5931\u8d25\uff1a" + da.getMessage());
                }
            } else if (this.operationSaveAndAdd.equalsIgnoreCase(operation)) {
                try {
                    if (this.validateBeforeSaveOrSubmit() && this.saveEntry()) {
                        ((BillModel)this.application.getBillModel()).setChanged(false);
                        this.application.createNewData();
                        this.afterSaveEntry(true);
                    }
                }
                catch (DataAccessException da) {
                    this.application.showMessage("\u4fdd\u5b58\u64cd\u4f5c\u5931\u8d25\uff1a" + da.getMessage());
                }
            } else if (this.operationColseWindow.equalsIgnoreCase(operation)) {
                this.application.close();
            } else if (this.operationPreviousdata.equalsIgnoreCase(operation)) {
                if (OperationStatus.VIEW.equals(OperationStatus.getStatus((String)oldStatus))) {
                    this.application.navigate("previous");
                    this.application.getBillView().load(this.application.getBillValue().getString("id"));
                } else if (this.validateBeforeSaveOrSubmit()) {
                    try {
                        if (!this.saveEntry()) break block38;
                        ((BillModel)this.application.getBillModel()).setChanged(false);
                        this.application.navigate("previous");
                        this.application.getBillView().setOperationStatus(OperationStatus.getStatus((String)oldStatus));
                        this.application.getBillView().load(this.application.getBillValue().getString("id"));
                        if (OperationStatus.EDIT.equals(OperationStatus.getStatus((String)oldStatus)) || OperationStatus.ADDNEW.equals(OperationStatus.getStatus((String)oldStatus))) {
                            this.afterSaveEntry(false);
                            break block38;
                        }
                        this.afterSaveEntry(true);
                    }
                    catch (DataAccessException da) {
                        this.application.showMessage("\u4fdd\u5b58\u64cd\u4f5c\u5931\u8d25\uff1a" + da.getMessage());
                    }
                }
            } else if (this.operationNextdata.equalsIgnoreCase(operation)) {
                if (OperationStatus.VIEW.equals(OperationStatus.getStatus((String)oldStatus))) {
                    this.application.navigate("next");
                    this.application.getBillView().load(this.application.getBillValue().getString("id"));
                } else if (this.validateBeforeSaveOrSubmit()) {
                    try {
                        if (this.saveEntry()) {
                            ((BillModel)this.application.getBillModel()).setChanged(false);
                            this.application.navigate("next");
                            this.application.getBillView().setOperationStatus(OperationStatus.getStatus((String)oldStatus));
                            this.application.getBillView().load(this.application.getBillValue().getString("id"));
                            if (OperationStatus.EDIT.equals(OperationStatus.getStatus((String)oldStatus)) || OperationStatus.ADDNEW.equals(OperationStatus.getStatus((String)oldStatus))) {
                                this.afterSaveEntry(false);
                            } else {
                                this.afterSaveEntry(true);
                            }
                        }
                    }
                    catch (DataAccessException da) {
                        this.application.showMessage("\u4fdd\u5b58\u64cd\u4f5c\u5931\u8d25\uff1a" + da.getMessage());
                    }
                }
            }
        }
    }

    private String getLongPropertyName(BusinessInfo business, Field field) {
        String propertyName = field.getPropertyName();
        if (StringUtils.isEmpty((String)propertyName)) {
            return null;
        }
        if (ExpressionUtil.isFieldName((String)propertyName)) {
            propertyName = ExpressionUtil.removeFormatSymbol((String)propertyName);
            field.setPropertyName(propertyName);
            return null;
        }
        Entity entity = business.getEntity(field.getEntityKey());
        if (entity.getEntityType() == 1) {
            String entryName = entity.getEntryName();
            propertyName = entryName + "." + propertyName;
        }
        return propertyName;
    }

    private void setNodeControlPolicy() throws EASBizException, BOSException {
        String pk = this.getPk();
        IObjectValue objectValue = null;
        TemplateInfo templateInfo = this.getTemplateInfo();
        if (pk != null) {
            objectValue = DAOHelper.getDAO().load(this.application.getContext(), pk, null);
            if (templateInfo != null && templateInfo.getFlowNodeKey() != null) {
                String nodeDesc = objectValue.getString("nodeDesc");
                this.application.setControlText(templateInfo.getFlowNodeKey(), nodeDesc == null ? "" : nodeDesc);
            }
            this.setControlCtl((IObjectCollection)objectValue.get("fieldEntrys"));
            this.setControlCtl((IObjectCollection)objectValue.get("containerEntrys"));
            this.setControlCtl((IObjectCollection)objectValue.get("operationEntrys"));
            if (Boolean.FALSE.equals(objectValue.get("isAddAccessory"))) {
                this.application.lockAttachmentOperation("mnuNew");
            }
            if (Boolean.FALSE.equals(objectValue.get("isEditAccessory"))) {
                this.application.lockAttachmentOperation("mnuEdit");
            }
            if (Boolean.FALSE.equals(objectValue.get("isViewAccessory"))) {
                this.application.lockAttachmentOperation("mnuView");
            }
            if (Boolean.FALSE.equals(objectValue.get("isDeleteAccessory"))) {
                this.application.lockAttachmentOperation("mnuDelete");
            }
            if (Boolean.FALSE.equals(objectValue.get("isModifyAccessory"))) {
                this.application.lockAttachmentOperation("mnuEditAttachment");
            }
        }
    }

    private void setControlCtl(IObjectCollection entryCollection) {
        for (IObjectValue rowData : entryCollection) {
            boolean isLock;
            Object key = rowData.get("key");
            if (key == null) continue;
            boolean isHide = rowData.getBoolean("isHide");
            if (isHide) {
                this.application.hideElement(key.toString(), isHide);
            }
            if (isLock = rowData.getBoolean("isLock")) {
                this.application.lockElement(key.toString(), isLock);
            }
            boolean isMustInput = rowData.getBoolean("isMustInput");
            BusinessInfo business = this.application.getBillModel().getBusinessInfo();
            Field field = business.getField(key.toString());
            if (!isMustInput || field.isMustInput()) continue;
            this.application.setMustInput(key.toString(), isMustInput);
        }
    }

    private String getPk() {
        FilterInfo filter = new FilterInfo();
        if ("-1".equals(this.nodeId)) {
            this.flowId = "DRAFT";
        }
        if (this.flowId != null) {
            filter.appendFilterItem("flowId", (Object)this.flowId);
        }
        filter.appendFilterItem("flowNodeId", (Object)this.nodeId);
        filter.appendFilterItem("formId", (Object)this.formId);
        try {
            IObjectPK[] pks = DAOHelper.getDAO().getPKList(this.application.getContext(), BOSObjectType.create((String)NODECONTROLBOSTYPE), filter, null);
            if (pks.length > 0) {
                return pks[0].toString();
            }
            return null;
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    private TemplateInfo getTemplateInfo() throws EASBizException, BOSException {
        ITemplate templateService = null;
        TemplateInfo templateInfo = null;
        try {
            templateService = TemplateFactory.getLocalInstance((Context)this.application.getContext());
            TemplateCollection col = templateService.getTemplateCollection("select id where formId='" + this.formId + "'");
            if (col != null && col.size() > 0) {
                templateInfo = templateService.getTemplateInfo((IObjectPK)new ObjectUuidPK(col.get(0).getId()));
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return templateInfo;
    }
}

