/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.wp.plugins;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.form.model.command.BeforeDeleteArg;
import com.kingdee.eas.base.form.model.command.BeforeQueryArg;
import com.kingdee.eas.base.form.model.list.IListView;
import com.kingdee.eas.base.form.model.list.ListPlugin;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.wp.DictateOrderFactory;
import com.kingdee.eas.cp.wp.DictateOrderInfo;
import com.kingdee.eas.cp.wp.plugins.WPHelpUitl;
import java.util.ArrayList;
import java.util.List;

public class DictateOrderListPlugin
extends ListPlugin {
    public static final int GOING_VALUE = 10;
    public static final int COMMUNICATE_VALUE = 20;
    public static final int DEFER_VALUE = 30;
    public static final int FINISH_VALUE = 40;
    public static final int CANCEL_VALUE = 50;

    public void onLoad() {
        super.onLoad();
        IListView view = this.application.getListView();
        String src = view.getOpenSource();
        if ("print2".equals(src)) {
            ArrayList<String> menu = new ArrayList<String>();
            menu.add("mnuFileNew");
            menu.add("mnuEditModify");
            menu.add("mnuEditDelete");
            menu.add("mnuExportData");
            try {
                view.hideBarItem(menu);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }

    public void onBeforeDelete(BeforeDeleteArg arg) {
        super.onBeforeDelete(arg);
        try {
            UserInfo curUser = (UserInfo)this.application.getListModel().getDefaultValueCalculator().evaluateFunction("getUser(@CONTEXT)");
            List idList = arg.getIdList();
            Context ctx = this.application.getContext();
            boolean flag = false;
            for (int i = 0; i < idList.size(); ++i) {
                try {
                    String id = (String)idList.get(i);
                    DictateOrderInfo dotInfo = DictateOrderFactory.getLocalInstance(ctx).getDictateOrderInfo((IObjectPK)new ObjectUuidPK(id));
                    UserInfo creatorUser = dotInfo.getCreator();
                    if (dotInfo.getFinishInfo() == null || WPHelpUitl.compareUser(curUser, creatorUser) && (dotInfo.getFinishInfo().getValue() == 10 || dotInfo.getFinishInfo().getValue() == 50)) continue;
                    flag = true;
                    break;
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
            if (flag) {
                idList.removeAll(idList);
                this.application.showMessage("\u5305\u542b\u4e0d\u80fd\u5220\u9664\u7684\u6307\u4ee4\u5355\uff01");
            }
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
    }

    public void onBeforeQuery(BeforeQueryArg arg) {
        FilterInfo filter = arg.getFilterInfo();
        String createTime = this.application.getFieldName("date", false);
        arg.setOrderBy(createTime + " desc");
        PersonInfo curPerson = null;
        UserInfo userInfo = null;
        try {
            curPerson = (PersonInfo)this.application.getListModel().getDefaultValueCalculator().evaluateFunction("getUser(@CONTEXT,Person)");
            userInfo = (UserInfo)this.application.getListModel().getDefaultValueCalculator().evaluateFunction("getUser(@CONTEXT)");
            filter.getFilterItems().add(new FilterItemInfo("creator.id", userInfo.get("id")));
            if (curPerson != null) {
                filter.getFilterItems().add(new FilterItemInfo("directionLead.id", curPerson.get("id")));
                filter.getFilterItems().add(new FilterItemInfo("scoutPerson", (Object)("%" + curPerson.getName() + "%"), CompareType.LIKE));
                filter.getFilterItems().add(new FilterItemInfo("liabilityPerson.id", curPerson.get("id")));
                filter.getFilterItems().add(new FilterItemInfo("sender", (Object)("%" + curPerson.getName() + "%"), CompareType.LIKE));
                filter.getFilterItems().add(new FilterItemInfo("finishInfo", (Object)Integer.valueOf(String.valueOf(10)), CompareType.NOTEQUALS));
                filter.setMaskString("#0 or (#1 or #2 or #3 or #4) and (#5)");
            } else {
                filter.setMaskString("#0");
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }
}

