/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.wp.plugins;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.form.core.OpenModeEnum;
import com.kingdee.eas.base.form.json.JSONException;
import com.kingdee.eas.base.form.json.JSONObject;
import com.kingdee.eas.base.form.metadata.FormOperation;
import com.kingdee.eas.base.form.model.IFormApplication;
import com.kingdee.eas.base.form.model.command.CommandArg;
import com.kingdee.eas.base.form.model.command.DataChangeCommandArg;
import com.kingdee.eas.base.form.plugin.AbstractBillPlugin;
import com.kingdee.eas.base.form.util.FormActionUtil;
import com.kingdee.eas.base.form.web.WebBillEditPanel;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.INewOrgUnitFacade;
import com.kingdee.eas.basedata.org.NewOrgUnitFacadeFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.wp.IWpWorkFlowSetting;
import com.kingdee.eas.cp.wp.JobPlanBizTypeFactory;
import com.kingdee.eas.cp.wp.JobPlanBizTypeInfo;
import com.kingdee.eas.cp.wp.JobPlanEntryCollection;
import com.kingdee.eas.cp.wp.JobPlanEntryInfo;
import com.kingdee.eas.cp.wp.JobPlanInfo;
import com.kingdee.eas.cp.wp.PeriodSetCollection;
import com.kingdee.eas.cp.wp.PeriodSetFactory;
import com.kingdee.eas.cp.wp.PeriodSetInfo;
import com.kingdee.eas.cp.wp.PlanCycEnum;
import com.kingdee.eas.cp.wp.WorkPlanStateEnum;
import com.kingdee.eas.cp.wp.WpWorkFlowSettingFactory;
import com.kingdee.eas.cp.wp.WpWorkFlowSettingInfo;
import com.kingdee.eas.cp.wp.plugins.InOrNotMulbasedata;
import java.util.ArrayList;
import java.util.Date;

public class JobPlanEditPlugin
extends AbstractBillPlugin {
    public void onLoad() {
        super.onLoad();
        try {
            Context ctx = this.application.getContext();
            PeriodSetCollection psColl = PeriodSetFactory.getLocalInstance(ctx).getPeriodSetCollection();
            PeriodSetInfo psInfo = psColl.get(0);
            ArrayList<PlanCycEnum> enums = new ArrayList<PlanCycEnum>();
            if (psInfo != null) {
                if (psInfo.isWp_Year()) {
                    enums.add(PlanCycEnum.getEnum(10));
                }
                if (psInfo.isWp_HalfYear()) {
                    enums.add(PlanCycEnum.getEnum(20));
                }
                if (psInfo.isWp_Season()) {
                    enums.add(PlanCycEnum.getEnum(30));
                }
                if (psInfo.isWp_Month()) {
                    enums.add(PlanCycEnum.getEnum(40));
                }
                if (psInfo.isWp_Week()) {
                    enums.add(PlanCycEnum.getEnum(50));
                }
                if (psInfo.isWp_day()) {
                    enums.add(PlanCycEnum.getEnum(60));
                }
            }
            this.application.setEnumContents("list", enums);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void afterBindData() throws EASBizException, BOSException {
        String operationStatus = this.application.getBillView().getOperationStatus().getStatus();
        PersonInfo curPerson = (PersonInfo)this.application.getBillModel().getDefaultValueCalculator().evaluateFunction("getUser(@CONTEXT,Person)");
        UserInfo curUser = (UserInfo)this.application.getBillModel().getDefaultValueCalculator().evaluateFunction("getUser(@CONTEXT)");
        JobPlanInfo jpInfo = (JobPlanInfo)this.application.getBillModel().getBillValue();
        JobPlanEntryCollection jpEntryColl = jpInfo.getEntrys();
        UserInfo creator = jpInfo.getCreator();
        PersonInfo burdenPerson = jpInfo.getBurdenPerson();
        PersonInfo trackPerson = jpInfo.getTrackPerson();
        String examinePerson = jpInfo.getExaminePerson();
        WorkPlanStateEnum state = jpInfo.getState();
        boolean isViewFromList = ((WebBillEditPanel)this.application.getBillView()).isViewFromList();
        boolean isFromWorkflow = this.application.getBillView().getWfState().isFromWorkflow();
        String workFlowState = (String)this.application.getCustomParameter("state");
        this.initLockState();
        if (operationStatus.equals("ADDNEW")) {
            String[] str = new String[]{"btnMod", "btnCancel", "btnDisuse", "btnMod1", "btnCancel1", "btnDisuse1", "btnSubmitScore", "btnSubmitScore1", "btnExecuteFinish", "btnSoutFinish"};
            this.lockElement(str);
            this.application.lockElement("printMeetingDecide", false);
            this.application.lockElement("printDictateOrder", false);
        } else {
            String[] tStr;
            String[] str4;
            String[] str3;
            String[] str2;
            String[] str1;
            String[] str;
            if (state != null && (40 == state.getValue() || 70 == state.getValue() || 100 == state.getValue())) {
                String[] loadActionStr = new String[]{"basedata2", "basedata", "txt", "list", "date", "billnumber", "basedata3", "mulbasedata", "date2", "listState", "basedataCreator", "basedata1", "date1", "mulbasedataCheckPer", "remarkEstimateSource", "intGradeFLeadTwo", "intGradeFBosses", "intProportion", "remarkKeyTarget", "remarkGoal", "intSelfEva", "remarkTrack", "remarkFinishedCount", "remarkFinishDate", "txtType", "intGradeFLead", "remarkEstimateCriterion", "btnMod1", "btnCancel1", "btnMod", "btnCancel", "btnDisuse", "btn", "btnSubmit", "btn3", "btn4", "btn10", "btn5", "btn6", "btnUp", "btnDown", "btnSubmitScore", "btnSubmitScore1", "btnSoutFinish", "btnExecuteFinish"};
                this.lockElement(loadActionStr);
            }
            if (operationStatus.equals("VIEW")) {
                str = new String[]{"txt", "basedata", "basedata1", "basedata2", "list"};
                str1 = new String[]{"date", "date1", "mulbasedata", "basedata3", "listState", "mulbasedataCheckPer"};
                str2 = new String[]{"txtType", "remarkGoal", "remarkKeyTarget", "remarkFinishDate", "remarkEstimateCriterion", "remarkEstimateSource", "intProportion"};
                str3 = new String[]{"btn", "btnSubmit", "btn5", "btn6", "btn3", "btn4", "btn10", "btnMod", "btnCancel", "btnDisuse", "btnMod1", "btnCancel1", "btnDisuse1", "btnSubmitScore", "btnSubmitScore1", "btnExecuteFinish", "btnSoutFinish", "FbtnExportEntry", "FbtnExportEntry1"};
                str4 = new String[]{"remarkTrack", "remarkFinishedCount", "intSelfEva", "intGradeFLead", "intGradeFLeadTwo", "intGradeFBosses"};
                this.lockElement(str);
                this.lockElement(str1);
                this.lockElement(str2);
                this.lockElement(str3);
                this.application.lockElement("printMeetingDecide", false);
                this.application.lockElement("printDictateOrder", false);
                this.hideElement(str4);
                if (state.getValue() <= 60 || state.getValue() >= 50) {
                    String[] strs = new String[]{"intGradeFLead", "intGradeFLeadTwo", "intGradeFBosses"};
                    this.hideElement(strs);
                }
                if (state.getValue() == 50 && burdenPerson.equals((Object)curPerson)) {
                    this.application.hideElement("remarkFinishedCount", false);
                    this.application.hideElement("intSelfEva", false);
                }
                if (state.getValue() == 50 && trackPerson.equals((Object)curPerson)) {
                    this.application.hideElement("remarkFinishedCount", true);
                    this.application.hideElement("intSelfEva", true);
                }
                if (state.getValue() == 52 && burdenPerson.equals((Object)curPerson)) {
                    this.application.hideElement("remarkFinishedCount", false);
                    this.application.hideElement("intSelfEva", false);
                }
                if (state.getValue() == 52 && trackPerson.equals((Object)curPerson)) {
                    this.application.hideElement("remarkTrack", false);
                }
                if (state.getValue() == 54 && burdenPerson.equals((Object)curPerson)) {
                    this.application.hideElement("remarkFinishedCount", false);
                    this.application.hideElement("intSelfEva", false);
                }
                if (state.getValue() == 54 && trackPerson.equals((Object)curPerson)) {
                    this.application.hideElement("remarkTrack", false);
                }
                if (state.getValue() == 60 && burdenPerson.equals((Object)curPerson)) {
                    this.application.hideElement("remarkFinishedCount", false);
                    this.application.hideElement("intSelfEva", false);
                }
                if (state.getValue() == 60 && trackPerson.equals((Object)curPerson)) {
                    this.application.hideElement("remarkTrack", false);
                }
                if (state.getValue() == 70) {
                    this.application.hideElement("remarkTrack", false);
                    this.application.hideElement("remarkFinishedCount", false);
                    this.application.hideElement("intGradeFLead", false);
                    this.application.hideElement("intGradeFLeadTwo", false);
                    this.application.hideElement("intGradeFBosses", false);
                    this.application.hideElement("intSelfEva", false);
                    this.application.lockElement("FbtnExportEntry", false);
                    this.application.lockElement("FbtnExportEntry1", false);
                }
                if (isFromWorkflow) {
                    this.application.lockElement("btn8", true);
                    this.application.lockElement("btn9", true);
                }
                tStr = new String[]{"btnMod", "btnCancel", "btnDisuse", "btnMod1", "btnCancel1", "btnDisuse1"};
                this.lockElement(str);
                this.newRule(curPerson, curUser, creator, burdenPerson, trackPerson, examinePerson, state);
            }
            if (operationStatus.equals("EDIT")) {
                String[] str5;
                String[] str32;
                String[] str22;
                String[] str12;
                InOrNotMulbasedata inOrNot;
                if (state != null && (state.getValue() == 10 || state.getValue() == 20 || state.getValue() == 30)) {
                    this.application.lockElement("printMeetingDecide", false);
                    this.application.lockElement("printDictateOrder", false);
                    this.application.lockElement("btnSubmitScore", true);
                    this.application.lockElement("btnSubmitScore1", true);
                    if (this.compareUser(curUser, creator)) {
                        if (state.getValue() == 10) {
                            str = new String[]{"btnSubmitScore", "btnSubmitScore1", "btnMod", "btnCancel", "btnDisuse", "btnMod1", "btnCancel1", "btnDisuse1", "btnExecuteFinish", "btnSoutFinish"};
                            this.lockElement(str);
                            this.application.lockElement("btn9", false);
                            this.application.lockElement("btn8", false);
                        }
                        if (state.getValue() == 20) {
                            str = new String[]{"btn", "btn5", "btn3", "btn4", "btn10", "billnumber", "btnSubmit", "btn6", "btnMod", "btnCancel", "btnDisuse", "btnMod1", "btnCancel1", "btnDisuse1", "btnUp", "btnDown", "btn8", "btn9", "btnExecuteFinish", "btnSoutFinish", "FBiztype"};
                            this.lockElement(str);
                        }
                        if (state.getValue() == 30) {
                            String[] tStr2 = new String[]{"btnMod", "btnCancel", "btnMod1", "btnCancel1"};
                            this.lockElement(tStr2);
                            if (isViewFromList) {
                                String[] str33 = new String[]{"btn", "btn3", "btn4", "btn5", "btn6", "btn8", "btn9", "btn10", "btnSubmit", "btnDisuse1", "btnDisuse", "btnUp", "btnDown", "btnExecuteFinish", "btnSoutFinish"};
                                this.lockElement(str33);
                            } else {
                                String[] str52 = new String[]{"FlinkShowFlowChart", "FlinkShowApproveResult", "printView", "btnDisuse1", "btnDisuse", "btn3", "btn4", "btn10", "btnUp", "btnDown"};
                                this.unLockElement(str52);
                            }
                        }
                    }
                    if (!this.compareUser(curUser, creator)) {
                        str = new String[]{"txt", "basedata", "basedata1", "basedata2", "list"};
                        str1 = new String[]{"date", "date1", "mulbasedata", "basedata3", "listState", "mulbasedataCheckPer"};
                        str2 = new String[]{"txtType", "remarkGoal", "remarkKeyTarget", "remarkFinishDate", "remarkEstimateCriterion", "remarkEstimateSource", "intProportion"};
                        str3 = new String[]{"btn", "btnSubmit", "btn5", "btn6", "btn3", "btn4", "btn10", "btnMod", "btnCancel", "btnDisuse", "btnMod1", "btnCancel1", "btnDisuse1", "btn8", "btn9", "btnExecuteFinish", "btnSoutFinish", "btnUp", "btnDown"};
                        this.lockElement(str);
                        this.lockElement(str1);
                        this.lockElement(str2);
                        this.lockElement(str3);
                        str4 = new String[]{"remarkTrack", "remarkFinishedCount", "intSelfEva", "intGradeFLead", "intGradeFLeadTwo", "intGradeFBosses"};
                        this.hideElement(str4);
                        tStr = new String[]{"btnMod", "btnCancel", "btnDisuse", "btnMod1", "btnCancel1", "btnDisuse1"};
                        this.lockElement(str);
                    }
                }
                if (state != null && state.getValue() == 50) {
                    inOrNot = new InOrNotMulbasedata();
                    boolean bool = false;
                    if (jpInfo.getExaminePerson() != null) {
                        bool = InOrNotMulbasedata.isINMulbasedata(curPerson, jpInfo.getExaminePerson());
                    }
                    str12 = new String[]{"txt", "basedata", "basedata1", "basedata2", "list", "date", "date1", "mulbasedata", "basedata3", "listState", "btnDisuse", "mulbasedataCheckPer", "FBiztype"};
                    this.lockElement(str12);
                    str22 = new String[]{"txtType", "remarkGoal", "remarkKeyTarget", "remarkFinishDate", "remarkEstimateCriterion", "remarkEstimateSource", "intProportion"};
                    this.lockElement(str22);
                    str32 = new String[]{"btn", "btnSubmit", "btn3", "btn4", "btnUp", "btnDown", "btn10", "btn5", "btn6", "btnMod", "btnCancel", "btnDisuse", "btnMod1", "btnCancel1", "btnDisuse1", "btnSubmitScore", "btnSubmitScore1", "btn8", "btn9", "btnExecuteFinish", "btnSoutFinish"};
                    this.lockElement(str32);
                    if (curPerson.equals((Object)trackPerson)) {
                        str5 = new String[]{"intSelfEva", "remarkFinishedCount", "intGradeFLead", "intGradeFLeadTwo", "intGradeFBosses"};
                        this.hideElement(str5);
                        this.application.lockElement("btn", false);
                        this.application.lockElement("btnSubmit", true);
                        this.application.lockElement("btn5", false);
                        this.application.lockElement("btn6", true);
                    }
                    if (curPerson.equals((Object)burdenPerson) || this.compareUser(curUser, creator) || bool) {
                        this.application.hideElement("remarkTrack", true);
                        this.application.lockElement("intGradeFLead", true);
                        this.application.lockElement("intGradeFLeadTwo", true);
                        this.application.lockElement("intGradeFBosses", true);
                        if (bool) {
                            this.application.hideElement("remarkTrack", false);
                            this.application.lockElement("remarkTrack", true);
                            this.application.lockElement("intSelfEva", true);
                            this.application.lockElement("remarkFinishedCount", true);
                        }
                        if (this.compareUser(curUser, creator)) {
                            this.application.lockElement("btn", true);
                            this.application.lockElement("btn5", true);
                            this.application.lockElement("intSelfEva", true);
                            this.application.lockElement("remarkFinishedCount", true);
                            this.application.lockElement("btnMod", false);
                            this.application.lockElement("btnCancel", false);
                            this.application.lockElement("btnMod1", false);
                            this.application.lockElement("btnCancel1", false);
                        }
                        if (curPerson.equals((Object)burdenPerson)) {
                            this.application.lockElement("btn", false);
                            this.application.lockElement("btn5", false);
                            this.application.hideElement("intSelfEva", false);
                            this.application.hideElement("remarkFinishedCount", false);
                            this.application.lockElement("intSelfEva", false);
                            this.application.lockElement("remarkFinishedCount", false);
                            this.application.lockElement("btnSubmitScore", true);
                            this.application.lockElement("btnSubmitScore1", true);
                            this.application.lockElement("btnExecuteFinish", false);
                            this.application.lockElement("btnMod", false);
                            this.application.lockElement("btnMod1", false);
                            if (this.compareUser(curUser, creator)) {
                                this.application.lockElement("btnCancel", false);
                                this.application.lockElement("btnCancel1", false);
                            }
                        }
                    }
                }
                if (state != null && (state.getValue() == 52 || state.getValue() == 54)) {
                    inOrNot = new InOrNotMulbasedata();
                    boolean bool = false;
                    if (jpInfo.getExaminePerson() != null) {
                        bool = InOrNotMulbasedata.isINMulbasedata(curPerson, jpInfo.getExaminePerson());
                    }
                    str12 = new String[]{"txt", "basedata", "basedata1", "basedata2", "list", "date", "date1", "mulbasedata", "basedata3", "listState", "btnDisuse", "mulbasedataCheckPer", "FBiztype"};
                    this.lockElement(str12);
                    str22 = new String[]{"txtType", "remarkGoal", "remarkKeyTarget", "remarkFinishDate", "remarkEstimateCriterion", "remarkEstimateSource", "intProportion", "remarkFinishedCount", "remarkTrack", "intSelfEva", "intGradeFLead", "intGradeFLeadTwo", "intGradeFBosses"};
                    this.lockElement(str22);
                    String[] hideStr = new String[]{"intGradeFLead", "intGradeFLeadTwo", "intGradeFBosses", "remarkTrack", "remarkFinishedCount", "intSelfEva"};
                    this.hideElement(hideStr);
                    String[] str34 = new String[]{"btn", "btnSubmit", "btn3", "btn4", "btnUp", "btnDown", "btn10", "btn5", "btn6", "btnMod", "btnCancel", "btnDisuse", "btnMod1", "btnCancel1", "btnDisuse1", "btnSubmitScore", "btnSubmitScore1", "btn8", "btn9", "btnExecuteFinish", "btnSoutFinish"};
                    this.lockElement(str34);
                    if (state.getValue() == 52 && curPerson.equals((Object)burdenPerson)) {
                        this.application.hideElement("intSelfEva", false);
                        this.application.hideElement("remarkFinishedCount", false);
                        this.application.lockElement("remarkTrack", false);
                    }
                    if (state.getValue() == 52 && curPerson.equals((Object)trackPerson)) {
                        this.application.hideElement("remarkTrack", false);
                        this.application.lockElement("remarkTrack", false);
                        this.application.lockElement("btn", false);
                        this.application.lockElement("btn5", false);
                        this.application.lockElement("btnSoutFinish", false);
                        this.application.lockElement("intSelfEva", true);
                        this.application.lockElement("remarkFinishedCount", true);
                    }
                    if (state.getValue() == 54 && curPerson.equals((Object)burdenPerson)) {
                        this.application.hideElement("intSelfEva", false);
                        this.application.hideElement("remarkFinishedCount", false);
                        if (burdenPerson.equals((Object)trackPerson)) {
                            this.application.hideElement("remarkTrack", false);
                        }
                        this.application.lockElement("btnSubmitScore", false);
                        this.application.lockElement("btnSubmitScore1", false);
                    }
                    if (state.getValue() == 54 && curPerson.equals((Object)trackPerson)) {
                        this.application.hideElement("remarkTrack", false);
                        if (burdenPerson.equals((Object)trackPerson)) {
                            this.application.hideElement("intSelfEva", false);
                            this.application.hideElement("remarkFinishedCount", false);
                        }
                    }
                }
                if (state != null && state.getValue() == 60) {
                    inOrNot = new InOrNotMulbasedata();
                    boolean bool = false;
                    if (jpInfo.getExaminePerson() != null) {
                        bool = InOrNotMulbasedata.isINMulbasedata(curPerson, jpInfo.getExaminePerson());
                    }
                    str12 = new String[]{"txt", "basedata", "basedata1", "basedata2", "list", "date", "date1", "mulbasedata", "basedata3", "listState", "mulbasedataCheckPer", "FBiztype"};
                    this.lockElement(str12);
                    str22 = new String[]{"txtType", "remarkGoal", "remarkKeyTarget", "remarkFinishDate", "remarkEstimateCriterion", "remarkEstimateSource", "intProportion", "remarkFinishedCount"};
                    this.lockElement(str22);
                    str32 = new String[]{"btn", "btnSubmit", "btn3", "btn4", "btnUp", "btnDown", "btn10", "btn5", "btn6", "btnMod", "btnCancel", "btnDisuse", "btnMod1", "btnCancel1", "btnDisuse1", "btnSubmitScore", "btnSubmitScore1", "btn8", "btn9", "btnExecuteFinish", "btnSoutFinish"};
                    this.lockElement(str32);
                    this.application.hideElement("printMeetingDecide", false);
                    this.application.hideElement("printDictateOrder", false);
                    if (curPerson.equals((Object)trackPerson) || bool) {
                        this.application.lockElement("remarkTrack", true);
                        if (curPerson.equals((Object)trackPerson)) {
                            str5 = new String[]{"intSelfEva", "intGradeFLead", "intGradeFLeadTwo", "intGradeFBosses"};
                            this.hideElement(str5);
                        }
                        if (bool) {
                            this.application.hideElement("printMeetingDecide", false);
                            this.application.hideElement("printDictateOrder", false);
                            str5 = new String[]{"intSelfEva", "intGradeFLead", "intGradeFLeadTwo", "intGradeFBosses"};
                            this.lockElement(str5);
                        }
                    }
                    if (curPerson.equals((Object)burdenPerson) || this.compareUser(curUser, creator)) {
                        str5 = new String[]{"intSelfEva", "remarkTrack", "intGradeFLead", "intGradeFLeadTwo", "intGradeFBosses"};
                        this.hideElement(str5);
                        if (curPerson.equals((Object)burdenPerson) && isFromWorkflow) {
                            this.application.lockElement("btnSubmitScore", false);
                            this.application.lockElement("btnSubmitScore1", false);
                            this.application.hideElement("remarkTrack", false);
                            this.application.hideElement("intSelfEva", false);
                            this.application.lockElement("remarkTrack", true);
                            this.application.lockElement("intSelfEva", true);
                            this.application.hideElement("intGradeFLead", false);
                            this.application.hideElement("intGradeFLeadTwo", false);
                            this.application.hideElement("intGradeFBosses", false);
                        }
                    }
                    if (!isViewFromList) {
                        this.application.lockElement("btnSubmitScore", false);
                        this.application.lockElement("btnSubmitScore1", false);
                        this.application.hideElement("remarkTrack", false);
                        this.application.hideElement("intSelfEva", false);
                        this.application.lockElement("remarkTrack", true);
                        this.application.lockElement("intSelfEva", true);
                        this.application.hideElement("intGradeFLead", false);
                        this.application.hideElement("intGradeFLeadTwo", false);
                        this.application.hideElement("intGradeFBosses", false);
                        this.application.lockElement("intGradeFLead", false);
                        this.application.lockElement("intGradeFLeadTwo", false);
                        this.application.lockElement("intGradeFBosses", false);
                    }
                }
                this.newRule(curPerson, curUser, creator, burdenPerson, trackPerson, examinePerson, state);
                if (workFlowState != null && (workFlowState.equals("direct") || workFlowState.equals("junior") || workFlowState.equals("senior"))) {
                    String[] str13 = new String[]{"txt", "basedata", "basedata1", "basedata2", "list", "date", "date1", "mulbasedata", "basedata3", "listState", "btnDisuse", "mulbasedataCheckPer", "FBiztype"};
                    this.lockElement(str13);
                    String[] str23 = new String[]{"txtType", "remarkGoal", "remarkKeyTarget", "remarkFinishDate", "remarkEstimateCriterion", "remarkEstimateSource", "intProportion", "remarkFinishedCount", "remarkTrack", "intSelfEva", "intGradeFLead", "intGradeFLeadTwo", "intGradeFBosses"};
                    this.lockElement(str23);
                    String[] hideStr = new String[]{"intGradeFLead", "intGradeFLeadTwo", "intGradeFBosses"};
                    this.hideElement(hideStr);
                    str3 = new String[]{"btn", "btnSubmit", "btn3", "btn4", "btnUp", "btnDown", "btn10", "btn5", "btn6", "btnMod", "btnCancel", "btnDisuse", "btnMod1", "btnCancel1", "btnDisuse1", "btnSubmitScore", "btnSubmitScore1", "btn8", "btn9", "btnExecuteFinish", "btnSoutFinish"};
                    this.lockElement(str3);
                    if (workFlowState.equals("direct")) {
                        this.application.lockElement("btn", false);
                        this.application.lockElement("btn5", false);
                        this.application.lockElement("btnSubmitScore", false);
                        this.application.lockElement("btnSubmitScore1", false);
                        this.application.hideElement("intGradeFLead", false);
                        this.application.lockElement("intGradeFLead", false);
                    }
                    if (workFlowState.equals("junior")) {
                        this.application.lockElement("btn", false);
                        this.application.lockElement("btn5", false);
                        this.application.lockElement("btnSubmitScore", false);
                        this.application.lockElement("btnSubmitScore1", false);
                        this.application.hideElement("intGradeFLead", false);
                        this.application.hideElement("intGradeFLeadTwo", false);
                        this.application.lockElement("intGradeFLeadTwo", false);
                    }
                    if (workFlowState.equals("senior")) {
                        this.application.lockElement("btn", false);
                        this.application.lockElement("btn5", false);
                        this.application.lockElement("btnSubmitScore", false);
                        this.application.lockElement("btnSubmitScore1", false);
                        this.application.hideElement("intGradeFLead", false);
                        this.application.hideElement("intGradeFLeadTwo", false);
                        this.application.hideElement("intGradeFBosses", false);
                        this.application.lockElement("intGradeFBosses", false);
                        this.application.lockElement("FRemarkAudit", false);
                    }
                }
            }
            if (isFromWorkflow && state.getValue() == 20) {
                str = new String[]{"txtType", "remarkGoal", "remarkKeyTarget", "remarkFinishDate", "remarkEstimateCriterion", "remarkEstimateSource", "intProportion"};
                this.unLockElement(str);
            }
        }
    }

    private void initLockState() {
        this.application.lockElement("FRemarkAudit", true);
    }

    private void newRule(PersonInfo curPerson, UserInfo userInfo, UserInfo creator, PersonInfo burdenPerson, PersonInfo trackPerson, String examinePerson, WorkPlanStateEnum state) {
        if ((state.getValue() == 50 || state.getValue() == 52 || state.getValue() == 54 || state.getValue() == 60) && curPerson.equals((Object)trackPerson)) {
            this.application.hideElement("remarkTrack", false);
            this.application.hideElement("remarkFinishedCount", false);
        }
        if ((state.getValue() == 50 || state.getValue() == 52 || state.getValue() == 54 || state.getValue() == 60) && (this.compareUser(userInfo, creator) || curPerson.equals((Object)burdenPerson))) {
            this.application.hideElement("remarkFinishedCount", false);
            this.application.hideElement("intSelfEva", false);
            this.application.hideElement("intGradeFLead", false);
            this.application.hideElement("intGradeFLeadTwo", false);
            this.application.hideElement("intGradeFBosses", false);
        }
        if ((state.getValue() == 50 || state.getValue() == 52 || state.getValue() == 54 || state.getValue() == 60) && examinePerson != null && examinePerson.indexOf(curPerson.getName()) != -1) {
            this.application.hideElement("remarkTrack", false);
            this.application.hideElement("remarkFinishedCount", false);
            this.application.hideElement("intSelfEva", false);
            this.application.hideElement("intGradeFLead", false);
            this.application.hideElement("intGradeFLeadTwo", false);
            this.application.hideElement("intGradeFBosses", false);
        }
    }

    public void doCustomOperation(String operation) throws EASBizException, BOSException {
        super.doCustomOperation(operation);
        if (operation.equalsIgnoreCase("submitScore") || operation.equalsIgnoreCase("btnSubmitScore1")) {
            this.application.setValue("listState", (Object)new Integer(60), 0);
            this.application.save();
            this.application.showMessage("\u63d0\u4ea4\u8003\u8bc4\u6210\u529f");
            this.application.lockElement("btnSubmitScore", true);
            this.application.lockElement("btnSubmitScore1", true);
            this.application.lockElement("btn", true);
            this.application.lockElement("btn5", true);
        }
    }

    public void doSummaryByGrade() throws EASBizException, BOSException {
        double result = 0.0;
        JobPlanEntryCollection entryColl = (JobPlanEntryCollection)((Object)this.application.getBillModel().getBillValue().get("entrys"));
        int count = entryColl.size();
        for (int i = 0; i < count; ++i) {
            JobPlanEntryInfo entryInfo = entryColl.get(i);
            int weight = entryInfo.getProportion3();
            int selfGrade = entryInfo.getGradeFSelf();
            int ceoGrade = entryInfo.getGradeFBosses();
            int leaderGrade = entryInfo.getGradeFLead();
            int indirectLeaderGrade = entryInfo.getGradeFLeadTwo();
            result += (double)((selfGrade + ceoGrade + leaderGrade + indirectLeaderGrade) * weight / 100);
        }
        this.application.setValue("FjobPlanGradeSum", (Object)new Double(result), 0);
    }

    public void lockElement(String[] arg) {
        for (int i = 0; i < arg.length; ++i) {
            String str = arg[i];
            this.application.lockElement(str, true);
        }
    }

    public void unLockElement(String[] arg) {
        for (int i = 0; i < arg.length; ++i) {
            String str = arg[i];
            this.application.lockElement(str, false);
        }
    }

    public void hideElement(String[] arg) {
        for (int i = 0; i < arg.length; ++i) {
            String str = arg[i];
            this.application.hideElement(str, true);
        }
    }

    public boolean compareUser(UserInfo curUser, UserInfo creator) {
        boolean flag = false;
        if (curUser != null && creator != null && curUser.getId().equals((Object)creator.getId())) {
            flag = true;
        }
        return flag;
    }

    public boolean isOrNotInt(String str) {
        boolean bool = true;
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            bool = false;
        }
        return bool;
    }

    public void fireButtonClick(CommandArg commandArg) throws EASBizException, BOSException {
        JobPlanEntryInfo jpInfoEntry;
        String key = commandArg.getKey();
        JobPlanInfo jpInfo = (JobPlanInfo)this.application.getBillModel().getBillValue();
        JobPlanEntryCollection jpEntryColl = (JobPlanEntryCollection)((Object)this.application.getBillModel().getBillValue().get("entrys"));
        String operationStatus = this.application.getBillView().getOperationStatus().getStatus();
        PersonInfo curPerson = (PersonInfo)this.application.getBillModel().getDefaultValueCalculator().evaluateFunction("getUser(@CONTEXT,Person)");
        UserInfo createPerson = jpInfo.getCreator();
        PersonInfo burdenPerson = jpInfo.getBurdenPerson();
        PersonInfo trackPerson = jpInfo.getTrackPerson();
        WorkPlanStateEnum state = jpInfo.getState();
        boolean isFromWorkflow = this.application.getBillView().getWfState().isFromWorkflow();
        if ((key.equalsIgnoreCase("btn") || key.equalsIgnoreCase("btn5")) && operationStatus.equals("ADDNEW")) {
            this.application.setValue("listState", (Object)new Integer(10), 0);
        }
        if (key.equalsIgnoreCase("btnSubmitScore") || key.equalsIgnoreCase("btnSubmitScore1")) {
            // empty if block
        }
        if (key.equalsIgnoreCase("FbtnExportEntry") || key.equalsIgnoreCase("FbtnExportEntry1")) {
            JSONObject urlParam = new JSONObject();
            JSONObject winParam = new JSONObject();
            try {
                String pageId = ((WebBillEditPanel)this.application.getBillView()).getPageId();
                urlParam.put("pageid", (Object)pageId);
                urlParam.put("type", (Object)"exportEntry");
                winParam.put("name", (Object)"ExportData");
                winParam.put("title", (Object)"\u5bfc\u51fa\u6570\u636e");
                winParam.put("x", 800);
                winParam.put("y", 600);
            }
            catch (JSONException pageId) {
                // empty catch block
            }
            String url = "/easweb/cp/wp/exportExcel.jsf";
            FormActionUtil.invokeShowPopupAction((IFormApplication)this.application, (String)urlParam.toString(), (String)winParam.toString(), (String)url, (OpenModeEnum)OpenModeEnum.OpenNewWindow);
        }
        if ((key.equalsIgnoreCase("btnDisuse") || key.equalsIgnoreCase("btnDisuse1")) && state != null && state.getValue() == 30) {
            this.application.setValue("listState", (Object)new Integer(100), 0);
            this.application.save();
            this.application.showMessage("\u5e9f\u5f03\u64cd\u4f5c\u6210\u529f");
        }
        if (state != null && state.getValue() == 50) {
            if (curPerson.getName().equals(createPerson.getName()) && (key.equalsIgnoreCase("btnCancel") || key.equalsIgnoreCase("btnCancel1"))) {
                this.application.setValue("listState", (Object)new Integer(40), 0);
                this.application.save();
                this.application.showMessage("\u53d6\u6d88\u64cd\u4f5c\u6210\u529f");
            }
            if ((curPerson.getName().equals(createPerson.getName()) || curPerson.getName().equals(burdenPerson.getName())) && (key.equalsIgnoreCase("btnMod") || key.equalsIgnoreCase("btnMod1"))) {
                this.application.setValue("listState", (Object)new Integer(100), 0);
                this.application.save();
                String modSourceBillId = this.application.getDynamicFormModel().getPKValue();
                this.application.copyData();
                this.application.setValue("listState", (Object)new Integer(10), 0);
                JobPlanInfo planInfo = (JobPlanInfo)this.application.getBillModel().getBillValue();
                planInfo.setModSourceBillId(modSourceBillId);
                this.application.showMessage("\u5de5\u4f5c\u8ba1\u5212\u8c03\u6574\u521b\u5efa\u65b0\u7248\u672c\uff01");
            }
            if (curPerson.equals((Object)trackPerson) && (key.equalsIgnoreCase("btn") || key.equalsIgnoreCase("btn6"))) {
                this.application.save();
                this.application.showMessage("\u4fdd\u5b58\u64cd\u4f5c\u6210\u529f");
            }
            if (key.equalsIgnoreCase("btnExecuteFinish")) {
                boolean bool = true;
                for (int i = 0; i < jpEntryColl.size(); ++i) {
                    jpInfoEntry = jpEntryColl.get(i);
                    if (jpInfoEntry.getCompleteCircs() == null || jpInfoEntry.getCompleteCircs().length() <= 500) continue;
                    bool = false;
                    throw new BOSException("\u5b8c\u6210\u60c5\u51b5\u53ca\u52a0\u51cf\u5206\u539f\u56e0 \u7684\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e500\uff01");
                }
                if (bool) {
                    this.application.setValue("listState", (Object)new Integer(52), 0);
                    this.application.save();
                    this.application.showMessage("\u6267\u884c\u5b8c\u6210");
                }
            }
        }
        if (key.equalsIgnoreCase("btnSoutFinish") && state != null && state.getValue() == 52) {
            boolean bool = true;
            for (int i = 0; i < jpEntryColl.size(); ++i) {
                jpInfoEntry = jpEntryColl.get(i);
                if (jpInfoEntry.getExamineCircs() == null || jpInfoEntry.getExamineCircs().length() <= 500) continue;
                bool = false;
                throw new BOSException("\u8ddf\u8e2a\u4eba\u68c0\u67e5\u60c5\u51b5 \u7684\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e500\uff01");
            }
            if (bool) {
                this.application.setValue("listState", (Object)new Integer(54), 0);
                this.application.save();
                this.application.showMessage("\u5b8c\u6210\u8ddf\u8e2a");
            }
        }
        super.fireButtonClick(commandArg);
    }

    public boolean beforeOperation(FormOperation operation) throws EASBizException, BOSException {
        int i;
        boolean flag = true;
        JobPlanInfo jpInfo = (JobPlanInfo)this.application.getBillModel().getBillValue();
        JobPlanEntryCollection jpEntryColl = (JobPlanEntryCollection)((Object)this.application.getBillModel().getBillValue().get("entrys"));
        int scole = 0;
        for (i = 0; i < jpEntryColl.size(); ++i) {
            JobPlanEntryInfo jpEntryInfo = jpEntryColl.get(i);
            if (jpEntryInfo == null) continue;
            scole += jpEntryInfo.getProportion3();
        }
        if ("Submit".equalsIgnoreCase(operation.getOperation()) || "Save".equalsIgnoreCase(operation.getOperation())) {
            if (flag && jpInfo.getTitle() != null && jpInfo.getTitle().length() > 100) {
                this.application.showMessage("\u6807\u9898   \u7684\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e100\uff01");
                flag = false;
            }
            for (i = 0; flag && i < jpEntryColl.size(); ++i) {
                JobPlanEntryInfo jpInfoEntry = jpEntryColl.get(i);
                if (jpInfoEntry.getSort() != null && jpInfoEntry.getSort().length() > 100) {
                    this.application.showMessage("\u7c7b\u522b   \u7684\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e100\uff01");
                    flag = false;
                }
                if (jpInfoEntry.getTarget() != null && jpInfoEntry.getTarget().length() > 500) {
                    this.application.showMessage("\u76ee\u6807\u4efb\u52a1   \u7684\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e500\uff01");
                    flag = false;
                }
                if (jpInfoEntry.getKeyTarget() != null && jpInfoEntry.getKeyTarget().length() > 500) {
                    this.application.showMessage("\u5173\u952e\u6307\u6807   \u7684\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e500\uff01");
                    flag = false;
                }
                if (jpInfoEntry.getCompleteTime() != null && jpInfoEntry.getCompleteTime().length() > 100) {
                    this.application.showMessage("\u5b8c\u6210\u671f\u9650   \u7684\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e100\uff01");
                    flag = false;
                }
                if (jpInfoEntry.getEvalStandard() != null && jpInfoEntry.getEvalStandard().length() > 500) {
                    this.application.showMessage("\u8bc4\u4f30\u6807\u51c6   \u7684\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e500\uff01");
                    flag = false;
                }
                if (jpInfoEntry.getEvalSource() != null && jpInfoEntry.getEvalSource().length() > 100) {
                    this.application.showMessage("\u8bc4\u4f30\u6765\u6e90   \u7684\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e100\uff01");
                    flag = false;
                }
                if (jpInfoEntry.getExamineCircs() != null && jpInfoEntry.getExamineCircs().length() > 500) {
                    this.application.showMessage("\u8ddf\u8e2a\u4eba\u68c0\u67e5\u60c5\u51b5  \u7684\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e500\uff01");
                    flag = false;
                }
                if (jpInfoEntry.getCompleteCircs() != null && jpInfoEntry.getCompleteCircs().length() > 500) {
                    this.application.showMessage("\u5b8c\u6210\u60c5\u51b5\u548c\u52a0\u51cf\u5206\u539f\u56e0  \u7684\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e500\uff01");
                    flag = false;
                }
                if (!"Submit".equalsIgnoreCase(operation.getOperation()) || jpInfoEntry.getProportion3() != 0) continue;
                this.application.showMessage("\u5206\u5f55\u4e2d\u7684\u6743\u91cd\u4e0d\u80fd\u4e3a0\uff01");
                flag = false;
            }
            if (flag && scole > 100) {
                this.application.showMessage("\u6240\u5360\u6743\u91cd\u4e4b\u548c\u5fc5\u987b\u7b49\u4e8e100");
                flag = false;
            }
            if (flag && scole < 100 && "Submit".equalsIgnoreCase(operation.getOperation())) {
                this.application.showMessage("\u6240\u5360\u6743\u91cd\u4e4b\u548c\u5fc5\u987b\u7b49\u4e8e100");
                flag = false;
            }
        }
        Date date = (Date)this.application.getBillModel().getValue("date", 0);
        Date date1 = (Date)this.application.getBillModel().getValue("date1", 0);
        if (flag && (date == null || date1 == null)) {
            this.application.showMessage("\u8bf7\u9009\u62e9\u5f00\u59cb\u65e5\u671f\u3001\u7ed3\u675f\u65e5\u671f");
            flag = false;
        }
        if (flag && date != null && date1 != null && date.after(date1)) {
            this.application.showMessage("\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u5f00\u59cb\u65e5\u671f");
            flag = false;
        }
        return flag;
    }

    public void dataChanged(DataChangeCommandArg dataChangeCommandArg) {
        if (dataChangeCommandArg != null && dataChangeCommandArg.getKey().indexOf("basedata2") >= 0) {
            AdminOrgUnitInfo orgUnitInfo = (AdminOrgUnitInfo)dataChangeCommandArg.getNewValue();
            try {
                Context ctx = this.application.getContext();
                INewOrgUnitFacade iOrg = NewOrgUnitFacadeFactory.getLocalInstance((Context)ctx);
                CompanyOrgUnitInfo companyOrgUnitInfo = null;
                companyOrgUnitInfo = (CompanyOrgUnitInfo)iOrg.getDelegateUnit(orgUnitInfo.getId().toString(), OrgType.Company);
                this.application.setValue("FBurdenCompany", (Object)companyOrgUnitInfo, 0);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
        super.dataChanged(dataChangeCommandArg);
    }

    public void afterOperation(FormOperation operation) throws EASBizException, BOSException {
        super.afterOperation(operation);
        if ("Copy".equalsIgnoreCase(operation.getOperation())) {
            Context ctx = this.application.getContext();
            JobPlanBizTypeInfo jobPlanBizType = (JobPlanBizTypeInfo)this.application.getBillModel().getBillValue().get("jobPlanBizType");
            if (jobPlanBizType != null && (jobPlanBizType = JobPlanBizTypeFactory.getLocalInstance(ctx).getJobPlanBizTypeInfo((IObjectPK)new ObjectUuidPK(jobPlanBizType.getId().toString()))).getBizState() != null && "ENABLEITEM" != jobPlanBizType.getBizState().getValue()) {
                this.application.setValue("FBiztype", null, 0);
            }
        }
    }

    public String getCustomWorkFlowID() throws EASBizException, BOSException {
        JobPlanInfo jpInfo = (JobPlanInfo)this.application.getBillModel().getBillValue();
        WorkPlanStateEnum state = jpInfo.getState();
        IWpWorkFlowSetting iworkFlowSetting = WpWorkFlowSettingFactory.getLocalInstance(this.application.getContext());
        String oql = "where bizBillType = '2'";
        if (state == null || state.equals((Object)WorkPlanStateEnum.draft) || state.equals((Object)WorkPlanStateEnum.stay)) {
            oql = oql + " and flowType = '1'";
        } else if (state.equals((Object)WorkPlanStateEnum.excess)) {
            oql = oql + " and flowType = '2'";
        } else {
            return null;
        }
        try {
            WpWorkFlowSettingInfo wfInfo = iworkFlowSetting.getWpWorkFlowSettingInfo(oql);
            if (wfInfo == null) {
                return null;
            }
            return wfInfo.getFlowId();
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
    }
}

