/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.wp.plugins;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.form.model.command.BeforeCommandArg;
import com.kingdee.eas.base.form.model.command.BeforeDeleteArg;
import com.kingdee.eas.base.form.model.command.BeforeQueryArg;
import com.kingdee.eas.base.form.model.command.CommandArg;
import com.kingdee.eas.base.form.model.list.IListView;
import com.kingdee.eas.base.form.model.list.ListApplication;
import com.kingdee.eas.base.form.model.list.ListPlugin;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.wp.LiabilityBookFactory;
import com.kingdee.eas.cp.wp.LiabilityBookInfo;
import com.kingdee.eas.cp.wp.PeriodEnum;
import com.kingdee.eas.cp.wp.PeriodSetCollection;
import com.kingdee.eas.cp.wp.PeriodSetFactory;
import com.kingdee.eas.cp.wp.PeriodSetInfo;
import com.kingdee.eas.cp.wp.plugins.WPHelpUitl;
import java.util.ArrayList;
import java.util.List;

public class LiabilityBookListPlugin
extends ListPlugin {
    public static final int DRAFT_VALUE = 10;
    public static final int INAUDIT_VALUE = 20;
    public static final int UNPASSAUDIT_VALUE = 30;
    public static final int PASSAUDIT_VALUE = 40;
    public static final int REPORTED_VALUE = 50;
    public static final int ABANDON_VALUE = 70;
    public static final int FINISHED_VALUE = 60;

    public void onLoad() {
        super.onLoad();
        IListView view = this.application.getListView();
        String src = view.getOpenSource();
        ArrayList<String> menu = new ArrayList<String>();
        menu.add("mnuEditCheck");
        try {
            view.hideBarItem(menu);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        Context ctx = this.application.getContext();
        try {
            PeriodSetCollection psColl = PeriodSetFactory.getLocalInstance(ctx).getPeriodSetCollection();
            PeriodSetInfo psInfo = psColl.get(0);
            ArrayList<PeriodEnum> enums = new ArrayList<PeriodEnum>();
            if (psInfo != null) {
                enums.add(PeriodEnum.getEnum(365));
                enums.add(PeriodEnum.getEnum(178));
                enums.add(PeriodEnum.getEnum(89));
                enums.add(PeriodEnum.getEnum(30));
            }
            this.application.setEnumContents("listPeriod", enums);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public void onBeforeDelete(BeforeDeleteArg arg) {
        super.onBeforeDelete(arg);
        try {
            UserInfo curUser = (UserInfo)this.application.getListModel().getDefaultValueCalculator().evaluateFunction("getUser(@CONTEXT)");
            List idList = arg.getIdList();
            Context ctx = this.application.getContext();
            boolean flag = false;
            for (int i = 0; i < idList.size(); ++i) {
                try {
                    String id = (String)idList.get(i);
                    LiabilityBookInfo liabilityInfo = LiabilityBookFactory.getLocalInstance(ctx).getLiabilityBookInfo((IObjectPK)new ObjectUuidPK(id));
                    UserInfo creatorUser = liabilityInfo.getCreator();
                    if (liabilityInfo.getDocState() == null || WPHelpUitl.compareUser(curUser, creatorUser) && (liabilityInfo.getDocState().getValue() == 10 || liabilityInfo.getDocState().getValue() == 70)) continue;
                    flag = true;
                    break;
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
            if (flag) {
                idList.removeAll(idList);
                this.application.showMessage("\u5305\u542b\u4e0d\u80fd\u5220\u9664\u7684\u76ee\u6807\u8d23\u4efb\u4e66 \uff01");
            }
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
    }

    public void activate() {
        super.activate();
    }

    public void afterBarItemClick(CommandArg commandArg) throws EASBizException, BOSException {
        super.afterBarItemClick(commandArg);
    }

    public void attachApplication(ListApplication application) {
        super.attachApplication(application);
    }

    public void beforeBarItemClick(BeforeCommandArg beforeCommandArg) throws EASBizException, BOSException {
        super.beforeBarItemClick(beforeCommandArg);
    }

    public void fireButtonClick(CommandArg commandArg) throws EASBizException, BOSException {
        super.fireButtonClick(commandArg);
    }

    public void refresh() {
        super.refresh();
    }

    public void onBeforeQuery(BeforeQueryArg arg) {
        super.onBeforeQuery(arg);
        FilterInfo filter = arg.getFilterInfo();
        String createTime = this.application.getFieldName("date", false);
        arg.setOrderBy(createTime + " desc");
        try {
            PersonInfo person = (PersonInfo)this.application.getListModel().getDefaultValueCalculator().evaluateFunction("getUser(@CONTEXT,Person)");
            UserInfo curUser = (UserInfo)this.application.getListModel().getDefaultValueCalculator().evaluateFunction("getUser(@CONTEXT)");
            if (curUser != null) {
                filter.getFilterItems().add(new FilterItemInfo("creator.id", curUser.get("id")));
                if (person != null) {
                    filter.getFilterItems().add(new FilterItemInfo("liabilityPerson.id", person.get("id")));
                    filter.getFilterItems().add(new FilterItemInfo("creatorPerson", person.get("id")));
                    filter.getFilterItems().add(new FilterItemInfo("docState", (Object)Integer.valueOf(String.valueOf(10)), CompareType.NOTEQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("docState", (Object)Integer.valueOf(String.valueOf(20)), CompareType.NOTEQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("docState", (Object)Integer.valueOf(String.valueOf(30)), CompareType.NOTEQUALS));
                    filter.setMaskString("#0 or (#1 or #2) and (#3 and #4 and #5)");
                } else {
                    filter.setMaskString("#0");
                }
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }
}

