/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeBorders;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.tools.datatask.AccountingDataInterfaceFacadeFactory;
import com.kingdee.eas.tools.datatask.AccoutDataException;
import com.kingdee.eas.tools.datatask.IAccountingDataInterfaceFacade;
import com.kingdee.eas.tools.datatask.client.AbstractAccountExportDataUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class AccountExportDataUI
extends AbstractAccountExportDataUI {
    private static final Logger logger = CoreUIObject.getLogger(AccountExportDataUI.class);
    private final String PERMISSION_ITEM = "bd_account_accountView_view";
    private boolean noStopRequested;
    private Thread progressThread = null;

    @Override
    protected void prmtAccountPeriodType_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtAccountPeriodType.getData() == null || this.prmtAccountPeriodType.getData().toString().trim().length() <= 0) {
            this.spinPeriodYear.setEnabled(false);
            this.spinPeriodNumber.setEnabled(false);
            this.contCompanyF7.setEnabled(false);
            return;
        }
        this.prmtCompany.setData(null);
        PeriodTypeInfo periodTypeInfo = (PeriodTypeInfo)this.prmtAccountPeriodType.getData();
        String id = periodTypeInfo.getId().toString();
        PeriodCollection periodCol = PeriodFactory.getRemoteInstance().getPeriodCollection("select * where periodType.id = '" + id + "' order by periodYear,periodNumber");
        int minYear = periodCol.get(0).getPeriodYear();
        int maxYear = periodCol.get(periodCol.size() - 1).getPeriodYear();
        Iterator iterator = periodCol.iterator();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int curyear = 0;
        while (iterator.hasNext()) {
            PeriodInfo periodinfo = (PeriodInfo)iterator.next();
            if (curyear != periodinfo.getPeriodYear()) {
                curyear = periodinfo.getPeriodYear();
                map.put(curyear + "min", new Integer(periodinfo.getPeriodNumber()));
            }
            map.put(curyear + "max", new Integer(periodinfo.getPeriodNumber()));
        }
        this.spinPeriodYear.setModel((SpinnerModel)new SpinnerNumberModel(minYear, minYear, maxYear, 1));
        this.spinPeriodToYear.setModel((SpinnerModel)new SpinnerNumberModel(minYear, minYear, maxYear, 1));
        this.changePeriodNumberByYear(Integer.parseInt(this.spinPeriodYear.getValue().toString()));
        this.changePeriodNumberByToYear(Integer.parseInt(this.spinPeriodToYear.getValue().toString()));
        this.contCompanyF7.setEnabled(true);
        this.spinPeriodYear.setEnabled(true);
        this.spinPeriodNumber.setEnabled(true);
        this.spinPeriodToNumber.setEnabled(true);
        this.filterCompanyOrgUnitInfoByAccountPeriodType((PeriodTypeInfo)this.prmtAccountPeriodType.getData(), this.prmtCompany);
    }

    private void filterCompanyOrgUnitInfoByAccountPeriodType(PeriodTypeInfo periodTypeInfo, KDBizPromptBox company) {
        NewCompanyF7 companyF7 = new NewCompanyF7();
        OrgUnitInfo orgInfo = SysContext.getSysContext().getCurrentOrgUnit();
        companyF7.setRootUnitID(orgInfo.getId().toString());
        String cuID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        companyF7.setCurrentCUID(cuID);
        companyF7.setMultiSelect(true);
        companyF7.setShowAssistantOrg(true);
        companyF7.setPermissionItem("bd_account_accountView_view");
        FilterInfo filterAccount = new FilterInfo();
        filterAccount.getFilterItems().add(new FilterItemInfo("unit.partFI.accountPeriodType.id", (Object)periodTypeInfo.getId().toString(), CompareType.EQUALS));
        companyF7.setOuterFilterInfo(filterAccount);
        this.prmtCompany.setSelector((KDPromptSelector)companyF7);
        this.prmtCompany.setEditFormat("$number$");
        this.prmtCompany.setDisplayFormat("$name$");
        this.prmtCompany.setCommitFormat("$number$");
    }

    @Override
    protected void spinPeriodYear_stateChanged(ChangeEvent e) throws Exception {
        int year = (Integer)this.spinPeriodYear.getValue();
        this.changePeriodNumberByYear(year);
        this.spinPeriodToYear.setValue((Object)year);
    }

    public void changePeriodNumberByYear(int year) throws Exception {
        PeriodTypeInfo periodTypeInfo = (PeriodTypeInfo)this.prmtAccountPeriodType.getData();
        String id = periodTypeInfo.getId().toString();
        PeriodCollection periodCol = PeriodFactory.getRemoteInstance().getPeriodCollection("select * where periodType.id = '" + id + "' and periodYear='" + year + "' order by periodYear,periodNumber");
        int minPeriod = periodCol.get(0).getPeriodNumber();
        int maxPeriod = periodCol.get(periodCol.size() - 1).getPeriodNumber();
        this.spinPeriodNumber.setModel((SpinnerModel)new SpinnerNumberModel(minPeriod, minPeriod, maxPeriod, 1));
    }

    public void changePeriodNumberByToYear(int year) throws Exception {
        PeriodTypeInfo periodTypeInfo = (PeriodTypeInfo)this.prmtAccountPeriodType.getData();
        String id = periodTypeInfo.getId().toString();
        PeriodCollection periodCol = PeriodFactory.getRemoteInstance().getPeriodCollection("select * where periodType.id = '" + id + "' and periodYear='" + year + "' order by periodYear,periodNumber");
        int minPeriod = periodCol.get(0).getPeriodNumber();
        int maxPeriod = periodCol.get(periodCol.size() - 1).getPeriodNumber();
        this.spinPeriodToNumber.setModel((SpinnerModel)new SpinnerNumberModel(minPeriod, minPeriod, maxPeriod, 1));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.txtFilePath.setEnabled(true);
        this.wbOpenFile.setEnabled(true);
        this.btExport.setEnabled(true);
        this.btCancel.setEnabled(true);
        this.spinPeriodYear.setEnabled(false);
        this.spinPeriodNumber.setEnabled(false);
        this.contCompanyF7.setEnabled(false);
        this.lblExportWait.setVisible(false);
        this.barExportData.setVisible(false);
        this.barExportData.setEnabled(false);
        this.spinPeriodToYear.setEnabled(false);
        this.spinPeriodToNumber.setEnabled(false);
    }

    @Override
    public void actionOpenFile_actionPerformed(ActionEvent e) throws Exception {
        try {
            String path = System.getProperty("user.home");
            KDFileChooser choose = new KDFileChooser(path);
            choose.setFileSelectionMode(1);
            int returnValue = choose.showSaveDialog((Component)((Object)this));
            if (returnValue == 0) {
                this.txtFilePath.setText(choose.getSelectedFile().getPath());
            }
        }
        catch (Exception err) {
            logger.error((Object)err.getStackTrace(), (Throwable)err);
            MsgBox.showError((String)err.getMessage());
        }
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws AccoutDataException {
        this.noStopRequested = true;
        int year = Integer.parseInt(this.spinPeriodYear.getValue().toString());
        int period = Integer.parseInt(this.spinPeriodNumber.getValue().toString());
        int toYear = Integer.parseInt(this.spinPeriodToYear.getValue().toString());
        int toPeriod = Integer.parseInt(this.spinPeriodToNumber.getValue().toString());
        if (year > toYear || toYear == year && period > toPeriod) {
            throw new AccoutDataException(AccoutDataException.EXCEPTION4);
        }
        if (this.prmtAccountPeriodType.getValue() == null) {
            String msg = EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"AccountPeriodTypeNotNull");
            MsgBox.showInfo((Component)((Object)this), (String)msg);
            this.prmtAccountPeriodType.requestFocus();
            return;
        }
        if (this.prmtCompany.getData() == null) {
            String msg = EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"CompanyNotNull");
            MsgBox.showInfo((Component)((Object)this), (String)msg);
            this.prmtCompany.requestFocus();
            return;
        }
        if (this.txtFilePath.getText() == null || this.txtFilePath.getText().trim().length() <= 0) {
            String msg = EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"FilePathNotNull");
            MsgBox.showInfo((Component)((Object)this), (String)msg);
            this.txtFilePath.requestFocus();
            return;
        }
        this.barExportData.setBorder(KingdeeBorders.createBevelBorder((boolean)true, (Color)new Color(4, 67, 123), (Color)new Color(4, 67, 123)));
        this.barExportData.setSize(300, 18);
        this.onPreparedToRun();
        Thread taskThread = new Thread(){

            @Override
            public void run() {
                try {
                    AccountExportDataUI.this.exportData();
                    AccountExportDataUI.this.onFinishedRunning();
                }
                catch (Exception ex) {
                    logger.error((Object)ex.getStackTrace(), (Throwable)ex);
                    MsgBox.showInfo((String)ex.getMessage());
                    return;
                }
                finally {
                    AccountExportDataUI.this.stopProgressRequest();
                }
            }
        };
        taskThread.start();
    }

    public void stopProgressRequest() {
        this.noStopRequested = false;
        this.progressThread.interrupt();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void exportData() throws EASBizException, BOSException {
        OrgUnitInfo[] orgs = (OrgUnitInfo[])this.prmtCompany.getData();
        List<OrgUnitInfo> companyList = Arrays.asList(orgs);
        String path = this.txtFilePath.getText();
        int year = Integer.parseInt(this.spinPeriodYear.getValue().toString());
        int period = Integer.parseInt(this.spinPeriodNumber.getValue().toString());
        int toYear = Integer.parseInt(this.spinPeriodToYear.getValue().toString());
        int toPeriod = Integer.parseInt(this.spinPeriodToNumber.getValue().toString());
        PeriodTypeInfo periodTypeInfo = (PeriodTypeInfo)this.prmtAccountPeriodType.getData();
        ObjectUuidPK typeInfopk = new ObjectUuidPK(periodTypeInfo.getId());
        IAccountingDataInterfaceFacade accountingDataFacade = AccountingDataInterfaceFacadeFactory.getRemoteInstance();
        Map result = AccountingDataInterfaceFacadeFactory.getRemoteInstance().exportData(companyList, year, period, toYear, toPeriod, (IObjectPK)typeInfopk);
        Iterator resultKeyIterator = result.keySet().iterator();
        block8: while (resultKeyIterator.hasNext()) {
            Object key = resultKeyIterator.next();
            Object value = result.get(key);
            String fileName = (String)key;
            String fileId = (String)value;
            FileOutputStream os = null;
            boolean exceptionOccurred = true;
            try {
                File file = new File(this.txtFilePath.getText().trim(), fileName);
                os = new FileOutputStream(file);
                while (true) {
                    byte[] bytes;
                    if ((bytes = accountingDataFacade.readExportedFile(fileId)) == null) {
                        accountingDataFacade.closeExportedFile(fileId);
                        exceptionOccurred = false;
                        this.closeIfNotNull(os);
                        if (!exceptionOccurred) continue block8;
                        break;
                    }
                    ((OutputStream)os).write(bytes);
                }
            }
            catch (Throwable t) {
                try {
                    throw new RuntimeException(t);
                }
                catch (Throwable throwable) {
                    this.closeIfNotNull(os);
                    if (!exceptionOccurred) throw throwable;
                    try {
                        accountingDataFacade.closeExportedFile(fileId);
                        throw throwable;
                    }
                    catch (Exception e) {
                        logger.warn((Object)e.getMessage(), (Throwable)e);
                    }
                    throw throwable;
                }
            }
            try {
                accountingDataFacade.closeExportedFile(fileId);
            }
            catch (Exception e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void onPreparedToRun() {
        this.barExportData.setValue(0);
        this.barExportData.setVisible(true);
        this.lblExportWait.setVisible(true);
        this.increaseValue();
        this.disableButtons();
    }

    private void onFinishedRunning() {
        this.barExportData.setValue(100);
        this.barExportData.setVisible(false);
        this.lblExportWait.setVisible(false);
        this.enableButtons();
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"83_AccountExportDataUI"));
    }

    private void increaseValue() {
        Runnable increaseRun = new Runnable(){

            @Override
            public void run() {
                while (AccountExportDataUI.this.noStopRequested) {
                    try {
                        Thread.sleep(50L);
                        AccountExportDataUI.this.barExportData.setValue(AccountExportDataUI.this.barExportData.getValue() + 5);
                        if (AccountExportDataUI.this.barExportData.getValue() >= AccountExportDataUI.this.barExportData.getMaximum()) {
                            AccountExportDataUI.this.barExportData.setValue(AccountExportDataUI.this.barExportData.getMinimum());
                        }
                        AccountExportDataUI.this.repaint();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        };
        this.progressThread = new Thread(increaseRun);
        this.progressThread.start();
    }

    private void disableButtons() {
        this.btExport.setEnabled(false);
        this.btCancel.setEnabled(false);
        this.wbOpenFile.setEnabled(false);
        this.txtFilePath.setEnabled(false);
        this.contCompanyF7.setEnabled(false);
        this.spinPeriodYear.setEnabled(false);
        this.spinPeriodNumber.setEnabled(false);
        this.kDLabelContainer2.setEnabled(false);
    }

    private void enableButtons() {
        this.btExport.setEnabled(true);
        this.btCancel.setEnabled(true);
        this.wbOpenFile.setEnabled(true);
        this.txtFilePath.setEnabled(true);
        this.contCompanyF7.setEnabled(true);
        this.spinPeriodYear.setEnabled(true);
        this.spinPeriodNumber.setEnabled(true);
        this.kDLabelContainer2.setEnabled(true);
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().hide();
    }

    private void closeIfNotNull(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

