/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.client;

import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.wizard.IWizard;
import com.kingdee.eas.framework.client.wizard.IWizardPage;
import com.kingdee.eas.tools.datatask.DIETemplateFactory;
import com.kingdee.eas.tools.datatask.DIETemplateInfo;
import com.kingdee.eas.tools.datatask.IDIETemplate;
import com.kingdee.eas.tools.datatask.client.UserDefineTemplateBasicMessageUI;
import com.kingdee.eas.tools.datatask.client.UserDefineTemplateFieldUI;
import com.kingdee.eas.tools.datatask.client.UserDefineTemplateSltUI;
import com.kingdee.eas.tools.datatask.util.EASResourceJoinUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DIETemplateWizard
implements IWizard {
    private static final Logger logger = CoreUIObject.getLogger(DIETemplateWizard.class);
    private static final String RESOURCE = "com.kingdee.eas.tools.datatask.DatataskResource";
    private KDPanel container = null;
    private List pages = new ArrayList();

    public DIETemplateWizard(Map context) {
        try {
            this.addPage((IWizardPage)new UserDefineTemplateSltUI(context));
            this.addPage((IWizardPage)new UserDefineTemplateBasicMessageUI(context));
            this.addPage((IWizardPage)new UserDefineTemplateFieldUI());
        }
        catch (Exception e) {
            MsgBox.showInfo((String)EASResourceJoinUtil.getString(RESOURCE, "loaduierror", new Object[]{e.getMessage()}));
        }
    }

    public boolean performFinish() {
        UserDefineTemplateFieldUI ui = (UserDefineTemplateFieldUI)this.getPage(UserDefineTemplateFieldUI.class.getName());
        if (!ui.verifyInput()) {
            return false;
        }
        ui.storeFields();
        DIETemplateInfo dieInfo = ui.getEditData();
        IDIETemplate dt = null;
        try {
            dt = DIETemplateFactory.getRemoteInstance();
            if (dieInfo.getId() == null) {
                dt.addnew((CoreBaseInfo)dieInfo);
            } else {
                ObjectUuidPK pk = new ObjectUuidPK(dieInfo.getId());
                dt.update((IObjectPK)pk, (CoreBaseInfo)dieInfo);
            }
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"savesuccess"));
            return true;
        }
        catch (Exception e) {
            logger.error((Object)e);
            MsgBox.showInfo((String)e.getMessage());
            return false;
        }
    }

    public DIETemplateWizard() {
        this(null);
    }

    public void setContainer(KDPanel wizardContainer) {
        this.container = wizardContainer;
    }

    public void addPage(IWizardPage page) {
        this.pages.add(page);
        page.setWizard((IWizard)this);
    }

    public void addPages() {
    }

    public boolean canFinish() {
        for (int i = 0; i < this.pages.size(); ++i) {
            if (((IWizardPage)this.pages.get(i)).isPageComplete()) continue;
            return false;
        }
        return true;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        String name = page.getName();
        for (int i = 0; i < this.pages.size(); ++i) {
            IWizardPage tmppage = (IWizardPage)this.pages.get(i);
            String pageName = tmppage.getName();
            if (!pageName.equals(name) || i >= this.pages.size() - 1) continue;
            return (IWizardPage)this.pages.get(i + 1);
        }
        return null;
    }

    public IWizardPage getPage(String name) {
        for (int i = 0; i < this.pages.size(); ++i) {
            IWizardPage page = (IWizardPage)this.pages.get(i);
            String pageName = page.getName();
            if (!pageName.equals(name)) continue;
            return page;
        }
        return null;
    }

    public int getPageCount() {
        return this.pages.size();
    }

    public IWizardPage[] getPages() {
        return this.pages.toArray(new IWizardPage[this.pages.size()]);
    }

    public int indexOfPage(IWizardPage page) {
        return this.pages.indexOf(page);
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        String name = page.getName();
        for (int i = 0; i < this.pages.size(); ++i) {
            IWizardPage tmppage = (IWizardPage)this.pages.get(i);
            String pageName = tmppage.getName();
            if (!pageName.equals(name) || i <= 0) continue;
            return (IWizardPage)this.pages.get(i - 1);
        }
        return null;
    }

    public IWizardPage getStartingPage() {
        if (this.pages.size() == 0) {
            return null;
        }
        return (IWizardPage)this.pages.get(0);
    }

    public boolean performCancel() {
        return true;
    }

    public KDPanel getContainer() {
        return this.container;
    }
}

