/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.base.permission.IPermItem;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.tools.datatask.DIETemplateCollection;
import com.kingdee.eas.tools.datatask.DIETemplateFactory;
import com.kingdee.eas.tools.datatask.DIETemplateInfo;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.DatataskRunServerFactory;
import com.kingdee.eas.tools.datatask.ErrorHandleModeEnum;
import com.kingdee.eas.tools.datatask.ExtendsDataskParameter;
import com.kingdee.eas.tools.datatask.IDIETemplate;
import com.kingdee.eas.tools.datatask.IDatataskRunServer;
import com.kingdee.eas.tools.datatask.ReturnInfo;
import com.kingdee.eas.tools.datatask.TaskStateEnum;
import com.kingdee.eas.tools.datatask.TemplateFolderFactory;
import com.kingdee.eas.tools.datatask.TemplateFolderInfo;
import com.kingdee.eas.tools.datatask.client.AbstractDioMainUI;
import com.kingdee.eas.tools.datatask.client.CommonQueryPromptBox;
import com.kingdee.eas.tools.datatask.client.DiscardUtil;
import com.kingdee.eas.tools.datatask.client.FileChooserPromptBox;
import com.kingdee.eas.tools.datatask.client.ILogUI;
import com.kingdee.eas.tools.datatask.client.PermCheckUtil;
import com.kingdee.eas.tools.datatask.client.TranslateUI;
import com.kingdee.eas.tools.datatask.client.UIUtil;
import com.kingdee.eas.tools.datatask.client.webservice.EASLogin.EASLoginProxyServiceLocator;
import com.kingdee.eas.tools.datatask.client.webservice.WSExternalDataExchangeFacade.WSExternalDataExchangeFacadeSrvProxyServiceLocator;
import com.kingdee.eas.tools.datatask.log.TaskLog;
import com.kingdee.eas.tools.datatask.runtime.ExternalExcelDataReader;
import com.kingdee.eas.tools.datatask.runtime.ExternalStructInfo;
import com.kingdee.eas.tools.datatask.runtime.UploadFileToServerHelper;
import com.kingdee.eas.tools.datatask.task.ITask;
import com.kingdee.eas.tools.datatask.task.TaskExternalCode;
import com.kingdee.eas.tools.datatask.task.TaskTemplateAdapter;
import com.kingdee.eas.tools.datatask.util.EASResourceJoinUtil;
import com.kingdee.eas.tools.datatask.util.GlobalFunction;
import com.kingdee.eas.tools.datatask.util.ZipUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.Uuid;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.xml.rpc.ServiceException;
import org.apache.log4j.Logger;

public class DioMainUI
extends AbstractDioMainUI
implements ILogUI,
KDTMouseListener {
    private static final Logger logger = CoreUIObject.getLogger(DioMainUI.class);
    private IObjectPK userPK = null;
    private IObjectPK orgPK = null;
    private IObjectPK cuPK = null;
    private HashMap permIsCu = new HashMap(2);
    private IPermission perm = null;
    private IPermItem iPermItem = null;
    private HashMap idNames = new HashMap(2);
    private IDatataskRunServer drs = null;
    private static final String TB_SHEETNAME = "colSheetName";
    private static final String TB_ID = "id";
    private static final String TB_SELECT = "colSelect";
    private static final String TB_FILEPATH = "colFilePath";
    private static final String TB_TASKSTRUCT = "colTaskStruct";
    private static final String TB_TASKUUID = "colTaskUuid";
    private static final String TB_TASKNAME = "colTaskName";
    private static final String TB_RECORDCOUNT = "colRecordCount";
    private static final String TB_SUCCESSCOUNT = "colSuccessCount";
    private static final String TB_FAILCOUNT = "colFailCount";
    private static final String TB_STATUS = "colStatus";
    private static final String TB_FILTER = "colFilter";
    private static final String TB_ADDNEWIMPORT = "colAllowAddNewImport";
    private static final String TB_OVERWRITEIMPORT = "colOverWriteImport";
    private static final String TB_PARTIALIMPORT = "colPartialImport";
    private static final int COLUMN_INDEX_SELECT = 3;
    private static final int INDEX_FILEPATH = 5;
    private static final int INDEX_SHEETNAME = 6;
    private Map queryInfoMap = null;

    public DioMainUI() throws Exception {
        this.initBtnState();
    }

    private void initBtnState() {
        this.actionAddNew.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionQuery.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionView.setVisible(false);
        this.actionAddNew.setEnabled(false);
        this.actionEdit.setEnabled(false);
        this.actionQuery.setEnabled(false);
        this.actionRemove.setEnabled(false);
        this.actionView.setEnabled(false);
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.kDPanel1.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 785, 393));
        this.kDPanel4.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 785, 180));
        Color bgColor = this.tblMain.getBackground();
        this.kDSplitPane2.setBackground(bgColor);
        this.kDPanel1.setBackground(bgColor);
        this.kDPanel2.setBackground(bgColor);
        this.kDPanel3.setBackground(bgColor);
        this.kDPanel4.setBackground(bgColor);
        this.kDPanel5.setBackground(bgColor);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionOnLoad.actionPerformed(new ActionEvent(this, 1, "onload"));
        UserInfo ui = SysContext.getSysContext().getCurrentUserInfo();
        this.userPK = new ObjectUuidPK(ui.getId());
        OrgUnitInfo oui = SysContext.getSysContext().getCurrentOrgUnit();
        CtrlUnitInfo cui = SysContext.getSysContext().getCurrentCtrlUnit();
        this.orgPK = new ObjectUuidPK(oui.getId());
        this.cuPK = new ObjectUuidPK(cui.getId());
        this.perm = PermissionFactory.getRemoteInstance();
        this.iPermItem = PermItemFactory.getRemoteInstance();
        this.initTree();
        this.expandRootNode();
        this.initTblMain();
        this.installListener();
        this.tblLog.addKDTMouseListener((KDTMouseListener)this);
        this.getInputMap(2).put(KeyStroke.getKeyStroke("F8"), "actionTranslate");
        this.getActionMap().put("actionTranslate", (Action)((Object)this.actionTranslate));
        this.getInputMap(2).put(KeyStroke.getKeyStroke("F11"), "actionWebServiceExport");
        this.getActionMap().put("actionWebServiceExport", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DioMainUI.this.btnExport.requestFocus();
                if (!DioMainUI.this.btnExport.isSelected()) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"12_DioMainUI"));
                    return;
                }
                if (!DioMainUI.this.verifyWSInput(null)) {
                    return;
                }
                ArrayList params = DioMainUI.this.getParam(DioMainUI.this.getMode());
                DioMainUI.this.executeWSExport(params);
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"13_DioMainUI"));
            }
        });
        if (new Locale("L2").equals(SysContext.getSysContext().getLocale())) {
            this.actionTranslate.setEnabled(true);
        } else {
            this.actionTranslate.setEnabled(false);
        }
        this.setImportMode();
        this.tblMain.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editValueChanged(KDTEditEvent e) {
                if (e.getColIndex() == 3) {
                    KDTable tblCompany = (KDTable)e.getSource();
                    IRow row = tblCompany.getRow(e.getRowIndex());
                    if (!((Boolean)row.getCell(DioMainUI.TB_SELECT).getValue()).booleanValue()) {
                        row.getCell(DioMainUI.TB_SELECT).setValue((Object)Boolean.TRUE);
                    } else {
                        row.getCell(DioMainUI.TB_SELECT).setValue((Object)Boolean.FALSE);
                    }
                    DioMainUI.this.setImportMode();
                }
            }
        });
        this.btnPartialImport.setVisible(false);
    }

    private void executeWSExport(ArrayList params) {
        int count = params.size();
        ITask[] tasks = new ITask[count];
        for (int i = 0; i < count; ++i) {
            DatataskParameter dp = (DatataskParameter)params.get(i);
            int rowNum = (Integer)dp.getContextParam().get("rowNum");
            ITask task = this.getTaskOfRow(this.tblMain, rowNum);
            dp.datataskMode = 1;
            dp.setLogUuID(task.getTaskUuID());
            EntityViewInfo evi = this.getColFilterStr(rowNum);
            if (evi != null) {
                dp.getContextParam().put("commonFilter", evi);
            }
            task.setTaskParameter(dp);
            tasks[i] = task;
        }
        String serverHostName = UIConfig.getUrl();
        serverHostName = serverHostName.substring(serverHostName.lastIndexOf(47) + 1);
        serverHostName = serverHostName.substring(0, serverHostName.indexOf(58));
        EASLoginProxyServiceLocator easLoginProxyServiceLocator = new EASLoginProxyServiceLocator(serverHostName);
        try {
            String userName = SysContext.getSysContext().getUserName();
            String passWord = "";
            String slnName = SysContext.getSysContext().getSlnName();
            String dcNumber = SysContext.getSysContext().getDCNumber();
            Locale locale = SysContext.getSysContext().getLocale();
            Integer dbType = (Integer)SysContext.getSysContext().getProperty((Object)"dbType");
            easLoginProxyServiceLocator.getEASLogin().login(userName, passWord, slnName, dcNumber, locale.toString(), dbType);
        }
        catch (RemoteException e2) {
            MsgBox.showError((String)e2.getMessage());
            return;
        }
        catch (ServiceException e2) {
            MsgBox.showError((String)e2.getMessage());
            return;
        }
        DatataskParameter dp = null;
        for (int i = 0; i < tasks.length; ++i) {
            try {
                dp = (DatataskParameter)tasks[i].getTaskParameter();
                String easTemplateNumber = ((TaskExternalCode)tasks[i]).getDIETemplateInfo().getNumber();
                String mainQueryPK = this.getQueryInfo((TaskExternalCode)tasks[i]);
                String mainQuery = null;
                EntityViewInfo evi = (EntityViewInfo)dp.getContextParam().get("commonFilter");
                if (evi != null) {
                    mainQuery = evi.toString();
                }
                WSExternalDataExchangeFacadeSrvProxyServiceLocator locator = new WSExternalDataExchangeFacadeSrvProxyServiceLocator(serverHostName);
                String dataXML = locator.getWSExternalDataExchangeFacade().exportData(easTemplateNumber, mainQueryPK, mainQuery);
                byte[] fileByte = dataXML.getBytes("UTF-8");
                this.writeFile(fileByte, dp.getOpenFileName());
                continue;
            }
            catch (Exception e) {
                MsgBox.showError((String)e.getMessage());
            }
        }
    }

    private void setImportMode() {
        this.kDButtonGroup2.remove((AbstractButton)this.btnAddNewImport);
        this.kDButtonGroup2.remove((AbstractButton)this.btnUpdateImport);
        this.kDButtonGroup2.remove((AbstractButton)this.btnPartialImport);
        this.btnErrorGroup.remove((AbstractButton)this.btnReturnRightNow);
        this.btnErrorGroup.remove((AbstractButton)this.btnReturnWhenFinish);
        this.btnAddNewImport.setSelected(false);
        this.btnUpdateImport.setSelected(false);
        this.btnPartialImport.setSelected(false);
        this.btnReturnRightNow.setSelected(false);
        this.btnReturnWhenFinish.setSelected(false);
        this.btnAddNewImport.setEnabled(false);
        this.btnUpdateImport.setEnabled(false);
        this.btnPartialImport.setEnabled(false);
        this.btnPartialImport.setVisible(false);
        this.btnReturnRightNow.setEnabled(false);
        this.btnReturnWhenFinish.setEnabled(false);
        if (this.btnExport.isSelected()) {
            return;
        }
        int rowCount = this.tblMain.getRowCount();
        boolean isAllowAddNewImport = true;
        boolean isOverWriteImport = true;
        boolean isPartialImport = true;
        boolean tmpAllowAddNewImport = true;
        boolean tmpOverWriteImport = true;
        boolean tmpPartialImport = true;
        boolean selected = false;
        for (int i = 0; i < rowCount; ++i) {
            if (!this.hasCheckedRow(this.tblMain, i)) continue;
            selected = true;
            tmpAllowAddNewImport = (Boolean)this.tblMain.getCell(i, TB_ADDNEWIMPORT).getValue();
            tmpOverWriteImport = (Boolean)this.tblMain.getCell(i, TB_OVERWRITEIMPORT).getValue();
            tmpPartialImport = (Boolean)this.tblMain.getCell(i, TB_PARTIALIMPORT).getValue();
            tmpOverWriteImport = tmpOverWriteImport || tmpPartialImport;
            isAllowAddNewImport = isAllowAddNewImport && tmpAllowAddNewImport;
            isOverWriteImport = isOverWriteImport && tmpOverWriteImport;
            isPartialImport = isPartialImport && tmpPartialImport;
        }
        if (selected) {
            this.btnAddNewImport.setEnabled(isAllowAddNewImport);
            this.btnUpdateImport.setEnabled(isOverWriteImport);
            this.btnReturnRightNow.setEnabled(true);
            this.btnReturnWhenFinish.setEnabled(true);
            this.btnReturnWhenFinish.setSelected(true);
        }
        this.kDButtonGroup2.add((AbstractButton)this.btnAddNewImport);
        this.kDButtonGroup2.add((AbstractButton)this.btnUpdateImport);
        this.kDButtonGroup2.add((AbstractButton)this.btnPartialImport);
        this.btnErrorGroup.add((AbstractButton)this.btnReturnRightNow);
        this.btnErrorGroup.add((AbstractButton)this.btnReturnWhenFinish);
    }

    private void expandRootNode() {
        TreeModel model = this.treeMain.getModel();
        if (model != null && model.getRoot() != null && model.getRoot() instanceof TreeNode) {
            TreeNode node = (TreeNode)model.getRoot();
            TreeNode node1 = node.getChildAt(0);
            this.treeMain.expandPath(new TreePath(new Object[]{node, node1}));
        }
    }

    private void initTblMain() {
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.tblMain.getSelectManager().setSelectMode(1);
        this.tblMain.getColumn(TB_SHEETNAME).getStyleAttributes().setHided(false);
        FileChooserPromptBox nf7 = new FileChooserPromptBox((Component)((Object)this), "OPEN");
        nf7.setDisplayFormat("$name$");
        nf7.setEditable(true);
        KDTDefaultCellEditor cellEditorPath = new KDTDefaultCellEditor((IKDEditor)nf7);
        this.tblMain.getColumn(TB_FILEPATH).setEditor((ICellEditor)cellEditorPath);
        CommonQueryPromptBox filterF7 = new CommonQueryPromptBox((Component)((Object)this));
        filterF7.setEditable(false);
        KDTDefaultCellEditor cellEditorFilter = new KDTDefaultCellEditor((IKDEditor)filterF7);
        this.tblMain.getColumn(TB_FILTER).setEditor((ICellEditor)cellEditorFilter);
        this.btnClearAll.setEnabled(true);
        this.btnSelectAll.setEnabled(true);
        this.btnExecute.setEnabled(true);
        this.menuItemClearAll.setEnabled(true);
        this.menuItemSelectAll.setEnabled(true);
        this.menuItemRun.setEnabled(true);
    }

    private void installListener() {
        this.tblMain.addKDTEditListener(new KDTEditListener(){

            public void editStarting(KDTEditEvent e) {
            }

            public void editStarted(KDTEditEvent e) {
            }

            public void editValueChanged(KDTEditEvent e) {
            }

            public void editStopping(KDTEditEvent e) {
            }

            public void editStopped(KDTEditEvent e) {
                DioMainUI.this.tableEditStopped(e);
            }

            public void editCanceled(KDTEditEvent e) {
            }
        });
    }

    private void tableEditStopped(KDTEditEvent e) {
        boolean isImport = this.isImportMode();
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (colIndex == 5 && isImport) {
            Object o = this.tblMain.getRow(rowIndex).getCell(colIndex).getValue();
            String filePath = "";
            if (o != null) {
                filePath = o.toString();
            }
            boolean isExcel = GlobalFunction.isExcelFileType(filePath);
            Object o1 = this.tblMain.getRow(rowIndex).getCell(TB_TASKSTRUCT).getValue();
            TaskExternalCode task = (TaskExternalCode)o1;
            String defaultSheet = task.getExternalStructInfo().getSheetName();
            if (isExcel) {
                this.tblMain.getRow(rowIndex).getCell(6).getStyleAttributes().setLocked(false);
                try {
                    UIUtil.setComboBoxField(this.tblMain, rowIndex, 6, filePath, defaultSheet);
                }
                catch (IOException e1) {
                    String errorMsg = EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"readFileError");
                    MsgBox.showError((String)errorMsg);
                }
                catch (Exception e1) {
                    MsgBox.showError((String)e1.getMessage());
                }
            } else {
                this.tblMain.getRow(rowIndex).getCell(6).getStyleAttributes().setLocked(true);
                this.tblMain.getRow(rowIndex).getCell(6).setValue((Object)defaultSheet);
            }
            this.repaint();
        }
    }

    protected void checkTableParsed() {
        this.tblMain.checkParsed();
    }

    @Override
    public void loadFields() {
        this.tHelper.init();
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void execQuery() {
        this.tblMain.removeRows();
        try {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(TB_ID);
            selector.add("queryName");
            selector.add("importPermName");
            selector.add("exportPermName");
            selector.add("longNumber");
            selector.add("name");
            selector.add("number");
            selector.add("description");
            selector.add("level");
            selector.add("sheetName");
            selector.add("parentFolder.longNumber");
            selector.add("parentFolder.id");
            selector.add("parentFolder.number");
            selector.add("parentFolder.name");
            selector.add("isHintInTool");
            selector.add("allowAddNewImport");
            selector.add("allowOverWriteImport");
            selector.add("allowPartialImport");
            selector.add("implementClassName");
            selector.add("entityBosType");
            selector.add("countEachTime");
            selector.add("fieldEntries.id");
            selector.add("fieldEntries.seq");
            selector.add("fieldEntries.number");
            selector.add("fieldEntries.name");
            selector.add("fieldEntries.isNeed");
            selector.add("fieldEntries.memo");
            selector.add("fieldEntries.locale");
            selector.add("fieldEntries.isPrimary");
            selector.add("fieldEntries.isAutoMapping");
            selector.add("fieldEntries.entityPropName");
            selector.add("fieldEntries.entityPropClass");
            selector.add("fieldEntries.queryPropName");
            this.mainQuery.setSelector(selector);
            IDIETemplate template = (IDIETemplate)this.getBizInterface();
            DIETemplateCollection coll = template.getDIETemplateCollection(this.mainQuery);
            if (coll != null && coll.size() > 0) {
                int size = coll.size();
                this.queryInfoMap = this.getQueryInfoSet(coll);
                for (int i = 0; i < size; ++i) {
                    DIETemplateInfo info = coll.get(i);
                    TaskExternalCode task = TaskTemplateAdapter.getTaskExternalCode(info, SysContext.getSysContext().getLocale());
                    if (this.isHideTask(task)) continue;
                    this.addATaskToTable(task, info.getId().toString());
                }
            }
        }
        catch (Exception e) {
            MsgBox.showError((Component)((Object)this), (String)e.getMessage());
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private Map getQueryInfoSet(DIETemplateCollection coll) {
        Map queryInfoMap = new HashMap();
        if (coll == null || coll.size() == 0) {
            return queryInfoMap;
        }
        ArrayList<String> dataTransmissionClassNameList = new ArrayList<String>();
        DIETemplateInfo temp = null;
        String implementClassName = null;
        int count = coll.size();
        for (int i = 0; i < count; ++i) {
            temp = coll.get(i);
            implementClassName = temp.getImplementClassName();
            if (implementClassName == null || implementClassName.trim().length() <= 0) continue;
            dataTransmissionClassNameList.add(implementClassName);
        }
        this.drs = this.getInterface();
        try {
            queryInfoMap = this.drs.getQueryInfoSet(dataTransmissionClassNameList);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return queryInfoMap;
    }

    protected String getLongNumberFieldName() {
        return "parentFolder.longNumber";
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
    }

    protected void initTree() throws Exception {
        super.initTree();
        KDTreeNode root = (KDTreeNode)this.treeMain.getModel().getRoot();
    }

    protected FilterInfo getDefaultFilterForTree() {
        FilterInfo fInfo = super.getDefaultFilterForTree();
        FilterInfo tmpInfo = new FilterInfo();
        tmpInfo.getFilterItems().add(new FilterItemInfo("number", (Object)"accout", CompareType.NOTEQUALS));
        try {
            fInfo.mergeFilter(tmpInfo, "AND");
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return fInfo;
    }

    protected String getRootName() {
        return null;
    }

    protected Object getRootObject() {
        return null;
    }

    private boolean hideNoPermissionNode(KDTreeNode selectedNode) {
        Object o = selectedNode.getUserObject();
        if (selectedNode.getChildCount() == 0) {
            if (o instanceof TaskExternalCode) {
                if (this.isHideTask((TaskExternalCode)o) && selectedNode.getParent() != null) {
                    this.treeMain.removeNodeFromParent((MutableTreeNode)selectedNode);
                    return true;
                }
            } else if (o instanceof TemplateFolderInfo) {
                String[] hideNodes = new String[]{"accout"};
                String number = ((TemplateFolderInfo)o).getNumber();
                for (int i = 0; i < hideNodes.length; ++i) {
                    if (!hideNodes[i].equals(number)) continue;
                    this.treeMain.removeNodeFromParent((MutableTreeNode)selectedNode);
                    return true;
                }
            }
        } else {
            if (o instanceof TemplateFolderInfo) {
                String[] hideNodes = new String[]{"accout"};
                String number = ((TemplateFolderInfo)o).getNumber();
                for (int i = 0; i < hideNodes.length; ++i) {
                    if (!hideNodes[i].equals(number)) continue;
                    this.treeMain.removeNodeFromParent((MutableTreeNode)selectedNode);
                    return true;
                }
            }
            int childCount = selectedNode.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                KDTreeNode node;
                o = selectedNode.getChildAt(i);
                if (o == null || !(o instanceof KDTreeNode) || !this.hideNoPermissionNode(node = (KDTreeNode)o)) continue;
                --childCount;
                --i;
            }
            if (selectedNode.getChildCount() == 0 && selectedNode.getParent() != null) {
                this.treeMain.removeNodeFromParent((MutableTreeNode)selectedNode);
                return true;
            }
        }
        return false;
    }

    private boolean isHideTask(TaskExternalCode task) {
        String number = task.getNumber();
        if ("accountview".equals(number) || "accounttype".equals(number) || "generalasstacttype".equals(number)) {
            return true;
        }
        return task.isHintInTool();
    }

    private void disableState() {
        this.btnExecute.setEnabled(false);
        this.btnClearAll.setEnabled(false);
        this.btnAddNewImport.setEnabled(false);
        this.btnExport.setEnabled(false);
        this.btnImport.setEnabled(false);
        this.btnPageSetup.setEnabled(false);
        this.btnSelectAll.setEnabled(false);
        this.btnUpdateImport.setEnabled(false);
        this.menuItemClearAll.setEnabled(false);
        this.menuItemSelectAll.setEnabled(false);
        this.menuItemRun.setEnabled(false);
    }

    private void enableState() {
        this.btnExecute.setEnabled(true);
        this.btnClearAll.setEnabled(true);
        this.btnExport.setEnabled(true);
        this.btnImport.setEnabled(true);
        this.btnPageSetup.setEnabled(true);
        this.btnSelectAll.setEnabled(true);
        this.menuItemClearAll.setEnabled(true);
        this.menuItemSelectAll.setEnabled(true);
        this.menuItemRun.setEnabled(true);
        try {
            if (this.btnImport.isSelected()) {
                this.btnImport_focusGained(null);
            } else {
                this.btnExport_focusGained(null);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeMain_valueChanged(e);
    }

    protected String getQueryInfo(TaskExternalCode task) throws BOSException {
        String query = null;
        query = task.getDataTransmissionClassName() != null && !task.getDataTransmissionClassName().equals("") ? (String)this.queryInfoMap.get(task.getDataTransmissionClassName()) : task.getDIETemplateInfo().getQueryName();
        return query;
    }

    protected String getQueryInfoBAK(TaskExternalCode task) throws BOSException {
        String query = null;
        try {
            IDatataskRunServer drs = this.getInterface();
            query = task.getDataTransmissionClassName() != null && !task.getDataTransmissionClassName().equals("") ? drs.getQueryInfo(task.getDataTransmissionClassName()) : task.getDIETemplateInfo().getQueryName();
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return query;
    }

    protected String _getQueryInfo(String className) throws BOSException {
        Object result = null;
        try {
            Class<?> transmissionClass = Class.forName(className);
            Method getQueryMethod = transmissionClass.getMethod("getExportQueryInfo", Context.class);
            result = getQueryMethod.invoke(transmissionClass.newInstance(), new Object[]{null});
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException("", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException("", (Throwable)e);
        }
        return (String)result;
    }

    private void addATaskToTable(TaskExternalCode task, String id) {
        IRow row = this.tblMain.addRow();
        ExternalStructInfo info = task.getExternalStructInfo();
        row.getCell(TB_ID).setValue((Object)id);
        row.getCell(TB_SELECT).setValue((Object)Boolean.FALSE);
        row.getCell(TB_SELECT).getStyleAttributes().setLocked(false);
        row.getCell(TB_FILEPATH).getStyleAttributes().setLocked(false);
        String uuid = Uuid.create().toString();
        task.setTaskUuID(uuid);
        row.getCell(TB_TASKSTRUCT).setValue((Object)task);
        row.getCell(TB_TASKUUID).setValue((Object)uuid);
        row.getCell(TB_TASKNAME).setValue((Object)task.getName());
        row.getCell(TB_TASKNAME).getStyleAttributes().setLocked(true);
        row.getCell(TB_SHEETNAME).setValue((Object)info.getSheetName());
        row.getCell(TB_SHEETNAME).getStyleAttributes().setLocked(true);
        row.getCell(TB_RECORDCOUNT).getStyleAttributes().setLocked(true);
        row.getCell(TB_SUCCESSCOUNT).getStyleAttributes().setLocked(true);
        row.getCell(TB_FAILCOUNT).getStyleAttributes().setLocked(true);
        row.getCell(TB_STATUS).getStyleAttributes().setLocked(true);
        row.getCell(TB_ADDNEWIMPORT).setValue((Object)new Boolean(task.getDIETemplateInfo().isAllowAddNewImport()));
        row.getCell(TB_OVERWRITEIMPORT).setValue((Object)new Boolean(task.getDIETemplateInfo().isAllowOverWriteImport()));
        row.getCell(TB_PARTIALIMPORT).setValue((Object)new Boolean(task.getDIETemplateInfo().isAllowPartialImport()));
        CommonQueryPromptBox filterF7 = new CommonQueryPromptBox((Component)((Object)this));
        filterF7.setEditable(false);
        String query = null;
        try {
            query = this.getQueryInfo(task);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        filterF7.setQueryInfo(query);
        KDTDefaultCellEditor cellEditorFilter = new KDTDefaultCellEditor((IKDEditor)filterF7);
        row.getCell(TB_FILTER).setEditor((ICellEditor)cellEditorFilter);
        if (query == null) {
            row.getCell(TB_FILTER).getStyleAttributes().setLocked(true);
        } else {
            row.getCell(TB_FILTER).getStyleAttributes().setLocked(false);
        }
    }

    protected boolean isIncludeAllChildren() {
        return true;
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        int columnIndex = e.getColIndex();
        if (columnIndex == this.tblMain.getColumn(TB_FILTER).getColumnIndex()) {
            int rowIndex = e.getRowIndex();
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return;
            }
            String query = this.getQueryInfo((TaskExternalCode)row.getCell(TB_TASKSTRUCT).getValue());
            if (query == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"queryerr"));
                return;
            }
            QueryInfo queryInfo = Util.getQueryInfo((String)query);
            if (queryInfo == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"queryerr"));
                this.treeMain_valueChanged(null);
            }
        }
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
    }

    @Override
    protected void btnExport_focusGained(FocusEvent e) throws Exception {
        this.btnExport.setSelected(true);
        IColumn col = this.tblMain.getColumn(TB_FILTER);
        col.getStyleAttributes().setHided(false);
        col = this.tblMain.getColumn(TB_SHEETNAME);
        col.getStyleAttributes().setHided(true);
        col.getStyleAttributes().setLocked(true);
        FileChooserPromptBox nf7 = new FileChooserPromptBox((Component)((Object)this), "SAVE");
        nf7.setDisplayFormat("$name$");
        nf7.setEditable(false);
        KDTDefaultCellEditor cellEditorPath = new KDTDefaultCellEditor((IKDEditor)nf7);
        this.tblMain.getColumn(TB_FILEPATH).setEditor((ICellEditor)cellEditorPath);
        this.btnAddNewImport.setEnabled(false);
        this.btnUpdateImport.setEnabled(false);
        this.btnPartialImport.setEnabled(false);
        this.btnReturnRightNow.setEnabled(false);
        this.btnReturnWhenFinish.setEnabled(false);
        this.btnErrorGroup.remove((AbstractButton)this.btnReturnRightNow);
        this.btnErrorGroup.remove((AbstractButton)this.btnReturnWhenFinish);
        this.btnReturnRightNow.setSelected(false);
        this.btnReturnWhenFinish.setSelected(false);
    }

    protected void nf7_dataChanged(DataChangeEvent e) throws Exception {
        Object newValue = e.getNewValue();
        if (newValue != null && newValue instanceof File) {
            File file = (File)newValue;
            int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
            this.tblMain.getCell(rowIndex, TB_FILEPATH).setValue((Object)file.getPath());
        }
    }

    @Override
    protected void btnImport_focusGained(FocusEvent e) throws Exception {
        this.btnImport.setSelected(true);
        IColumn col = this.tblMain.getColumn(TB_FILTER);
        col.getStyleAttributes().setHided(true);
        col = this.tblMain.getColumn(TB_SHEETNAME);
        col.getStyleAttributes().setHided(false);
        col.getStyleAttributes().setLocked(false);
        FileChooserPromptBox nf7 = new FileChooserPromptBox((Component)((Object)this), "OPEN");
        nf7.setDisplayFormat("$name$");
        nf7.setEditable(false);
        KDTDefaultCellEditor cellEditorPath = new KDTDefaultCellEditor((IKDEditor)nf7);
        this.tblMain.getColumn(TB_FILEPATH).setEditor((ICellEditor)cellEditorPath);
        this.setImportMode();
    }

    @Override
    protected void kDRadioBtn_NewImport_stateChanged(ChangeEvent e) throws Exception {
        super.kDRadioBtn_NewImport_stateChanged(e);
    }

    @Override
    protected void kDRadioBtn_CoverImport_stateChanged(ChangeEvent e) throws Exception {
        super.kDRadioBtn_CoverImport_stateChanged(e);
    }

    @Override
    protected void btnPartialImport_stateChanged(ChangeEvent e) throws Exception {
        super.btnPartialImport_stateChanged(e);
    }

    public void tableClicked(KDTMouseEvent e) {
        if (e.getType() == 0) {
            return;
        }
        if (e.getRowIndex() >= 0 && e.getColIndex() >= 0) {
            if (e.getClickCount() == 2 && !e.isShiftDown()) {
                IRow row = this.tblLog.getRow(e.getRowIndex());
                String str = (String)row.getCell("logDetail").getUserObject();
                MsgBox.showInfo((Component)((Object)this), (String)str);
                return;
            }
            if (e.getClickCount() == 2 && e.isShiftDown()) {
                IRow row = this.tblLog.getRow(e.getRowIndex());
                String err = (String)row.getCell("logDetail").getValue();
                String errDetail = (String)row.getUserObject();
                MsgBox.showError((Component)((Object)this), (String)err, (String)errDetail);
            }
        }
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        int rowCount = 0;
        rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblMain.getRow(i);
            row.getCell(TB_SELECT).setValue((Object)Boolean.FALSE);
        }
        this.setImportMode();
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        int rowCount = 0;
        rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblMain.getRow(i);
            row.getCell(TB_SELECT).setValue((Object)Boolean.TRUE);
        }
        this.setImportMode();
    }

    private void beforeExecute() {
        this.disableState();
        this.getUuid();
        this.tblLog.removeRows();
    }

    private ArrayList getParam(int mode) {
        ArrayList<DatataskParameter> params = new ArrayList<DatataskParameter>();
        DatataskParameter dp = null;
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            if (!this.hasCheckedRow(this.tblMain, i) || !this.getParamOfRow(this.tblMain, i, dp = new DatataskParameter())) continue;
            dp.datataskMode = mode;
            if (this.btnReturnRightNow.isSelected()) {
                dp.getContextParam().put("errorHandleMode", ErrorHandleModeEnum.ReturnRightnow);
            } else {
                dp.getContextParam().put("errorHandleMode", ErrorHandleModeEnum.ReturnWhenFinish);
            }
            dp.getContextParam().put("rowNum", new Integer(i));
            params.add(dp);
        }
        return params;
    }

    private void executeImport(ArrayList params) {
        int count = params.size();
        ExtendsDataskParameter[] allParam = new ExtendsDataskParameter[params.size()];
        for (int i = 0; i < count; ++i) {
            DatataskParameter dp = (DatataskParameter)params.get(i);
            int rowNum = (Integer)dp.getContextParam().get("rowNum");
            ITask task = this.getTaskOfRow(this.tblMain, rowNum);
            allParam[i] = new ExtendsDataskParameter(dp, (TaskExternalCode)task);
        }
        try {
            ReturnInfo rs = this.checkMaxCount(allParam);
            if (rs != null && "error".equals(rs.getMsg())) {
                MsgBox.showError((String)rs.getData().toString());
                return;
            }
            DiscardUtil.clearCache(null);
            this.drs.runImportTasks(allParam);
        }
        catch (BOSException e) {
            TaskLog log = new TaskLog(0);
            log.setLogUuID(allParam[allParam.length - 1].getParam().getLogUuID());
            log.setTaskState(TaskStateEnum.FAILEND);
            String errorMsg = EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"executeimporterr");
            log.addException(errorMsg, e, null);
            try {
                this.drs.writeTaskLog(log);
            }
            catch (Exception e1) {
                logger.error((Object)e1.getMessage(), (Throwable)e1);
            }
        }
    }

    private ReturnInfo checkMaxCount(ExtendsDataskParameter[] params) {
        ReturnInfo rs = null;
        int size = params.length;
        for (int i = 0; i < size; ++i) {
            try {
                DatataskParameter param = params[i].getParam();
                TaskExternalCode task = params[i].getTask();
                ArrayList list = new ArrayList();
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("solu", task.getNumber());
                map.put("soluName", param.getAlias());
                map.put("seq", 1);
                list.add(map);
                String json = JSONUtils.convertObjectToJson(null, list);
                rs = this.drs.getMultiExcelInfo(task.getTaskUuID(), param.getOpenFileName(), json);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return rs;
    }

    private void executeExport(ArrayList params) {
        DatataskParameter dp;
        int count = params.size();
        ITask[] tasks = new ITask[count];
        ReturnInfo res = null;
        for (int i = 0; i < count; ++i) {
            dp = (DatataskParameter)params.get(i);
            int rowNum = (Integer)dp.getContextParam().get("rowNum");
            ITask task = this.getTaskOfRow(this.tblMain, rowNum);
            dp.datataskMode = 1;
            dp.setLogUuID(task.getTaskUuID());
            EntityViewInfo evi = this.getColFilterStr(rowNum);
            if (evi != null) {
                dp.getContextParam().put("commonFilter", evi);
            }
            task.setTaskParameter(dp);
            tasks[i] = task;
        }
        try {
            res = this.drs.runExportTask(tasks);
        }
        catch (Exception e) {
            TaskLog log = new TaskLog(0);
            log.setLogUuID(tasks[0].getTaskUuID());
            log.setTaskState(TaskStateEnum.FAILEND);
            String errorMsg = EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"executeexporterr");
            log.addException(errorMsg, e, null);
            try {
                this.drs.writeTaskLog(log);
            }
            catch (Exception e1) {
                logger.error((Object)e1.getMessage(), (Throwable)e1);
            }
        }
        HashSet<String> fileNames = new HashSet<String>();
        dp = null;
        ZipUtil zip = new ZipUtil();
        for (int i = 0; i < tasks.length; ++i) {
            TaskLog log;
            try {
                dp = (DatataskParameter)tasks[i].getTaskParameter();
                String openFile = dp.getOpenFileName();
                if (!fileNames.contains(openFile)) {
                    fileNames.add(openFile);
                    Map fileMap = (Map)res.getData();
                    byte[] fileByte = null;
                    for (String fileName : (List)fileMap.get(openFile)) {
                        fileByte = this.drs.getExportFile(fileName);
                        if (fileByte == null) continue;
                        zip.unGzipFile(fileByte, openFile);
                    }
                    zip.close();
                }
                log = new TaskLog(0);
                log.setTaskState(TaskStateEnum.SUCCESSEND);
                log.setLogType("exportlog");
                this.drs.writeTaskLog(log);
                continue;
            }
            catch (Exception e) {
                log = new TaskLog(0);
                log.setLogUuID(dp.getLogUuID());
                log.setTaskState(TaskStateEnum.FAILEND);
                String errorMsg = EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"executeexporterr");
                log.addException(errorMsg, e, null);
                try {
                    this.drs.writeTaskLog(log);
                    continue;
                }
                catch (Exception e1) {
                    logger.error((Object)e1.getMessage(), (Throwable)e1);
                }
            }
        }
    }

    private void afterExecute(IDatataskRunServer drs) throws Exception {
        Set ids = this.idNames.keySet();
        for (String id : ids) {
            TaskLog log = drs.getTaskLog(id);
            this.updateLogUI(log);
        }
        this.enableState();
    }

    @Override
    public void actionExecute_actionPerformed(ActionEvent ae) throws Exception {
        this.tblMain.getEditManager().editingStopped();
        if (!this.verifyInput(ae)) {
            return;
        }
        try {
            this.beforeExecute();
            ArrayList params = this.getParam(this.getMode());
            if (this.isImportMode()) {
                this.executeImport(params);
            } else {
                this.executeExport(params);
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.afterExecute(this.drs);
        }
    }

    protected void btnExportTemplate_actionPerformed(ActionEvent e) throws Exception {
    }

    private EntityViewInfo getColFilterStr(int rowIndex) {
        return (EntityViewInfo)this.tblMain.getRow(rowIndex).getCell(TB_FILTER).getValue();
    }

    private boolean verifyInput(ActionEvent e) {
        int size = this.tblMain.getRowCount();
        IRow row = null;
        int sltedCount = 0;
        StringBuilder sb = new StringBuilder("");
        for (int i = 0; i < size; ++i) {
            if (!this.hasCheckedRow(this.tblMain, i)) continue;
            row = this.tblMain.getRow(i);
            row.getCell(TB_RECORDCOUNT).setValue((Object)"");
            row.getCell(TB_SUCCESSCOUNT).setValue((Object)"");
            row.getCell(TB_FAILCOUNT).setValue((Object)"");
            row.getCell(TB_STATUS).setValue((Object)"");
            row = this.tblMain.getRow(i);
            String filePath = this.getFileName(this.tblMain, row.getRowIndex());
            if (filePath == null || filePath.equals("")) {
                String s = EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"setFilePath");
                MessageFormat mf = new MessageFormat(s);
                MsgBox.showInfo((String)mf.format(new Object[]{i + 1}));
                return false;
            }
            String fileType = GlobalFunction.getFileExtension(filePath);
            if (!(fileType != null && (fileType.equalsIgnoreCase("csv") || fileType.equalsIgnoreCase("xls") || fileType.equalsIgnoreCase("xlsx") || fileType.equalsIgnoreCase("txt") || fileType.equalsIgnoreCase("xml")))) {
                String s = EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"setFilePath");
                MessageFormat mf = new MessageFormat(s);
                MsgBox.showInfo((String)mf.format(new Object[]{i + 1}));
                return false;
            }
            ITask task = this.getTaskOfRow(this.tblMain, i);
            if (this.isImportMode()) {
                if (!(this.btnAddNewImport.isEnabled() || this.btnUpdateImport.isEnabled() || this.btnPartialImport.isEnabled())) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"configTemplateImportMode"));
                    return false;
                }
                if (!(this.btnAddNewImport.isSelected() || this.btnUpdateImport.isSelected() || this.btnPartialImport.isSelected())) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"selectImportMode"));
                    return false;
                }
                this.checkPerm(sb, task, ((TaskExternalCode)task).getImportPermItemName());
            } else {
                this.checkPerm(sb, task, ((TaskExternalCode)task).getExportPermItemName());
            }
            ++sltedCount;
        }
        if (sltedCount == 0 && this.isImportMode()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"importTask"));
            return false;
        }
        if (sltedCount == 0 && !this.isImportMode()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"sltExportTask"));
            return false;
        }
        if (sb.length() > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)sb.toString());
            return false;
        }
        return true;
    }

    private void checkPerm(StringBuilder sb, ITask task, String importName) {
        String taskName;
        String[][] checkResult = PermCheckUtil.hasFunctionPermision(importName);
        if ("error".equals(checkResult[0][0])) {
            taskName = EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"taskName");
            sb.append(taskName).append(":").append(task.getName()).append(",").append(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"errorMessage")).append(":").append(checkResult[0][1]).append("\n");
        }
        if ("false".equals(checkResult[0][0])) {
            taskName = EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"taskName");
            String message = EASResourceJoinUtil.getString("com.kingdee.eas.tools.datatask.DatataskResource", "permissionCheck", new Object[]{SysContext.getSysContext().getUserName(), SysContext.getSysContext().getCurrentOrgUnit().getName(), checkResult[0][1]});
            sb.append(taskName).append(":").append(task.getName()).append(",").append(message).append("\n");
        }
    }

    private boolean verifyWSInput(ActionEvent e) {
        int size = this.tblMain.getRowCount();
        IRow row = null;
        int sltedCount = 0;
        StringBuilder sb = new StringBuilder("");
        for (int i = 0; i < size; ++i) {
            if (!this.hasCheckedRow(this.tblMain, i)) continue;
            row = this.tblMain.getRow(i);
            row.getCell(TB_RECORDCOUNT).setValue((Object)"");
            row.getCell(TB_SUCCESSCOUNT).setValue((Object)"");
            row.getCell(TB_FAILCOUNT).setValue((Object)"");
            row.getCell(TB_STATUS).setValue((Object)"");
            row = this.tblMain.getRow(i);
            String filePath = this.getFileName(this.tblMain, row.getRowIndex());
            if (filePath == null || filePath.equals("")) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResourceJoinUtil.getString("com.kingdee.eas.tools.datatask.DatataskResource", "setLine", new Object[]{i + 1}));
                return false;
            }
            String fileType = GlobalFunction.getFileExtension(filePath);
            if (fileType == null || !fileType.equalsIgnoreCase("xml")) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResourceJoinUtil.getString("com.kingdee.eas.tools.datatask.DatataskResource", "setLine", new Object[]{i + 1}));
                return false;
            }
            ITask task = this.getTaskOfRow(this.tblMain, i);
            if (this.isImportMode()) {
                this.checkPerm(sb, task, ((TaskExternalCode)task).getImportPermItemName());
            } else {
                this.checkPerm(sb, task, ((TaskExternalCode)task).getExportPermItemName());
            }
            ++sltedCount;
        }
        if (sltedCount == 0 && this.isImportMode()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"importTask"));
            return false;
        }
        if (sltedCount == 0 && !this.isImportMode()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"sltExportTask"));
            return false;
        }
        if (sb.length() > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)sb.toString());
            return false;
        }
        return true;
    }

    private String[] getUuid() {
        int size = this.tblMain.getRowCount();
        IRow row = null;
        boolean sltedCount = false;
        ArrayList<String> uuids = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            if (!this.hasCheckedRow(this.tblMain, i)) continue;
            row = this.tblMain.getRow(i);
            String uuid = (String)row.getCell(TB_TASKUUID).getValue();
            uuids.add(uuid);
            String taskName = (String)row.getCell(TB_TASKNAME).getValue();
            this.idNames.put(uuid, taskName);
        }
        return uuids.toArray(new String[0]);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return DIETemplateFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return null;
    }

    @Override
    public void initUIMenuBarLayout() {
        this.menuBar.add((JMenu)this.menuFile);
        this.menuBar.add((JMenu)this.menuEdit);
        this.menuBar.add((JMenu)this.menuView);
        this.menuBar.add((JMenu)this.menuBiz);
        this.menuBar.add((JMenu)this.menuTool);
        this.menuBar.add((JMenu)this.menuTools);
        this.menuBar.add((JMenu)this.menuHelp);
        this.menuFile.add((JMenuItem)this.menuItemAddNew);
        this.menuFile.add((JMenuItem)this.menuItemImportData);
        this.menuFile.add((JMenuItem)this.menuItemExportData);
        this.menuFile.add((Component)this.separatorFile1);
        this.menuFile.add((JMenuItem)this.MenuItemAttachment);
        this.menuFile.add((Component)this.kDSeparator1);
        this.menuFile.add((JMenuItem)this.menuItemPageSetup);
        this.menuFile.add((JMenuItem)this.menuItemPrint);
        this.menuFile.add((JMenuItem)this.menuItemPrintPreview);
        this.menuFile.add((JMenuItem)this.menuItemExitCurrent);
        this.menuEdit.add((JMenuItem)this.menuItemSelectAll);
        this.menuEdit.add((JMenuItem)this.menuItemClearAll);
        this.menuHelp.add((JMenuItem)this.menuItemHelp);
        this.menuHelp.add((Component)this.kDSeparator12);
        this.menuHelp.add((JMenuItem)this.menuItemAbout);
        this.menuView.add((JMenuItem)this.menuItemView);
        this.menuView.add((JMenuItem)this.menuItemLocate);
        this.menuView.add((Component)this.separatorView1);
        this.menuView.add((JMenuItem)this.menuItemQuery);
        this.menuView.add((JMenuItem)this.menuItemRefresh);
        this.menuBiz.add((JMenuItem)this.menuItemCancelCancel);
        this.menuBiz.add((JMenuItem)this.menuItemCancel);
        this.menuBiz.add((JMenuItem)this.menuItemRun);
        this.menuTool.add((JMenuItem)this.menuItemSendMessage);
        this.menuTools.add((JMenuItem)this.menuMail);
        this.menuTools.add((JMenuItem)this.menuItemStartWorkFlow);
        this.menuTools.add((JMenuItem)this.menuItemPublishReport);
        this.menuMail.add((JMenuItem)this.menuItemToHTML);
        this.menuMail.add((JMenuItem)this.menuItemCopyScreen);
        this.menuMail.add((JMenuItem)this.menuItemToExcel);
    }

    @Override
    public void initUIToolBarLayout() {
        this.toolBar.add((Component)this.btnSelectAll);
        this.toolBar.add((Component)this.btnClearAll);
        this.toolBar.add((Component)this.btnExecute);
        this.toolBar.add((Component)this.kDSeparator2);
        this.toolBar.add((Component)this.btnPageSetup);
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.menuItemSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.menuItemClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnExecute.setIcon(EASResource.getIcon((String)"imgTbtn_execute"));
        this.menuItemRun.setIcon(EASResource.getIcon((String)"imgTbtn_execute"));
    }

    @Override
    public void updateLogUI(TaskLog log) {
        if (log == null) {
            return;
        }
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblMain.getRow(i);
            TaskExternalCode task = (TaskExternalCode)row.getCell(TB_TASKSTRUCT).getValue();
            if (!task.getTaskUuID().equals(log.getLogUuID())) continue;
            this.updateRow(row, log);
            this.tblMain.repaint();
            break;
        }
        if (log.getTaskState().equals((Object)TaskStateEnum.FAILEND) || log.getTaskState().equals((Object)TaskStateEnum.SUCCESSEND)) {
            this.displayLogOnTblLog(log);
            try {
                this.drs.clearTaskLog(log.getLogUuID());
            }
            catch (BOSException bOSException) {
                // empty catch block
            }
            this.enableState();
        }
    }

    private void displayLogOnTblLog(TaskLog logs) {
        int size = logs.getErrorDetailCount();
        int rowNumOfRecordStart = logs.getRowNumOfRecordStart();
        for (int i = 0; i < size; ++i) {
            if (logs.getErrorDetail(i) == null || logs.getErrorDetail(i).isEmpty()) continue;
            IRow row = this.tblLog.addRow();
            row.getStyleAttributes().setLocked(true);
            row.getCell("taskName").setValue(this.idNames.get(logs.getLogUuID()));
            row.getCell("rowNumber").setValue((Object)(logs.getErrorRowNum(i) + rowNumOfRecordStart));
            row.getCell("logSubject").setValue((Object)logs.getErrorSubject(i));
            row.getCell("logDetail").setValue((Object)logs.getErrorDetail(i));
            row.getCell("logDetail").setUserObject((Object)logs.getErrorDetail(i));
            row.setUserObject((Object)logs.getExceptionStack(i));
        }
    }

    private void updateRow(IRow row, TaskLog log) {
        row.getCell(TB_RECORDCOUNT).setValue((Object)new Integer(log.getSuccessRecordCount() + log.getFailRecordCount()));
        row.getCell(TB_SUCCESSCOUNT).setValue((Object)new Integer(log.getSuccessRecordCount()));
        row.getCell(TB_FAILCOUNT).setValue((Object)new Integer(log.getFailRecordCount()));
        if (log.getTaskState() != null) {
            row.getCell(TB_STATUS).setValue((Object)log.getTaskState());
        } else {
            row.getCell(TB_STATUS).setValue((Object)TaskStateEnum.PROCESS);
        }
    }

    private int getMode() {
        if (this.btnImport.isSelected()) {
            if (this.btnAddNewImport.isSelected()) {
                return 8;
            }
            if (this.btnUpdateImport.isSelected()) {
                return 16;
            }
            return 128;
        }
        return 1;
    }

    private boolean isImportMode() {
        boolean isImport = true;
        isImport = this.btnImport.isSelected();
        return isImport;
    }

    private IDatataskRunServer getInterface() {
        try {
            if (this.drs == null) {
                this.drs = DatataskRunServerFactory.getRemoteInstance();
            }
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        return this.drs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(byte[] fileBytes, String filePath) throws IOException {
        File file = null;
        FileOutputStream fs = null;
        try {
            file = new File(filePath);
            if (!file.exists()) {
                file.createNewFile();
            }
            if ((fs = new FileOutputStream(file)) != null && fileBytes != null && fileBytes.length > 0) {
                fs.write(fileBytes);
            }
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (fs != null) {
                fs.close();
                fs = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getByteOfFile(String fileName) {
        FileInputStream file = null;
        byte[] fileData = null;
        try {
            file = new FileInputStream(fileName);
            fileData = new byte[file.available()];
            file.read(fileData);
        }
        catch (Exception exception) {
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException iOException) {}
                file = null;
            }
        }
        return fileData;
    }

    private ITask getTaskOfRow(KDTable table, int tableRow) {
        TaskExternalCode taskExternalCode = null;
        if (table == null || tableRow < 0) {
            return taskExternalCode;
        }
        IRow row = table.getRow(tableRow);
        if (row != null && row.getCell(TB_TASKSTRUCT) != null) {
            taskExternalCode = (TaskExternalCode)row.getCell(TB_TASKSTRUCT).getValue();
            try {
                IDIETemplate template = (IDIETemplate)this.getBizInterface();
                DIETemplateInfo templateInfo = template.getDIETemplateInfo((IObjectPK)new ObjectUuidPK(taskExternalCode.getDIETemplateInfo().getId()));
                TaskExternalCode newTaskExternalCode = TaskTemplateAdapter.getTaskExternalCode(templateInfo, SysContext.getSysContext().getLocale());
                newTaskExternalCode.setTaskUuID(taskExternalCode.getTaskUuID());
                row.getCell(TB_TASKSTRUCT).setValue((Object)newTaskExternalCode);
                taskExternalCode = newTaskExternalCode;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return taskExternalCode;
    }

    private boolean getParamOfRow(KDTable table, int tableRow, DatataskParameter dp) {
        IRow row = table.getRow(tableRow);
        dp.alias = row.getCell(TB_SHEETNAME).getValue() != null ? row.getCell(TB_SHEETNAME).getValue().toString() : "sheet1";
        String fileName = this.getFileName(table, tableRow);
        if (fileName == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"15_DioMainUI"));
            return false;
        }
        if (!this.isValidFile(fileName)) {
            return false;
        }
        String fileType = GlobalFunction.getFileExtension(fileName);
        if (fileType == null) {
            fileType = "txt";
        }
        dp.setFileType(fileType);
        dp.setOpenFileName(fileName);
        dp.datataskMode = this.getMode();
        if (this.isImportMode()) {
            try {
                UploadFileToServerHelper helper = new UploadFileToServerHelper();
                String serverTmpFileName = helper.uploadFile(fileName);
                dp.setOpenFileName(serverTmpFileName);
            }
            catch (Exception e) {
                MsgBox.showError((Component)((Object)this), (String)e.getMessage());
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValidFile(String filePath) {
        String fileExtension;
        if (this.isImportMode() && "xls".equalsIgnoreCase(fileExtension = GlobalFunction.getFileExtension(filePath))) {
            try {
                ExternalExcelDataReader reader = new ExternalExcelDataReader();
                ArrayList sheetNames = null;
                sheetNames = reader.getSheetNameCollection(filePath);
                if (sheetNames.size() > 20) {
                    String msg = EASResourceJoinUtil.getString("com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", "16_DioMainUI", new Object[]{20});
                    MsgBox.showError((Component)((Object)this), (String)msg);
                    return false;
                }
            }
            catch (IOException e) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"readFileError"));
                return false;
            }
            catch (Exception e) {
                MsgBox.showError((Component)((Object)this), (String)e.getMessage());
                return false;
            }
        }
        File file = null;
        FileInputStream f = null;
        try {
            file = new File(filePath);
            if (!file.exists()) {
                file.createNewFile();
            }
            if ((f = new FileInputStream(filePath)) != null && (long)f.available() > 0xA00000L) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"importfiletoolarge"));
                boolean sheetNames = false;
                return sheetNames;
            }
        }
        catch (FileNotFoundException e) {
            MsgBox.showInfo((Component)((Object)this), (String)e.getMessage());
            logger.error((Object)e.getMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            MsgBox.showInfo((Component)((Object)this), (String)e.getMessage());
            logger.error((Object)e.getMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (file != null) {
                file = null;
            }
            if (f != null) {
                try {
                    f.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                f = null;
            }
        }
        return true;
    }

    private boolean hasCheckedRow(KDTable table, int tableRow) {
        Object tmp = table.getCell(tableRow, TB_SELECT).getValue();
        if (!(tmp instanceof Boolean)) {
            return false;
        }
        boolean tmpb = (Boolean)tmp;
        return tmpb;
    }

    private String getFileName(KDTable table, int tableRow) {
        IRow row = table.getRow(tableRow);
        if (row.getCell(TB_FILEPATH).getValue() != null) {
            return row.getCell(TB_FILEPATH).getValue().toString();
        }
        return null;
    }

    @Override
    public void actionTranslate_actionPerformed(ActionEvent e) throws Exception {
        super.actionTranslate_actionPerformed(e);
        IUIFactory uiFactory = null;
        UIContext ctx = new UIContext((Object)this);
        uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow translateDialog = uiFactory.create(TranslateUI.class.getName(), (Map)ctx);
        translateDialog.show();
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return TemplateFolderFactory.getRemoteInstance();
    }
}

