/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.client;

import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.ErrorHandleModeEnum;
import com.kingdee.eas.tools.datatask.client.DlgEASDatatask;
import com.kingdee.eas.tools.datatask.client.DlgEASDatataskLog;
import com.kingdee.eas.tools.datatask.client.DlgEASDatataskMultiSheet;
import com.kingdee.eas.tools.datatask.log.TaskLog;
import com.kingdee.eas.tools.datatask.runtime.GenerateErrorDataExcel;
import com.kingdee.eas.tools.datatask.runtime.GenerateErrorDataExcelX;
import com.kingdee.eas.tools.datatask.util.GlobalFunction;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class DlgEASDatataskImportLog
extends KDDialog
implements ActionListener,
KDTMouseListener {
    ArrayList params = null;
    ErrorHandleModeEnum errorHandleMode = null;
    int mode;
    boolean isSltSheet;
    private String errDataPath = null;
    private TaskLog logs = null;
    private final int ROWOFDATASTART = 4;
    private boolean hasDelErrLog = false;
    String fileName = null;
    private static final Logger logger = Logger.getLogger(DlgEASDatataskLog.class);
    public boolean isOK = false;
    private KDPanel pnlInfos = null;
    private KDPanel pnlBtns = null;
    private KDSeparator sepBtns = null;
    private KDButton btnOK = null;
    private KDButton btnCancel = null;
    private KDButton btnModifyData = null;
    private KDWorkButton btnContinue = null;
    KDMenuItem reChooseMenuItem = null;
    private KDLabel lblSuccessNum = null;
    private KDLabel lblFailNum = null;
    private KDTextArea tarDetail = null;
    private final int nWidth = 392;
    private final int nHeight = 423;
    private final int nMinOffset = 3;
    private final int nNormalOffset = 8;
    private final int nMaxOffset = 10;
    private final int nDlgBorderHeight = 27;
    private final int nDlgBorderWidth = 8;
    private int nPnlWidth = 392;
    private DlgEASDatatask taskDlg = null;

    public DlgEASDatataskImportLog(KDDialog parent, String fileName, TaskLog logs, String title) {
        super((Dialog)parent);
        this.logs = logs;
        this.fileName = fileName;
        try {
            this.init();
            this.jbInit();
        }
        catch (Exception ex) {
            logger.debug((Object)ex.getMessage());
        }
        this.setTitle(title);
    }

    public DlgEASDatataskImportLog(KDDialog parent, TaskLog logs) {
        this(parent, null, logs, null);
    }

    public DlgEASDatataskImportLog(KDDialog parent, ArrayList logs) {
        super((Dialog)parent);
        try {
            this.init();
            this.jbInit();
        }
        catch (Exception ex) {
            logger.debug((Object)ex.getMessage());
        }
    }

    private void init() {
        this.pnlInfos = new KDPanel();
        this.pnlBtns = new KDPanel();
        this.sepBtns = new KDSeparator();
        this.btnOK = new KDButton();
        this.btnCancel = new KDButton();
        this.lblSuccessNum = new KDLabel();
        this.lblFailNum = new KDLabel();
        this.tarDetail = new KDTextArea();
        this.btnModifyData = new KDButton();
        this.btnContinue = new KDWorkButton();
        this.reChooseMenuItem = new KDMenuItem(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"reChooseFile"));
        this.btnContinue.addAssistMenuItem((JMenuItem)this.reChooseMenuItem);
    }

    private void initTarDetail() {
        if (this.logs != null) {
            int size = this.logs.getErrorDetailCount();
            StringBuffer errLogStr = new StringBuffer();
            int errLogCount = 0;
            for (int i = 0; i < size; ++i) {
                String preErrDetail;
                String curErrSubject = this.logs.getErrorSubject(i);
                String preErrSubject = i == 0 ? null : this.logs.getErrorSubject(i - 1);
                String curErrDetail = this.logs.getErrorDetail(i);
                String string = preErrDetail = i == 0 ? null : this.logs.getErrorDetail(i - 1);
                if (curErrSubject != null && !curErrSubject.equals(preErrSubject)) {
                    errLogStr.append(curErrSubject).append("\n");
                    ++errLogCount;
                }
                if (curErrDetail != null && !curErrDetail.isEmpty()) {
                    boolean supportEntryErrorReason = this.logs.isSupportEntryErrorReason();
                    if (supportEntryErrorReason) {
                        int dataRow = this.logs.getErrorRowNum(i);
                        int excelRowNum = dataRow + this.logs.getRowNumOfRecordStart();
                        String prefixMsg = this.getErrorMsg(String.valueOf(excelRowNum));
                        errLogStr.append(prefixMsg).append(" ");
                    }
                    errLogStr.append(curErrDetail).append("\n");
                }
                if (errLogCount > 5 || i == size - 1) {
                    errLogStr.append("......").append("\n");
                    if (this.errorHandleMode == ErrorHandleModeEnum.ReturnRightnow) {
                        String msg = EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"importNotice3");
                        errLogStr.append(msg);
                        this.btnModifyData.setVisible(false);
                    } else {
                        String importNotice1 = EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"importNotice1");
                        String importNotice2 = EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"importNotice2");
                        errLogStr.append(importNotice1).append("\n").append(importNotice2);
                    }
                    errLogStr.append("\n");
                    break;
                }
                logger.error((Object)this.logs.getErrorDetail(i), this.logs.getThrowable(i));
            }
            this.tarDetail.setText(errLogStr.toString());
            this.lblSuccessNum.setText(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"successRecordNum") + this.logs.getSuccessRecordCount());
            this.lblFailNum.setText(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"failRecordNum") + this.logs.getFailRecordCount());
        }
    }

    private String getErrorMsg(String errorNumber) {
        return EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"whichRow", (Object[])new Object[]{errorNumber});
    }

    private void jbInit() {
        this.setSize(400, 450);
        this.setResizable(false);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.nWidth) / 2, (screenSize.height - this.nHeight) / 2);
        this.getRootPane().setDefaultButton((JButton)this.btnOK);
        this.getContentPane().setLayout(null);
        this.getContentPane().add((Component)this.pnlInfos, null);
        this.getContentPane().add((Component)this.pnlBtns, null);
        this.getContentPane().add((Component)this.sepBtns, null);
        this.getContentPane().setBackground(this.pnlBtns.getBackground());
        int nBtnWidth = 83;
        int nBtnHeight = 21;
        int nLblWidth = 150;
        int nTxtHeight = 19;
        this.nPnlWidth = 372;
        int nPnlBtnsHeight = nBtnHeight;
        int nPnlInfosHeight = 423 - nPnlBtnsHeight - 40 - 3;
        int nRightBtnLeft = this.nPnlWidth - nBtnWidth;
        int nLogTop = nTxtHeight + 8;
        int nLogHeight = nPnlInfosHeight - nTxtHeight - 8;
        this.pnlInfos.setLayout(null);
        this.pnlInfos.setBounds(10, 10, this.nPnlWidth, nPnlInfosHeight);
        this.lblSuccessNum.setBounds(0, 0, nLblWidth, nTxtHeight);
        this.lblFailNum.setBounds(this.nPnlWidth - nLblWidth, 0, nLblWidth, nTxtHeight);
        this.tarDetail.setBounds(0, nLogTop, this.nPnlWidth, nLogHeight);
        this.pnlInfos.add((Component)this.lblSuccessNum, null);
        this.pnlInfos.add((Component)this.lblFailNum, null);
        this.pnlInfos.add((Component)this.tarDetail, null);
        this.sepBtns.setBounds(0, 20 + nPnlInfosHeight, 392, 3);
        this.pnlBtns.setLayout(null);
        this.pnlBtns.setBounds(10, nPnlInfosHeight + 30 + 3, this.nPnlWidth, nBtnHeight);
        this.btnCancel.setBounds(nRightBtnLeft, 0, nBtnWidth, nBtnHeight);
        this.btnOK.setBounds(nRightBtnLeft - nBtnWidth - 3, 0, nBtnWidth, nBtnHeight);
        this.btnModifyData.setBounds(0, 0, nBtnWidth + 30, nBtnHeight);
        this.btnContinue.setBounds(nBtnWidth + 30 + 5, 0, nBtnWidth, nBtnHeight);
        this.btnOK.setText(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"ok"));
        this.btnOK.setVisible(false);
        this.btnCancel.setText(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"close"));
        this.btnModifyData.setText(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"modifyData"));
        this.btnContinue.setText(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"continueImport"));
        this.btnOK.addActionListener((ActionListener)this);
        this.btnCancel.addActionListener((ActionListener)this);
        this.btnModifyData.addActionListener((ActionListener)this);
        this.btnContinue.addActionListener((ActionListener)this);
        this.reChooseMenuItem.addActionListener((ActionListener)this);
        this.pnlBtns.add((Component)this.btnOK, null);
        this.pnlBtns.add((Component)this.btnCancel, null);
        this.pnlBtns.add((Component)this.btnModifyData, null);
        this.pnlBtns.add((Component)this.btnContinue, null);
        this.tarDetail.setEditable(false);
    }

    public boolean isOK() {
        return this.isOK;
    }

    private void onBtnOKClicked() {
        this.isOK = true;
        this.hide();
    }

    private void onBtnCancelClicked() {
        this.isOK = false;
        this.hide();
    }

    private void onBtnModifyDataClicked() {
        String strPath = this.fileName;
        String fileExtension = GlobalFunction.getFileExtension(strPath);
        try {
            if ("xls".equalsIgnoreCase(fileExtension)) {
                GenerateErrorDataExcel errExcel = new GenerateErrorDataExcel(this.params, strPath, this.logs, 4);
                this.errDataPath = errExcel.ReadExcel();
            } else if ("xlsx".equalsIgnoreCase(fileExtension)) {
                Object tmp = this.params.get(0);
                if (!(tmp instanceof DatataskParameter)) {
                    logger.error((Object)"params is not instance of DatataskParameter.");
                    return;
                }
                DatataskParameter dp = (DatataskParameter)tmp;
                this.errDataPath = dp.getClientErrFile();
                if (DlgEASDatataskImportLog.isWindows()) {
                    String cmd = "cmd /c start " + this.errDataPath.replace(" ", "\" \"");
                    Runtime.getRuntime().exec(cmd);
                } else {
                    String[] cmdArray = new String[]{"xdg-open", this.errDataPath};
                    Runtime.getRuntime().exec(cmdArray);
                }
            }
            this.hasDelErrLog = false;
        }
        catch (Exception e) {
            if (e != null && e instanceof FileNotFoundException) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"openedfile"));
                return;
            }
            logger.debug((Object)e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source.equals(this.btnOK)) {
            this.onBtnOKClicked();
        } else if (source.equals(this.btnCancel)) {
            this.onBtnCancelClicked();
        } else if (source.equals(this.btnModifyData)) {
            this.onBtnModifyDataClicked();
        } else if (source.equals(this.btnContinue)) {
            this.onbtnContinueClicked();
        } else if (source.equals(this.reChooseMenuItem)) {
            this.onReChooseClick();
        }
    }

    private void onReChooseClick() {
        if (this.params.size() <= 1) {
            DlgEASDatatask taskDlg = new DlgEASDatatask((Dialog)((Object)this), this.params, this.mode, this.isSltSheet);
            this.dispose();
            taskDlg.setModal(true);
            taskDlg.show();
            taskDlg.dispose();
            taskDlg = null;
        } else {
            DlgEASDatataskMultiSheet taskDlg = new DlgEASDatataskMultiSheet((Dialog)((Object)this), this.params, this.mode);
            this.dispose();
            taskDlg.setModal(true);
            taskDlg.show();
            taskDlg.dispose();
            Object var1_2 = null;
        }
    }

    private void onbtnContinueClicked() {
        String strPath = this.fileName;
        String fileExtension = GlobalFunction.getFileExtension(strPath);
        if (!this.hasDelErrLog && "xls".equalsIgnoreCase(fileExtension)) {
            this.delErrorLogColumn();
        }
        if (this.params.size() <= 1) {
            DlgEASDatatask taskDlg = new DlgEASDatatask((Dialog)((Object)this), this.params, this.mode, this.isSltSheet);
            if (StringUtils.isEmpty((String)this.errDataPath)) {
                this.errDataPath = this.fileName;
            }
            taskDlg.setFile(this.errDataPath);
            this.dispose();
            taskDlg.setModal(true);
            taskDlg.show();
            taskDlg.dispose();
            taskDlg = null;
        } else {
            DlgEASDatataskMultiSheet taskDlg = new DlgEASDatataskMultiSheet((Dialog)((Object)this), this.params, this.mode);
            if (StringUtils.isEmpty((String)this.errDataPath)) {
                this.errDataPath = this.fileName;
            }
            taskDlg.setFile(this.errDataPath);
            this.dispose();
            taskDlg.setModal(true);
            taskDlg.show();
            taskDlg.dispose();
            Object var3_4 = null;
        }
    }

    private void delErrorLogColumn() {
        String strPath = this.errDataPath;
        if (StringUtils.isEmpty((String)strPath)) {
            return;
        }
        String fileExtension = GlobalFunction.getFileExtension(strPath);
        try {
            if ("xls".equalsIgnoreCase(fileExtension)) {
                GenerateErrorDataExcel errExcel = new GenerateErrorDataExcel();
                errExcel.delErrorLogColumn(strPath);
            } else if ("xlsx".equalsIgnoreCase(fileExtension)) {
                GenerateErrorDataExcelX errExcelX = new GenerateErrorDataExcelX();
                errExcelX.delErrorLogColumn(strPath);
            }
            this.hasDelErrLog = true;
        }
        catch (Exception e) {
            if (e != null && e instanceof FileNotFoundException) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"errorFileOpened"));
                SysUtil.abort();
            }
            logger.debug((Object)e.getMessage());
            e.printStackTrace();
        }
    }

    public void tableClicked(KDTMouseEvent e) {
    }

    public void setParm(ArrayList parms) {
        this.params = parms;
        Object tmp = this.params.get(0);
        if (!(tmp instanceof DatataskParameter)) {
            logger.error((Object)"params is not instance of DatataskParameter.");
            return;
        }
        DatataskParameter dp = (DatataskParameter)tmp;
        this.errorHandleMode = (ErrorHandleModeEnum)((Object)dp.getContextParam().get("errorHandleMode"));
        this.initTarDetail();
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void setIsSltSheet(boolean isSltSheet) {
        this.isSltSheet = isSltSheet;
    }

    private static boolean isWindows() {
        return File.separatorChar == '\\';
    }
}

