/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.client;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.tools.datatask.DIETemplateFieldEntryInfo;
import com.kingdee.eas.tools.datatask.DIETemplateInfo;
import com.kingdee.eas.tools.datatask.client.AbstractPropertySetUI;
import com.kingdee.eas.tools.datatask.client.UIUtil;
import com.kingdee.eas.tools.datatask.databind.DataBindUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.DoubleEnum;
import com.kingdee.util.enums.DynamicEnum;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.FloatEnum;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.LongEnum;
import com.kingdee.util.enums.StringEnum;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class PropertySetUI
extends AbstractPropertySetUI {
    private static final Logger logger = CoreUIObject.getLogger(PropertySetUI.class);
    private String bosType = "";
    private String queryName = "";
    private DIETemplateInfo info = null;
    private BOSObjectType rootBosType = null;
    private String entityDesc = null;
    private DefaultKingdeeTreeNode rootNode = null;
    public static final String classSeparator = "$";
    private static final String descSeparator = "_";

    public PropertySetUI() throws Exception {
        this.btnCancel.setEnabled(true);
        this.btnConfirm.setEnabled(true);
    }

    private void initTree() {
        this.treeProp.setModel(null);
        this.rootNode = new DefaultKingdeeTreeNode((Object)this.entityDesc);
        this.treeProp.setModel((TreeModel)new DefaultTreeModel((TreeNode)this.rootNode));
        this.buildTreeNode(this.rootNode, this.rootBosType);
        this.treeProp.setSyncChecked(true);
        this.treeProp.setShowCheckBox(true);
        ((DefaultTreeModel)this.treeProp.getModel()).setAsksAllowsChildren(true);
        this.treeProp.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)event.getPath().getLastPathComponent();
                if (node == null) {
                    return;
                }
                EntityObjectInfo tmpInfo = null;
                if (node == PropertySetUI.this.rootNode) {
                    tmpInfo = PropertySetUI.this.getEntityObjectInfo(PropertySetUI.this.rootBosType);
                } else {
                    MyPropertyInfo info = (MyPropertyInfo)node.getUserObject();
                    LinkPropertyInfo tmpLinkInfo = (LinkPropertyInfo)info.getPropertyInfo();
                    tmpInfo = tmpLinkInfo.getRelationship().getSupplierObject();
                    if (!tmpInfo.getName().equals(info.getEntity().getName())) {
                        tmpInfo = tmpLinkInfo.getRelationship().getClientObject();
                    }
                }
                PropertySetUI.this.buildTreeNode(node, tmpInfo);
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.info = (DIETemplateInfo)this.getUIContext().get("editData");
        String strBosType = (String)this.getUIContext().get("bostype");
        String bosAlias = (String)this.getUIContext().get("bosAlias");
        this.queryName = (String)this.getUIContext().get("queryName");
        this.rootBosType = BOSObjectType.create((String)strBosType);
        this.entityDesc = bosAlias;
        this.initTree();
    }

    private void buildTreeNode(DefaultKingdeeTreeNode parentNode, EntityObjectInfo eoInfo) {
        PropertyCollection coll = eoInfo.getInheritedNoDuplicatedProperties();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            PropertyInfo tmp = coll.get(i);
            if (this.isExistSameProp(parentNode, tmp)) continue;
            MyPropertyInfo myInfo = new MyPropertyInfo(tmp);
            DefaultKingdeeTreeNode tmpNode = new DefaultKingdeeTreeNode((Object)myInfo);
            tmpNode.setCheckBoxVisible(true);
            if (tmp.getClass().getName().equals(LinkPropertyInfo.class.getName())) {
                tmpNode.setAllowsChildren(true);
                MyPropertyInfo info = (MyPropertyInfo)parentNode.getUserObject();
                EntityObjectInfo peoInfo = info.getEntity();
                LinkPropertyInfo lpInfo = (LinkPropertyInfo)tmp;
                EntityObjectInfo tmpInfo = lpInfo.getRelationship().getSupplierObject();
                if (tmpInfo.getName().equals(peoInfo.getName())) {
                    tmpInfo = lpInfo.getRelationship().getClientObject();
                }
                myInfo.setEntity(tmpInfo);
            } else {
                tmpNode.setAllowsChildren(false);
            }
            this.treeProp.addNodeInto((MutableTreeNode)tmpNode, (MutableTreeNode)parentNode);
            this.treeProp.scrollPathToVisible(new TreePath(tmpNode.getPath()));
        }
    }

    private boolean isExistSameProp(DefaultKingdeeTreeNode parentNode, PropertyInfo propInfo) {
        int count = parentNode.getChildCount();
        for (int i = 0; i > count; ++i) {
            MyPropertyInfo tmInfo;
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)parentNode.getChildAt(i);
            Object o = node.getUserObject();
            if (!(o instanceof MyPropertyInfo) || !(tmInfo = (MyPropertyInfo)o).getPropertyInfo().equals((Object)propInfo)) continue;
            return true;
        }
        return false;
    }

    private void buildTreeNode(DefaultKingdeeTreeNode parentNode, BOSObjectType type) {
        EntityObjectInfo eoInfo = this.getEntityObjectInfo(type);
        Object object = parentNode.getUserObject();
        if (object != null && !(object instanceof MyPropertyInfo)) {
            PropertyInfo propertyInfo = new PropertyInfo();
            propertyInfo.setName(object.toString());
            MyPropertyInfo myInfo = new MyPropertyInfo(propertyInfo);
            myInfo.setEntity(eoInfo);
            parentNode.setUserObject((Object)myInfo);
        }
        this.buildTreeNode(parentNode, eoInfo);
    }

    private EntityObjectInfo getEntityObjectInfo(BOSObjectType type) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader(null);
        return loader.getEntity(type);
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        ArrayList result = new ArrayList();
        this.getCheckedLeafNode((DefaultKingdeeTreeNode)this.treeProp.getModel().getRoot(), result);
        if (result != null && result.size() > 0) {
            int size = result.size();
            DefaultKingdeeTreeNode tmpNode = null;
            Object tmp = null;
            DIETemplateFieldEntryInfo tmpEntryInfo = null;
            for (int i = 0; i < size; ++i) {
                tmpNode = (DefaultKingdeeTreeNode)result.get(i);
                TreeNode[] nodes = tmpNode.getPath();
                int length = nodes.length;
                tmpEntryInfo = new DIETemplateFieldEntryInfo();
                for (int j = 1; j < length; ++j) {
                    DefaultKingdeeTreeNode tmpNode1 = (DefaultKingdeeTreeNode)nodes[j];
                    if (!(tmpNode.getUserObject() instanceof MyPropertyInfo)) continue;
                    MyPropertyInfo tmp1 = (MyPropertyInfo)tmpNode1.getUserObject();
                    PropertyInfo propInfo = tmp1.getPropertyInfo();
                    if (propInfo instanceof OwnPropertyInfo) {
                        OwnPropertyInfo tmpInfo = (OwnPropertyInfo)propInfo;
                        if (tmpInfo.isMultilingual()) {
                            DIETemplateFieldEntryInfo tmpEntryInfol2 = (DIETemplateFieldEntryInfo)tmpEntryInfo.clone();
                            DIETemplateFieldEntryInfo tmpEntryInfol3 = (DIETemplateFieldEntryInfo)tmpEntryInfo.clone();
                            this.fillEntryInfo(tmpEntryInfo, (OwnPropertyInfo)propInfo, new Locale("L1"));
                            tmpEntryInfo.setNumber(this.getField(tmpEntryInfo.getNumber()));
                            this.info.getFieldEntries().add(tmpEntryInfo);
                            this.fillEntryInfo(tmpEntryInfol2, (OwnPropertyInfo)propInfo, new Locale("L2"));
                            tmpEntryInfol2.setNumber(this.getField(tmpEntryInfol2.getNumber()));
                            this.info.getFieldEntries().add(tmpEntryInfol2);
                            this.fillEntryInfo(tmpEntryInfol3, (OwnPropertyInfo)propInfo, new Locale("L3"));
                            tmpEntryInfol3.setNumber(this.getField(tmpEntryInfol3.getNumber()));
                            this.info.getFieldEntries().add(tmpEntryInfol3);
                            continue;
                        }
                        this.fillEntryInfo(tmpEntryInfo, (OwnPropertyInfo)propInfo, null);
                        tmpEntryInfo.setNumber(this.getField(tmpEntryInfo.getNumber()));
                        this.info.getFieldEntries().add(tmpEntryInfo);
                        continue;
                    }
                    if (!(propInfo instanceof LinkPropertyInfo)) continue;
                    this.fillEntryInfo(tmpEntryInfo, (LinkPropertyInfo)propInfo);
                }
            }
        }
        this.getUIWindow().close();
    }

    private void fillEntryInfo(DIETemplateFieldEntryInfo entryInfo, OwnPropertyInfo ownInfo, Locale locale) {
        entryInfo.setIsAutoMapping(true);
        if (entryInfo.getEntityPropName() != null) {
            entryInfo.setEntityPropName(entryInfo.getEntityPropName() + classSeparator + ownInfo.getName());
        } else {
            entryInfo.setEntityPropName(ownInfo.getName());
        }
        if (entryInfo.getNumber() != null) {
            entryInfo.setNumber(entryInfo.getNumber() + descSeparator + ownInfo.getName());
        } else {
            entryInfo.setNumber(ownInfo.getName());
        }
        if (entryInfo.getName() != null) {
            entryInfo.setName(entryInfo.getName() + descSeparator + ownInfo.getAlias());
        } else {
            entryInfo.setName(ownInfo.getAlias());
        }
        if (entryInfo.getEntityPropAlias() != null) {
            entryInfo.setEntityPropAlias(entryInfo.getEntityPropAlias() + descSeparator + ownInfo.getAlias());
        } else {
            entryInfo.setEntityPropAlias(ownInfo.getAlias());
        }
        if (entryInfo.getEntityPropClass() != null) {
            entryInfo.setEntityPropClass(entryInfo.getEntityPropClass() + classSeparator + ownInfo.getDataType().toString());
        } else {
            entryInfo.setEntityPropClass(ownInfo.getDataType().toString());
        }
        this.addEnumMemoMsg(entryInfo, ownInfo);
        if (locale != null) {
            entryInfo.setNumber(entryInfo.getNumber() + descSeparator + locale.toString());
            entryInfo.setName(entryInfo.getName() + descSeparator + locale.toString());
            entryInfo.setLocale(locale.toString());
        }
        this.autoBindExportField(entryInfo, ownInfo);
    }

    private void autoBindExportField(DIETemplateFieldEntryInfo entryInfo, OwnPropertyInfo ownInfo) {
        String queryFullName = null;
        queryFullName = StringUtils.isEmpty((String)this.queryName) ? this.info.getQueryName() : this.queryName;
        if (StringUtils.isEmpty((String)queryFullName)) {
            return;
        }
        ArrayList queryProperties = UIUtil.getQueryProperty(queryFullName);
        OwnPropertyInfo tmpInfo = ownInfo;
        String entryNumber = entryInfo.getNumber().replaceAll(descSeparator, ".");
        if (tmpInfo.isMultilingual()) {
            entryNumber = entryNumber.substring(0, entryNumber.lastIndexOf("."));
        }
        QueryFieldInfo queryFieldInfo = null;
        for (int i = 0; i < queryProperties.size(); ++i) {
            queryFieldInfo = (QueryFieldInfo)queryProperties.get(i);
            if (!queryFieldInfo.getName().equals(entryNumber)) continue;
            entryInfo.setQueryPropAlias(queryFieldInfo.getDisplayName());
            entryInfo.setQueryPropClass(null);
            entryInfo.setQueryPropName(queryFieldInfo.getName());
        }
    }

    private void autoBindExportField(DIETemplateFieldEntryInfo entryInfo, LinkPropertyInfo linkInfo) {
        String queryFullName = null;
        queryFullName = StringUtils.isEmpty((String)this.queryName) ? this.info.getQueryName() : this.queryName;
        if (StringUtils.isEmpty((String)queryFullName)) {
            return;
        }
        ArrayList queryProperties = UIUtil.getQueryProperty(queryFullName);
        QueryFieldInfo queryFieldInfo = null;
        for (int i = 0; i < queryProperties.size(); ++i) {
            queryFieldInfo = (QueryFieldInfo)queryProperties.get(i);
            if (!queryFieldInfo.getName().equals(linkInfo.getName())) continue;
            entryInfo.setQueryPropAlias(queryFieldInfo.getDisplayName());
            entryInfo.setQueryPropClass(null);
            entryInfo.setQueryPropName(queryFieldInfo.getName());
        }
    }

    private void addEnumMemoMsg(DIETemplateFieldEntryInfo entryInfo, OwnPropertyInfo ownInfo) {
        String dataType = ownInfo.getDataType().toString();
        if ("Enum".equalsIgnoreCase(dataType)) {
            Map enumMaps = DataBindUtil.getEnumMap(ownInfo);
            Set keyset = enumMaps.keySet();
            Iterator it = keyset.iterator();
            Object[] sortString = new String[keyset.size()];
            StringBuffer memo = new StringBuffer();
            int i = 0;
            while (it.hasNext()) {
                Object key = it.next();
                Enum aa = (Enum)enumMaps.get(key);
                if (aa == null) {
                    return;
                }
                String actualValue = "";
                if (aa instanceof IntEnum) {
                    actualValue = String.valueOf(((IntEnum)aa).getValue());
                } else if (aa instanceof StringEnum) {
                    actualValue = ((StringEnum)aa).getValue();
                } else if (aa instanceof LongEnum) {
                    actualValue = String.valueOf(((LongEnum)aa).getValue());
                } else if (aa instanceof FloatEnum) {
                    actualValue = String.valueOf(((FloatEnum)aa).getValue());
                } else if (aa instanceof DoubleEnum) {
                    actualValue = String.valueOf(((DoubleEnum)aa).getValue());
                } else if (aa instanceof DynamicEnum) {
                    actualValue = String.valueOf(((DynamicEnum)aa).getValue());
                }
                sortString[i] = actualValue + "-----------" + aa.getAlias() + "; ";
                ++i;
            }
            Arrays.sort((Object[])sortString);
            for (int j = 0; j < sortString.length; ++j) {
                memo.append((String)sortString[j]);
            }
            entryInfo.setMemo(memo.toString());
        } else if ("Boolean".equalsIgnoreCase(dataType)) {
            StringBuffer memo = new StringBuffer();
            memo.append("true").append("-----------").append(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"20_PropertySetUI")).append("; ");
            memo.append("false").append("-----------").append(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"21_PropertySetUI")).append("; ");
            entryInfo.setMemo(memo.toString());
        }
    }

    private void fillEntryInfo(DIETemplateFieldEntryInfo entryInfo, LinkPropertyInfo linkInfo) {
        entryInfo.setIsAutoMapping(true);
        if (entryInfo.getEntityPropName() != null) {
            entryInfo.setEntityPropName(entryInfo.getEntityPropName() + classSeparator + linkInfo.getName());
        } else {
            entryInfo.setEntityPropName(linkInfo.getName());
        }
        if (entryInfo.getNumber() != null) {
            entryInfo.setNumber(entryInfo.getNumber() + classSeparator + linkInfo.getName());
        } else {
            entryInfo.setNumber(linkInfo.getName());
        }
        if (entryInfo.getName() != null) {
            entryInfo.setName(entryInfo.getName() + classSeparator + linkInfo.getAlias());
        } else {
            entryInfo.setName(linkInfo.getAlias());
        }
        if (entryInfo.getEntityPropAlias() != null) {
            entryInfo.setEntityPropAlias(entryInfo.getEntityPropAlias() + classSeparator + linkInfo.getAlias());
        } else {
            entryInfo.setEntityPropAlias(linkInfo.getAlias());
        }
        EntityObjectInfo eoInfo = null;
        eoInfo = this.rootBosType.equals((Object)linkInfo.getRelationship().getClientObject().getType()) ? linkInfo.getRelationship().getSupplierObject() : (!this.rootBosType.equals((Object)linkInfo.getRelationship().getSupplierObject().getType()) ? linkInfo.getRelationship().getSupplierObject() : linkInfo.getRelationship().getClientObject());
        String dataType = eoInfo.getObjectValueClass();
        if (entryInfo.getEntityPropClass() != null) {
            entryInfo.setEntityPropClass(entryInfo.getEntityPropClass() + classSeparator + dataType);
        } else {
            entryInfo.setEntityPropClass(dataType);
        }
        this.autoBindExportField(entryInfo, linkInfo);
    }

    private String getDataType(DefaultKingdeeTreeNode node) {
        String dataType = "";
        if (node.getParent() == this.rootNode) {
            return this.getSpecifyNodeDataType(node);
        }
        return this.getSpecifyNodeDataType((DefaultKingdeeTreeNode)node.getParent()) + "!" + this.getSpecifyNodeDataType(node);
    }

    private String getSpecifyNodeDataType(DefaultKingdeeTreeNode node) {
        String dataType = "";
        MyPropertyInfo tmp = (MyPropertyInfo)node.getUserObject();
        PropertyInfo propInfo = tmp.getPropertyInfo();
        if (propInfo instanceof LinkPropertyInfo) {
            LinkPropertyInfo linkInfo = (LinkPropertyInfo)propInfo;
            EntityObjectInfo eoInfo = linkInfo.getRelationship().getSupplierObject();
            dataType = eoInfo.getObjectValueClass();
            return dataType;
        }
        if (propInfo instanceof OwnPropertyInfo) {
            return ((OwnPropertyInfo)propInfo).getDataType().toString();
        }
        return null;
    }

    private void getCheckedLeafNode(DefaultKingdeeTreeNode parentNode, ArrayList result) {
        if (parentNode == null || parentNode.getChildCount() == 0) {
            return;
        }
        int childCount = parentNode.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            DefaultKingdeeTreeNode tmpNode = (DefaultKingdeeTreeNode)parentNode.getChildAt(i);
            if (tmpNode.isLeaf() && !tmpNode.getAllowsChildren()) {
                if (!tmpNode.isChecked()) continue;
                result.add(tmpNode);
                continue;
            }
            this.getCheckedLeafNode(tmpNode, result);
        }
    }

    private String getField(String prop) {
        return "F" + prop.substring(0, 1).toUpperCase() + prop.substring(1, prop.length());
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    private class MyPropertyInfo {
        private PropertyInfo info = null;
        private EntityObjectInfo entity = null;

        public MyPropertyInfo(PropertyInfo info) {
            this.info = info;
        }

        public void setEntity(EntityObjectInfo entity) {
            this.entity = entity;
        }

        public EntityObjectInfo getEntity() {
            return this.entity;
        }

        public String toString() {
            if (this.info.getAlias() != null) {
                return this.info.getAlias().toString();
            }
            return this.info.getName().toString();
        }

        public PropertyInfo getPropertyInfo() {
            return this.info;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof MyPropertyInfo)) {
                return false;
            }
            MyPropertyInfo myInfo = (MyPropertyInfo)o;
            PropertyInfo tmpPropInfo = myInfo.getPropertyInfo();
            if (this == myInfo) {
                return true;
            }
            return this.getPropertyInfo().equals((Object)tmpPropInfo);
        }
    }
}

