/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.client;

import com.kingdee.eas.tools.datatask.DatataskRunServerFactory;
import com.kingdee.eas.tools.datatask.FileInfo;
import com.kingdee.eas.tools.datatask.IDatataskRunServer;
import com.kingdee.eas.tools.datatask.client.AbstractTemplateExport;
import com.kingdee.eas.tools.datatask.util.EASResourceJoinUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.prefs.Preferences;
import org.apache.log4j.Logger;

public class ServerTemplateExport
extends AbstractTemplateExport {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tools.datatask.client.ServerTemplateExport");
    protected String actualFilePath = null;
    protected boolean isVirtual = false;
    protected boolean isSame = true;

    public ServerTemplateExport(String filePath) {
        this(filePath, false);
    }

    private ServerTemplateExport(String filePath, boolean isVirtual) {
        this.actualFilePath = filePath;
        this.isVirtual = isVirtual;
    }

    private String getActualFilePath(String filePathVirtualName) {
        return filePathVirtualName;
    }

    public String export(String localfilePath, boolean isShowMsg) throws Exception {
        String localClientPath = null;
        String easClientHome = this.getEasClientHome();
        localClientPath = easClientHome + File.separator + "template" + File.separator + this.actualFilePath;
        if (localfilePath == null) {
            return null;
        }
        FileInfo f = this.getLocalClientFileInfo(localClientPath, false);
        if (f.isExist()) {
            FileInfo sf = this.getServerFileInfo(this.actualFilePath, false);
            if (!sf.isExist()) {
                if (isShowMsg) {
                    this.showMsg(EASResourceJoinUtil.getString("com.kingdee.eas.tools.datatask.DatataskResource", "nofilepath", new Object[]{this.actualFilePath}));
                    return null;
                }
                throw new FileNotFoundException(EASResourceJoinUtil.getString("com.kingdee.eas.tools.datatask.DatataskResource", "nofilepath", new Object[]{this.actualFilePath}));
            }
            if (!f.isEqualsExContent(sf)) {
                FileInfo asf = this.getServerFileInfo(this.actualFilePath, true);
                this.save2Local(asf, localClientPath);
                f = asf;
            } else {
                f = this.getLocalClientFileInfo(localClientPath, true);
                f.setFileName(sf.getFileName());
            }
        } else {
            FileInfo asf;
            f = asf = this.getServerFileInfo(this.actualFilePath, true);
            if (!asf.isExist()) {
                if (isShowMsg) {
                    this.showMsg(EASResourceJoinUtil.getString("com.kingdee.eas.tools.datatask.DatataskResource", "nofilepath", new Object[]{this.actualFilePath}));
                    return null;
                }
                throw new FileNotFoundException(EASResourceJoinUtil.getString("com.kingdee.eas.tools.datatask.DatataskResource", "nofilepath", new Object[]{this.actualFilePath}));
            }
            this.save2Local(asf, localClientPath);
        }
        String filePath = "";
        filePath = !localClientPath.equals(localfilePath) ? this.save2Local(f, localfilePath) : localfilePath;
        if (isShowMsg) {
            if (this.isSame) {
                this.showMsg(EASResourceJoinUtil.getString("com.kingdee.eas.tools.datatask.DatataskResource", "templatefilepath", new Object[]{filePath}));
            } else {
                this.showMsg(EASResourceJoinUtil.getString("com.kingdee.eas.tools.datatask.DatataskResource", "templatefilepathChangeSuffix", new Object[]{filePath}));
            }
        }
        return filePath;
    }

    @Override
    public String export() throws Exception {
        String toFilePath = this.getFilePath();
        return this.export(toFilePath, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileInfo getLocalClientFileInfo(String filePath, boolean isReadData) {
        FileInfo fi = new FileInfo();
        File f = new File(filePath);
        if (!f.exists()) {
            fi.setExist(false);
            return fi;
        }
        fi.setExist(true);
        byte[] fileData = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            if (isReadData) {
                fileData = new byte[fis.available()];
                fis.read(fileData);
                fi.setSize(fileData.length);
                fi.setData(fileData);
            } else {
                fi.setSize(fis.available());
            }
        }
        catch (Exception err) {
            logger.error((Object)err);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                    fis = null;
                }
                catch (IOException e) {
                    logger.error((Object)e);
                }
            }
        }
        return fi;
    }

    protected FileInfo getServerFileInfo(String filePath, boolean isReadData) {
        FileInfo f = new FileInfo();
        try {
            IDatataskRunServer drs = DatataskRunServerFactory.getRemoteInstance();
            f = drs.getServerFile(filePath, isReadData, this.isVirtual);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return f;
    }

    protected String save2Local(FileInfo fi, String localFilePath) throws Exception {
        String locSuffix;
        String temFileName = fi.getFileName();
        String temSuffix = temFileName.substring(temFileName.lastIndexOf("."), temFileName.length());
        if (!temSuffix.equalsIgnoreCase(locSuffix = localFilePath.substring(localFilePath.lastIndexOf("."), localFilePath.length()))) {
            localFilePath = localFilePath.substring(0, localFilePath.lastIndexOf(".")) + temSuffix;
            this.isSame = false;
        }
        this.createPath(localFilePath);
        this.writeFile(fi.getData(), localFilePath);
        return localFilePath;
    }

    protected boolean isEqualsFile(FileInfo serverFile, FileInfo clientInfo) {
        return serverFile.isEqualsExContent(clientInfo);
    }

    protected void showMsg(String msg) {
        if (msg != null) {
            MsgBox.showInfo((Component)this.getParentComp(), (String)msg);
        }
    }

    private void writeFile(byte[] fileBytes, String filePath) throws Exception {
        File file = new File(filePath);
        FileOutputStream fs = null;
        try {
            if (!file.exists()) {
                file.createNewFile();
            } else {
                file.delete();
                file.createNewFile();
            }
            fs = new FileOutputStream(file);
            fs.write(fileBytes);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw e;
        }
        finally {
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (Exception exception) {}
                fs = null;
            }
        }
    }

    private void createPath(String filePath) {
        File f = new File(filePath);
        if (!f.exists()) {
            f.mkdirs();
        }
    }

    private String getEasClientHome() {
        Preferences pref = Preferences.systemRoot().node("kingdee/eas");
        String easClientHome = pref.get("easclienthome", null);
        if (easClientHome == null || easClientHome.trim().length() == 0) {
            easClientHome = System.getProperty("easclient.root");
            if (easClientHome != null && easClientHome.indexOf("/client/deploy/client") != -1) {
                easClientHome = easClientHome.substring(0, easClientHome.indexOf("/client/deploy/client"));
            }
            return easClientHome;
        }
        return easClientHome;
    }

    private String getEasServerHome() {
        String easPath = System.getProperty("INSTANCE_HOME");
        return easPath;
    }
}

