/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.client;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.tools.datatask.DatataskRunServerFactory;
import com.kingdee.eas.tools.datatask.IDatataskRunServer;
import com.kingdee.eas.tools.datatask.TaskStateEnum;
import com.kingdee.eas.tools.datatask.client.ExecuteTask;
import com.kingdee.eas.tools.datatask.client.ILogUI;
import com.kingdee.eas.tools.datatask.log.TaskLog;
import javax.swing.SwingUtilities;

public class TaskProcessMonitor {
    private boolean isFinished = false;
    private String[] uuid = null;
    private ILogUI logUI = null;

    public void startMonitor(String[] uuid, ILogUI logUI, ExecuteTask task) {
        this.uuid = uuid;
        this.logUI = logUI;
        StartTaskThread taskThread = new StartTaskThread(task);
        taskThread.start();
        MonitorThread monitor = new MonitorThread(this.uuid, this.logUI);
        monitor.start();
    }

    public synchronized void stopMonitor() {
        this.isFinished = true;
    }

    private class UpdateUIRunnable
    implements Runnable {
        private TaskLog _log;
        private ILogUI _logUI = null;

        private UpdateUIRunnable(TaskLog log, ILogUI logUI) {
            this._logUI = logUI;
            this._log = log;
        }

        @Override
        public void run() {
            this._logUI.updateLogUI(this._log);
        }
    }

    private class MonitorThread
    extends Thread {
        private String[] _mUuid = null;
        private ILogUI _logUI = null;
        private boolean hasGet = false;

        public MonitorThread(String[] uuid, ILogUI logUI) {
            this._mUuid = uuid;
            this._logUI = logUI;
        }

        @Override
        public void run() {
            IDatataskRunServer ids = null;
            try {
                ids = DatataskRunServerFactory.getRemoteInstance();
            }
            catch (BOSException bOSException) {
                // empty catch block
            }
            if (this._mUuid == null || this._mUuid.length == 0) {
                return;
            }
            int length = this._mUuid.length;
            for (int i = 0; i < length; ++i) {
                TaskProcessMonitor.this.isFinished = false;
                this.getOneTaskLog(i, ids);
            }
        }

        private void getOneTaskLog(int i, IDatataskRunServer ids) {
            TaskLog log = null;
            while (!TaskProcessMonitor.this.isFinished) {
                try {
                    MonitorThread.sleep(2000L);
                    log = ids.getTaskLog(this._mUuid[i]);
                    if (log == null) continue;
                    if (log.getTaskState().equals((Object)TaskStateEnum.FAILEND) || log.getTaskState().equals((Object)TaskStateEnum.SUCCESSEND)) {
                        this.hasGet = true;
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (BOSException bOSException) {
                    // empty catch block
                }
                SwingUtilities.invokeLater(new UpdateUIRunnable(log, this._logUI));
            }
            if (TaskProcessMonitor.this.isFinished && !this.hasGet) {
                try {
                    MonitorThread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    log = ids.getTaskLog(this._mUuid[i]);
                }
                catch (BOSException bOSException) {
                    // empty catch block
                }
                SwingUtilities.invokeLater(new UpdateUIRunnable(log, this._logUI));
            }
        }
    }

    private class StartTaskThread
    extends Thread {
        private ExecuteTask _task = null;

        public StartTaskThread(ExecuteTask task) {
            this._task = task;
        }

        @Override
        public void run() {
            this._task.run();
            TaskProcessMonitor.this.isFinished = true;
        }
    }
}

