/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.client;

import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.tools.datatask.DIETemplateCollection;
import com.kingdee.eas.tools.datatask.DIETemplateFactory;
import com.kingdee.eas.tools.datatask.DIETemplateInfo;
import com.kingdee.eas.tools.datatask.IDIETemplate;
import com.kingdee.eas.tools.datatask.client.AbstractTemplateExport;
import com.kingdee.eas.tools.datatask.export.ExternalCSVDataWriter;
import com.kingdee.eas.tools.datatask.export.ExternalExcelDataWriter;
import com.kingdee.eas.tools.datatask.export.ExternalExcelDataWriter2007;
import com.kingdee.eas.tools.datatask.export.ExternalTxtDataWriter;
import com.kingdee.eas.tools.datatask.export.ExternalXmlDataWriter;
import com.kingdee.eas.tools.datatask.export.IExternalDataWriter;
import com.kingdee.eas.tools.datatask.task.TaskExternalCode;
import com.kingdee.eas.tools.datatask.task.TaskTemplateAdapter;
import com.kingdee.eas.tools.datatask.util.GlobalFunction;
import com.kingdee.util.StringUtils;

public class TemplateExport
extends AbstractTemplateExport {
    private String[] templateNumber = null;
    private String sheetName = null;
    private IExternalDataWriter writer = null;

    public TemplateExport(String templateNumber, String sheetName) {
        this.templateNumber = new String[1];
        this.templateNumber[0] = templateNumber;
        this.sheetName = sheetName;
    }

    public TemplateExport(String[] templateNumbers) {
        this.templateNumber = templateNumbers;
    }

    public String getTemplateNumber() {
        return this.templateNumber[0];
    }

    public void setTemplateNumber(String templateNumber) {
        this.templateNumber[0] = templateNumber;
    }

    public String export(String localFilePath) throws Exception {
        if (localFilePath == null) {
            return null;
        }
        EntityViewInfo evInfo = new EntityViewInfo();
        FilterInfo fInfo = new FilterInfo();
        FilterItemInfo fIInfo = new FilterItemInfo("number", (Object)TemplateExport.array2String(this.templateNumber, ","), CompareType.INCLUDE);
        fInfo.getFilterItems().add(fIInfo);
        evInfo.setFilter(fInfo);
        IDIETemplate dt = DIETemplateFactory.getRemoteInstance();
        DIETemplateCollection coll = dt.getDIETemplateCollection(evInfo);
        if (coll != null && coll.size() > 0) {
            coll = this.orderBySet(coll);
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                DIETemplateInfo info = coll.get(i);
                TaskExternalCode taskCode = TaskTemplateAdapter.getTaskExternalCode(info, null);
                this.writeFile(taskCode, localFilePath, i);
            }
            this.close();
            return localFilePath;
        }
        return null;
    }

    private DIETemplateCollection orderBySet(DIETemplateCollection coll) {
        DIETemplateCollection collClone = (DIETemplateCollection)((Object)coll.clone());
        DIETemplateCollection coll2 = new DIETemplateCollection();
        for (int i = 0; i < this.templateNumber.length; ++i) {
            int size = collClone.size();
            for (int j = 0; j < size; ++j) {
                if (!collClone.get(j).getNumber().equals(this.templateNumber[i])) continue;
                coll2.add(collClone.get(j));
                collClone.removeObject(j);
                j = 0;
                --size;
            }
        }
        return coll2;
    }

    private void close() throws Exception {
        if (this.writer != null) {
            this.writer.closeWriter();
        }
    }

    @Override
    public String export() throws Exception {
        String filePath = this.getFilePath(this.sheetName);
        return this.export(filePath);
    }

    private void writeFile(TaskExternalCode taskCode, String filePath, int sheetIndex) throws Exception {
        String sheetName;
        String fileType = GlobalFunction.getFileExtension(filePath);
        if (this.writer == null) {
            if ("xls".equalsIgnoreCase(fileType)) {
                this.writer = new ExternalExcelDataWriter();
                this.writer.setLocacle(SysContext.getSysContext().getLocale());
            } else if ("xlsx".equalsIgnoreCase(fileType)) {
                this.writer = new ExternalExcelDataWriter2007();
                this.writer.setLocacle(SysContext.getSysContext().getLocale());
                ((ExternalExcelDataWriter2007)this.writer).setExportTemplate(true);
            } else if ("txt".equalsIgnoreCase(fileType)) {
                this.writer = new ExternalTxtDataWriter();
                this.writer.setLocacle(SysContext.getSysContext().getLocale());
                ((ExternalTxtDataWriter)this.writer).setExportTemplate(true);
            } else if ("csv".equalsIgnoreCase(fileType)) {
                this.writer = new ExternalCSVDataWriter();
                this.writer.setLocacle(SysContext.getSysContext().getLocale());
                ((ExternalCSVDataWriter)this.writer).setExportTemplate(true);
            } else if ("xml".equalsIgnoreCase(fileType)) {
                this.writer = new ExternalXmlDataWriter();
                this.writer.setLocacle(SysContext.getSysContext().getLocale());
                ((ExternalXmlDataWriter)this.writer).setExportTemplate(true);
            } else {
                this.writer = new ExternalExcelDataWriter();
                this.writer.setLocacle(SysContext.getSysContext().getLocale());
                ((ExternalExcelDataWriter)this.writer).setSheetName(this.sheetName == null ? taskCode.getExternalStructInfo().getSheetName() : this.sheetName);
            }
            this.writer.setFileName(filePath);
        }
        if (StringUtils.isEmpty((String)(sheetName = taskCode.getExternalStructInfo().getSheetName()))) {
            sheetName = "sheet" + sheetIndex;
        }
        if (this.writer instanceof ExternalExcelDataWriter2007) {
            ((ExternalExcelDataWriter2007)this.writer).setSheetName(sheetName);
        }
        if (this.writer instanceof ExternalExcelDataWriter) {
            ((ExternalExcelDataWriter)this.writer).setSheetName(sheetName);
        }
        this.writer.openWriter();
        this.writer.writeStruct(taskCode.getExternalStructInfo());
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    private static String array2String(String[] paths, String separator) {
        if (paths != null && paths.length > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < paths.length; ++i) {
                if (i != paths.length - 1) {
                    sb.append(paths[i] + separator);
                    continue;
                }
                sb.append(paths[i]);
            }
            return sb.toString();
        }
        return "";
    }
}

