/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.tools.datatask.BDEntityInfo;
import com.kingdee.eas.tools.datatask.DatataskRunServerFactory;
import com.kingdee.eas.tools.datatask.client.AbstractTranslateUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TranslateUI
extends AbstractTranslateUI {
    private static final String RESOURCE_FILE_NAME = "com.kingdee.eas.tools.datatask.DatataskResource";
    private Map bdEntityInfoMap = null;
    private static String previousDataCenter = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    private void init() {
        this.initUI();
        new LoadDataThread().start();
    }

    private void initUI() {
        this.tblMain.checkParsed();
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getColumn("bdAlias").getStyleAttributes().setLocked(true);
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_affirm"));
        this.btnClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_faffirm"));
        this.btnConvert.setIcon(EASResource.getIcon((String)"imgTbtn_execute"));
        this.progressBar.setStringPainted(true);
    }

    private void beginProgress() {
        this.disableComponents();
        this.progressBar.setIndeterminate(true);
    }

    private void endProgress() {
        this.enableComponents();
        this.progressBar.setIndeterminate(false);
    }

    private void disableComponents() {
        this.tblMain.setEnabled(false);
        this.btnSelectAll.setEnabled(false);
        this.btnClearAll.setEnabled(false);
        this.btnConvert.setEnabled(false);
    }

    private void enableComponents() {
        this.tblMain.setEnabled(true);
        this.btnSelectAll.setEnabled(true);
        this.btnClearAll.setEnabled(true);
        this.btnConvert.setEnabled(true);
    }

    public String getUITitle() {
        return EASResource.getString((String)RESOURCE_FILE_NAME, (String)"translateTitile");
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectAll_actionPerformed(e);
        this.progressBar.setString("");
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.tblMain.getRow(i).getCell("select").setValue((Object)Boolean.TRUE);
        }
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionClearAll_actionPerformed(e);
        this.progressBar.setString("");
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.tblMain.getRow(i).getCell("select").setValue((Object)Boolean.FALSE);
        }
    }

    @Override
    public void actionConvert_actionPerformed(ActionEvent e) throws Exception {
        super.actionConvert_actionPerformed(e);
        this.progressBar.setString("");
        ArrayList<String> tableList = new ArrayList<String>();
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblMain.getRow(i);
            Boolean isSelect = (Boolean)row.getCell("select").getValue();
            if (isSelect != Boolean.TRUE) continue;
            String name = (String)row.getCell("tableName").getValue();
            tableList.add(name);
        }
        if (tableList.isEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_FILE_NAME, (String)"selectBasedata"));
        } else {
            new TranslateThread(tableList).start();
        }
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        this.progressBar.setString("");
    }

    private class TranslateThread
    extends Thread {
        private List tableList = null;

        public TranslateThread(List tableList) {
            this.tableList = tableList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                TranslateUI.this.beginProgress();
                TranslateUI.this.progressBar.setString(EASResource.getString((String)TranslateUI.RESOURCE_FILE_NAME, (String)"onTranslating"));
                DatataskRunServerFactory.getRemoteInstance().translateBasedata(this.tableList);
                TranslateUI.this.progressBar.setString(EASResource.getString((String)TranslateUI.RESOURCE_FILE_NAME, (String)"translateSuccess"));
            }
            catch (BOSException e) {
                String errorTable = e.getMessage().trim();
                int index = errorTable.indexOf(10);
                if (index > 0) {
                    errorTable = errorTable.substring(0, index);
                }
                BDEntityInfo info = (BDEntityInfo)TranslateUI.this.bdEntityInfoMap.get(errorTable);
                TranslateUI.this.progressBar.setString((info != null ? (info.getEntityAlias(SysContext.getSysContext().getLocale()) == null ? info.getEntityName() : info.getEntityAlias(SysContext.getSysContext().getLocale())) : "") + EASResource.getString((String)TranslateUI.RESOURCE_FILE_NAME, (String)"translateFail"));
                TranslateUI.this.handUIException(e);
            }
            finally {
                TranslateUI.this.endProgress();
            }
        }
    }

    private class LoadDataThread
    extends Thread {
        private LoadDataThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                int i;
                TranslateUI.this.beginProgress();
                TranslateUI.this.progressBar.setString(EASResource.getString((String)TranslateUI.RESOURCE_FILE_NAME, (String)"gettingInfo"));
                if (TranslateUI.this.bdEntityInfoMap == null) {
                    TranslateUI.this.bdEntityInfoMap = DatataskRunServerFactory.getRemoteInstance().getBDEntityInfoMap();
                    previousDataCenter = SysContext.getSysContext().getDcName();
                } else if (!previousDataCenter.equals(SysContext.getSysContext().getDcName())) {
                    TranslateUI.this.bdEntityInfoMap = DatataskRunServerFactory.getRemoteInstance().getBDEntityInfoMap();
                    previousDataCenter = SysContext.getSysContext().getDcName();
                }
                Object[] bdInfos = TranslateUI.this.bdEntityInfoMap.values().toArray();
                int len = bdInfos.length;
                for (i = 0; i < len - 1; ++i) {
                    int min = i;
                    for (int j = i + 1; j < len; ++j) {
                        if (((BDEntityInfo)bdInfos[j]).getTableName().compareTo(((BDEntityInfo)bdInfos[min]).getTableName()) >= 0) continue;
                        min = j;
                    }
                    if (min == i) continue;
                    Object temp = bdInfos[i];
                    bdInfos[i] = bdInfos[min];
                    bdInfos[min] = temp;
                }
                for (i = 0; i < len; ++i) {
                    BDEntityInfo info = (BDEntityInfo)bdInfos[i];
                    IRow row = TranslateUI.this.tblMain.addRow();
                    row.getCell("select").setValue((Object)Boolean.FALSE);
                    row.getCell("bdName").setValue((Object)info.getEntityName());
                    String entityAlias = info.getEntityAlias(SysContext.getSysContext().getLocale());
                    if (entityAlias == null) {
                        row.getCell("bdAlias").setValue((Object)info.getEntityName());
                    } else {
                        row.getCell("bdAlias").setValue((Object)entityAlias);
                    }
                    row.getCell("tableName").setValue((Object)info.getTableName());
                }
                TranslateUI.this.tblMain.revalidate();
                TranslateUI.this.progressBar.setString(EASResource.getString((String)TranslateUI.RESOURCE_FILE_NAME, (String)"gettingInfoSuccess"));
            }
            catch (BOSException e) {
                TranslateUI.this.progressBar.setString(EASResource.getString((String)TranslateUI.RESOURCE_FILE_NAME, (String)"gettingInfoFail"));
                TranslateUI.this.handUIException(e);
            }
            finally {
                TranslateUI.this.endProgress();
            }
        }
    }
}

