/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDProgressBar;
import com.kingdee.bos.ctrl.swing.KDStatusBar;
import com.kingdee.bos.ctrl.swing.SimpleStatusBarPart;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.IPermItem;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.tools.datatask.DIETemplateInfo;
import com.kingdee.eas.tools.datatask.client.SimpleValueObjectInfo;
import com.kingdee.eas.tools.datatask.runtime.ExternalExcelDataReader;
import com.kingdee.eas.tools.datatask.runtime.ExternalExcelXDataReader;
import com.kingdee.eas.tools.datatask.util.GlobalFunction;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;

public class UIUtil {
    public static SimpleStatusBarPart createStatusBarPart(KDStatusBar statusBar) {
        SimpleStatusBarPart part = new SimpleStatusBarPart(statusBar);
        part.setBorder(BorderFactory.createEmptyBorder());
        part.setHgrap(0);
        return part;
    }

    public static SimpleStatusBarPart buildPartProgress(KDStatusBar statusBar, KDProgressBar progressBar) {
        SimpleStatusBarPart part = UIUtil.createStatusBarPart(statusBar);
        return part;
    }

    public static KDProgressBar getProgressBar(KDProgressBar progressBar) {
        progressBar.setMinimum(0);
        progressBar.setMaximum(100);
        progressBar.setStringPainted(true);
        progressBar.setString("");
        return progressBar;
    }

    public static IUIWindow showDialog(String strUI, Map map, String status, Component parent) {
        map.put("Owner", parent);
        IUIFactory uiFactory = null;
        IUIWindow curDialog = null;
        try {
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            curDialog = uiFactory.create(strUI, map, null, status);
            curDialog.show();
        }
        catch (UIException ex1) {
            ex1.printStackTrace();
        }
        return curDialog;
    }

    public static boolean isNull(String data) {
        return data == null || data.trim().length() <= 0;
    }

    public static boolean isNull(Object data) {
        return data == null;
    }

    public static PermItemInfo[] StringToPermInfo(String perms) {
        if (perms == null || perms.trim().length() == 0) {
            return null;
        }
        String[] importPerms = perms.split(";");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < importPerms.length; ++i) {
            if (i == importPerms.length - 1) {
                sb.append("'").append(importPerms[i]).append("'");
                continue;
            }
            sb.append("'").append(importPerms[i]).append("'").append(",");
        }
        FilterInfo finfo = new FilterInfo();
        finfo.getFilterItems().add(new FilterItemInfo("number", (Object)sb.toString(), CompareType.INNER));
        EntityViewInfo evInfo = new EntityViewInfo();
        evInfo.setFilter(finfo);
        IPermItem pi = null;
        try {
            pi = PermItemFactory.getRemoteInstance();
            PermItemCollection piColl = pi.getPermItemCollection(evInfo);
            if (piColl == null || piColl.size() <= 0) {
                return null;
            }
            int size = piColl.size();
            PermItemInfo[] piInfos = new PermItemInfo[size];
            for (int i = 0; i < size; ++i) {
                piInfos[i] = piColl.get(i);
            }
            return piInfos;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String permToString(PermItemInfo[] piInfos) {
        StringBuffer sb = new StringBuffer();
        int length = piInfos.length;
        String tmp = "";
        for (int i = 0; i < length; ++i) {
            String string = tmp = piInfos[i] == null ? "" : piInfos[i].getNumber();
            if (i == length - 1) {
                sb.append(tmp);
                continue;
            }
            sb.append(tmp).append(";");
        }
        return sb.toString();
    }

    public static SimpleValueObjectInfo getSimpleValueObjectInfo(String bosType) {
        if (bosType == null) {
            return null;
        }
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader(null);
        EntityObjectInfo eoInfo = null;
        try {
            eoInfo = loader.getEntity(BOSObjectType.create((String)bosType));
        }
        catch (Exception e) {
            eoInfo = null;
        }
        if (eoInfo == null) {
            return null;
        }
        SimpleValueObjectInfo info = new SimpleValueObjectInfo();
        info.setName(eoInfo.getAlias());
        info.setValue(bosType);
        return info;
    }

    public static SimpleValueObjectInfo getSimpleValueObjectInfoByQuery(String fullName) {
        if (fullName == null) {
            return null;
        }
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader(null);
        MetaDataPK mainQueryPK = new MetaDataPK(fullName);
        QueryInfo queryInfo = null;
        try {
            queryInfo = loader.getQuery((IMetaDataPK)mainQueryPK);
        }
        catch (Exception e) {
            queryInfo = null;
        }
        if (queryInfo == null) {
            return null;
        }
        SimpleValueObjectInfo info = new SimpleValueObjectInfo();
        info.setName(queryInfo.getAlias());
        info.setValue(fullName);
        return info;
    }

    public static ArrayList getQueryProperty(String queryFullName) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader(null);
        QueryInfo queryInfo = null;
        try {
            MetaDataPK mainQueryPK = new MetaDataPK(queryFullName);
            queryInfo = loader.getQuery((IMetaDataPK)mainQueryPK);
        }
        catch (Exception e) {
            queryInfo = null;
        }
        if (queryInfo == null) {
            return null;
        }
        return queryInfo.getSelector().getFields();
    }

    public static void loadPermData(String perms, KDBizPromptBox box) {
        PermItemInfo[] exportPerms = UIUtil.StringToPermInfo(perms);
        box.setData((Object)exportPerms);
    }

    public static void storeImportPermData(DIETemplateInfo info, KDBizPromptBox box) {
        Object o = box.getData();
        if (o instanceof Object[]) {
            Object[] os = (Object[])o;
            PermItemInfo[] piInfos = new PermItemInfo[os.length];
            for (int i = 0; i < os.length; ++i) {
                piInfos[i] = (PermItemInfo)os[i];
            }
            String s = UIUtil.permToString(piInfos);
            info.setImportPermName(s);
        } else {
            info.setImportPermName(null);
        }
    }

    public static void storeExportPermData(DIETemplateInfo info, KDBizPromptBox box) {
        Object o = box.getData();
        if (o instanceof Object[]) {
            Object[] os = (Object[])o;
            PermItemInfo[] piInfos = new PermItemInfo[os.length];
            for (int i = 0; i < os.length; ++i) {
                piInfos[i] = (PermItemInfo)os[i];
            }
            String s = UIUtil.permToString(piInfos);
            info.setExportPermName(s);
        } else {
            info.setExportPermName(null);
        }
    }

    private static void setSheetNameBox(KDComboBox comboSheets, String path, String defaultSheet) throws Exception {
        String fileExtension = GlobalFunction.getFileExtension(path);
        if ("xls".equalsIgnoreCase(fileExtension)) {
            ExternalExcelDataReader reader = new ExternalExcelDataReader();
            ArrayList sheetNamesColl = reader.getSheetNameCollection(path);
            UIUtil.setSheetNameBoxByType(comboSheets, defaultSheet, sheetNamesColl);
        } else {
            ExternalExcelXDataReader reader = new ExternalExcelXDataReader();
            ArrayList sheetNamesColl = reader.getSheetNameCollection(path);
            UIUtil.setSheetNameBoxByType(comboSheets, defaultSheet, sheetNamesColl);
        }
    }

    private static void setSheetNameBoxByType(KDComboBox comboSheets, String defaultSheet, List sheetNamesColl) {
        comboSheets.removeAllItems();
        if (sheetNamesColl != null) {
            int size = sheetNamesColl.size();
            for (int i = 0; i < size; ++i) {
                comboSheets.addItem(sheetNamesColl.get(i));
            }
        }
        if (sheetNamesColl.contains(defaultSheet)) {
            comboSheets.setSelectedItem((Object)defaultSheet);
        } else {
            comboSheets.setSelectedIndex(0);
        }
    }

    protected static KDComboBox setComboBoxField(KDTable kdTable, int rowIndex, int colIndex, String path, String defaultSheet) throws Exception {
        KDComboBox kdComboBox = new KDComboBox();
        UIUtil.setSheetNameBox(kdComboBox, path, defaultSheet);
        kdComboBox.setMaximumRowCount(10);
        KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((JComboBox)kdComboBox);
        kdTable.getRow(rowIndex).getCell(colIndex).setEditor((ICellEditor)kdtDefaultCellEditor);
        kdTable.getRow(rowIndex).getCell(colIndex).setValue(kdComboBox.getSelectedItem());
        return kdComboBox;
    }
}

