/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.tools.datatask.DIETemplateFieldEntryCollection;
import com.kingdee.eas.tools.datatask.DIETemplateFieldEntryInfo;
import com.kingdee.eas.tools.datatask.TemplateConfigInfo;
import com.kingdee.eas.tools.datatask.client.AbstractUserDefineTemplateFieldUI;
import com.kingdee.eas.tools.datatask.client.PropertySetUI;
import com.kingdee.eas.tools.datatask.client.SimpleValueObjectInfo;
import com.kingdee.eas.tools.datatask.client.UIUtil;
import com.kingdee.eas.tools.datatask.util.EASResourceJoinUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class UserDefineTemplateFieldUI
extends AbstractUserDefineTemplateFieldUI {
    private static final Logger logger = CoreUIObject.getLogger(UserDefineTemplateFieldUI.class);
    private SimpleValueObjectInfo svoInfo = null;
    private static final String RESOURCE = "com.kingdee.eas.tools.datatask.DatataskResource";

    public UserDefineTemplateFieldUI() throws Exception {
        this.initUI();
    }

    private void initUI() {
        this.btnAddField.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDelete.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnUp.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.installListener();
    }

    private void initTable() {
        if (this.editData == null) {
            return;
        }
        DIETemplateFieldEntryCollection entryColl = this.editData.getFieldEntries();
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            DIETemplateFieldEntryInfo tmp = entryColl.get(i);
            if (tmp.isIsAutoMapping()) {
                this.loadBindImport(tmp);
                continue;
            }
            IRow row = this.loadBindImport(tmp);
            this.lockRow(row);
        }
    }

    private void lockRow(IRow row) {
        row.getStyleAttributes().setLocked(true);
        row.getStyleAttributes().setBackground(Color.LIGHT_GRAY);
    }

    private void initTableQueryField() {
        String queryName = this.editData.getQueryName();
        ArrayList queryMap = UIUtil.getQueryProperty(queryName);
        KDTDefaultCellEditor itemEditor = null;
        KDComboBox comQueryProps = new KDComboBox();
        comQueryProps.addItem((Object)"");
        if (queryMap != null) {
            int size = queryMap.size();
            for (int i = 0; i < size; ++i) {
                QueryFieldInfo qfInfo = (QueryFieldInfo)queryMap.get(i);
                comQueryProps.addItem((Object)this.getSimpleValueObjectInfo(qfInfo.getDisplayName(), qfInfo.getName()));
            }
        }
        itemEditor = new KDTDefaultCellEditor((JComboBox)comQueryProps);
        this.tblFields.getColumn("queryField").setEditor((ICellEditor)itemEditor);
    }

    private void installListener() {
        this.btnAddField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserDefineTemplateFieldUI.this.addField();
            }
        });
        this.btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserDefineTemplateFieldUI.this.deleteField();
            }
        });
        this.btnUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserDefineTemplateFieldUI.this.fieldUp();
            }
        });
        this.btnDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserDefineTemplateFieldUI.this.fieldDown();
            }
        });
    }

    private SimpleValueObjectInfo getSimpleValueObjectInfo(String name, String value) {
        SimpleValueObjectInfo soInfo = new SimpleValueObjectInfo();
        soInfo.setName(name);
        soInfo.setValue(value);
        return soInfo;
    }

    private void addField() {
        if (this.tcInfo != null) {
            this.svoInfo = this.tcInfo.getValueObjectInfo();
        }
        if (this.svoInfo == null && this.editData.getEntityBosType() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"26_UserDefineImportUI"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Owner", (Object)this);
        uiContext.put((Object)"editData", (Object)this.editData);
        String alias = this.svoInfo.getName();
        if (alias == null || alias.equals("")) {
            alias = this.svoInfo.getValue();
        }
        uiContext.put((Object)"bosAlias", (Object)alias);
        uiContext.put((Object)"bostype", (Object)this.svoInfo.getValue());
        UIUtil.showDialog(PropertySetUI.class.getName(), (Map)uiContext, OprtState.ADDNEW, (Component)((Object)this));
        this.loadBindFields();
        this.tblFields.validate();
    }

    private void deleteField() {
        KDTSelectBlock selectBlock = this.tblFields.getSelectManager().get();
        if (selectBlock != null) {
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblFields.getRow(rowIndex);
            if (row == null) {
                return;
            }
            DIETemplateFieldEntryInfo entryInfo = (DIETemplateFieldEntryInfo)row.getUserObject();
            if (!entryInfo.isIsAutoMapping()) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"30_UserDefineTemplateFieldUI"));
                return;
            }
            String fieldNumber = (String)row.getCell("fieldNumber").getValue();
            DIETemplateFieldEntryCollection coll = this.editData.getFieldEntries();
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                DIETemplateFieldEntryInfo tmp = coll.get(i);
                if (tmp == null || !tmp.getNumber().equals(fieldNumber)) continue;
                coll.remove(tmp);
            }
            this.tblFields.removeRow(rowIndex);
        }
    }

    private void fieldUp() {
        int rowIndex;
        KDTSelectBlock selectBlock = this.tblFields.getSelectManager().get();
        if (selectBlock != null && (rowIndex = selectBlock.getTop()) > 0) {
            IRow row = this.tblFields.getRow(rowIndex);
            if (row == null) {
                return;
            }
            this.tblFields.removeRow(rowIndex);
            this.tblFields.addRow(rowIndex - 1, row);
            this.tblFields.getSelectManager().select(rowIndex - 1, 4);
        }
    }

    private void fieldDown() {
        int rowIndex;
        KDTSelectBlock selectBlock = this.tblFields.getSelectManager().get();
        if (selectBlock != null && (rowIndex = selectBlock.getTop()) < this.tblFields.getRowCount() - 1) {
            IRow row = this.tblFields.getRow(rowIndex);
            if (row == null) {
                return;
            }
            this.tblFields.removeRow(rowIndex);
            this.tblFields.addRow(rowIndex + 1, row);
            this.tblFields.getSelectManager().select(rowIndex + 1, 4);
        }
    }

    private void loadBindFields() {
        DIETemplateFieldEntryCollection entryColl = this.editData.getFieldEntries();
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            DIETemplateFieldEntryInfo tmp = entryColl.get(i);
            if (this.isExistSameEntryInfo(tmp) || !tmp.isIsAutoMapping()) continue;
            this.loadBindImport(tmp);
        }
    }

    private boolean isExistSameEntryInfo(DIETemplateFieldEntryInfo tmp) {
        int rowCount = this.tblFields.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblFields.getRow(i);
            DIETemplateFieldEntryInfo targetInfo = (DIETemplateFieldEntryInfo)row.getUserObject();
            if (targetInfo != null && targetInfo.getNumber() != null && targetInfo.getNumber().equalsIgnoreCase(tmp.getNumber())) {
                return true;
            }
            if (targetInfo == null || tmp == null || targetInfo.getEntityPropName() == null || !targetInfo.getEntityPropName().equals(tmp.getEntityPropName()) || targetInfo.getLocale() == null || tmp.getLocale() == null || !targetInfo.getLocale().equalsIgnoreCase(tmp.getLocale())) continue;
            return true;
        }
        return false;
    }

    private IRow loadBindImport(DIETemplateFieldEntryInfo tmp) {
        IRow row = this.tblFields.addRow();
        row.getCell("fieldNumber").setValue((Object)tmp.getNumber());
        row.getCell("fieldName").setValue((Object)tmp.getName());
        row.getCell("propNumber").setValue((Object)tmp.getEntityPropName());
        row.getCell("propName").setValue((Object)tmp.getEntityPropAlias());
        row.getCell("propLocale").setValue((Object)tmp.getLocale());
        row.getCell("isAutoMapping").setValue((Object)new Boolean(!tmp.isIsAutoMapping()));
        row.getCell("isAutoMapping").getStyleAttributes().setLocked(true);
        row.getCell("isAutoMapping").getStyleAttributes().setBackground(Color.LIGHT_GRAY);
        row.getCell("isPrimary").setValue((Object)new Boolean(tmp.isIsPrimary()));
        row.getCell("isNeed").setValue((Object)new Boolean(tmp.isIsNeed()));
        row.getCell("queryField").setValue((Object)this.getSimpleValueObjectInfo(tmp.getQueryPropAlias(), tmp.getQueryPropName()));
        if (tmp.getNumber() != null && tmp.getNumber().equalsIgnoreCase("FNumber")) {
            row.getCell("isPrimary").setValue((Object)new Boolean(true));
        }
        row.setUserObject((Object)tmp);
        row.getCell("fieldNumber").getStyleAttributes().setLocked(true);
        row.getCell("fieldName").getStyleAttributes().setLocked(true);
        row.getCell("propNumber").getStyleAttributes().setLocked(true);
        row.getCell("propName").getStyleAttributes().setLocked(true);
        row.getCell("propLocale").getStyleAttributes().setLocked(true);
        return row;
    }

    private void loadEditDataToUI() {
        if (this.editData == null) {
            return;
        }
        this.initTableQueryField();
        this.tblFields.removeRows();
        this.initTable();
    }

    private void storeUIDataToEditData() {
        if (this.editData == null) {
            return;
        }
        DIETemplateFieldEntryCollection coll = this.editData.getFieldEntries();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            DIETemplateFieldEntryInfo tmp = coll.get(i);
            if (!tmp.isIsAutoMapping()) continue;
            coll.remove(tmp);
            --size;
            --i;
        }
        int rowCount = this.tblFields.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblFields.getRow(i);
            DIETemplateFieldEntryInfo entryInfo = (DIETemplateFieldEntryInfo)row.getUserObject();
            this.AddOtherInfo(row, entryInfo);
            this.editData.getFieldEntries().add(entryInfo);
        }
    }

    private void AddOtherInfo(IRow row, DIETemplateFieldEntryInfo entryInfo) {
        Object o = row.getCell("isPrimary").getValue();
        if (o instanceof Boolean) {
            entryInfo.setIsPrimary((Boolean)o);
        }
        if ((o = row.getCell("isNeed").getValue()) instanceof Boolean) {
            entryInfo.setIsNeed((Boolean)o);
        }
        if ((o = row.getCell("queryField").getValue()) instanceof SimpleValueObjectInfo) {
            SimpleValueObjectInfo sinfo = (SimpleValueObjectInfo)o;
            entryInfo.setQueryPropName(sinfo.getValue());
            entryInfo.setQueryPropAlias(sinfo.getName());
        } else {
            entryInfo.setQueryPropName(null);
            entryInfo.setQueryPropAlias(null);
        }
    }

    @Override
    public void loadFields() {
        this.loadEditDataToUI();
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.storeUIDataToEditData();
        this.isStored = true;
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.tcInfo = (TemplateConfigInfo)this.getUIContext().get("TemplateConfigInfo");
        if (this.tcInfo != null) {
            this.svoInfo = this.tcInfo.getValueObjectInfo();
        }
    }

    @Override
    protected boolean verifyInput() {
        if (this.tblFields.getRowCount() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"onefieldisneed"));
            return false;
        }
        if (this.editData.getQueryName() != null) {
            int rowCount = this.tblFields.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                IRow row = this.tblFields.getRow(i);
                DIETemplateFieldEntryInfo entryInfo = (DIETemplateFieldEntryInfo)row.getUserObject();
                Object o = row.getCell("queryField").getValue();
                if (o != null || !entryInfo.isIsAutoMapping()) continue;
                return MsgBox.showConfirm3((Component)((Object)this), (String)EASResourceJoinUtil.getString("com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", "31_UserDefineTemplateFieldUI", new Object[]{entryInfo.getName()})) == 0;
            }
        }
        return true;
    }

    public boolean isPageComplete() {
        return this.editData != null;
    }
}

