/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.databind;

import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.util.enums.DynamicEnum;
import com.kingdee.util.enums.Enum;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.log4j.Logger;

public class DataBindUtil {
    private static final Logger logger = Logger.getLogger(DataBindUtil.class);

    public static Object getInstance(String className) throws TaskExternalException {
        Object o = null;
        try {
            Class<?> c = Class.forName(className);
            Constructor<?> cst = c.getConstructor(null);
            o = cst.newInstance(null);
        }
        catch (Exception e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return o;
    }

    public static Enum getIntegerEnum(Class c, String methodName, int methodValue) throws TaskExternalException {
        Object o = null;
        try {
            return (Enum)c.getMethod(methodName, Integer.TYPE).invoke((Object)c, new Integer(methodValue));
        }
        catch (Exception e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public static Enum getLongEnum(Class c, String methodName, long methodValue) throws TaskExternalException {
        Object o = null;
        try {
            return (Enum)c.getMethod(methodName, Long.TYPE).invoke((Object)c, new Long(methodValue));
        }
        catch (Exception e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public static Enum getFloatEnum(Class c, String methodName, float methodValue) throws TaskExternalException {
        Object o = null;
        try {
            return (Enum)c.getMethod(methodName, Float.TYPE).invoke((Object)c, new Float(methodValue));
        }
        catch (Exception e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public static Enum getDoubleEnum(Class c, String methodName, double methodValue) throws TaskExternalException {
        Object o = null;
        try {
            return (Enum)c.getMethod(methodName, Double.TYPE).invoke((Object)c, new Double(methodValue));
        }
        catch (Exception e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public static Enum getStringEnum(Class c, String methodName, String methodValue) throws TaskExternalException {
        Object o = null;
        try {
            return (Enum)c.getMethod(methodName, methodValue.getClass()).invoke((Object)c, methodValue);
        }
        catch (Exception e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public static Map getEnumMap(Class c, String methodName, Object o) throws TaskExternalException {
        try {
            return (Map)c.getMethod(methodName, null).invoke((Object)c, null);
        }
        catch (Exception e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public static Map getEnumMap(OwnPropertyInfo property) {
        BizEnumInfo enumInfo = property.getEnumType();
        if (enumInfo.isDynamic()) {
            return DynamicEnum.getEnumMap((String)enumInfo.getFullName());
        }
        String enumClassName = enumInfo.getClassName();
        try {
            Class<?> cl = Class.forName(enumClassName);
            String methodName = "getEnumMap";
            return DataBindUtil.getEnumMap(cl, methodName, cl);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            return null;
        }
    }

    public static Object getObjectOfWriteValue(String className, String propName, String propValue) throws Exception {
        Object targetObj = DataBindUtil.getInstance(className);
        BeanInfo info = Introspector.getBeanInfo(targetObj.getClass());
        PropertyDescriptor[] props = info.getPropertyDescriptors();
        for (int i = 0; i < props.length; ++i) {
            if (!props[i].getName().equalsIgnoreCase(propName)) continue;
            props[i].getWriteMethod().invoke(targetObj, propValue);
            break;
        }
        return targetObj;
    }

    public static Object getObjectOfWriteValue(Object targetObj, String propName, String propValue) throws Exception {
        BeanInfo info = Introspector.getBeanInfo(targetObj.getClass());
        PropertyDescriptor[] props = info.getPropertyDescriptors();
        for (int i = 0; i < props.length; ++i) {
            if (!props[i].getName().equalsIgnoreCase(propName)) continue;
            props[i].getWriteMethod().invoke(targetObj, propValue);
            break;
        }
        return targetObj;
    }

    public static Object getReadValueOfObject(Object targetObj, String propName) throws Exception {
        BeanInfo info = Introspector.getBeanInfo(targetObj.getClass());
        PropertyDescriptor[] props = info.getPropertyDescriptors();
        Object returnValue = null;
        for (int i = 0; i < props.length; ++i) {
            if (!props[i].getName().equalsIgnoreCase(propName)) continue;
            returnValue = props[i].getReadMethod().invoke(targetObj, null);
            break;
        }
        if (returnValue == null) {
            returnValue = ((CoreBaseInfo)targetObj).get(propName);
        }
        return returnValue;
    }

    public static Object getReadValueOfObject(String className, String propName) throws Exception {
        Object targetObj = DataBindUtil.getInstance(className);
        BeanInfo info = Introspector.getBeanInfo(targetObj.getClass());
        PropertyDescriptor[] props = info.getPropertyDescriptors();
        Class<?> returnValue = null;
        for (int i = 0; i < props.length; ++i) {
            if (!props[i].getName().equalsIgnoreCase(propName)) continue;
            returnValue = props[i].getReadMethod().getReturnType();
            break;
        }
        return returnValue;
    }

    public static Object executeMethod(String className, String methodName, String methodValue) throws Exception {
        Class<?> c = Class.forName(className);
        Method m = c.getMethod(methodName, String.class);
        Object cb = m.invoke(null, methodValue);
        return cb;
    }

    public static boolean isNull(Object o) {
        return o == null || o.equals("");
    }

    public static boolean isNull(String s) {
        return s == null || s.equals("");
    }
}

