/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.databind;

import com.kingdee.bos.Context;
import com.kingdee.bos.ICommonBOSType;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.ep.BillEntryCustomCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tools.datatask.DIETemplateFieldEntryCollection;
import com.kingdee.eas.tools.datatask.DIETemplateFieldEntryInfo;
import com.kingdee.eas.tools.datatask.DIETemplateInfo;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.databind.DataBindUtil;
import com.kingdee.eas.tools.datatask.databind.InfoClassValueProvider;
import com.kingdee.eas.tools.datatask.databind.LinkPropertyField;
import com.kingdee.eas.tools.datatask.databind.PropertyField;
import com.kingdee.eas.tools.datatask.databind.SimpleClassValueProvider;
import com.kingdee.eas.tools.datatask.databind.SimplePropertyField;
import com.kingdee.eas.tools.datatask.log.SysLog;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.tools.datatask.util.EASServerResource;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class DataBinder {
    private ArrayList propMap = new ArrayList(5);
    private HashMap propFileMap = null;
    private HashSet FileFieldSet = null;
    private DIETemplateInfo templateInfo = null;
    private HashMap propFieldMap = new HashMap(5);
    private String splitStr = "\\$";
    private String longNumberSplitStr = "\\.";
    private EntityObjectInfo eoInfo = null;
    private int entryRowIndex = 0;
    private boolean isCodeImplementTrans;
    private boolean isUserDefineTrans;
    private Map<BOSObjectType, ObjectUuidPK> delOldEntrys = new HashMap<BOSObjectType, ObjectUuidPK>();
    private static Logger logger = SysLog.getLogger(DataBinder.class);
    private Context ctx = null;
    private String type = null;

    public void trans(Map data, CoreBaseInfo oldInfo) throws Exception {
        if (this.eoInfo == null) {
            IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)this.ctx);
            this.eoInfo = loader.getEntity(this.getBOSObjectType(this.type));
        }
        this.generatePropertyFieldStructMap(data, oldInfo);
        this.assignValueForFieldMap(data);
        this.generateInfo(oldInfo);
    }

    public void trans(Map data, CoreBaseInfo oldInfo, int importMode) throws Exception {
        if (this.eoInfo == null) {
            IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)this.ctx);
            this.eoInfo = loader.getEntity(this.getBOSObjectType(this.type));
        }
        this.generatePropertyFieldStructMap(data, oldInfo);
        this.assignValueForFieldMap(data);
        this.generateInfo(oldInfo, importMode);
    }

    private void generateInfo(CoreBaseInfo oldInfo) throws Exception {
        if (oldInfo == null) {
            oldInfo = this.getDynValueClass();
        }
        for (Object key : this.propFieldMap.keySet()) {
            PropertyField prop = (PropertyField)this.propFieldMap.get(key);
            Object value = this.getValueObject(prop);
            Locale l = null;
            if (!DataBindUtil.isNull(prop.getLocale())) {
                l = new Locale(prop.getLocale());
            }
            if (!prop.isSimpleClassProp()) {
                LinkPropertyField lpf = (LinkPropertyField)prop;
                if (lpf.getLinkType() == 1) {
                    this.assignCompoValueForObjectValue((IObjectValue)oldInfo, prop.getPropName(), value, l);
                    continue;
                }
                this.assignSimpleValueForObjectValue((IObjectValue)oldInfo, prop.getPropName(), value, null);
                continue;
            }
            this.assignSimpleValueForObjectValue((IObjectValue)oldInfo, prop.getPropName(), value, l);
        }
    }

    private void generateInfo(CoreBaseInfo oldInfo, int importMode) throws Exception {
        if (oldInfo == null) {
            oldInfo = this.getDynValueClass();
        }
        for (Object key : this.propFieldMap.keySet()) {
            PropertyField prop = (PropertyField)this.propFieldMap.get(key);
            Object value = this.getValueObject(prop);
            Locale l = null;
            if (!DataBindUtil.isNull(prop.getLocale())) {
                l = new Locale(prop.getLocale());
            }
            if (!prop.isSimpleClassProp()) {
                LinkPropertyField lpf = (LinkPropertyField)prop;
                if (lpf.getLinkType() == 1) {
                    if (importMode == 128 && value == null) continue;
                    this.assignCompoValueForObjectValue((IObjectValue)oldInfo, prop.getPropName(), prop.getPropClass(), value, l, importMode);
                    continue;
                }
                if (importMode == 128 && value == null) continue;
                this.assignSimpleValueForObjectValue((IObjectValue)oldInfo, prop.getPropName(), value, null);
                continue;
            }
            if (importMode == 128 && value == null) continue;
            this.assignSimpleValueForObjectValue((IObjectValue)oldInfo, prop.getPropName(), value, l);
        }
    }

    private void assignSimpleValueForObjectValue(IObjectValue object, String propName, Object propValue, Locale l) {
        object.put(propName, propValue, l);
    }

    private void assignCompoValueForObjectValue(IObjectValue object, String propName, String className, Object propValue, Locale l, int importMode) throws Exception {
        IObjectCollection ioc;
        Object tmpEntries = DataBindUtil.getReadValueOfObject(object, propName);
        if (this.isUserDefineTrans && !this.isCodeImplementTrans && importMode == 8 && tmpEntries instanceof IObjectCollection) {
            IObjectCollection ioc2 = (IObjectCollection)tmpEntries;
            ioc2.addObject((IObjectValue)propValue);
            return;
        }
        if (this.isUserDefineTrans && !this.isCodeImplementTrans && importMode == 16 && tmpEntries instanceof IObjectCollection) {
            IObjectCollection ioc3 = (IObjectCollection)tmpEntries;
            int size = ioc3.size();
            if (size > 0) {
                Object newInstance = Class.forName(className).newInstance();
                BOSObjectType bosType = DataBinder.getRelationEntityType(this.eoInfo, propName, (CoreBaseInfo)newInstance);
                for (int i = 0; i < size; ++i) {
                    IObjectValue entryValue = ioc3.getObject(i);
                    Object val = null;
                    if (entryValue != null) {
                        val = entryValue.get(entryValue.getPKField());
                    }
                    if (val == null) continue;
                    this.delOldEntrys.put(bosType, new ObjectUuidPK(val.toString()));
                    ioc3.removeObject(entryValue);
                }
            }
            ioc3.addObject((IObjectValue)propValue);
            return;
        }
        if (tmpEntries instanceof IObjectCollection && (ioc = (IObjectCollection)tmpEntries) != null) {
            int size = ioc.size();
            if (this.entryRowIndex >= 0 && this.entryRowIndex < size) {
                Enumeration keyIter = ((IObjectValue)propValue).keys();
                IObjectValue entryValue = ioc.getObject(this.entryRowIndex);
                while (keyIter.hasMoreElements()) {
                    String key = keyIter.nextElement().toString();
                    Object value = ((IObjectValue)propValue).get(key);
                    if (value instanceof IObjectCollection) {
                        IObjectCollection valueCollection = (IObjectCollection)value;
                        if (valueCollection.size() <= 0) continue;
                        logger.error((Object)"Two or more level entries are not supported in DEP import", (Throwable)new Exception());
                        continue;
                    }
                    if (value == null && entryValue.get(key) != null) {
                        entryValue.put(key, entryValue.get(key));
                        continue;
                    }
                    entryValue.put(key, value);
                }
            } else {
                ioc.addObject((IObjectValue)propValue);
            }
        }
    }

    private static BOSObjectType getRelationEntityType(EntityObjectInfo eoInfo, String propName, CoreBaseInfo baseInfo) throws TaskExternalException {
        RelationshipInfo resInfo;
        PropertyInfo propInfo = eoInfo.getPropertyByName(propName);
        if (propInfo != null && (eoInfo.isDynamic() || propInfo.isConfigured()) && propInfo instanceof LinkPropertyInfo && (resInfo = ((LinkPropertyInfo)propInfo).getRelationship()) != null && resInfo.getSupplierObject() != null) {
            BOSObjectType type = resInfo.getSupplierObject().getType();
            if (baseInfo instanceof ICommonBOSType) {
                ((ICommonBOSType)baseInfo).setBOSType(type);
            }
            return type;
        }
        return baseInfo.getBOSType();
    }

    private void assignCompoValueForObjectValue(IObjectValue object, String propName, Object propValue, Locale l) throws Exception {
        IObjectCollection ioc;
        Object tmpEntries = DataBindUtil.getReadValueOfObject(object, propName);
        if (this.isUserDefineTrans && !this.isCodeImplementTrans && tmpEntries instanceof IObjectCollection) {
            IObjectCollection ioc2 = (IObjectCollection)tmpEntries;
            ioc2.addObject((IObjectValue)propValue);
            return;
        }
        if (tmpEntries instanceof IObjectCollection && (ioc = (IObjectCollection)tmpEntries) != null) {
            int size = ioc.size();
            if (this.entryRowIndex >= 0 && this.entryRowIndex < size) {
                Enumeration keyIter = ((IObjectValue)propValue).keys();
                IObjectValue entryValue = ioc.getObject(this.entryRowIndex);
                while (keyIter.hasMoreElements()) {
                    String key = keyIter.nextElement().toString();
                    Object value = ((IObjectValue)propValue).get(key);
                    if (value instanceof IObjectCollection) {
                        IObjectCollection valueCollection = (IObjectCollection)value;
                        if (valueCollection.size() <= 0) continue;
                        logger.error((Object)"Two or more level entries are not supported in DEP import", (Throwable)new Exception());
                        continue;
                    }
                    entryValue.put(key, value);
                }
            }
        }
    }

    private void generatePropertyFieldStructMap(Map data, CoreBaseInfo oldInfo) {
        int i;
        if (this.propFieldMap != null && this.propFieldMap.size() > 0) {
            return;
        }
        this.propMap.clear();
        this.propFieldMap.clear();
        int size = data.size();
        for (String key : data.keySet()) {
            DIETemplateFieldEntryInfo entryInfo;
            if (key.equalsIgnoreCase("PreviousNumber") || (entryInfo = this.getPropName(key)) == null || !entryInfo.isIsAutoMapping()) continue;
            String propName = entryInfo.getEntityPropName();
            String[] propNameArray = propName.split(this.splitStr);
            DataToken dt = (DataToken)data.get(key);
            String propClassName = this.getPropAllClassName(propName);
            String[] propClassArray = propClassName.split(this.splitStr);
            if (propNameArray.length <= 1) {
                SimplePropertyField propField = this.getSimplePropertyField(propClassArray[0], 0, propNameArray[0], dt.data.toString(), null);
                propField.setFileField(key);
                propField.setLocale(entryInfo.getLocale());
                propField.setNecessary(entryInfo.isIsNeed());
                this.propMap.add(propField);
                continue;
            }
            HashMap prop = new HashMap(3);
            for (int i2 = propNameArray.length - 1; i2 >= 0; --i2) {
                PropertyField propField;
                String tmpProp = propNameArray[i2];
                if (i2 == propNameArray.length - 1) {
                    propField = this.getSimplePropertyField(propClassArray[propClassArray.length - 1], propNameArray.length - 1, propNameArray[propNameArray.length - 1], dt.data.toString(), (PropertyField)prop.get(String.valueOf(propNameArray.length - 2)));
                    propField.setLongNumber(this.getLongNumber(propNameArray, propNameArray.length));
                    propField.setFileField(key);
                    propField.setLocale(entryInfo.getLocale());
                    ((SimplePropertyField)propField).setNecessary(entryInfo.isIsNeed());
                    this.propMap.add(propField);
                    continue;
                }
                propField = new LinkPropertyField();
                propField.setSimpleClassProp(false);
                propField.setParentPropertyField(null);
                propField.setPropClass(propClassArray[i2]);
                propField.setLocale(entryInfo.getLocale());
                propField.setPropLevel(i2);
                propField.setPropName(propNameArray[i2]);
                propField.setLongNumber(this.getLongNumber(propNameArray, i2 + 1));
                if (i2 == 0) {
                    LinkPropertyInfo lpInfo = (LinkPropertyInfo)this.eoInfo.getPropertyByName(propField.getPropName());
                    RelationshipType type = lpInfo.getRelationship().getType();
                    if (type.equals((Object)RelationshipType.COMPOSITION) && this.eoInfo.getName().equals(lpInfo.getRelationship().getClientObject().getName())) {
                        ((LinkPropertyField)propField).setLinkType(1);
                    } else {
                        ((LinkPropertyField)propField).setLinkType(0);
                    }
                }
                this.propMap.add(propField);
            }
        }
        int propSize = this.propMap.size();
        for (i = 0; i < propSize - 1; ++i) {
            for (int soni = i + 1; soni < propSize; ++soni) {
                PropertyField pf = (PropertyField)this.propMap.get(i);
                PropertyField sonpf = (PropertyField)this.propMap.get(soni);
                if (pf.getPropLevel() <= sonpf.getPropLevel()) continue;
                this.propMap.set(i, sonpf);
                this.propMap.set(soni, pf);
            }
        }
        for (i = 0; i < propSize; ++i) {
            PropertyField pf = (PropertyField)this.propMap.get(i);
            if (pf.getPropLevel() == 0) {
                SimplePropertyField parentspf = new SimplePropertyField();
                parentspf.setPropClass(oldInfo.getClass().getName());
                pf.setParentPropertyField(parentspf);
                this.propFieldMap.put(this.getKey(pf), pf);
                continue;
            }
            this.settleDownLinkPropertyField(this.propFieldMap, pf);
        }
    }

    public boolean isExistEntrys() {
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)this.ctx);
        this.eoInfo = loader.getEntity(this.getBOSObjectType(this.type));
        DIETemplateFieldEntryInfo entryInfo = null;
        DIETemplateFieldEntryCollection coll = this.templateInfo.getFieldEntries();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            LinkPropertyInfo lpInfo;
            RelationshipType type;
            String[] propNameArray;
            String propName;
            entryInfo = coll.get(i);
            if (entryInfo == null || !entryInfo.isIsAutoMapping() || (propName = entryInfo.getEntityPropName()) == null || (propNameArray = propName.split(this.splitStr)).length <= 1 || !(type = (lpInfo = (LinkPropertyInfo)this.eoInfo.getPropertyByName(propNameArray[0])).getRelationship().getType()).equals((Object)RelationshipType.COMPOSITION)) continue;
            return true;
        }
        return false;
    }

    private void assignValueForFieldMap(Map data) {
        for (Object key : this.propFieldMap.keySet()) {
            PropertyField pf = (PropertyField)this.propFieldMap.get(key);
            if (pf.isSimpleClassProp()) {
                SimplePropertyField spf = (SimplePropertyField)pf;
                this.assignValueForSimplePropertyField(spf, data);
                continue;
            }
            LinkPropertyField lpf = (LinkPropertyField)pf;
            this.assignValueForLinkPropertyField(lpf, data);
        }
    }

    private void assignValueForLinkPropertyField(LinkPropertyField lpf, Map data) {
        HashMap children = lpf.getChildren();
        for (Object o : children.keySet()) {
            Object value = children.get(o);
            if (value instanceof LinkPropertyField) {
                this.assignValueForLinkPropertyField((LinkPropertyField)value, data);
                continue;
            }
            SimplePropertyField spf = (SimplePropertyField)value;
            this.assignValueForSimplePropertyField(spf, data);
        }
    }

    private void assignValueForSimplePropertyField(SimplePropertyField spf, Map data) {
        DataToken dt = (DataToken)data.get(spf.getFileField());
        String val = dt.data.toString();
        if (spf.isNecessary() && StringUtils.isEmpty((String)val)) {
            String info = EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "necessaryFields", this.ctx.getLocale());
            throw new RuntimeException(spf.getFileField() + " " + info);
        }
        spf.setPropValue(val);
    }

    private void settleDownLinkPropertyField(HashMap pfMap, PropertyField pf) {
        int level = pf.getPropLevel();
        String longNumber = pf.getLongNumber();
        String[] numbers = this.getNumbersByLongNumber(longNumber);
        int parentLevel = level - 1;
        String parentNumber = "";
        for (int i = 0; i < level; ++i) {
            parentNumber = parentNumber + numbers[i];
        }
        int size = this.propMap.size();
        LinkPropertyField cestorField = null;
        for (int i = 0; i < size; ++i) {
            PropertyField tmpPf = (PropertyField)this.propMap.get(i);
            String tmpPfLongNumber = tmpPf.getLongNumber();
            if (parentLevel != tmpPf.getPropLevel() || !parentNumber.equals(tmpPfLongNumber == null ? null : tmpPfLongNumber.replace(".", ""))) continue;
            cestorField = (LinkPropertyField)tmpPf;
        }
        LinkPropertyField parentField = cestorField;
        parentField.addChild(pf);
    }

    private String getKey(PropertyField pf) {
        String twostr;
        String field = pf.getFileField();
        String locale = "";
        if (field != null && field.length() > 2 && ((twostr = field.substring(field.length() - 2, field.length())).equalsIgnoreCase("l1") || twostr.equalsIgnoreCase("l2") || twostr.equalsIgnoreCase("l3"))) {
            locale = twostr;
        }
        return pf.getPropLevel() + "_" + pf.getPropName() + "_" + locale;
    }

    private String getLongNumber(String[] numbers, int count) {
        if (numbers == null || numbers.length < count) {
            throw new IllegalArgumentException("count" + count + " is large than numbers lenght");
        }
        StringBuffer longNumber = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            longNumber.append(numbers[i]);
            if (i == count - 1) continue;
            longNumber.append(".");
        }
        return longNumber.toString();
    }

    private String[] getNumbersByLongNumber(String longNumber) {
        return longNumber.split(this.longNumberSplitStr);
    }

    private SimplePropertyField getSimplePropertyField(String propClass, int propLevel, String propName, String propValue, PropertyField parentPropertyField) {
        SimplePropertyField propField = new SimplePropertyField();
        propField.setSimpleClassProp(true);
        propField.setParentPropertyField(parentPropertyField);
        propField.setPropClass(propClass);
        propField.setPropLevel(propLevel);
        propField.setPropName(propName);
        return propField;
    }

    private DIETemplateFieldEntryInfo getPropName(String templateFieldName) {
        if (this.propFileMap == null) {
            this.propFileMap = new HashMap(5);
            this.FileFieldSet = new HashSet();
            DIETemplateFieldEntryCollection coll = this.templateInfo.getFieldEntries();
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                DIETemplateFieldEntryInfo entryInfo = coll.get(i);
                this.propFileMap.put(entryInfo.getNumber(), entryInfo);
                this.FileFieldSet.add(entryInfo.getNumber());
            }
        }
        return (DIETemplateFieldEntryInfo)this.propFileMap.get(templateFieldName);
    }

    private String getPropAllClassName(String propName) {
        DIETemplateFieldEntryCollection coll = this.templateInfo.getFieldEntries();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            DIETemplateFieldEntryInfo tmp = coll.get(i);
            if (tmp == null || !tmp.isIsAutoMapping() || tmp.getEntityPropName() == null || !tmp.getEntityPropName().equals(propName)) continue;
            return tmp.getEntityPropClass();
        }
        return null;
    }

    private Object getValueObject(PropertyField propField) throws TaskExternalException {
        if (propField.isSimpleClassProp()) {
            return this.getSimpleValueObject((SimplePropertyField)propField);
        }
        return this.getLinkValueObject((LinkPropertyField)propField);
    }

    private Object getSimpleValueObject(SimplePropertyField propField) throws TaskExternalException {
        return SimpleClassValueProvider.getValueObject(propField, this.eoInfo);
    }

    private CoreBaseInfo getLinkValueObject(LinkPropertyField propField) throws TaskExternalException {
        return InfoClassValueProvider.getValueObject(propField, this.eoInfo);
    }

    public CoreBaseInfo getDynValueClass() throws TaskExternalException {
        if (this.eoInfo == null) {
            IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)this.ctx);
            this.eoInfo = loader.getEntity(this.getBOSObjectType(this.type));
        }
        String valueClassName = this.eoInfo.getObjectValueClass();
        CoreBaseInfo info = null;
        try {
            Class<?> c = Class.forName(valueClassName);
            Constructor<?> cst = c.getConstructor(null);
            info = (CoreBaseInfo)cst.newInstance(null);
            PropertyCollection properties = this.eoInfo.getProperties();
            int size = properties.size();
            for (int i = 0; i < size; ++i) {
                PropertyInfo propertyInfo = properties.get(i);
                if (!propertyInfo.isConfigured() || !this.isEntry(propertyInfo)) continue;
                info.put(propertyInfo.getName(), (Object)new BillEntryCustomCollection());
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            if (e instanceof ClassNotFoundException) {
                throw new TaskExternalException(EASCommonResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"26_UserDefineImportUI", (Locale)this.ctx.getLocale()));
            }
            throw new TaskExternalException("", (Throwable)e);
        }
        return info;
    }

    public boolean isEntry(PropertyInfo property) {
        if (property instanceof LinkPropertyInfo) {
            RelationshipInfo relationship = ((LinkPropertyInfo)property).getRelationship();
            if (this.eoInfo == null) {
                IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)this.ctx);
                this.eoInfo = loader.getEntity(this.getBOSObjectType(this.type));
            }
            if (!relationship.isReverseLink(this.eoInfo) && (Boolean.TRUE.toString().equalsIgnoreCase(property.getExtendedProperty("isEntries")) || relationship != null && relationship.getClientObject() != null && RelationshipType.COMPOSITION.equals((Object)relationship.getType()) && (CardinalityType.ONE.equals((Object)relationship.getClientCardinality()) || CardinalityType.ZERO_TO_ONE.equals((Object)relationship.getClientCardinality())) && (CardinalityType.ZERO_TO_UNBOUNDED.equals((Object)relationship.getSupplierCardinality()) || CardinalityType.ONE_TO_UNBOUNDED.equals((Object)relationship.getSupplierCardinality())))) {
                return true;
            }
        }
        return false;
    }

    private BOSObjectType getBOSObjectType(String bosType) {
        return BOSObjectType.create((String)bosType);
    }

    public DIETemplateInfo getTemplateInfo() {
        return this.templateInfo;
    }

    public void setTemplateInfo(DIETemplateInfo templateInfo) {
        this.templateInfo = templateInfo;
        this.type = templateInfo.getEntityBosType();
    }

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public String getIDOfSamePrimaryKey(CoreBaseInfo info) {
        String id = null;
        return id;
    }

    public int getEntryRowIndex() {
        return this.entryRowIndex;
    }

    public void setEntryRowIndex(int entryRowIndex) {
        this.entryRowIndex = entryRowIndex;
    }

    public boolean isCodeImplementTrans() {
        return this.isCodeImplementTrans;
    }

    public void setCodeImplementTrans(boolean isCodeImplementTrans) {
        this.isCodeImplementTrans = isCodeImplementTrans;
    }

    public boolean isUserDefineTrans() {
        return this.isUserDefineTrans;
    }

    public void setUserDefineTrans(boolean isUserDefineTrans) {
        this.isUserDefineTrans = isUserDefineTrans;
    }

    public Map<BOSObjectType, ObjectUuidPK> getDelOldEntrys() {
        return this.delOldEntrys;
    }
}

