/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.export;

import com.kingdee.eas.tools.datatask.export.AbstractExternalExcel2007SheetWriter;
import com.kingdee.eas.tools.datatask.export.Excel2007Writer;
import com.kingdee.eas.tools.datatask.runtime.ExternalStructInfo;
import com.kingdee.eas.tools.datatask.runtime.FieldPropertyInfo;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public class ExternalExcelSheetWriter
extends AbstractExternalExcel2007SheetWriter {
    private ExternalStructInfo structInfo;

    public ExternalExcelSheetWriter(Excel2007Writer excelWriter) {
        super(excelWriter);
    }

    @Override
    public void writeStruct(ExternalStructInfo structInfo) {
        this.structInfo = structInfo;
        super.writeStruct(structInfo);
        try {
            FieldPropertyInfo fpi;
            int i;
            int i2;
            ArrayList<FieldPropertyInfo> fields = structInfo.getFieldCollection();
            int size = fields.size();
            this.insertRow(0);
            this.addOrgStructCell(0, structInfo.getProductName());
            this.addOrgStructCell(1, structInfo.getVersion());
            this.addTitleCell(2, structInfo.getObjectDesc());
            for (i2 = 3; i2 < size; ++i2) {
                this.addTitleCell(i2, "");
            }
            this.endRow();
            this.insertRow(1);
            this.addOrgStructCell(0, structInfo.getObjectName());
            this.addOrgStructCell(1, structInfo.getObjectDesc());
            for (i2 = 2; i2 < size; ++i2) {
                this.addTitleCell(i2, "");
            }
            this.endRow();
            this.insertRow(2);
            XSSFDrawing p = this.sheet.createDrawingPatriarch();
            for (i = 0; i < size; ++i) {
                fpi = (FieldPropertyInfo)fields.get(i);
                this.addOrgStructCell(i, fpi.getFieldName());
                if (StringUtils.isEmpty((String)fpi.getFiledMemo())) continue;
                this.isHasComment = true;
                Comment comment = null;
                comment = i <= 2 ? p.createCellComment((ClientAnchor)new XSSFClientAnchor(0, 0, 0, 0, 7, 7, 10, 10)) : p.createCellComment((ClientAnchor)new XSSFClientAnchor(0, 0, 0, 0, (int)((short)(3 + i)), 3 + i, (int)((short)(8 + i)), 8 + i));
                comment.setString((RichTextString)new XSSFRichTextString(fpi.getFiledMemo()));
                Cell cell = this.getCell((Sheet)this.sheet, 3, i);
                cell.setCellComment(comment);
            }
            this.endRow();
            this.insertRow(3);
            for (i = 0; i < size; ++i) {
                fpi = (FieldPropertyInfo)fields.get(i);
                String fieldDesc = fpi.getFieldDesc();
                if (fpi.getIsNecessary()) {
                    fieldDesc = "*" + fieldDesc;
                    this.addOrgStructCell1(i, fieldDesc, true);
                    continue;
                }
                this.addOrgStructCell1(i, fieldDesc, false);
            }
            this.endRow();
            this.curRowNum = 4;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected List<String> getFieldOrder() {
        ArrayList<String> rs = new ArrayList<String>();
        ArrayList<FieldPropertyInfo> fields = this.structInfo.getFieldCollection();
        this.orderByColNumber(fields);
        for (FieldPropertyInfo fpi : fields) {
            rs.add(fpi.getFieldName());
        }
        return rs;
    }

    @Override
    protected void megeCell() throws IOException {
        int size = this.structInfo.getFieldCollection().size();
        size = size < 3 ? 3 : size;
        this.beginMergeCells(1);
        this.mergeCell(0, 2, 1, size - 1);
        this.endMergeCells();
    }
}

