/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.export;

import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.export.Excel2007SheetErrorWriter;
import com.kingdee.eas.tools.datatask.export.Excel2007Writer;
import com.kingdee.eas.tools.datatask.export.IExternalExcelDataWriter;
import com.kingdee.eas.tools.datatask.record.IRecord;
import com.kingdee.eas.tools.datatask.record.RecordCollection;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.tools.datatask.task.util.ExcelParam;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MultiExcel2007SheetErrorManager {
    private Map<String, ExcelParam> expMap;
    private Set<String> sheets = new HashSet<String>();
    private Set<String> excels = new HashSet<String>();
    private Map<String, IExternalExcelDataWriter> errSheetWriterMap = new HashMap<String, IExternalExcelDataWriter>();

    public MultiExcel2007SheetErrorManager(Map<String, ExcelParam> expMap) {
        this.expMap = expMap;
    }

    public MultiExcel2007SheetErrorManager(ExcelParam exp) {
        this.expMap = new HashMap<String, ExcelParam>(1);
        this.expMap.put(exp.getTaskParam().getFileUuId(), exp);
    }

    public void writeErrSheet(RecordCollection coll) throws TaskRunnerException {
        for (IRecord rec : coll) {
            this.writeErrSheet(rec);
        }
    }

    public void writeErrSheet(IRecord rec) throws TaskRunnerException {
        String errMsg = EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"notImport");
        this.writeErrSheet(errMsg, rec);
    }

    public void writeErrSheet(String errMsg, IRecord rec) throws TaskRunnerException {
        String errFieldDesc;
        String fileUuId = rec.getFileUuId();
        int sheetId = rec.getSheetId();
        String _sheet_flag = fileUuId + "_" + sheetId;
        ExcelParam exp = this.expMap.get(fileUuId);
        if (!this.excels.contains(fileUuId)) {
            exp.getExcelWriter().initWb();
            this.excels.add(fileUuId);
        }
        if (!this.sheets.contains(_sheet_flag)) {
            DatataskParameter taskParam = exp.getTaskParam();
            String sheetName = taskParam.getSheetIdAndName().get(sheetId);
            Excel2007SheetErrorWriter errSheetWriter = new Excel2007SheetErrorWriter(exp.getExcelWriter());
            exp.getExcelWriter().addErrSheet(sheetId);
            errSheetWriter.setSheetName(sheetName);
            errSheetWriter.openWriter();
            errSheetWriter.setDimension(5, exp.getStructMap().get(sheetId).getFieldCollection().size());
            errSheetWriter.writeStruct(exp.getStructMap().get(sheetId));
            this.sheets.add(_sheet_flag);
            this.errSheetWriterMap.put(_sheet_flag, errSheetWriter);
        }
        DataToken value = new DataToken();
        value.name = "ErrorReason";
        value.desc = errFieldDesc = EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"errorReason");
        value.data = errMsg;
        rec.put(value.name, value);
        this.errSheetWriterMap.get(_sheet_flag).writeLine(rec.getMap());
    }

    public void closeALLExcelSheet() throws TaskRunnerException {
        for (IExternalExcelDataWriter sheetWriter : this.errSheetWriterMap.values()) {
            sheetWriter.closeWriter();
        }
    }

    public void setIsImported(String fileUuId) {
        ExcelParam exp = this.expMap.get(fileUuId);
        Excel2007Writer errExcelWriter = exp.getExcelWriter();
        errExcelWriter.setImported();
    }
}

