/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.log;

import com.kingdee.eas.tools.datatask.log.ILog;
import com.kingdee.eas.tools.datatask.log.ILogMultiFileManager;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TaskLogMultiFileManager
implements ILogMultiFileManager {
    private static final TaskLogMultiFileManager instance = new TaskLogMultiFileManager();
    private static final ConcurrentHashMap<String, ILog> logMap = new ConcurrentHashMap();

    private TaskLogMultiFileManager() {
    }

    public static TaskLogMultiFileManager getInstance() {
        return instance;
    }

    @Override
    public ILog putLog(ILog log) {
        ILog _log = logMap.putIfAbsent(log.getLogUuID() + "_" + log.getFileUuID(), log);
        if (_log == null) {
            _log = log;
        }
        return _log;
    }

    @Override
    public ILog getLog(String uuid, String fileUuid) {
        return logMap.get(uuid + "_" + fileUuid);
    }

    @Override
    public List<ILog> getLogByTask(String taskUuId) {
        ArrayList<ILog> rs = new ArrayList<ILog>();
        for (Map.Entry<String, ILog> entry : logMap.entrySet()) {
            String logUuId = entry.getKey();
            if (logUuId.indexOf(taskUuId) <= -1) continue;
            rs.add(entry.getValue());
        }
        return rs;
    }

    @Override
    public void clearLog(String uuid) {
        Enumeration<String> keys = logMap.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (key.indexOf(uuid) <= -1) continue;
            logMap.remove(key);
        }
    }
}

