/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.runtime;

import com.kingdee.eas.tools.datatask.IFileInfo;
import com.kingdee.eas.tools.datatask.runtime.ExternalDataRowInfo;
import com.kingdee.eas.tools.datatask.runtime.ExternalStructInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ExcelInfo
implements IFileInfo {
    private String fileName;
    private String fileUuId;
    private final ConcurrentHashMap<Integer, ExcelSheetInfo> sheetList = new ConcurrentHashMap();

    public ExcelInfo(String fileUuId, String fileName) {
        this.fileName = fileName;
        this.fileUuId = fileUuId;
    }

    public ExcelSheetInfo get(int sheetId) {
        return this.sheetList.get(sheetId);
    }

    public ExcelSheetInfo get(String sheetName) {
        for (Map.Entry<Integer, ExcelSheetInfo> entry : this.sheetList.entrySet()) {
            ExcelSheetInfo sheetInfo = entry.getValue();
            String _sheetName = sheetInfo.getSheetName();
            if (!_sheetName.equals(sheetName)) continue;
            return sheetInfo;
        }
        return null;
    }

    public List<ExcelSheetInfo> getBySolution(String solution) {
        ArrayList<ExcelSheetInfo> list = new ArrayList<ExcelSheetInfo>();
        for (Map.Entry<Integer, ExcelSheetInfo> entry : this.sheetList.entrySet()) {
            ExcelSheetInfo sheetInfo = entry.getValue();
            String _solution = sheetInfo.getStructInfo().getObjectName();
            if (!_solution.equals(solution)) continue;
            list.add(sheetInfo);
        }
        return list;
    }

    public void add(int sheetId, ExcelSheetInfo excelSheetInfo) {
        this.sheetList.putIfAbsent(sheetId, excelSheetInfo);
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public String getFileUuId() {
        return this.fileUuId;
    }

    public void setFileUuId(String fileUuId) {
        this.fileUuId = fileUuId;
    }

    public List<ExcelSheetInfo> getSheetList() {
        ArrayList<ExcelSheetInfo> list = new ArrayList<ExcelSheetInfo>();
        Iterator<ExcelSheetInfo> iter = this.sheetList.values().iterator();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    public class ExcelSheetInfo {
        private String sheetName;
        private int sheetId;
        private int rowCount;
        private String templateNo;
        private ExternalStructInfo structInfo = new ExternalStructInfo();
        private ExternalDataRowInfo rowInfo = new ExternalDataRowInfo();

        public ExcelSheetInfo(int sheetId, String sheetName) {
            this.sheetId = sheetId;
            this.sheetName = sheetName;
        }

        public String getSheetName() {
            return this.sheetName;
        }

        public void setSheetName(String sheetName) {
            this.sheetName = sheetName;
        }

        public int getSheetId() {
            return this.sheetId;
        }

        public void setSheetId(int sheetId) {
            this.sheetId = sheetId;
        }

        public int getRowCount() {
            return this.rowCount;
        }

        public void setRowCount(int rowCount) {
            this.rowCount = rowCount - 4;
        }

        public String getTemplateNo() {
            return this.templateNo;
        }

        public void setTemplateNo(String templateNo) {
            this.templateNo = templateNo;
        }

        public ExternalStructInfo getStructInfo() {
            return this.structInfo;
        }

        public void setStructInfo(ExternalStructInfo structInfo) {
            this.structInfo = structInfo;
        }

        public ExternalDataRowInfo getRowInfo() {
            return this.rowInfo;
        }

        public void setRowInfo(ExternalDataRowInfo rowInfo) {
            this.rowInfo = rowInfo;
        }
    }
}

