/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.runtime;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.message.util.StringUtil;
import com.kingdee.eas.base.param.NantionalServiceFacadeFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.ss.usermodel.Cell;

public class ExcelUtil {
    private static Logger logger = Logger.getLogger(ExcelUtil.class);
    public static String dateFormatString = null;

    public static boolean isBlankRow(HSSFCell[] cells) {
        if (cells == null || cells.length <= 0) {
            return true;
        }
        for (int i = 0; i < cells.length; ++i) {
            if (StringUtils.isEmpty((String)ExcelUtil.getCellValue(cells[i]))) continue;
            return false;
        }
        return true;
    }

    public static String getCellValue(HSSFCell cell) {
        if (cell == null) {
            return "";
        }
        switch (cell.getCellType()) {
            case STRING: {
                return cell.getStringCellValue() == null ? "" : cell.getStringCellValue().trim();
            }
            case NUMERIC: {
                double d = cell.getNumericCellValue();
                if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                    Date cal = HSSFDateUtil.getJavaDate((double)d);
                    return ExcelUtil.getStringByDate(cal);
                }
                BigDecimal bd = new BigDecimal(new Double(d).toString());
                String s = bd.toString();
                if (s.endsWith(".0")) {
                    s = s.substring(0, s.length() - 2);
                }
                return s;
            }
            case FORMULA: {
                String valueStr = null;
                valueStr = cell.getStringCellValue();
                if (valueStr != null && valueStr.trim().length() > 0) {
                    return valueStr.trim();
                }
                double value = cell.getNumericCellValue();
                BigDecimal bd = new BigDecimal(new Double(value).toString());
                valueStr = bd.toString();
                if (valueStr.endsWith(".0")) {
                    valueStr = valueStr.substring(0, valueStr.length() - 2);
                }
                return valueStr;
            }
            case BOOLEAN: {
                return String.valueOf(cell.getBooleanCellValue());
            }
            case BLANK: {
                return "";
            }
        }
        return cell.getStringCellValue() == null ? "" : cell.getStringCellValue().trim();
    }

    private static String getStringByDate(Date d) {
        Calendar cl = Calendar.getInstance();
        cl.setTime(d);
        String fix = "-";
        StringBuffer dateStr = new StringBuffer();
        dateStr.append(cl.get(1));
        dateStr.append(fix);
        int month = cl.get(2) + 1;
        if (month < 10) {
            dateStr.append("0");
        }
        dateStr.append(month);
        dateStr.append(fix);
        int day = cl.get(5);
        if (day < 10) {
            dateStr.append("0");
        }
        dateStr.append(day);
        return dateStr.toString();
    }

    public static Date formatNationalDate(Context ctx, String dateStr) {
        if (StringUtil.isEmpty((String)dateStr)) {
            return null;
        }
        HashMap nationmap = null;
        try {
            nationmap = NantionalServiceFacadeFactory.getLocalInstance((Context)ctx).getNationalConfig(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString(), ctx.getLocale().toString());
            SimpleDateFormat dtformat = (SimpleDateFormat)nationmap.get("dateFormat");
            dateFormatString = dtformat.toPattern();
            if (dateStr.length() == dateFormatString.length()) {
                return dtformat.parse(dateStr);
            }
            dtformat = (SimpleDateFormat)nationmap.get("dateTimeFormat");
            return dtformat.parse(dateStr);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        catch (ParseException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String getDateFomartString(Context ctx) {
        if (dateFormatString == null) {
            HashMap nationmap = null;
            try {
                nationmap = NantionalServiceFacadeFactory.getLocalInstance((Context)ctx).getNationalConfig(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString(), ctx.getLocale().toString());
                SimpleDateFormat dtformat = (SimpleDateFormat)nationmap.get("dateFormat");
                dateFormatString = dtformat.toPattern();
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                return null;
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                return null;
            }
        }
        return dateFormatString;
    }

    public static String formatNationalTime(Context ctx, Object dateStr) {
        if (dateStr == null) {
            return "";
        }
        String param = "";
        HashMap nationmap = null;
        try {
            nationmap = NantionalServiceFacadeFactory.getLocalInstance((Context)ctx).getNationalConfig(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString(), ctx.getLocale().toString());
            SimpleDateFormat dtformat = null;
            if (dateStr instanceof Timestamp) {
                dtformat = (SimpleDateFormat)nationmap.get("dateTimeFormat");
            } else if (dateStr instanceof Date) {
                dtformat = (SimpleDateFormat)nationmap.get("dateFormat");
            }
            if (null != dtformat) {
                param = dtformat.format(dateStr);
            }
            return param;
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static int getRowIndex(String rowStr) {
        rowStr = rowStr.replaceAll("[^A-Z]", "");
        byte[] rowAbc = rowStr.getBytes();
        int len = rowAbc.length;
        float num = 0.0f;
        for (int i = 0; i < len; ++i) {
            num = (float)((double)num + (double)(rowAbc[i] - 65 + 1) * Math.pow(26.0, len - i - 1));
        }
        return (int)num;
    }

    public static int getSheetRowCount(String dim) {
        dim = dim.replaceAll("[A-Z]", "");
        int num = 0;
        num = dim.indexOf(":") > -1 ? Integer.parseInt(dim.substring(dim.indexOf(":") + 1)) : Integer.parseInt(dim);
        return num;
    }

    public static String getDimension(int rowspan, int colspan) {
        if (rowspan == 0 || colspan == 0) {
            return "";
        }
        if (colspan == 1) {
            return "A" + rowspan;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        ArrayList<Integer> flag = new ArrayList<Integer>();
        while (colspan > 26) {
            int quotient = colspan / 26;
            int remainder = colspan % 26;
            if (remainder == 0) {
                list.add(25);
                flag.add(1);
            } else {
                list.add(remainder);
                flag.add(0);
            }
            colspan = --quotient;
        }
        if (colspan > 0) {
            list.add(colspan);
            flag.add(0);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = list.size() - 1; i >= 0; --i) {
            int number = (Integer)list.get(i);
            int increment = (Integer)flag.get(i);
            sb.append((char)(64 + number + increment));
        }
        return "A1:" + sb.toString() + rowspan;
    }

    public static void main(String[] args) {
        int rowspan = 10;
        int colspan = ExcelUtil.getRowIndex("A");
        String dim = ExcelUtil.getDimension(rowspan, colspan);
        System.out.println(colspan);
        System.out.println(dim);
    }
}

