/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.task;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.tools.datatask.util.EASResourceJoinUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class CheckUtil {
    private static Logger logger = Logger.getLogger(CheckUtil.class);

    public static int getSqlRowCount(Context ctx, String selectSql) throws BOSException {
        if (selectSql.indexOf("from ") >= 0) {
            selectSql = selectSql.substring(selectSql.indexOf("from "), selectSql.length());
        } else if (selectSql.indexOf("FROM ") >= 0) {
            selectSql = selectSql.substring(selectSql.indexOf("FROM "), selectSql.length());
        }
        if (selectSql.indexOf("order by") >= 0) {
            selectSql = selectSql.substring(0, selectSql.indexOf("order by"));
        } else if (selectSql.indexOf("ORDER BY") >= 0) {
            selectSql = selectSql.substring(0, selectSql.indexOf("ORDER BY"));
        }
        String rowCountsql = "select count(*) as sqlrowcount " + selectSql;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)rowCountsql);
            if (rs.next()) {
                return rs.getInt("sqlrowcount");
            }
        }
        catch (BOSException e) {
            logger.error((Object)"sql execute error", (Throwable)e);
            throw new BOSException("Sql execute exception : " + rowCountsql, (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)"sql execute error", (Throwable)e);
            throw new BOSException("Sql execute exception : " + rowCountsql, (Throwable)e);
        }
        return Integer.MAX_VALUE;
    }

    public static void isSqlRowCountValid(Context ctx, String selectSql, int maxRowCount) throws BOSException, TaskRunnerException {
        if (CheckUtil.getSqlRowCount(ctx, selectSql) > maxRowCount) {
            throw new TaskRunnerException(4, EASResourceJoinUtil.getString("com.kingdee.eas.tools.datatask.DatataskResource", "exportrecordtoolarge", new Object[]{60000}));
        }
    }
}

