/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.task;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.freechart.util.Log;
import com.kingdee.bos.dao.AbstractBaseObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.framework.AbstractCoreBillEntryBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.DefaultDataTransmission;
import com.kingdee.eas.tools.datatask.ErrorHandleModeEnum;
import com.kingdee.eas.tools.datatask.IDataTransmission;
import com.kingdee.eas.tools.datatask.TaskStateEnum;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.export.ExternalExcelDataWriter;
import com.kingdee.eas.tools.datatask.export.IExternalDataWriter;
import com.kingdee.eas.tools.datatask.log.SysLog;
import com.kingdee.eas.tools.datatask.log.TaskLog;
import com.kingdee.eas.tools.datatask.log.TaskLogUtil;
import com.kingdee.eas.tools.datatask.runtime.AbstractExternalDataReader;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.tools.datatask.runtime.ExcelXErrorDataWriter;
import com.kingdee.eas.tools.datatask.runtime.ExternalExcelDataReader;
import com.kingdee.eas.tools.datatask.runtime.ExternalExcelXDataReader;
import com.kingdee.eas.tools.datatask.runtime.ExternalStructInfo;
import com.kingdee.eas.tools.datatask.task.BlockDataInfo;
import com.kingdee.eas.tools.datatask.task.FileUtil;
import com.kingdee.eas.tools.datatask.task.ITask;
import com.kingdee.eas.tools.datatask.task.ITaskRunnerAdapter;
import com.kingdee.eas.tools.datatask.task.InspectorCreator;
import com.kingdee.eas.tools.datatask.task.ReaderUtil;
import com.kingdee.eas.tools.datatask.task.TaskExternalCode;
import com.kingdee.eas.tools.datatask.task.TaskUtil;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.tools.datatask.util.EASServerResource;
import com.kingdee.eas.util.client.EASResource;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class MultiSheetTaskExternalCodeRunner
implements ITaskRunnerAdapter {
    private static Logger logger = SysLog.getLogger(MultiSheetTaskExternalCodeRunner.class);
    private static final String ERROR_REASON = "ErrorReason";
    private static final String SEQ_KEY = "FSeq";
    private Context ctx;
    private List<ITask> tasks;
    protected TaskLog tl;
    private ITask currentTask;
    private AbstractExternalDataReader reader;
    private IExternalDataWriter errDataWriter;
    private ErrorHandleModeEnum errorHandleMode = ErrorHandleModeEnum.ReturnRightnow;
    private IDataTransmission iDataTrans;
    private DefaultDataTransmission defaultTrans = null;
    private boolean stopOnError = false;
    private boolean isCodeImplementTrans = true;
    private boolean isUserDefineTrans = false;
    private int submitType = 0;
    private Map hsData;
    private BlockDataInfo bdInfo = null;
    protected int nCurCount;
    protected int nSuccessCount;
    protected int nFailCount;
    protected int nBlankCount;
    private int currentSeqFor_SUMITSINGLERECTYPE = 0;
    private Map previousData = null;
    private boolean needSetRowStartNumber = true;

    public MultiSheetTaskExternalCodeRunner(List<ITask> tasks, Context ctx) {
        this.tasks = tasks;
        this.ctx = ctx;
    }

    @Override
    public void run() {
        try {
            Iterator<ITask> iterator = this.tasks.iterator();
            while (iterator.hasNext()) {
                ITask task;
                this.currentTask = task = iterator.next();
                this.taskStart();
                this.doRun();
                this.taskEnd();
                if (!this.stopOnError) continue;
                break;
            }
        }
        catch (TaskRunnerException e) {
            logger.error((Object)e);
            if (e.getExceptionCode() == 4) {
                String errMsg = this.getFatalError();
                this.tl.addException(errMsg, (Throwable)((Object)e), null);
                this.tl.setTaskState(TaskStateEnum.FAILEND);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            String errMsg = EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "fatalError", this.ctx.getLocale());
            if (e.getMessage() != null) {
                errMsg = errMsg + "\u3002" + e.getMessage();
            }
            this.tl.addException(errMsg, e, null);
            this.tl.setTaskState(TaskStateEnum.FAILEND);
        }
        finally {
            this.finish();
        }
    }

    private void taskStart() throws TaskRunnerException {
        InputStream is = null;
        try {
            TaskExternalCode taskCode = (TaskExternalCode)this.currentTask;
            DatataskParameter dp = (DatataskParameter)taskCode.getTaskParameter();
            String fileType = dp.getFileType();
            String fileName = dp.getOpenFileName();
            Locale locale = this.ctx.getLocale();
            String alias = dp.getAlias();
            ExternalStructInfo structInfo = taskCode.getExternalStructInfo();
            is = FileUtil.getServerTmpFileStream(dp.getOpenFileName());
            this.reader = ReaderUtil.buildReader(fileType, fileName, locale, alias, is, structInfo);
            this.needSetRowStartNumber = true;
            this.initErrorWriter();
            this.errorHandleMode = dp.getContextParam().get("errorHandleMode") != null ? (ErrorHandleModeEnum)((Object)dp.getContextParam().get("errorHandleMode")) : ErrorHandleModeEnum.ReturnWhenFinish;
            if (this.tl == null) {
                this.tl = new TaskLog(0);
                this.tl.setLogUuID(taskCode.getTaskUuID());
                this.tl.setTaskState(TaskStateEnum.INITTASK);
                TaskLogUtil.putLog(this.tl);
            }
            this.isCodeImplementTrans = TaskUtil.isCodeImplementTrans(taskCode);
            this.isUserDefineTrans = TaskUtil.isUserDefineTrans(taskCode);
            if (this.isCodeImplementTrans) {
                this.iDataTrans = this.createDataTransmissionObject(taskCode);
            }
            this.defaultTrans = new DefaultDataTransmission(this.ctx);
            this.defaultTrans.setDIETemplateInfo(taskCode.getDIETemplateInfo());
            this.defaultTrans.setContext(this.ctx);
            this.defaultTrans.setCodeImplementTrans(this.isCodeImplementTrans);
            this.defaultTrans.setUserDefineTrans(this.isUserDefineTrans);
            HashMap<String, Integer> contextParam = new HashMap<String, Integer>();
            Map myParam = dp.getContextParam();
            if (myParam != null) {
                contextParam.putAll(myParam);
            }
            contextParam.put("DATATASKMODE", new Integer(dp.datataskMode));
            this.defaultTrans.setContextParameter(contextParam);
            this.submitType = this.iDataTrans != null ? this.iDataTrans.getSubmitType() : (this.defaultTrans != null ? this.defaultTrans.getSubmitType() : 0);
            this.stopOnError = false;
            this.nCurCount = 0;
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            String errorMsg = ex.getMessage();
            if (errorMsg == null || errorMsg.trim().length() == 0) {
                errorMsg = EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "notstandardtemplate", this.ctx.getLocale());
            }
            throw new TaskRunnerException(4, errorMsg, ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void initErrorWriter() throws TaskRunnerException {
        TaskExternalCode taskCode = (TaskExternalCode)this.currentTask;
        DatataskParameter dp = (DatataskParameter)taskCode.getTaskParameter();
        Locale locale = this.ctx.getLocale();
        ErrorHandleModeEnum errorHandleMode = (ErrorHandleModeEnum)((Object)dp.getContextParam().get("errorHandleMode"));
        if (errorHandleMode == ErrorHandleModeEnum.ReturnWhenFinish) {
            if (this.errDataWriter == null) {
                if (this.reader instanceof ExternalExcelXDataReader) {
                    ExcelXErrorDataWriter errDataWriter = new ExcelXErrorDataWriter();
                    this.errDataWriter = errDataWriter;
                    errDataWriter.setLocacle(locale);
                    errDataWriter.setFileName(dp.getErrDataFileName());
                    errDataWriter.setSheetName(dp.alias);
                    errDataWriter.openWriter();
                    errDataWriter.writeStruct(taskCode.getExternalStructInfo());
                } else if (this.reader instanceof ExternalExcelDataReader) {
                    ExternalExcelDataWriter errDataWriter = new ExternalExcelDataWriter();
                    this.errDataWriter = errDataWriter;
                    errDataWriter.setLocacle(locale);
                    errDataWriter.setFileName(dp.getErrDataFileName());
                    errDataWriter.setSheetName(dp.alias);
                    errDataWriter.openWriter();
                    errDataWriter.writeStruct(taskCode.getExternalStructInfo());
                }
            } else if (this.reader instanceof ExternalExcelXDataReader) {
                ExcelXErrorDataWriter errDataWriter = (ExcelXErrorDataWriter)this.errDataWriter;
                errDataWriter.setLocacle(locale);
                errDataWriter.setFileName(dp.getErrDataFileName());
                errDataWriter.setSheetName(dp.alias);
                errDataWriter.openWriter();
                errDataWriter.writeStruct(taskCode.getExternalStructInfo());
            } else if (this.reader instanceof ExternalExcelDataReader) {
                ExternalExcelDataWriter errDataWriter = (ExternalExcelDataWriter)this.errDataWriter;
                errDataWriter.setLocacle(locale);
                errDataWriter.setFileName(dp.getErrDataFileName());
                errDataWriter.setSheetName(dp.alias);
                errDataWriter.openWriter();
                errDataWriter.writeStruct(taskCode.getExternalStructInfo());
            }
        }
    }

    private void initErrorHandleMode() {
        TaskExternalCode taskCode = (TaskExternalCode)this.currentTask;
        DatataskParameter dp = (DatataskParameter)taskCode.getTaskParameter();
        this.errorHandleMode = dp.getContextParam().get("errorHandleMode") != null ? (ErrorHandleModeEnum)((Object)dp.getContextParam().get("errorHandleMode")) : ErrorHandleModeEnum.ReturnWhenFinish;
    }

    private void doRun() throws TaskRunnerException {
        if (this.submitType == 0) {
            this.runSingleSubmitType();
        } else if (this.submitType == 1) {
            this.runMultiSubmitType();
        }
    }

    private void runMultiSubmitType() throws TaskRunnerException {
        HashMap lastRow = new HashMap();
        while (!this.stopOnError && this.reader.hasNext()) {
            BlockDataInfo blockData;
            this.bdInfo = blockData = this.block(lastRow);
            int blockSize = blockData.getData().size();
            if (lastRow.isEmpty()) break;
            try {
                this.submitBlock(blockData.getData());
                this.nSuccessCount += blockSize;
                this.tl.setSuccessRecordCount(this.nSuccessCount);
            }
            catch (Exception e) {
                logger.error((Object)e);
                this.nFailCount += blockSize;
                this.tl.setFailRecordCount(this.nFailCount);
                this.tl.setTaskState(TaskStateEnum.FAILEND);
                this.onDataError(e);
            }
        }
        if (this.nFailCount <= 0) {
            this.tl.setTaskState(TaskStateEnum.SUCCESSEND);
        } else {
            this.tl.setTaskState(TaskStateEnum.FAILEND);
        }
        TaskLogUtil.putLog(this.tl);
    }

    private void taskEnd() {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    private void setSeq(Map blockData) {
        for (int seq = 0; seq < blockData.size(); ++seq) {
            if (!(blockData.get(seq) instanceof Map)) continue;
            Map entry = (Map)blockData.get(seq);
            if (seq == 0 && entry.containsKey(SEQ_KEY)) {
                return;
            }
            entry.put(SEQ_KEY, seq + 1);
        }
    }

    private int getCoreBaseInfoEntryIndexBySEQ(CoreBaseInfo coreBaseInfo, Map entry) {
        if (coreBaseInfo == null) {
            return -1;
        }
        Object entriesObj = coreBaseInfo.get("entries");
        if (entriesObj == null || !(entriesObj instanceof AbstractBaseObjectCollection)) {
            return -1;
        }
        AbstractBaseObjectCollection collection = (AbstractBaseObjectCollection)coreBaseInfo.get("entries");
        if (collection != null && collection.size() > 0) {
            Integer tempSeq = -1;
            try {
                Object seq = entry.get(SEQ_KEY);
                if (seq != null) {
                    tempSeq = seq instanceof DataToken ? (Integer)((DataToken)seq).data : (Integer)seq;
                }
            }
            catch (Exception e) {
                Log.error((Object)"TaskExternalCodeRunner can not get correct Fseq");
            }
            for (int i = 0; i < collection.size(); ++i) {
                AbstractCoreBillEntryBaseInfo entryInfo;
                IObjectValue obj = collection.getObject(i);
                if (!(obj instanceof AbstractCoreBillEntryBaseInfo) || (entryInfo = (AbstractCoreBillEntryBaseInfo)obj).getSeq() != tempSeq.intValue()) continue;
                return i;
            }
        }
        return -1;
    }

    protected void submitBlock(Map blockData) throws TaskRunnerException {
        this.setSeq(blockData);
        CoreBaseInfo coreBaseInfo = null;
        if (this.isCodeImplementTrans) {
            coreBaseInfo = this.iDataTrans.transmit(blockData, this.ctx);
            coreBaseInfo = InspectorCreator.attachCreator(coreBaseInfo, (Map)blockData.get(new Integer(0)), this.ctx);
        }
        if (this.isUserDefineTrans && this.isCodeImplementTrans) {
            int blockSize = blockData.size();
            for (int i = 0; i < blockSize; ++i) {
                Map entry = (Map)blockData.get(new Integer(i));
                int tempIndex = this.getCoreBaseInfoEntryIndexBySEQ(coreBaseInfo, entry);
                if (tempIndex != -1) {
                    this.defaultTrans.setCurrentEntryRowIndex(tempIndex);
                } else {
                    this.defaultTrans.setCurrentEntryRowIndex(i);
                }
                coreBaseInfo = this.defaultTrans.transmit(entry, coreBaseInfo);
            }
            this.iDataTrans.submit(coreBaseInfo, this.ctx);
        } else if (this.isUserDefineTrans && !this.isCodeImplementTrans) {
            int blockSize = blockData.size();
            for (int i = 0; i < blockSize; ++i) {
                this.defaultTrans.setCurrentEntryRowIndex(i);
                coreBaseInfo = this.defaultTrans.transmit((Map)blockData.get(new Integer(i)), coreBaseInfo);
            }
            this.defaultTrans.submit(coreBaseInfo, this.ctx);
        } else if (!this.isUserDefineTrans && this.isCodeImplementTrans) {
            this.iDataTrans.submit(coreBaseInfo, this.ctx);
        }
        this.nSuccessCount += blockData.size();
    }

    private BlockDataInfo block(Map lastRowData) throws TaskRunnerException {
        BlockDataInfo blockData = new BlockDataInfo();
        blockData.setStardRow(0);
        blockData.setEndRow(0);
        int i = 0;
        HashMap map = new HashMap();
        map.putAll(lastRowData);
        if (!lastRowData.isEmpty()) {
            blockData.getData().put(i, map);
            ++i;
        }
        int startRow = this.nCurCount;
        int endRow = this.nCurCount;
        while (this.reader.hasNext()) {
            Map hsData = this.reader.getNext();
            ++this.nCurCount;
            if (hsData == null) break;
            if (hsData.isEmpty()) continue;
            if (lastRowData.isEmpty()) {
                lastRowData.putAll(hsData);
            }
            if (!this.isSameBlock(hsData, lastRowData)) {
                lastRowData.clear();
                lastRowData.putAll(hsData);
                break;
            }
            blockData.getData().put(i, hsData);
            endRow = this.nCurCount;
            ++i;
        }
        blockData.setStardRow(startRow + 1);
        blockData.setEndRow(endRow);
        return blockData;
    }

    private boolean isSameBlock(Map firstRecordData, Map currentRecordData) {
        if (this.iDataTrans != null) {
            return this.iDataTrans.isSameBlock(firstRecordData, currentRecordData);
        }
        if (this.defaultTrans != null) {
            return this.defaultTrans.isSameBlock(firstRecordData, currentRecordData);
        }
        return false;
    }

    private IDataTransmission createDataTransmissionObject(TaskExternalCode taskCode) throws TaskRunnerException {
        IDataTransmission iObject = null;
        try {
            Class<?> classDefinition = Class.forName(taskCode.getDataTransmissionClassName());
            iObject = (IDataTransmission)classDefinition.newInstance();
            HashMap<String, Integer> contextParam = new HashMap<String, Integer>();
            DatataskParameter dp = (DatataskParameter)taskCode.getTaskParameter();
            Map myParam = dp.getContextParam();
            if (myParam != null) {
                contextParam.putAll(myParam);
            }
            contextParam.put("DATATASKMODE", new Integer(dp.datataskMode));
            iObject.setContextParameter(contextParam);
        }
        catch (Exception e) {
            logger.error((Object)e);
            String detail = EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"create") + taskCode.getDataTransmissionClassName() + EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"createException");
            detail = detail + e.getMessage();
            throw new TaskRunnerException(4, detail, e);
        }
        return iObject;
    }

    private void runSingleSubmitType() throws TaskRunnerException {
        while (this.reader.hasNext()) {
            Map hsData = this.reader.getNext();
            ++this.nCurCount;
            this.hsData = hsData;
            if (hsData == null || hsData.isEmpty()) break;
            try {
                this.submitSingle(hsData);
                ++this.nSuccessCount;
                this.tl.setSuccessRecordCount(this.nSuccessCount);
            }
            catch (Exception e) {
                logger.error((Object)e);
                ++this.nFailCount;
                this.tl.setFailRecordCount(this.nFailCount);
                this.tl.setTaskState(TaskStateEnum.FAILEND);
                this.onDataError(e);
            }
        }
        if (this.nFailCount <= 0) {
            this.tl.setTaskState(TaskStateEnum.SUCCESSEND);
        } else {
            this.tl.setTaskState(TaskStateEnum.FAILEND);
        }
        TaskLogUtil.putLog(this.tl);
    }

    private void submitSingle(Map hsData) throws TaskRunnerException {
        if (this.previousData == null) {
            this.previousData = hsData;
            this.currentSeqFor_SUMITSINGLERECTYPE = 1;
        } else if (this.isSameBlock(this.previousData, hsData)) {
            ++this.currentSeqFor_SUMITSINGLERECTYPE;
        } else {
            this.previousData = hsData;
            this.currentSeqFor_SUMITSINGLERECTYPE = 1;
        }
        Object seqObj = hsData.get(SEQ_KEY);
        if (seqObj != null) {
            try {
                int seq;
                this.currentSeqFor_SUMITSINGLERECTYPE = seq = Integer.parseInt(seqObj.toString());
            }
            catch (Exception seq) {
                // empty catch block
            }
        }
        CoreBaseInfo coreBaseInfo = null;
        if (this.isCodeImplementTrans) {
            coreBaseInfo = this.iDataTrans.transmit(hsData, this.ctx);
            coreBaseInfo = InspectorCreator.attachCreator(coreBaseInfo, hsData, this.ctx);
        }
        if (coreBaseInfo != null && coreBaseInfo.get("entries") != null) {
            int entryRowIndex = this.getCoreBaseInfoEntryIndexBySEQ(coreBaseInfo, hsData);
            if (entryRowIndex != -1) {
                this.defaultTrans.setCurrentEntryRowIndex(entryRowIndex);
            } else {
                this.defaultTrans.setCurrentEntryRowIndex(this.currentSeqFor_SUMITSINGLERECTYPE - 1);
            }
        }
        if (this.isUserDefineTrans && this.isCodeImplementTrans) {
            coreBaseInfo = this.defaultTrans.transmit(hsData, coreBaseInfo);
            this.iDataTrans.submit(coreBaseInfo, this.ctx);
        } else if (this.isUserDefineTrans && !this.isCodeImplementTrans) {
            coreBaseInfo = this.defaultTrans.transmit(hsData, coreBaseInfo);
            this.defaultTrans.submit(coreBaseInfo, this.ctx);
        } else if (!this.isUserDefineTrans && this.isCodeImplementTrans) {
            this.iDataTrans.submit(coreBaseInfo, this.ctx);
        }
    }

    protected String getMsgOnDataErr() {
        TaskExternalCode taskCode = (TaskExternalCode)this.currentTask;
        DatataskParameter dp = (DatataskParameter)taskCode.getTaskParameter();
        Locale locale = this.ctx.getLocale();
        StringBuilder sb = new StringBuilder().append(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "whenimportfile", locale)).append(dp.alias).append(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "somesheet", locale));
        String sheetName = sb.toString();
        int rowNumOfDataStart = this.reader.getExternalDataRowInfo().getRowOfDataStart();
        String rowNumber = String.valueOf(this.nCurCount + rowNumOfDataStart);
        if (this.bdInfo != null) {
            if (this.bdInfo.getStardRow() != this.bdInfo.getEndRow()) {
                int startRow = this.bdInfo.getStardRow() + rowNumOfDataStart;
                int endRow = this.bdInfo.getEndRow() + rowNumOfDataStart;
                rowNumber = String.valueOf(startRow + "-" + endRow);
            } else {
                int startRow = this.bdInfo.getStardRow() + rowNumOfDataStart;
                rowNumber = String.valueOf(startRow);
            }
        }
        return sheetName + EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "importNo", locale) + rowNumber + EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "lineData", locale);
    }

    protected String getFatalError() {
        TaskExternalCode taskCode = (TaskExternalCode)this.currentTask;
        DatataskParameter dp = (DatataskParameter)taskCode.getTaskParameter();
        Locale locale = this.ctx.getLocale();
        StringBuilder sb = new StringBuilder().append(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "whenimportfile", locale)).append(dp.alias).append(EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "somesheet", locale));
        String sheetName = sb.toString();
        return sheetName + EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "fatalError", locale);
    }

    protected boolean hasMoreRecord() throws TaskRunnerException {
        return this.reader.hasNext();
    }

    protected void dataErrorHandle(Throwable ex) {
        switch (this.errorHandleMode.getValue()) {
            case 1: {
                this.onDataErrorStop(ex);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.onDataErrorSkip(ex);
                break;
            }
            default: {
                this.onDataErrorStop(ex);
            }
        }
    }

    protected void onDataError(Throwable ex) throws TaskRunnerException {
        if (this.needSetRowStartNumber) {
            this.needSetRowStartNumber = false;
            int rowOfDataStart = this.reader.getExternalDataRowInfo().getRowOfDataStart();
            rowOfDataStart = rowOfDataStart < 0 ? 0 : rowOfDataStart;
            this.tl.setRowNumOfRecordStart(rowOfDataStart);
        }
        if (ex instanceof TaskRunnerException && ((TaskRunnerException)((Object)ex)).getExceptionCode() == 4) {
            throw (TaskRunnerException)((Object)ex);
        }
        String errMsg = this.getMsgOnDataErr();
        if (this.submitType == 1 && this.bdInfo != null) {
            int startRowNum = this.bdInfo.getStardRow();
            int endRowNum = this.bdInfo.getEndRow();
            Map<Object, Object> entryErrorReasons = new LinkedHashMap();
            if (ex instanceof TaskExternalException) {
                TaskExternalException tex = (TaskExternalException)((Object)ex);
                entryErrorReasons = tex.getEntryErrorReasons();
            }
            if (!entryErrorReasons.isEmpty()) {
                this.tl.setSupportEntryErrorReason(true);
                for (int i = startRowNum; i <= endRowNum; ++i) {
                    int entryIndex = i - startRowNum;
                    String errorReason = (String)entryErrorReasons.get(entryIndex);
                    errorReason = errorReason == null ? "" : errorReason;
                    this.tl.addException(errMsg, new Exception(errorReason), i);
                }
            } else {
                this.tl.addExceptionForBlock(errMsg, ex, startRowNum, endRowNum);
            }
        } else {
            this.tl.addException(errMsg, ex, this.nCurCount);
        }
        this.dataErrorHandle(ex);
    }

    protected void onDataErrorStop(Throwable ex) {
        this.stopOnError = true;
        if (this.reader instanceof ExternalExcelXDataReader) {
            ((ExternalExcelXDataReader)this.reader).interruptExcelXParseThread();
        }
    }

    protected void onDataErrorSkip(Throwable ex) {
        String errFieldDesc;
        DataToken value = new DataToken();
        value.name = ERROR_REASON;
        value.desc = errFieldDesc = EASServerResource.getString("com.kingdee.eas.tools.datatask.DatataskResource", "errorReason", this.ctx.getLocale());
        try {
            if (this.submitType == 1) {
                Map<Object, Object> entryErrorReasons = new LinkedHashMap();
                if (ex instanceof TaskExternalException) {
                    TaskExternalException tex = (TaskExternalException)((Object)ex);
                    entryErrorReasons = tex.getEntryErrorReasons();
                }
                for (int i = 0; i < this.bdInfo.getData().size(); ++i) {
                    String cellValue;
                    Map hsData = (Map)this.bdInfo.getData().get(i);
                    if (entryErrorReasons.isEmpty()) {
                        cellValue = ex.getMessage();
                        value.data = cellValue == null ? "" : cellValue.trim();
                        hsData.put(ERROR_REASON, value);
                    } else {
                        cellValue = (String)entryErrorReasons.get(i);
                        value.data = cellValue == null ? "" : cellValue.trim();
                        hsData.put(ERROR_REASON, value);
                    }
                    if (!this.containsField(this.errDataWriter, SEQ_KEY)) {
                        hsData.remove(SEQ_KEY);
                    }
                    this.errDataWriter.writeLine(hsData);
                }
            } else {
                int lastIndex = this.tl.getErrorDetailCount() - 1;
                String cellValue = this.tl.getErrorDetail(lastIndex);
                value.data = cellValue == null ? "" : cellValue.trim();
                this.hsData.put(ERROR_REASON, value);
                if (!this.containsField(this.errDataWriter, SEQ_KEY)) {
                    this.hsData.remove(SEQ_KEY);
                }
                this.errDataWriter.writeLine(this.hsData);
            }
        }
        catch (TaskRunnerException e) {
            logger.error((Object)e);
        }
    }

    private boolean containsField(IExternalDataWriter writer, String fieldName) {
        if (writer instanceof ExternalExcelDataWriter) {
            ExternalExcelDataWriter excelWriter = (ExternalExcelDataWriter)writer;
            return excelWriter.containsFieldName(fieldName);
        }
        if (writer instanceof ExcelXErrorDataWriter) {
            ExcelXErrorDataWriter excelXWriter = (ExcelXErrorDataWriter)writer;
            return excelXWriter.containsFieldName(fieldName);
        }
        return true;
    }

    protected void finish() {
        try {
            TaskLogUtil.putLog(this.tl);
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
            if (this.errDataWriter != null) {
                this.errDataWriter.closeWriter();
            }
            TaskExternalCode taskCode = (TaskExternalCode)this.currentTask;
            DatataskParameter dp = (DatataskParameter)taskCode.getTaskParameter();
            FileUtil.removeFile(dp.getOpenFileName());
        }
        catch (Exception e) {
            logger.warn((Object)e);
        }
    }

    @Override
    public void callRollbackProcess() throws Exception {
    }
}

