/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.task;

import com.kingdee.bos.Context;
import com.kingdee.eas.tools.datatask.log.SysLog;
import com.kingdee.eas.tools.datatask.task.ImpExpParam;
import com.kingdee.eas.tools.datatask.task.MultiExcelInfo;
import com.kingdee.eas.tools.datatask.task.MultitaskExportParse;
import com.kingdee.eas.tools.datatask.task.MultitaskImportParse;
import com.kingdee.eas.tools.datatask.task.util.TaskResult;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class MultitaskExcelSchedule {
    private static Logger logger = SysLog.getLogger(MultitaskExcelSchedule.class);
    private static final ExecutorService exec = Executors.newCachedThreadPool();
    private static final ConcurrentHashMap<String, Future<Boolean>> taskMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Boolean> doneMap = new ConcurrentHashMap();

    private MultitaskExcelSchedule() {
    }

    public static CompletionService<TaskResult> getCompletionSrv() {
        return new ExecutorCompletionService<TaskResult>(exec);
    }

    public static void addImportTask(String taskUuId, List<MultiExcelInfo> task, Map ctxParam, Context ctx) {
        try {
            Future<Boolean> fu = exec.submit(new MultitaskImportParse(taskUuId, task, ctxParam, ctx));
            taskMap.putIfAbsent(taskUuId, fu);
            doneMap.putIfAbsent(taskUuId, false);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public static void addExportTask(String taskUuId, List<ImpExpParam> exportParam, Map ctxParam, Context ctx) {
        try {
            Future<Boolean> fu = exec.submit(new MultitaskExportParse(taskUuId, exportParam, ctxParam, ctx));
            taskMap.putIfAbsent(taskUuId, fu);
            doneMap.putIfAbsent(taskUuId, false);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public static void stopTask(String taskUuId) {
        Future<Boolean> fu = taskMap.get(taskUuId);
        if (!fu.isDone()) {
            fu.cancel(true);
            taskMap.remove(taskUuId);
        }
    }

    public static boolean isDone(String taskUuId) {
        boolean rs = doneMap.get(taskUuId);
        if (rs) {
            doneMap.remove(taskUuId);
        }
        return rs;
    }

    public static ExecutorService getExec() {
        return exec;
    }

    public static void putDonemap(String taskUuId, boolean rs) {
        doneMap.put(taskUuId, rs);
    }
}

