/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.task;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.freechart.util.Log;
import com.kingdee.bos.dao.AbstractBaseObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.framework.AbstractCoreBillEntryBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tools.datatask.BlockDataTransmission;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.ErrorHandleModeEnum;
import com.kingdee.eas.tools.datatask.ExcelImportState;
import com.kingdee.eas.tools.datatask.TaskStateEnum;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.export.Excel2007SheetErrorManager;
import com.kingdee.eas.tools.datatask.export.MultiExcel2007SheetErrorManager;
import com.kingdee.eas.tools.datatask.log.ExcelTaskLog;
import com.kingdee.eas.tools.datatask.log.ILog;
import com.kingdee.eas.tools.datatask.log.TaskLogUtil;
import com.kingdee.eas.tools.datatask.record.IRecord;
import com.kingdee.eas.tools.datatask.record.RecordCollection;
import com.kingdee.eas.tools.datatask.record.RecordUtils;
import com.kingdee.eas.tools.datatask.runtime.BlockSplitInfo;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.tools.datatask.runtime.ExcelInfo;
import com.kingdee.eas.tools.datatask.runtime.ExternalExcelXDataReaderTask;
import com.kingdee.eas.tools.datatask.runtime.IDataReader;
import com.kingdee.eas.tools.datatask.task.AbstractTaskRunner;
import com.kingdee.eas.tools.datatask.task.ITask;
import com.kingdee.eas.tools.datatask.task.ITaskParameter;
import com.kingdee.eas.tools.datatask.task.InspectorCreator;
import com.kingdee.eas.tools.datatask.task.MultitaskExcelSchedule;
import com.kingdee.eas.tools.datatask.task.SuccessInfo;
import com.kingdee.eas.tools.datatask.task.util.ExcelParam;
import com.kingdee.eas.tools.datatask.task.util.TaskEnum;
import com.kingdee.eas.tools.datatask.task.util.TaskResult;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.tools.datatask.util.EASResourceJoinUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;

public class MultitaskImportExcelRunner
extends AbstractTaskRunner {
    private IDataReader dataReader;
    private RecordCollection curColl;
    private IRecord curRec = null;
    private List<BlockSplitInfo> splitList = new ArrayList<BlockSplitInfo>();
    private Map<Integer, Integer> recIndex = new HashMap<Integer, Integer>();
    private Map<String, ITaskParameter> taskParamMap;
    private boolean hasNext = true;
    private boolean isFinishedReader = false;
    private String logUuId;
    private String fileUuId;
    private String prevFileUuId;
    private Set<String> fileUuIdSet;
    private Excel2007SheetErrorManager errExcelSheetManager;
    private MultiExcel2007SheetErrorManager multiSheetErrorManager;
    private int blockSize;
    private List<String> sheets = new ArrayList<String>(2);
    private Map<String, Boolean> fileMap = new HashMap<String, Boolean>();
    private String taskRsKey;
    private ErrorHandleModeEnum errMode;
    private AtomicBoolean isCancel = new AtomicBoolean(false);
    private BlockingQueue<TaskResult> interruptTaskRs;
    private Future<TaskResult> fReader;
    private Map<String, ExcelParam> shareParams;
    private List entryInfos;
    public static final String SEQ_KEY = "FSeq";

    public MultitaskImportExcelRunner(ITask taskCode, Map<String, ExcelParam> expMap, Context ctx, BlockingQueue<TaskResult> interruptTaskRs) {
        super(taskCode, ctx);
        this.dataReader = new ExternalExcelXDataReaderTask(expMap);
        ((ExternalExcelXDataReaderTask)this.dataReader).setImportRunner(this);
        this.taskParamMap = taskCode.getTaskParameterMap();
        this.errExcelSheetManager = new Excel2007SheetErrorManager(expMap);
        this.interruptTaskRs = interruptTaskRs;
        this.fileUuIdSet = expMap.keySet();
        this.logUuId = taskCode.getTaskUuID();
    }

    protected DatataskParameter getTaskParam(String fileUuId) {
        return (DatataskParameter)this.taskParamMap.get(fileUuId);
    }

    @Override
    protected void onBeforeProcess() throws TaskRunnerException {
        super.onBeforeProcess();
        try {
            this.dataReader.setTaskRsKey(this.getTaskRsKey());
            this.fReader = MultitaskExcelSchedule.getExec().submit(this.dataReader);
            short size = this.taskCode.getDIETemplateInfo().getCountEachTime();
            this.blockSize = size <= 0 ? (short)1 : size;
            DatataskParameter taskParam = (DatataskParameter)this.taskParamMap.values().iterator().next();
            this.errMode = (ErrorHandleModeEnum)((Object)taskParam.getContextParam().get("errorHandleMode"));
        }
        catch (Exception e) {
            throw new TaskRunnerException(4, (Throwable)e);
        }
    }

    @Override
    protected boolean hasNext() throws TaskRunnerException {
        return this.hasNext;
    }

    private boolean hasNextRecord() throws TaskRunnerException {
        return this.dataReader.hasNextRecord();
    }

    private IRecord getNextRecord() throws TaskRunnerException {
        return this.dataReader.getNextRecord();
    }

    @Override
    protected void onEachRunningLoop() throws Exception {
        boolean canceled;
        this.curColl = null;
        if (this.splitList != null) {
            this.splitList.clear();
        }
        if (canceled = this.cancelImport()) {
            return;
        }
        if (this.submittype == 0) {
            this.curColl = this.getNextSingle();
            if (this.curColl.size() > 0) {
                this.splitList = this.getBlockSplit();
                canceled = this.cancelImport();
                if (canceled) {
                    return;
                }
                this.singleDataImport();
            }
        } else if (this.submittype == 2) {
            this.curColl = this.getNextBlock();
            if (this.curColl.size() > 0) {
                this.splitList = this.getBlockSplit();
                canceled = this.cancelImport();
                if (canceled) {
                    return;
                }
                this.entryDataImport();
            }
        } else if (this.iDataTrans instanceof BlockDataTransmission) {
            this.curColl = this.getNextBlock();
            if (this.curColl.size() > 0) {
                this.splitList = this.getBlockSplit();
                canceled = this.cancelImport();
                if (canceled) {
                    return;
                }
                this.newBlockDataImport();
            }
        } else {
            this.blockSize = 0;
            this.curColl = this.getNextBlock();
            if (this.curColl.size() > 0) {
                this.splitList = this.getBlockSplit();
                canceled = this.cancelImport();
                if (canceled) {
                    return;
                }
                this.oldBlockDataImport();
            }
        }
    }

    private boolean cancelImport() {
        if (!Thread.currentThread().isInterrupted() && !this.isCancel.get()) {
            return false;
        }
        try {
            Thread.currentThread();
            Thread.interrupted();
            this.setCancelFlag();
            this.splitList = null;
            if (this.curColl != null) {
                this.setExcelState(this.curColl);
                this.setSheetState(this.curColl);
                if (this.isWriteToErr(this.curColl)) {
                    this.errExcelSheetManager.writeErrSheet(this.curColl);
                }
            }
            while (this.hasNext()) {
                RecordCollection coll = this.getRecordToErr();
                this.setExcelState(coll);
                this.setSheetState(coll);
                if (!this.isWriteToErr(coll)) continue;
                this.errExcelSheetManager.writeErrSheet(coll);
            }
        }
        catch (TaskRunnerException e) {
            logger.error((Object)e.getMessage(), (Throwable)((Object)e));
        }
        return true;
    }

    private boolean isWriteToErr(RecordCollection coll) {
        if (coll != null && coll.size() == 0) {
            return false;
        }
        IRecord rec = coll.get(0);
        String fileUuId = rec.getFileUuId();
        boolean isImported = false;
        ExcelTaskLog excelLog = this.getExcelLog(this.logUuId, fileUuId);
        if (excelLog != null) {
            isImported = excelLog.isImported();
        }
        if (!isImported) {
            this.hasNext = false;
        }
        return isImported;
    }

    private void setExcelState(RecordCollection coll) {
        if (coll != null && coll.size() > 0 && !StringUtils.isEmpty((String)this.prevFileUuId)) {
            IRecord rec = coll.get(0);
            String fileUuId = rec.getFileUuId();
            if (!this.prevFileUuId.equals(fileUuId)) {
                this.fileMap.put(this.prevFileUuId, true);
            }
            this.prevFileUuId = "";
        }
    }

    private void setSheetState(RecordCollection coll) {
        if (coll != null && coll.size() > 0 && this.sheets != null && this.sheets.size() > 0) {
            IRecord rec = coll.get(0);
            String fileUuId = rec.getFileUuId();
            int sheetId = rec.getSheetId();
            boolean isFinishedImport = this.isSheetFinishedImport(fileUuId, sheetId);
            this.setSheetState(this.sheets, isFinishedImport);
        }
    }

    private void singleDataImport() throws TaskRunnerException {
        Map oneData = new HashMap();
        oneData = this.curColl.get(0).getMap();
        CoreBaseInfo coreBaseInfo = null;
        if (!this.isCodeImplementTrans) {
            coreBaseInfo = this.defaultTrans.transmit(oneData, coreBaseInfo);
            this.defaultTrans.submit(coreBaseInfo, this.ctx);
            return;
        }
        coreBaseInfo = this.iDataTrans.transmit(oneData, this.ctx);
        coreBaseInfo = InspectorCreator.attachCreator(coreBaseInfo, oneData, this.ctx);
        if (this.isUserDefineTrans) {
            coreBaseInfo = this.defaultTrans.transmit(oneData, coreBaseInfo);
        }
        this.iDataTrans.submit(coreBaseInfo, this.ctx);
    }

    private void entryDataImport() throws TaskRunnerException {
        int i;
        int blockSize;
        HashMap<Integer, Map> blockData = new HashMap<Integer, Map>();
        for (int i2 = 0; i2 < this.curColl.size(); ++i2) {
            blockData.put(i2, this.curColl.get(i2).getMap());
        }
        this.setSeq(blockData);
        CoreBaseInfo coreBaseInfo = null;
        if (this.isCodeImplementTrans) {
            coreBaseInfo = this.iDataTrans.transmit(blockData, this.ctx);
            coreBaseInfo = InspectorCreator.attachCreator(coreBaseInfo, (Map)blockData.get(0), this.ctx);
        } else {
            blockSize = blockData.size();
            for (i = 0; i < blockSize; ++i) {
                coreBaseInfo = this.defaultTrans.transmit((Map)blockData.get(i), coreBaseInfo);
            }
        }
        if (this.isUserDefineTrans) {
            blockSize = blockData.size();
            for (i = 0; i < blockSize; ++i) {
                Map entry = (Map)blockData.get(new Integer(i));
                int tempIndex = this.getCoreBaseInfoEntryIndexBySEQ(coreBaseInfo, entry);
                if (tempIndex != -1) {
                    this.defaultTrans.setCurrentEntryRowIndex(tempIndex);
                } else {
                    this.defaultTrans.setCurrentEntryRowIndex(i);
                }
                coreBaseInfo = this.defaultTrans.transmit(entry, coreBaseInfo);
            }
        }
        if (this.entryInfos == null) {
            this.entryInfos = new ArrayList();
        }
        this.entryInfos.add(coreBaseInfo);
    }

    private void setSeq(Map blockData) {
        for (int seq = 0; seq < blockData.size(); ++seq) {
            if (!(blockData.get(seq) instanceof Map)) continue;
            Map entry = (Map)blockData.get(seq);
            if (seq == 0 && entry.containsKey(SEQ_KEY)) {
                return;
            }
            entry.put(SEQ_KEY, seq + 1);
        }
    }

    private int getCoreBaseInfoEntryIndexBySEQ(CoreBaseInfo coreBaseInfo, Map entry) {
        if (coreBaseInfo == null) {
            return -1;
        }
        Object entriesObj = coreBaseInfo.get(this.getEntryName());
        if (entriesObj == null || !(entriesObj instanceof AbstractBaseObjectCollection)) {
            return -1;
        }
        AbstractBaseObjectCollection collection = (AbstractBaseObjectCollection)coreBaseInfo.get(this.getEntryName());
        if (collection != null && collection.size() > 0) {
            Integer tempSeq = -1;
            try {
                Object seq = entry.get(SEQ_KEY);
                if (seq != null) {
                    Object temp;
                    tempSeq = seq instanceof DataToken ? ((temp = ((DataToken)seq).data) instanceof String ? Integer.valueOf(Integer.parseInt((String)temp)) : (Integer)temp) : (seq instanceof String ? Integer.valueOf(Integer.parseInt((String)seq)) : (Integer)seq);
                }
            }
            catch (Exception e) {
                Log.error((Object)"TaskExternalCodeRunner can not get correct Fseq");
            }
            for (int i = 0; i < collection.size(); ++i) {
                AbstractCoreBillEntryBaseInfo entryInfo;
                IObjectValue obj = collection.getObject(i);
                if (!(obj instanceof AbstractCoreBillEntryBaseInfo) || (entryInfo = (AbstractCoreBillEntryBaseInfo)obj).getSeq() != tempSeq.intValue()) continue;
                return i;
            }
        }
        return -1;
    }

    protected String getEntryName() {
        if (this.iDataTrans != null) {
            return this.iDataTrans.getEntryName();
        }
        if (this.defaultTrans != null) {
            return this.defaultTrans.getEntryName();
        }
        return "entries";
    }

    private void oldBlockDataImport() throws TaskRunnerException, TaskExternalException {
        HashMap<Integer, Map> blockData = new HashMap<Integer, Map>();
        for (int i = 0; i < this.curColl.size(); ++i) {
            blockData.put(i, this.curColl.get(i).getMap());
        }
        CoreBaseInfo coreBaseInfo = null;
        if (!this.isCodeImplementTrans) {
            int blockSize = blockData.size();
            for (int i = 0; i < blockSize; ++i) {
                coreBaseInfo = this.defaultTrans.transmit((Map)blockData.get(i), coreBaseInfo);
            }
            this.defaultTrans.submit(coreBaseInfo, this.ctx);
            return;
        }
        coreBaseInfo = this.iDataTrans.transmit(blockData, this.ctx);
        coreBaseInfo = InspectorCreator.attachCreator(coreBaseInfo, (Map)blockData.get(0), this.ctx);
        if (this.isUserDefineTrans) {
            int blockSize = blockData.size();
            for (int i = 0; i < blockSize; ++i) {
                this.defaultTrans.setCurrentEntryRowIndex(i);
                coreBaseInfo = this.defaultTrans.transmit((Map)blockData.get(i), coreBaseInfo);
            }
        }
        this.iDataTrans.submit(coreBaseInfo, this.ctx);
    }

    private void newBlockDataImport() throws TaskExternalException {
        ExcelTaskLog excelLog = this.createAndGetExcelLog(this.logUuId, this.fileUuId);
        Map<Integer, String> sheetId2Name = this.getTaskParam(this.fileUuId).getSheetIdAndName();
        ((BlockDataTransmission)this.iDataTrans).setLog(excelLog);
        ((BlockDataTransmission)this.iDataTrans).setSheetId2Name(sheetId2Name);
        if (this.isAfterAllProcess) {
            if (this.multiSheetErrorManager == null) {
                this.multiSheetErrorManager = new MultiExcel2007SheetErrorManager(this.shareParams);
            }
            ((BlockDataTransmission)this.iDataTrans).setTaskRuner(this);
        }
        Object o = ((BlockDataTransmission)this.iDataTrans).transform(this.ctx, this.curColl);
        ((BlockDataTransmission)this.iDataTrans).verifyBlockData(this.ctx, o);
        ((BlockDataTransmission)this.iDataTrans).beforeSubmitBlockData(this.ctx, o);
        ((BlockDataTransmission)this.iDataTrans).submitBlock(this.ctx, o);
    }

    private RecordCollection getNextBlock() throws TaskRunnerException {
        RecordCollection coll = new RecordCollection();
        int count = 0;
        if (this.curRec != null) {
            coll.add(this.curRec);
            ++count;
            this.fileUuId = this.curRec.getFileUuId();
        }
        IRecord lastRec = null;
        if (this.curRec != null) {
            lastRec = this.curRec;
        }
        ArrayList<BlockSplitInfo> blankRows = new ArrayList<BlockSplitInfo>();
        while (this.hasNext = this.hasNextRecord()) {
            this.curRec = this.getNextRecord();
            if (StringUtils.isEmpty((String)this.fileUuId)) {
                this.fileUuId = this.curRec.getFileUuId();
            }
            if (!this.fileUuId.equals(this.curRec.getFileUuId())) break;
            if (this.curRec.getMap().isEmpty()) {
                blankRows.add(new BlockSplitInfo(this.curRec.getSheetId(), this.curRec.getRowNum(), 1));
                this.onDataBlank(blankRows);
                continue;
            }
            ++count;
            if (lastRec == null) {
                lastRec = this.curRec;
            }
            if (count > this.blockSize && !this.iDataTrans.isSameBlock(lastRec.getMap(), this.curRec.getMap())) break;
            lastRec = this.curRec;
            coll.add(this.curRec);
        }
        return coll;
    }

    private RecordCollection getNextSingle() throws TaskRunnerException {
        RecordCollection coll = new RecordCollection();
        IRecord rec = null;
        while (this.hasNext = this.hasNextRecord()) {
            rec = this.getNextRecord();
            if (StringUtils.isEmpty((String)this.fileUuId)) {
                this.fileUuId = rec.getFileUuId();
            }
            if (!this.fileUuId.equals(rec.getFileUuId())) {
                this.fileUuId = rec.getFileUuId();
            }
            if (rec.getMap().isEmpty()) {
                ArrayList<BlockSplitInfo> blankRows = new ArrayList<BlockSplitInfo>();
                blankRows.add(new BlockSplitInfo(rec.getSheetId(), rec.getRowNum(), 1));
                this.onDataBlank(blankRows);
                continue;
            }
            coll.add(rec);
            break;
        }
        return coll;
    }

    private RecordCollection getRecordToErr() throws TaskRunnerException {
        RecordCollection coll = new RecordCollection();
        int count = 0;
        if (this.curRec != null) {
            coll.add(this.curRec);
            ++count;
            this.fileUuId = this.curRec.getFileUuId();
        }
        IRecord lastRec = null;
        while (this.hasNext = this.hasNextRecord()) {
            this.curRec = this.getNextRecord();
            if (StringUtils.isEmpty((String)this.fileUuId)) {
                this.fileUuId = this.curRec.getFileUuId();
            }
            if (!this.fileUuId.equals(this.curRec.getFileUuId())) break;
            if (this.curRec.getMap().isEmpty()) continue;
            ++count;
            if (lastRec == null) {
                lastRec = this.curRec;
            }
            if (count > 500) break;
            lastRec = this.curRec;
            coll.add(this.curRec);
        }
        return coll;
    }

    private Map<Integer, Map<String, DataToken>> getNextBlockOld() throws TaskRunnerException {
        HashMap<Integer, Map<String, DataToken>> blockMap = new HashMap<Integer, Map<String, DataToken>>();
        int count = 0;
        if (this.curRec != null) {
            blockMap.put(count, this.curRec.getMap());
            ++count;
        }
        IRecord lastRec = null;
        while (this.hasNext = this.hasNextRecord()) {
            this.curRec = this.getNextRecord();
            if (this.curRec.getMap().isEmpty()) continue;
            ++count;
            if (lastRec == null) {
                lastRec = this.curRec;
            }
            if (!this.iDataTrans.isSameBlock(lastRec.getMap(), this.curRec.getMap())) break;
            blockMap.put(count, this.curRec.getMap());
        }
        return blockMap;
    }

    @Override
    protected void onDataError(Throwable ex) throws TaskRunnerException {
        if (ex instanceof TaskRunnerException && ((TaskRunnerException)((Object)ex)).getExceptionCode() == 4) {
            throw (TaskRunnerException)((Object)ex);
        }
        if (this.isSkipMainProcess) {
            return;
        }
        ExcelTaskLog excelLog = this.createAndGetExcelLog(this.logUuId, this.fileUuId);
        int size = this.splitList.size();
        Map<Object, Object> entryErrorReasons = new LinkedHashMap();
        if (ex instanceof TaskExternalException) {
            TaskExternalException tex = (TaskExternalException)((Object)ex);
            entryErrorReasons = tex.getEntryErrorReasons();
        }
        for (int i = 0; i < size; ++i) {
            BlockSplitInfo blockinfo = this.splitList.get(i);
            int sheetId = blockinfo.getSheetId();
            ExcelTaskLog.ExcelSheetTaskLog sheetlog = this.createAndGetSheetLog(excelLog, sheetId);
            int startRow = RecordUtils.getRowNum(blockinfo.getStartRow());
            int endRow = RecordUtils.getRowNum(blockinfo.getEndRow());
            if (!entryErrorReasons.isEmpty()) {
                for (int j = startRow; j <= startRow; ++j) {
                    int entryIndex = j - startRow;
                    String errorReason = (String)entryErrorReasons.get(entryIndex);
                    errorReason = errorReason == null ? "" : errorReason;
                    sheetlog.setBlockErrorInfo(startRow, endRow, errorReason.replaceAll("\"", ""));
                }
            } else {
                sheetlog.setBlockErrorInfo(startRow, endRow, ex.getMessage().replaceAll("\"", ""));
            }
            if (this.errMode.getValue() != ErrorHandleModeEnum.ReturnRightnow.getValue()) continue;
            this.isCancel.compareAndSet(false, true);
        }
    }

    private List<BlockSplitInfo> getBlockSplit() {
        int size = this.curColl.size();
        ArrayList<BlockSplitInfo> splitList = new ArrayList<BlockSplitInfo>();
        int sheetId = 0;
        BlockSplitInfo split = new BlockSplitInfo();
        for (int i = 0; i < size; ++i) {
            IRecord rec = this.curColl.get(i);
            this.recIndex.put(rec.getRowNum(), i);
            if (sheetId == 0) {
                sheetId = rec.getSheetId();
                split.setSheetId(sheetId);
                split.setStartRow(rec.getRowNum());
                if (size != 1) continue;
                split.setEndRow(rec.getRowNum());
                splitList.add(split);
                continue;
            }
            if (sheetId != rec.getSheetId()) {
                sheetId = rec.getSheetId();
                split.setEndRow(this.curColl.get(i - 1).getRowNum());
                splitList.add(split);
                split = new BlockSplitInfo();
                split.setSheetId(sheetId);
                split.setStartRow(rec.getRowNum());
                if (i != size - 1) continue;
                split.setEndRow(rec.getRowNum());
                splitList.add(split);
                continue;
            }
            if (i != size - 1) continue;
            split.setEndRow(rec.getRowNum());
            splitList.add(split);
        }
        return splitList;
    }

    @Override
    protected void onDataSuccess() throws TaskRunnerException {
        if (this.isSkipMainProcess) {
            return;
        }
        if (this.isCancel.get()) {
            return;
        }
        boolean bl = this.isFinishedReader = !this.hasNext();
        if (StringUtils.isEmpty((String)this.fileUuId)) {
            return;
        }
        this.initExcelState(this.fileUuId);
        ExcelInfo excelInfo = (ExcelInfo)this.dataReader.getFileInfo(this.fileUuId);
        ExcelTaskLog excelLog = this.createAndGetExcelLog(this.logUuId, this.fileUuId);
        for (BlockSplitInfo blockinfo : this.splitList) {
            int sheetId = blockinfo.getSheetId();
            ExcelTaskLog.ExcelSheetTaskLog sheetlog = this.createAndGetSheetLog(excelLog, sheetId);
            int rowCount = excelInfo.get(sheetId).getRowCount();
            sheetlog.setRowCount(rowCount);
            int currow = RecordUtils.getRowNum(blockinfo.getStartRow());
            int endrow = RecordUtils.getRowNum(blockinfo.getEndRow());
            sheetlog.setSuccessRowCount(currow, endrow);
            this.initSheetState(this.fileUuId, sheetId);
            this.writeErr2File(sheetlog, blockinfo);
        }
    }

    private void onDataBlank(List<BlockSplitInfo> blankRows) throws TaskRunnerException {
        ExcelTaskLog excelLog = this.createAndGetExcelLog(this.logUuId, this.fileUuId);
        for (BlockSplitInfo blockinfo : blankRows) {
            int sheetId = blockinfo.getSheetId();
            ExcelTaskLog.ExcelSheetTaskLog sheetlog = this.createAndGetSheetLog(excelLog, sheetId);
            int blankRow = RecordUtils.getRowNum(blockinfo.getBlankRow());
            sheetlog.setBlankRowCount(blankRow);
        }
    }

    @Override
    protected void onAfterProcess() throws TaskRunnerException {
        if (this.isSkipMainProcess) {
            this.initSheetRowCount();
        }
        if (this.isAfterAllProcess) {
            if (this.multiSheetErrorManager == null) {
                this.multiSheetErrorManager = new MultiExcel2007SheetErrorManager(this.shareParams);
            }
            if (this.iDataTrans instanceof BlockDataTransmission) {
                ((BlockDataTransmission)this.iDataTrans).setTaskRuner(this);
            }
            this.iDataTrans.solutionOnFinished(this.ctx);
        }
        this.setSheetStateOnFinished();
    }

    @Override
    protected void onFinishRunning() throws TaskRunnerException {
        this.errExcelSheetManager.closeSheet();
        if (this.multiSheetErrorManager != null) {
            this.multiSheetErrorManager.closeALLExcelSheet();
        }
        this.setSheetState(this.sheets);
        if (!this.fReader.isDone()) {
            this.fReader.cancel(true);
        }
        this.checkFileOnFlowOver();
        try {
            this.interruptTaskRs.put(this.getTaskResult());
        }
        catch (InterruptedException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            Thread.currentThread();
            Thread.interrupted();
            try {
                this.interruptTaskRs.put(this.getTaskResult());
            }
            catch (InterruptedException e1) {
                logger.error((Object)e1);
            }
        }
    }

    @Override
    protected void handFailure(Exception ex) throws Exception {
        ExcelTaskLog excelLog = null;
        if (this.fileUuIdSet != null) {
            for (String fileUuId : this.fileUuIdSet) {
                excelLog = this.createAndGetExcelLog(this.logUuId, fileUuId);
                excelLog.setTaskLogInfo(TaskStateEnum.FAILEND, ((TaskRunnerException)((Object)ex)).getOriginalMessage(), ex);
            }
        }
    }

    @Override
    protected void handSuccess() throws Exception {
    }

    private ExcelTaskLog createAndGetExcelLog(String logUuId, String fileUuId) {
        DatataskParameter taskParam = this.getTaskParam(fileUuId);
        String fileName = taskParam.getFileName();
        ExcelTaskLog log = TaskLogUtil.createAndGetExcelLog(logUuId, fileUuId, fileName);
        log.setEntryList(this.entryInfos);
        log.setCtx(this.ctx);
        return log;
    }

    private ExcelTaskLog.ExcelSheetTaskLog createAndGetSheetLog(ExcelTaskLog tasklog, int sheetId) {
        DatataskParameter taskParam = this.getTaskParam(tasklog.getFileUuID());
        String sheetName = taskParam.getSheetIdAndName().get(sheetId);
        return TaskLogUtil.createAndGetSheetLog(tasklog, sheetId, sheetName);
    }

    private ExcelTaskLog getExcelLog(String logUuId, String fileUuId) {
        ILog log = TaskLogUtil.getLog(logUuId, fileUuId);
        if (log != null) {
            ExcelTaskLog excellog = (ExcelTaskLog)log;
            excellog.setCtx(this.ctx);
            return excellog;
        }
        return null;
    }

    private void writeErr2File(ExcelTaskLog.ExcelSheetTaskLog sheetlog, BlockSplitInfo blockinfo) throws TaskRunnerException {
        int currow = blockinfo.getStartRow();
        int endrow = blockinfo.getEndRow();
        int sheetId = sheetlog.getSheetID();
        Map<Integer, Integer> blockMap = sheetlog.getBlockMap();
        Map<Integer, String> errMap = sheetlog.getErrorSubMap();
        String errmsg = "";
        int real_currow = RecordUtils.getRowNum(currow);
        int real_endRow = RecordUtils.getRowNum(endrow);
        if (blockMap.containsKey(real_currow)) {
            errmsg = sheetlog.getErrBlockMsg().get(real_currow);
            for (int row = real_currow; row <= real_endRow; ++row) {
                int rowNum = RecordUtils.convertRowNum(sheetId, row);
                IRecord rec = this.curColl.get(this.recIndex.get(rowNum));
                if (errMap.containsKey(row)) {
                    this.errExcelSheetManager.writeErrSheet(errMap.get(row), rec);
                    continue;
                }
                this.errExcelSheetManager.writeErrSheet(errmsg, rec);
            }
        } else {
            SortedMap tailMap = ((TreeMap)errMap).tailMap(real_currow);
            for (Map.Entry entry : tailMap.entrySet()) {
                int rowNum = entry.getKey();
                errmsg = (String)entry.getValue();
                rowNum = RecordUtils.convertRowNum(sheetId, rowNum);
                IRecord rec = this.curColl.get(this.recIndex.get(rowNum));
                this.errExcelSheetManager.writeErrSheet(errmsg, rec);
            }
        }
    }

    public void writeLog(RecordCollection col, List<SuccessInfo> successList) {
        try {
            if (col != null && col.size() > 0) {
                int size = col.size();
                for (int i = 0; i < size; ++i) {
                    IRecord rec = col.get(i);
                    String fileUuId = rec.getFileUuId();
                    int sheetId = rec.getSheetId();
                    int rowNum = RecordUtils.getRowNum(rec.getRowNum());
                    String msg = rec.getMsg();
                    this.setSheetStateOnInit(fileUuId, sheetId);
                    this.multiSheetErrorManager.writeErrSheet(msg, rec);
                    ExcelTaskLog excelLog = this.createAndGetExcelLog(this.logUuId, fileUuId);
                    ExcelTaskLog.ExcelSheetTaskLog sheetlog = this.createAndGetSheetLog(excelLog, sheetId);
                    sheetlog.setErrorInfo(rowNum, msg);
                }
            }
            if (successList != null && successList.size() > 0) {
                for (SuccessInfo sInfo : successList) {
                    String fileUuId = sInfo.getFileUuId();
                    int sheetId = sInfo.getSheetId();
                    int rowCount = sInfo.getRowCount();
                    this.setSheetStateOnInit(fileUuId, sheetId);
                    ExcelTaskLog excelLog = this.createAndGetExcelLog(this.logUuId, fileUuId);
                    ExcelTaskLog.ExcelSheetTaskLog sheetlog = this.createAndGetSheetLog(excelLog, sheetId);
                    sheetlog.setSuccessRowCount(rowCount);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void initSheetRowCount() {
        for (String fileUuId : this.fileUuIdSet) {
            ExcelInfo excelInfo = (ExcelInfo)this.dataReader.getFileInfo(fileUuId);
            List<ExcelInfo.ExcelSheetInfo> sheetList = excelInfo.getSheetList();
            ExcelTaskLog excelLog = this.createAndGetExcelLog(this.logUuId, fileUuId);
            for (ExcelInfo.ExcelSheetInfo info : sheetList) {
                ExcelTaskLog.ExcelSheetTaskLog sheetlog = this.createAndGetSheetLog(excelLog, info.getSheetId());
                sheetlog.setRowCount(info.getRowCount());
            }
        }
    }

    private void initSheetState(String fileUuId, int sheetId) {
        String _sheet_flag = fileUuId + "_" + sheetId;
        if (!this.sheets.contains(_sheet_flag)) {
            this.sheets.add(_sheet_flag);
            ExcelTaskLog excelLog = this.createAndGetExcelLog(this.logUuId, fileUuId);
            ExcelTaskLog.ExcelSheetTaskLog sheetLog = this.createAndGetSheetLog(excelLog, sheetId);
            sheetLog.setSheetResultState(TaskStateEnum.PROCESS);
            sheetLog.setSheetImportState(ExcelImportState.importing);
            int size = this.sheets.size();
            if (size > 1) {
                this.setSheetState(this.sheets);
            }
        }
    }

    private void setSheetStateOnInit(String fileUuId, int sheetId) {
        String _sheet_flag = fileUuId + "_" + sheetId;
        if (!this.sheets.contains(_sheet_flag)) {
            this.sheets.add(_sheet_flag);
            ExcelTaskLog excelLog = this.createAndGetExcelLog(this.logUuId, fileUuId);
            ExcelTaskLog.ExcelSheetTaskLog sheetLog = this.createAndGetSheetLog(excelLog, sheetId);
            sheetLog.setSheetResultState(TaskStateEnum.PROCESS);
            sheetLog.setSheetImportState(ExcelImportState.importing);
        }
    }

    private void setSheetStateOnFinished() {
        this.sheets.clear();
        for (Map.Entry<String, ExcelParam> entry : this.shareParams.entrySet()) {
            String fileUuId = entry.getKey();
            ExcelTaskLog excelLog = this.createAndGetExcelLog(this.logUuId, fileUuId);
            for (ExcelTaskLog.ExcelSheetTaskLog sheetLog : excelLog.getSheetList().values()) {
                sheetLog.setSheetImportState(ExcelImportState.finishedImport);
                sheetLog.setSheetResultState();
            }
        }
    }

    private void initExcelState(String fileUuId) {
        if (this.fileMap.size() == 0) {
            this.fileMap.put(fileUuId, false);
            this.prevFileUuId = fileUuId;
        } else {
            if (!this.fileMap.containsKey(fileUuId)) {
                this.fileMap.put(this.prevFileUuId, true);
                this.fileMap.put(fileUuId, false);
            }
            if (this.isFinishedReader) {
                this.fileMap.put(fileUuId, true);
            }
        }
    }

    private void setSheetState(List<String> sheets) {
        this.setSheetState(sheets, true);
    }

    private void setSheetState(List<String> sheets, boolean isFinishedImport) {
        if (sheets != null && sheets.size() > 0) {
            String prev_flag = sheets.get(0);
            String prev_fileUuId = prev_flag.substring(0, prev_flag.indexOf("_"));
            int prev_sheetId = Integer.parseInt(prev_flag.substring(prev_flag.indexOf("_") + 1));
            ExcelTaskLog excelLog = this.createAndGetExcelLog(this.logUuId, prev_fileUuId);
            ExcelTaskLog.ExcelSheetTaskLog sheetLog = this.createAndGetSheetLog(excelLog, prev_sheetId);
            if (isFinishedImport) {
                sheetLog.setSheetImportState(ExcelImportState.finishedImport);
            } else {
                sheetLog.setSheetImportState(ExcelImportState.unfinishedImport);
            }
            sheetLog.setSheetResultState();
            sheets.remove(0);
        }
    }

    private void setEmptySheetState(String fileUuId, int sheetId) {
        ExcelTaskLog excelLog = this.createAndGetExcelLog(this.logUuId, fileUuId);
        ExcelTaskLog.ExcelSheetTaskLog sheetLog = this.createAndGetSheetLog(excelLog, sheetId);
        sheetLog.setSheetImportState(ExcelImportState.finishedImport);
        sheetLog.setSheetResultState();
        String sheetName = this.getTaskParam(fileUuId).getSheetIdAndName().get(sheetId);
        Object[] join = new Object[]{sheetName};
        String msg = EASResourceJoinUtil.getServerString("sheetIsEmpty", join, this.ctx.getLocale());
        sheetLog.setSheetErrMsg(msg);
    }

    private boolean isSheetFinishedImport(String fileUuId, int sheetId) {
        String _sheet_flag;
        boolean rs = true;
        if (this.sheets != null && this.sheets.size() > 0 && this.sheets.contains(_sheet_flag = fileUuId + "_" + sheetId)) {
            rs = false;
        }
        return rs;
    }

    @Override
    public TaskResult getTaskResult() {
        TaskResult rs = new TaskResult();
        rs.setTaskEnum(TaskEnum.importTask);
        rs.setKey(this.getTaskRsKey());
        rs.setSucced(this.checkTaskIsSucced());
        return rs;
    }

    private boolean checkTaskIsSucced() {
        boolean rs = true;
        for (Map.Entry<String, ITaskParameter> entry : this.taskParamMap.entrySet()) {
            String fileUuId = entry.getKey();
            Set<Integer> sheetIds = this.getTaskParam(fileUuId).getSheetIdAndName().keySet();
            ExcelTaskLog excelLog = this.getExcelLog(this.logUuId, fileUuId);
            if (excelLog != null) {
                rs = excelLog.isSucced(sheetIds);
                if (rs) continue;
                break;
            }
            rs = false;
            break;
        }
        return rs;
    }

    private void checkFileOnFlowOver() {
        for (Map.Entry<String, ITaskParameter> entry : this.taskParamMap.entrySet()) {
            String fileUuId = entry.getKey();
            Set<Integer> sheetIds = this.getTaskParam(fileUuId).getSheetIdAndName().keySet();
            ExcelTaskLog excelLog = this.getExcelLog(this.logUuId, fileUuId);
            if (excelLog != null && excelLog.isImported()) {
                this.errExcelSheetManager.setIsImported(fileUuId);
            }
            if (this.isFinishedReader) {
                this.checkEmptySheetOnReadFinished(fileUuId, sheetIds);
                continue;
            }
            this.checkEmptySheetOnReadUnFinished(fileUuId, sheetIds);
            this.checkNotImportSheet(fileUuId, sheetIds);
        }
    }

    private void checkNotImportSheet(String fileUuId, Set<Integer> sheetIds) {
        ExcelTaskLog excelLog = this.getExcelLog(this.logUuId, fileUuId);
        if (excelLog == null) {
            this.errExcelSheetManager.setNotImportSheets(fileUuId, sheetIds);
        } else {
            if (this.fileMap.containsKey(fileUuId) && this.fileMap.get(fileUuId).booleanValue()) {
                return;
            }
            ExcelTaskLog.ExcelSheetTaskLog sheetLog = null;
            HashSet<Integer> notImports = new HashSet<Integer>();
            for (int sheetId : sheetIds) {
                sheetLog = excelLog.get(sheetId);
                if (sheetLog != null) continue;
                notImports.add(sheetId);
            }
            this.errExcelSheetManager.setNotImportSheets(fileUuId, notImports);
        }
    }

    private void checkEmptySheetOnReadUnFinished(String fileUuId, Set<Integer> sheetIds) {
        block5: {
            ExcelTaskLog excelLog = this.getExcelLog(this.logUuId, fileUuId);
            if (excelLog == null) break block5;
            if (this.fileMap.containsKey(fileUuId) && this.fileMap.get(fileUuId).booleanValue()) {
                ExcelTaskLog.ExcelSheetTaskLog sheetLog = null;
                for (int sheetId : sheetIds) {
                    sheetLog = excelLog.get(sheetId);
                    if (sheetLog != null) continue;
                    this.setEmptySheetState(fileUuId, sheetId);
                }
            } else {
                Set<Integer> importedSheets = excelLog.getSheetList().keySet();
                TreeSet<Integer> copyset = new TreeSet<Integer>();
                copyset.addAll(sheetIds);
                copyset.retainAll(importedSheets);
                if (copyset.isEmpty()) {
                    return;
                }
                int big = (Integer)copyset.last();
                for (int sheetId : sheetIds) {
                    if (copyset.contains(sheetId) || sheetId >= big) continue;
                    this.setEmptySheetState(fileUuId, sheetId);
                }
            }
        }
    }

    private void checkEmptySheetOnReadFinished(String fileUuId, Set<Integer> sheetIds) {
        ExcelTaskLog excelLog = this.getExcelLog(this.logUuId, fileUuId);
        if (excelLog == null) {
            for (int sheetId : sheetIds) {
                this.setEmptySheetState(fileUuId, sheetId);
            }
        } else {
            ExcelTaskLog.ExcelSheetTaskLog sheetLog = null;
            for (int sheetId : sheetIds) {
                sheetLog = excelLog.get(sheetId);
                if (sheetLog != null) continue;
                this.setEmptySheetState(fileUuId, sheetId);
            }
        }
    }

    public String getTaskRsKey() {
        return this.taskRsKey;
    }

    @Override
    public void setTaskRsKey(String key) {
        this.taskRsKey = key;
    }

    public void setCancelFlag() {
        this.isCancel.compareAndSet(false, true);
    }

    public void setShareParams(Map<String, ExcelParam> shareParams) {
        this.shareParams = shareParams;
    }
}

