/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.util.SimpleFileFilter;
import com.kingdee.eas.base.message.util.sendmsg.util.FileUtil;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.tools.datatask.FilesPathInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.sql.RowSet;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class GlobalFunction {
    private static String lastSelectPath = System.getProperty("user.home");
    private static final String historyPathFolder = System.getProperty("EAS_HOME") == null ? System.getProperty("user.home") + File.separator : System.getProperty("EAS_HOME").toString() + File.separator + "client" + File.separator + "cache" + File.separator + "datatask" + File.separator;
    private static Logger logger = Logger.getLogger(GlobalFunction.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getHistoryPath() {
        String userName = SysContext.getSysContext().getUserName();
        String path = historyPathFolder + userName + ".properties";
        InputStreamReader isr = null;
        BufferedReader br = null;
        File file = null;
        try {
            file = new File(path);
            if (file.isFile() && file.exists()) {
                isr = new InputStreamReader((InputStream)new FileInputStream(path), "utf-8");
                br = new BufferedReader(isr);
                String line = br.readLine();
                String string = line == null ? lastSelectPath : line;
                return string;
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return lastSelectPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateHistoryPath(String pathContent) {
        String userName = SysContext.getSysContext().getUserName();
        String path = historyPathFolder + userName + ".properties";
        File file = new File(path);
        FileUtil.deleteFile((File)file);
        OutputStreamWriter osw = null;
        try {
            if (!FileUtil.isExist((String)historyPathFolder)) {
                FileUtil.createFolder((String)historyPathFolder);
            }
            osw = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "utf-8");
            osw.write(pathContent);
            osw.flush();
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (osw != null) {
                    osw.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isFileExists(String fileName) {
        boolean isFileExists = false;
        try {
            File file = new File(fileName);
            isFileExists = file.exists();
            file = null;
        }
        catch (Exception ex) {
            isFileExists = false;
        }
        return isFileExists;
    }

    public static boolean isFileExists(String path, String fileName) {
        boolean isFileExists = false;
        try {
            File file = new File(path, fileName);
            isFileExists = file.exists();
            file = null;
        }
        catch (Exception ex) {
            isFileExists = false;
        }
        return isFileExists;
    }

    public static boolean getBoolean(String value) {
        boolean boolValue = value.compareTo("true") == 0;
        return boolValue;
    }

    public static boolean isInteger(Double value) {
        double digit = value - (double)value.intValue();
        return digit == 0.0;
    }

    public static String getExcelDataErrorMessage(Map hsData) throws RuntimeException {
        StringBuffer source = new StringBuffer();
        Object tmp = GlobalFunction.findStringIngoreCase(hsData, "FNumber");
        if (tmp != null) {
            source.append(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"74_GlobalFunction")).append(tmp.toString()).append("\u201c");
        }
        if ((tmp = GlobalFunction.findStringIngoreCase(hsData, "FName_L2")) != null) {
            if (source.length() > 0) {
                source.append(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"75_GlobalFunction")).append(tmp.toString()).append("\u201d");
            } else {
                source.append(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"76_GlobalFunction")).append(tmp.toString()).append("\u201d");
            }
        }
        if (source.length() > 0) {
            source.append(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"77_GlobalFunction"));
        }
        return source.toString();
    }

    public static URL getK3ScriptURL(Object myClass) throws BOSException {
        URL urlScript = null;
        urlScript = myClass.getClass().getClassLoader().getResource("UPT_BOSObject.data");
        return urlScript;
    }

    public static URL getSolutionURL(Object myClass, int datataskMode) throws BOSException {
        URL urlSolution = null;
        try {
            urlSolution = datataskMode == 2 ? myClass.getClass().getClassLoader().getResource("DataIntegrationWithK3.data") : (datataskMode == 0 ? myClass.getClass().getClassLoader().getResource("All_Solution.data") : myClass.getClass().getClassLoader().getResource("All_Solution.data"));
        }
        catch (Exception ex) {
            String msg = EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"78_GlobalFunction");
            msg = msg + ex.getMessage();
            throw new BOSException(msg);
        }
        return urlSolution;
    }

    public static final String excelFileChooseForExport(KDDialog parent) throws Exception {
        String sFileName = "";
        KDFileChooser choose = new KDFileChooser();
        int rVal = choose.showOpenDialog((Component)parent);
        if (rVal == 0 && (sFileName = choose.getSelectedFile().getPath()).substring(sFileName.length() - 3, sFileName.length()).compareTo("xls") != 0) {
            Exception e = new Exception(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"79_GlobalFunction"));
            throw e;
        }
        return sFileName;
    }

    public static final String excelFileChoose(Component parent) throws Exception {
        String sFileName = null;
        KDFileChooser choose = new KDFileChooser(GlobalFunction.getHistoryPath());
        SimpleFileFilter ff = new SimpleFileFilter(new String[]{"csv", "txt", "xml", "xls", "xlsx"});
        choose.setFileFilter((FileFilter)ff);
        boolean isFileValid = false;
        while (!isFileValid) {
            int rVal = choose.showOpenDialog(parent);
            GlobalFunction.updateHistoryPath(choose.getCurrentDirectory().getPath());
            if (rVal == 0) {
                sFileName = choose.getSelectedFile().getPath();
                if (!GlobalFunction.isSupportFileType(sFileName)) {
                    MsgBox.showInfo((Component)parent, (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"supportfiletype"));
                    isFileValid = false;
                    sFileName = "";
                    continue;
                }
                isFileValid = true;
                continue;
            }
            isFileValid = true;
            sFileName = "";
        }
        return sFileName;
    }

    public static final FilesPathInfo excelFileChoose(Component parent, boolean isMulti, FilesPathInfo paths) throws Exception {
        FilesPathInfo fpInfo = new FilesPathInfo();
        KDFileChooser choose = new KDFileChooser(GlobalFunction.getHistoryPath());
        SimpleFileFilter ff = new SimpleFileFilter(new String[]{"csv", "txt", "xml", "xls", "xlsx"});
        choose.setFileFilter((FileFilter)ff);
        choose.setMultiSelectionEnabled(isMulti);
        if (paths != null) {
            File[] files = new File[paths.getFilePath().length];
            int size = files.length;
            for (int i = 0; i < size; ++i) {
                files[i] = new File(paths.getFilePath()[i]);
            }
            choose.setSelectedFiles(files);
        }
        boolean isFileValid = false;
        while (!isFileValid) {
            int rVal = choose.showOpenDialog(parent);
            GlobalFunction.updateHistoryPath(choose.getCurrentDirectory().getPath());
            if (rVal == 0) {
                File[] files = choose.getSelectedFiles();
                if (files.length > 50) {
                    MsgBox.showInfo((Component)parent, (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"sltFileTooMany"));
                    isFileValid = false;
                    continue;
                }
                if (!GlobalFunction.isSupportFileType(files[0].getPath())) {
                    MsgBox.showInfo((Component)parent, (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"supportfiletype"));
                    isFileValid = false;
                    continue;
                }
                isFileValid = true;
                fpInfo = GlobalFunction.getFilesPathInfo(files);
                continue;
            }
            isFileValid = true;
        }
        return fpInfo;
    }

    private static FilesPathInfo getFilesPathInfo(File[] files) {
        FilesPathInfo fpInfo = new FilesPathInfo();
        String[] fileNames = new String[files.length];
        String[] filePaths = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            fileNames[i] = files[i].getName();
            filePaths[i] = files[i].getPath();
        }
        fpInfo.setFileNames(fileNames);
        fpInfo.setFilePath(filePaths);
        return fpInfo;
    }

    public static final String excelFileSaver(Component parent) throws Exception {
        String sFileName = null;
        KDFileChooser choose = new KDFileChooser(GlobalFunction.getHistoryPath());
        SimpleFileFilter ff1 = new SimpleFileFilter(new String[]{"xlsx"});
        SimpleFileFilter ff2 = new SimpleFileFilter(new String[]{"xls"});
        SimpleFileFilter ff3 = new SimpleFileFilter(new String[]{"csv"});
        SimpleFileFilter ff4 = new SimpleFileFilter(new String[]{"txt"});
        SimpleFileFilter ff5 = new SimpleFileFilter(new String[]{"xml"});
        ff1.setDescription("excel2007");
        ff2.setDescription("excel97-2003");
        ff3.setDescription("csv");
        ff4.setDescription("text");
        ff5.setDescription("xml");
        choose.addChoosableFileFilter((FileFilter)ff1);
        choose.addChoosableFileFilter((FileFilter)ff2);
        choose.addChoosableFileFilter((FileFilter)ff3);
        choose.addChoosableFileFilter((FileFilter)ff4);
        choose.addChoosableFileFilter((FileFilter)ff5);
        boolean isFileValid = false;
        while (!isFileValid) {
            choose.setFileFilter((FileFilter)ff1);
            int rVal = choose.showSaveDialog(parent);
            GlobalFunction.updateHistoryPath(choose.getCurrentDirectory().getPath());
            if (rVal == 0) {
                String description;
                File retFile = choose.getSelectedFile();
                sFileName = retFile.getPath();
                logger.info((Object)("file path1:" + sFileName));
                int startPo = sFileName.lastIndexOf(File.separator);
                int lastPointPo = sFileName.lastIndexOf(".");
                String extendName = null;
                extendName = choose.getFileFilter() instanceof SimpleFileFilter ? ((description = ((SimpleFileFilter)choose.getFileFilter()).getDescription()).indexOf("csv") >= 0 ? "csv" : (description.indexOf("txt") >= 0 ? "txt" : (description.indexOf("xml") >= 0 ? "xml" : (description.indexOf("xlsx") >= 0 ? "xlsx" : (description.indexOf("xls") >= 0 ? "xls" : "xls"))))) : "xls";
                if (!sFileName.endsWith("." + extendName)) {
                    sFileName = new StringBuffer(sFileName).append(".").append(extendName).toString();
                }
                retFile = new File(sFileName);
                logger.info((Object)("file path2:" + sFileName));
                if (!GlobalFunction.isSupportFileType(sFileName)) {
                    MsgBox.showInfo((Component)parent, (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"supportfiletype"));
                    isFileValid = false;
                    sFileName = "";
                    continue;
                }
                if (retFile.exists()) {
                    int result = MsgBox.showConfirm2((Component)parent, (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"fileHasExisted"));
                    if (result == 0) {
                        isFileValid = true;
                        GlobalFunction.updateHistoryPath(choose.getCurrentDirectory().getPath());
                        continue;
                    }
                    isFileValid = false;
                    continue;
                }
                GlobalFunction.updateHistoryPath(choose.getCurrentDirectory().getPath());
                isFileValid = true;
                continue;
            }
            sFileName = "";
            isFileValid = true;
        }
        return sFileName;
    }

    public static final String excelDataFileChoose(KDDialog parent) throws Exception {
        String sFile = "";
        KDFileChooser choose = new KDFileChooser();
        int rVal = choose.showOpenDialog((Component)parent);
        if (rVal == 0 && (sFile = choose.getSelectedFile().getPath()).substring(sFile.length() - 3, sFile.length()).compareTo("xls") != 0) {
            Exception e = new Exception(EASResource.getString((String)"com.kingdee.eas.tools.datatask.DATATASKAutoGenerateResource", (String)"79_GlobalFunction"));
            throw e;
        }
        return sFile;
    }

    private static String getBOSType(Connection conn, String name) throws Exception {
        String sql = "select * from  T_PF_BosObject where FTableName ='" + name + "'";
        RowSet rs = null;
        rs = SQLUtils.getJdbcRowSet((Connection)conn, (String)sql);
        if (rs.next()) {
            String bosType = rs.getString("FBOSType");
            return bosType;
        }
        return "";
    }

    public static boolean findWithNoCaseInArray(ArrayList lsData, String key) {
        boolean isMatch = false;
        for (int i = 0; i < lsData.size(); ++i) {
            String keyToCompare = lsData.get(i).toString();
            if (keyToCompare.compareTo(key) != 0) continue;
            isMatch = true;
            break;
        }
        return isMatch;
    }

    public static Object findStringIngoreCase(Map hsData, String key) throws RuntimeException {
        Object obj = null;
        Iterator it = hsData.keySet().iterator();
        while (it.hasNext()) {
            String keyToMatch = it.next().toString();
            Object objTemp = hsData.get(keyToMatch);
            if (keyToMatch.compareToIgnoreCase(key) != 0) continue;
            obj = objTemp;
            break;
        }
        return obj;
    }

    private static boolean blurMatching(String src, String dest) {
        src = src.toLowerCase();
        if ((dest = dest.toLowerCase()).length() > src.length()) {
            dest = dest.substring(0, src.length());
        }
        return src.equalsIgnoreCase(dest);
    }

    public static String getLikeField(ArrayList fields, String fieldName, boolean isBlurMatching) {
        for (int i = 0; i < fields.size(); ++i) {
            String dest;
            String src = fields.get(i).toString();
            if (!GlobalFunction.blurMatching(src, dest = fieldName)) continue;
            return src;
        }
        return null;
    }

    public static synchronized String getUuID() {
        return Uuid.create().toString();
    }

    public static String getTempFileName(String uuid, String fileType) {
        return uuid + "." + fileType;
    }

    public static String getFilePathForServer() {
        return System.getProperty("EAS_HOME") + "/server/deploy/fileserver.ear/easWebClient/";
    }

    public static String getFilePathForClient() {
        return System.getProperty("EAS_HOME") + "/client/";
    }

    public static String getFileTempSavePath(String fileUuId) {
        String tempFolder = System.getProperty("java.io.tmpdir");
        return tempFolder + File.separator + fileUuId;
    }

    public static String getFileExtension(String path) {
        if (path != null) {
            String filename = path;
            int i = filename.lastIndexOf(46);
            int j = filename.lastIndexOf(File.separator);
            if (i > 0 && i < filename.length() - 1 && j < i) {
                return filename.substring(i + 1).toLowerCase();
            }
        }
        return null;
    }

    public static boolean isSupportFileType(String filePath) {
        String fileExtension = GlobalFunction.getFileExtension(filePath);
        if (fileExtension == null) {
            return false;
        }
        return "xls".equalsIgnoreCase(fileExtension) || "xlsx".equalsIgnoreCase(fileExtension) || "txt".equalsIgnoreCase(fileExtension) || "csv".equalsIgnoreCase(fileExtension) || "xml".equalsIgnoreCase(fileExtension);
    }

    public static boolean isExcelFileType(String filePath) {
        String fileExtension = GlobalFunction.getFileExtension(filePath);
        if (fileExtension == null) {
            return false;
        }
        return "xls".equalsIgnoreCase(fileExtension) || "xlsx".equalsIgnoreCase(fileExtension);
    }

    public static byte[] readFile(String fileName) throws Exception {
        FileInputStream file = null;
        byte[] fileData = null;
        try {
            file = new FileInputStream(fileName);
            fileData = new byte[file.available()];
            file.read(fileData);
        }
        catch (Exception err) {
            throw err;
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException iOException) {}
                file = null;
            }
        }
        return fileData;
    }

    public static final String excelFileSaverMulti(Component parent) throws Exception {
        String sFileName = null;
        KDFileChooser choose = new KDFileChooser(GlobalFunction.getHistoryPath());
        SimpleFileFilter ff1 = new SimpleFileFilter(new String[]{"xlsx"});
        SimpleFileFilter ff2 = new SimpleFileFilter(new String[]{"xls"});
        ff1.setDescription("excel2007");
        ff2.setDescription("excel97-2003");
        choose.removeChoosableFileFilter(choose.getFileFilter());
        choose.addChoosableFileFilter((FileFilter)ff1);
        choose.addChoosableFileFilter((FileFilter)ff2);
        boolean isFileValid = false;
        while (!isFileValid) {
            choose.setFileFilter((FileFilter)ff1);
            int rVal = choose.showSaveDialog(parent);
            GlobalFunction.updateHistoryPath(choose.getCurrentDirectory().getPath());
            if (rVal == 0) {
                String description;
                File retFile = choose.getSelectedFile();
                sFileName = retFile.getPath();
                logger.info((Object)("file path1:" + sFileName));
                String extendName = null;
                extendName = choose.getFileFilter() instanceof SimpleFileFilter ? ((description = ((SimpleFileFilter)choose.getFileFilter()).getDescription()).indexOf("xlsx") >= 0 ? "xlsx" : (description.indexOf("xls") >= 0 ? "xls" : "xls")) : "xls";
                if (!sFileName.endsWith("." + extendName)) {
                    sFileName = new StringBuffer(sFileName).append(".").append(extendName).toString();
                }
                retFile = new File(sFileName);
                logger.info((Object)("file path2:" + sFileName));
                if (!GlobalFunction.isSupportFileType(sFileName)) {
                    MsgBox.showInfo((Component)parent, (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"supportfiletype"));
                    isFileValid = false;
                    sFileName = "";
                    continue;
                }
                if (retFile.exists()) {
                    int result = MsgBox.showConfirm2((Component)parent, (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"fileHasExisted"));
                    if (result == 0) {
                        isFileValid = true;
                        GlobalFunction.updateHistoryPath(choose.getCurrentDirectory().getPath());
                        continue;
                    }
                    isFileValid = false;
                    continue;
                }
                GlobalFunction.updateHistoryPath(choose.getCurrentDirectory().getPath());
                isFileValid = true;
                continue;
            }
            sFileName = "";
            isFileValid = true;
        }
        return sFileName;
    }
}

