/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tools.datatask.util;

import com.kingdee.eas.tools.datatask.util.FileTransferInfo;
import com.kingdee.eas.tools.datatask.util.GlobalFunction;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class ZipUtil {
    private static Logger logger = Logger.getLogger(ZipUtil.class);
    private static final int BLOCK = 0xA00000;
    private static final int BUFSIZE = 0x100000;
    private static String filePath = GlobalFunction.getFilePathForServer();
    private static final String SUFFIX = ".gz";
    private FileOutputStream fout = null;

    public static List<String> gzipFile(File file) throws Exception {
        ArrayList<String> listFileName = new ArrayList<String>();
        String gzipName = GlobalFunction.getUuID();
        listFileName.add(gzipName + SUFFIX);
        FileInputStream is = null;
        FileOutputStream fout = null;
        DeflaterOutputStream gzip = null;
        try {
            byte[] data = new byte[0x100000];
            int sum = 0;
            int count = 0;
            is = new FileInputStream(file);
            fout = new FileOutputStream(filePath + gzipName + SUFFIX);
            gzip = new GZIPOutputStream((OutputStream)fout, 0x100000);
            while ((count = is.read(data, 0, 0x100000)) != -1) {
                if ((sum += count) <= 0xA00000) {
                    ((GZIPOutputStream)gzip).write(data, 0, count);
                    continue;
                }
                sum = 0;
                gzip.flush();
                gzip.close();
                fout.close();
                gzipName = GlobalFunction.getUuID();
                listFileName.add(gzipName + SUFFIX);
                fout = new FileOutputStream(filePath + gzipName + SUFFIX);
                gzip = new GZIPOutputStream((OutputStream)fout, 0x100000);
                ((GZIPOutputStream)gzip).write(data, 0, count);
            }
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (IOException ie) {
            logger.error((Object)ie.getMessage(), (Throwable)ie);
            throw ie;
        }
        finally {
            try {
                if (gzip != null) {
                    gzip.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return listFileName;
    }

    public static void unGzipFile(byte[] data, FileOutputStream fout) throws Exception {
        GZIPInputStream gzin = null;
        try {
            int count;
            gzin = new GZIPInputStream((InputStream)new ByteArrayInputStream(data), 0x100000);
            byte[] buf = new byte[0x100000];
            while ((count = gzin.read(buf, 0, 0x100000)) != -1) {
                fout.write(buf, 0, count);
            }
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (gzin != null) {
                    gzin.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void unGzipFile(byte[] data, String filePath) throws Exception {
        try {
            if (this.fout == null) {
                this.fout = new FileOutputStream(filePath);
            }
            ZipUtil.unGzipFile(data, this.fout);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void close() {
        try {
            if (this.fout != null) {
                this.fout.close();
                this.fout = null;
            }
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static List<String> gzipFile(File file, boolean isDeleteSrcFile) throws Exception {
        List<String> fileName = ZipUtil.gzipFile(file);
        if (isDeleteSrcFile && file.isFile() && file.exists()) {
            file.delete();
        }
        return fileName;
    }

    public static void setFilePath(String filePath) {
        ZipUtil.filePath = filePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileTransferInfo getFileTransfer(String fileName, long pos) {
        FileTransferInfo fileInfo = new FileTransferInfo();
        byte[] buf = new byte[0x100000];
        RandomAccessFile randomfile = null;
        try {
            String path = filePath + fileName;
            path = FilenameUtils.normalize((String)path);
            if (path != null) {
                randomfile = new RandomAccessFile(path, "r");
                randomfile.seek(pos);
                int readsize = randomfile.read(buf);
                fileInfo.setBuf(buf);
                fileInfo.setReadSize(readsize);
                fileInfo.setFileName(fileName);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (randomfile != null) {
                try {
                    randomfile.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return fileInfo;
    }
}

