/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.condition;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ColumnDataType;
import com.kingdee.eas.dynbusiness.IBusinessConfigItem;
import com.kingdee.eas.dynbusiness.condition.ConditionItem;
import com.kingdee.eas.dynbusiness.condition.ILevelFrom;
import com.kingdee.eas.dynbusiness.condition.IPreBatchFetch;
import com.kingdee.eas.dynbusiness.condition.IPropertyInitialization;
import com.kingdee.eas.dynbusiness.condition.IPropertySupport;
import com.kingdee.eas.dynbusiness.condition.ISelectorSupport;
import com.kingdee.eas.dynbusiness.condition.ITableSQLBuild;
import com.kingdee.eas.dynbusiness.condition.ListItem;
import com.kingdee.eas.dynbusiness.condition.PropertyItem;
import com.kingdee.eas.dynbusiness.util.ArrayUtils;
import com.kingdee.eas.dynbusiness.util.ValidationUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class Condition
implements ILevelFrom,
ITableSQLBuild,
IPreBatchFetch,
ISelectorSupport,
IPropertyInitialization,
IBusinessConfigItem {
    static final Logger logger = Logger.getLogger(Condition.class);
    ConditionItem item;
    String comparison;
    ConditionItem value;

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.item.toString());
        sb.append(this.comparison);
        sb.append(this.value.toString());
        return sb.toString();
    }

    private boolean[] calculateResultsLoopEntry(IObjectValue objValue, int level, Map paramMap, String objName, String entriesName) throws EASBizException, BOSException {
        Context ctx = (Context)paramMap.get("_CTX");
        IObjectCollection objCollection = (IObjectCollection)objValue.get(entriesName);
        if (objCollection == null || objCollection.size() == 0) {
            return new boolean[]{false};
        }
        boolean result = false;
        DataType dataType = null;
        String className = null;
        Object iValue = null;
        Object vValue = null;
        boolean[] results = new boolean[objCollection.size()];
        objName = entriesName;
        int size = objCollection.size();
        for (int idxOfEntry = 0; idxOfEntry < size; ++idxOfEntry) {
            if (this.item instanceof IPropertySupport) {
                IPropertySupport iItem = (IPropertySupport)((Object)this.item);
                iValue = iItem.getValue(objCollection.getObject(idxOfEntry), level + 1, paramMap, objName);
                dataType = iItem.getDataType(ctx);
                className = iItem.getClassName(ctx);
                if (iValue != null && iValue instanceof IObjectValue) {
                    iValue = ((BOSUuid)((IObjectValue)iValue).get(((IObjectValue)iValue).getPKField())).toString();
                }
            }
            if (this.value instanceof IPropertySupport) {
                vValue = ((IPropertySupport)((Object)this.value)).getValue(objCollection.getObject(idxOfEntry), level + 1, paramMap, objName);
                if (vValue instanceof Object[]) {
                    results[idxOfEntry] = this.campareWithArray(iValue, (Object[])vValue, dataType, className);
                    continue;
                }
            } else {
                vValue = this.value.getName();
            }
            if (vValue != null && vValue instanceof IObjectValue) {
                vValue = ((BOSUuid)((IObjectValue)vValue).get(((IObjectValue)vValue).getPKField())).toString();
            }
            if (dataType != null) {
                result = ValidationUtils.doRealCompare(iValue, vValue, this.comparison, dataType, className);
            }
            results[idxOfEntry] = result;
        }
        return results;
    }

    private boolean campareWithArray(Object iValue, Object[] values, DataType dataType, String className) {
        boolean result = false;
        if (this.comparison.equalsIgnoreCase("in") || this.comparison.equalsIgnoreCase("notIn")) {
            result = ValidationUtils.doRealCompare(iValue, values, this.comparison, dataType, className);
        } else {
            for (int idx = 0; idx < values.length; ++idx) {
                if (dataType != null) {
                    result = ValidationUtils.doRealCompare(iValue, values[idx], this.comparison, dataType, className);
                }
                if (!result) break;
            }
        }
        return result;
    }

    public boolean[] calculateResults(IObjectValue objValue, int level, Map paramMap, String objName) throws EASBizException, BOSException {
        String entriesName = (String)paramMap.get("_ENTRISENAME");
        if (level == 0 && this.item.hasLevelGreaterZero(entriesName + ".")) {
            if (this.item instanceof PropertyItem) {
                entriesName = ((PropertyItem)this.item).getEntryName();
            }
            return this.calculateResultsLoopEntry(objValue, level, paramMap, objName, entriesName);
        }
        boolean result = false;
        DataType dataType = null;
        String className = null;
        Object iValue = null;
        Object vValue = null;
        Context ctx = (Context)paramMap.get("_CTX");
        if (this.item instanceof IPropertySupport) {
            IPropertySupport iItem = (IPropertySupport)((Object)this.item);
            iValue = iItem.getValue(objValue, level, paramMap, objName);
            dataType = iItem.getDataType(ctx);
            className = iItem.getClassName(ctx);
            if (iValue != null && iValue instanceof IObjectValue) {
                iValue = ((BOSUuid)((IObjectValue)iValue).get(((IObjectValue)iValue).getPKField())).toString();
            }
        }
        if (this.value instanceof IPropertySupport) {
            vValue = ((IPropertySupport)((Object)this.value)).getValue(objValue, level, paramMap, objName);
            if (vValue instanceof Object[]) {
                Object[] values = (Object[])vValue;
                if (this.comparison.equals("in") || this.comparison.equals("notIn")) {
                    result = ValidationUtils.doRealCompare(iValue, values, this.comparison, dataType, className);
                } else {
                    for (int i = 0; i < values.length; ++i) {
                        if (dataType != null) {
                            result = ValidationUtils.doRealCompare(iValue, values[i], this.comparison, dataType, className);
                        }
                        if (result) continue;
                        return new boolean[]{false};
                    }
                }
                return new boolean[]{result};
            }
        } else {
            vValue = this.value.getName();
        }
        if (dataType != null) {
            result = ValidationUtils.doRealCompare(iValue, vValue, this.comparison, dataType, className);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u6761\u4ef6\u9879[" + this.toString() + "]\u7684\u503c\u4e3a" + result));
        }
        return new boolean[]{result};
    }

    public String buildUpdColList() {
        return this.item.getExpression();
    }

    @Override
    public String buildConditon(boolean isToSum, String[] columns) {
        StringBuffer sb = new StringBuffer();
        if (this.item instanceof ITableSQLBuild) {
            sb.append(((ITableSQLBuild)((Object)this.item)).buildConditon(isToSum, null));
        } else {
            sb.append(this.item.getName());
        }
        sb.append(" ");
        if ("isNull".equalsIgnoreCase(this.getComparison())) {
            sb.append("IS NULL");
        } else if ("isNotNull".equalsIgnoreCase(this.getComparison())) {
            sb.append("IS NOT NULL");
        } else {
            sb.append(this.getComparison());
        }
        sb.append(" ");
        if (this.value instanceof ITableSQLBuild) {
            sb.append(((ITableSQLBuild)((Object)this.value)).buildConditon(isToSum, null));
        } else if (this.value instanceof ListItem) {
            try {
                sb.append("(");
                Object[] values = (Object[])((ListItem)this.value).getValue(null, 0, null, null);
                for (int i = 0; i < values.length; ++i) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append(values[i]);
                }
                sb.append(")");
            }
            catch (EASBizException e) {
                logger.error((Object)e);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        } else {
            sb.append(this.value.getName());
        }
        return sb.toString();
    }

    @Override
    public boolean hasLevelGreaterZero(String alias) {
        return this.item.hasLevelGreaterZero(alias) || this.getValue().hasLevelGreaterZero(alias);
    }

    @Override
    public boolean hasLevelZero(String alias) {
        return this.item.hasLevelZero(alias) || this.getValue().hasLevelZero(alias);
    }

    public String getComparison() {
        return this.comparison;
    }

    public void setComparison(String comparison) {
        this.comparison = comparison;
    }

    public ConditionItem getItem() {
        return this.item;
    }

    public void setItem(ConditionItem item) {
        this.item = item;
    }

    public ConditionItem getValue() {
        return this.value;
    }

    public void setValue(ConditionItem value) {
        this.value = value;
    }

    @Override
    public boolean hasMulOrDivOperation(int levelFrom) {
        return this.item instanceof ITableSQLBuild && ((ITableSQLBuild)((Object)this.item)).hasMulOrDivOperation(levelFrom) || this.value instanceof ITableSQLBuild && ((ITableSQLBuild)((Object)this.value)).hasMulOrDivOperation(levelFrom);
    }

    @Override
    public String buildJoin() {
        String join = "";
        if (this.item instanceof ITableSQLBuild) {
            join = ((ITableSQLBuild)((Object)this.item)).buildJoin();
        }
        if (join == null && this.value instanceof ITableSQLBuild) {
            join = ((ITableSQLBuild)((Object)this.value)).buildJoin();
        }
        return join;
    }

    @Override
    public String[] getGroupByFields(int levelFrom) {
        String[] result1 = null;
        String[] result2 = null;
        if (this.item instanceof ITableSQLBuild) {
            result1 = ((ITableSQLBuild)((Object)this.item)).getGroupByFields(levelFrom);
        }
        if (this.value instanceof ITableSQLBuild) {
            result2 = ((ITableSQLBuild)((Object)this.value)).getGroupByFields(levelFrom);
        }
        return ArrayUtils.mergeArray(result1, result2);
    }

    @Override
    public void setDataType(ColumnDataType dataType) {
    }

    @Override
    public void collectPreFetchItems(List items, String entriesName) {
        if (this.item instanceof IPreBatchFetch) {
            ((IPreBatchFetch)((Object)this.item)).collectPreFetchItems(items, entriesName);
        }
        if (this.value instanceof IPreBatchFetch) {
            ((IPreBatchFetch)((Object)this.value)).collectPreFetchItems(items, entriesName);
        }
    }

    @Override
    public void preBatchFetch(IObjectCollection objCollection, int level, Map paramMap) throws EASBizException, BOSException {
    }

    @Override
    public String[] getColumnNames(int levelFrom, boolean withAlias) {
        String[] result1 = null;
        String[] result2 = null;
        if (this.item instanceof ITableSQLBuild) {
            result1 = ((ITableSQLBuild)((Object)this.item)).getColumnNames(levelFrom, withAlias);
        }
        if (this.value instanceof ITableSQLBuild) {
            result2 = ((ITableSQLBuild)((Object)this.value)).getColumnNames(levelFrom, withAlias);
        }
        return ArrayUtils.mergeArray(result1, result2);
    }

    @Override
    public List getSelectorList() {
        ArrayList result = new ArrayList();
        if (this.item instanceof ISelectorSupport) {
            result.addAll(((ISelectorSupport)((Object)this.item)).getSelectorList());
        }
        if (this.value instanceof ISelectorSupport) {
            result.addAll(((ISelectorSupport)((Object)this.value)).getSelectorList());
        }
        return result;
    }

    @Override
    public PropertyInfo[] getPropertyInfo(EntityObjectInfo mainEo, Map subEntities) {
        if (this.item instanceof IPropertyInitialization) {
            ((IPropertyInitialization)((Object)this.item)).getPropertyInfo(mainEo, subEntities);
        }
        if (this.value instanceof IPropertyInitialization) {
            ((IPropertyInitialization)((Object)this.value)).getPropertyInfo(mainEo, subEntities);
        }
        return null;
    }

    @Override
    public String getEntryName() {
        if (this.item instanceof IPropertyInitialization) {
            return ((IPropertyInitialization)((Object)this.item)).getEntryName();
        }
        if (this.value instanceof IPropertyInitialization) {
            return ((IPropertyInitialization)((Object)this.value)).getEntryName();
        }
        return null;
    }
}

