/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.condition;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.kscript.runtime.Interpreter;
import com.kingdee.bos.kscript.runtime.InterpreterException;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.condition.ConditionItem;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.dynbusiness.condition.IPropertySupport;
import com.kingdee.eas.dynbusiness.condition.ObjectValueSearcher;
import com.kingdee.eas.dynbusiness.function.FunctionLoader;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.dynbusiness.util.ExpressionParser;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PropertyItem
extends ConditionItem
implements IPropertySupport {
    static final Logger logger = Logger.getLogger(PropertyItem.class);
    private DataType dataType;
    PropertyInfo[] propertyInfos;
    BOSObjectType bosType;
    String entryName;

    public BOSObjectType getBosType() {
        return this.bosType;
    }

    public void setBosType(BOSObjectType bosType) {
        this.bosType = bosType;
    }

    @Override
    public PropertyInfo[] getPropertyInfo(EntityObjectInfo mainEo, Map subEntities) {
        if (this.propertyInfos != null) {
            return this.propertyInfos;
        }
        ArrayList<PropertyInfo> propList = new ArrayList<PropertyInfo>();
        ExpressionParser exprParser = ExpressionParser.getInstance();
        String[] thisProps = this.splitProperties();
        for (int i = 0; i < thisProps.length; ++i) {
            if (Conditions.isTemporaryVariable(thisProps[i])) continue;
            String[] props = exprParser.splitPropertise(thisProps[i]);
            propList.add(BusinessProcessUtil.getPropertyInfo(mainEo, thisProps[i], props, subEntities));
            if (props.length <= 1) continue;
            try {
                if (!BusinessProcessUtil.isEntryProperty(mainEo, props[0])) continue;
                this.entryName = props[0];
                continue;
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
        this.propertyInfos = propList.toArray(new PropertyInfo[0]);
        return this.propertyInfos;
    }

    private String[] splitProperties() {
        ExpressionParser exprParser = ExpressionParser.getInstance();
        String[] thisProps = exprParser.splitVariables(this.getName());
        return thisProps;
    }

    @Override
    public Object getValue(IObjectValue objValue, int level, Map paramMap, String objName) throws EASBizException, BOSException {
        String entriesName = (String)paramMap.get("_ENTRISENAME");
        if (this.isAggregation(entriesName, level)) {
            return this.calculateAggregation(objValue, level, paramMap, objName, entriesName, this.getSplits());
        }
        if (FunctionLoader.isFunction(this.getCalculate())) {
            return this.calculateFunction(objValue, level, paramMap, objName, entriesName, this.getSplits());
        }
        return this.calculateValue(objValue, level, paramMap, objName, this.getSplits());
    }

    private Object calculateValue(IObjectValue objValue, int level, Map paramMap, String objName, String[] splits) throws EASBizException, BOSException {
        ExpressionParser exprParser = ExpressionParser.getInstance();
        if (!exprParser.isExpression(this.getName())) {
            return ObjectValueSearcher.searchValue((Object)objValue, splits, level, objName, paramMap);
        }
        return this.calculateExpressionValue(objValue, level, paramMap, objName, exprParser);
    }

    private Object calculateExpressionValue(IObjectValue objValue, int level, Map paramMap, String objName, ExpressionParser exprParser) throws InterpreterException, ParserException {
        int i;
        Object[] results = null;
        String[] vars = exprParser.splitVariables2(this.getName());
        String entryName = (String)paramMap.get("_ENTRISENAME") + ".";
        boolean hasEntry = false;
        for (int i2 = 0; i2 < vars.length && !(hasEntry = vars[i2].startsWith(entryName)); ++i2) {
        }
        int size = 1;
        if (hasEntry) {
            IObjectCollection collection = (IObjectCollection)objValue.get((String)paramMap.get("_ENTRISENAME"));
            if (collection == null || collection.size() == 0) {
                return null;
            }
            size = collection.size();
            results = new Object[size];
        } else {
            results = new Object[size];
        }
        Map[] contexts = new Map[size];
        for (i = 0; i < size; ++i) {
            contexts[i] = new HashMap(vars.length);
        }
        for (i = 0; i < vars.length; ++i) {
            String[] splits2 = Conditions.isTemporaryVariable(vars[i]) ? new String[]{vars[i]} : vars[i].split("\\.");
            Object value = ObjectValueSearcher.searchValue((Object)objValue, splits2, level, objName, paramMap);
            if (value instanceof Object[]) {
                Object[] values = (Object[])value;
                for (int idxOfCtx = 0; idxOfCtx < size; ++idxOfCtx) {
                    contexts[idxOfCtx].put(vars[i], values[idxOfCtx]);
                }
                continue;
            }
            for (int idxOfCtx = 0; idxOfCtx < size; ++idxOfCtx) {
                contexts[idxOfCtx].put(vars[i], value);
            }
        }
        for (i = 0; i < size; ++i) {
            results[i] = this.loopCalculateValue(exprParser, vars, contexts[i]);
        }
        return hasEntry ? results : results[0];
    }

    private Object loopCalculateValue(ExpressionParser exprParser, String[] vars, Map context) throws InterpreterException, ParserException {
        HashMap context2 = new HashMap(vars.length);
        Interpreter interpreter = new Interpreter();
        String expr = this.getName();
        for (Map.Entry entry : context.entrySet()) {
            String key = (String)entry.getKey();
            String newKey = null;
            if (key.indexOf(46) >= 0) {
                newKey = key.replaceAll("\\.", "_");
            }
            if (Conditions.isTemporaryVariable(key)) {
                String string = newKey = newKey == null ? key.substring(1, key.length() - 1) : newKey.substring(1, newKey.length() - 1);
            }
            if (newKey == null) continue;
            context2.put(newKey, entry.getValue());
            expr = expr.replaceAll(exprParser.castRegular(key), newKey);
        }
        if (context2.size() > 0) {
            context.putAll(context2);
        }
        return interpreter.eval(expr, context);
    }

    private Object calculateFunction(IObjectValue objValue, int level, Map paramMap, String objName, String entriesName, String[] splits) throws EASBizException, BOSException {
        Object value = this.calculateValue(objValue, level, paramMap, objName, this.getSplits());
        return FunctionLoader.calculateFunction(value, this.getCalculate(), paramMap);
    }

    private boolean isAggregation(String entriesName, int level) {
        if (level == 0 && this.getCalculate() != null && this.getCalculate().equalsIgnoreCase("sum")) {
            ExpressionParser exprParser = ExpressionParser.getInstance();
            if (!exprParser.isExpression(this.getName())) {
                return this.getName().startsWith(entriesName + ".");
            }
            String[] vars = exprParser.splitVariables(this.getName());
            for (int i = 0; i < vars.length; ++i) {
                if (!vars[i].startsWith(entriesName + ".")) continue;
                return true;
            }
        }
        return false;
    }

    private Object calculateAggregation(IObjectValue objValue, int level, Map paramMap, String objName, String entriesName, String[] splits) throws EASBizException, BOSException {
        BigDecimal result = new BigDecimal("0.0");
        IObjectCollection objCollection = (IObjectCollection)objValue.get(entriesName);
        if (objCollection == null || objCollection.size() == 0) {
            return result;
        }
        for (IObjectValue entryObj : objCollection) {
            Object value = this.calculateValue(entryObj, 1, paramMap, entriesName, splits);
            if (!(value instanceof BigDecimal)) continue;
            result = result.add((BigDecimal)value);
        }
        return result;
    }

    public PropertyItem(String name) {
        super(name);
    }

    @Override
    public String getExpression() {
        return null;
    }

    @Override
    public String[] getSplits() {
        if (this.splits == null) {
            ExpressionParser exprParser = ExpressionParser.getInstance();
            this.splits = exprParser.splitPropertise(this.getName());
        }
        return super.getSplits();
    }

    public PropertyInfo[] getPropertyInfos() {
        return this.propertyInfos;
    }

    public void setPropertyInfos(PropertyInfo[] propertyInfo) {
        this.propertyInfos = propertyInfo;
    }

    @Override
    public DataType getDataType(Context ctx) throws BOSException {
        if (this.dataType != null) {
            return this.dataType;
        }
        if (this.propertyInfos == null || this.propertyInfos.length == 0) {
            return DataType.INTEGER;
        }
        this.dataType = BusinessProcessUtil.getDataType(this.propertyInfos[0]);
        return this.dataType;
    }

    @Override
    public String getClassName(Context ctx) throws BOSException {
        DataType dataType = this.getDataType(ctx);
        if (dataType.equals((Object)DataType.ENUM)) {
            BizEnumInfo enumInfo = ((OwnPropertyInfo)this.propertyInfos[0]).getEnumType();
            return enumInfo.getClassName();
        }
        return null;
    }

    @Override
    public List getSelectorList() {
        ArrayList<SelectorItemInfo> selectorList = new ArrayList<SelectorItemInfo>();
        if (!Conditions.isTemporaryVariable(this.getName())) {
            ExpressionParser exprParser = ExpressionParser.getInstance();
            if (!exprParser.isExpression(this.getName())) {
                selectorList.add(new SelectorItemInfo(this.getName()));
            } else {
                String[] vars = exprParser.splitVariables(this.getName());
                for (int i = 0; i < vars.length; ++i) {
                    selectorList.add(new SelectorItemInfo(vars[i]));
                }
            }
        }
        return selectorList;
    }

    public void setDataType(String dataType) {
        if (dataType == null || dataType.length() == 0) {
            return;
        }
        try {
            this.dataType = (DataType)DataType.class.getField(dataType.toUpperCase()).get(dataType);
        }
        catch (SecurityException e) {
            logger.error((Object)e);
        }
        catch (NoSuchFieldException e) {
            logger.error((Object)e);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e);
        }
    }

    @Override
    public boolean hasLevelGreaterZero(String alias) {
        ExpressionParser exprParser = ExpressionParser.getInstance();
        if (!exprParser.isExpression(this.getName())) {
            boolean result = this.getName().startsWith(alias);
            return result || this.entryName != null;
        }
        String[] vars = exprParser.splitVariables(this.getName());
        for (int i = 0; i < vars.length; ++i) {
            if (!vars[i].startsWith(alias)) continue;
            return true;
        }
        return super.hasLevelGreaterZero(alias);
    }

    @Override
    public String getEntryName() {
        return this.entryName;
    }
}

