/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.config;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.dynbusiness.IBusinessConfigItem;
import com.kingdee.eas.dynbusiness.TableTypeEnum;

public class BusinessObjectStructure
implements IBusinessConfigItem {
    private int level = 0;
    private LevelStructure[] structures;

    public void setLevel(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public String getRelationField(TableTypeEnum table) {
        return this.getRelationField(this.level, table);
    }

    public String getRelationField(int level, TableTypeEnum table) {
        EntityStructure es = this.getEntityStructure(level, table);
        if (es != null) {
            return es.getRelation();
        }
        return null;
    }

    private EntityStructure getEntityStructure(int level, TableTypeEnum table) {
        EntityStructure es = null;
        es = TableTypeEnum.ENTRY.equals(table) ? this.getEntryEntityStructure(level) : this.getHeadEntityStructure(level);
        return es;
    }

    public String getTableName(int level, TableTypeEnum table) {
        EntityStructure es = this.getEntityStructure(level, table);
        if (es == null) {
            return null;
        }
        return es.getTableName();
    }

    private LevelStructure getLevelStructure(int level) {
        if (level < 0 || level > 2) {
            throw new IllegalArgumentException("level\u53c2\u6570\u503c\u65e0\u6548\uff0c\u5fc5\u987b\u57280-2\u4e4b\u95f4");
        }
        return this.structures[level];
    }

    private EntityStructure getEntryEntityStructure(int level) {
        LevelStructure ls = this.getLevelStructure(level);
        if (ls == null) {
            return null;
        }
        EntityStructure es = ls.getEntity();
        if (es.getEntries() != null && es.getEntries().length > 0) {
            return es.getEntries()[0];
        }
        return null;
    }

    private EntityStructure getHeadEntityStructure(int level) {
        LevelStructure ls = this.getLevelStructure(level);
        if (ls == null) {
            return null;
        }
        return ls.getEntity();
    }

    public String getRelationFieldWithAlias() {
        if (this.level == 1) {
            String entryAlias = this.getRelationTableAlias(this.level);
            StringBuffer sb = new StringBuffer();
            sb.append(entryAlias);
            sb.append(".");
            sb.append(this.getRelationField(TableTypeEnum.ENTRY));
            return sb.toString();
        }
        return "idtemp.FEntryId";
    }

    private String getRelationTableAlias(int level) {
        EntityStructure es = this.getEntryEntityStructure(level);
        String entryAlias = level == 1 ? (TableTypeEnum.ENTRY.equals(es.getRalationTable()) ? "entry" : "head") : (TableTypeEnum.ENTRY.equals(es.getRalationTable()) ? "src0e" : "src0");
        return entryAlias;
    }

    public String buildInnerJoinClauseForHD(int level, TableTypeEnum table) {
        EntityStructure es = this.getEntityStructure(level, table);
        String link = null;
        if (table.equals(TableTypeEnum.HEAD)) {
            EntityStructure entryEs = this.getEntryEntityStructure(level);
            link = entryEs.getLinkToParent();
        } else {
            link = es.getLinkToParent();
        }
        String headTableAlias = null;
        String entryTableAlias = null;
        if (level == 0) {
            headTableAlias = "head";
            entryTableAlias = "entry";
        } else {
            headTableAlias = "src";
            entryTableAlias = "srce";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("INNER JOIN ").append(es.getTableName()).append(" ").append(table.equals(TableTypeEnum.HEAD) ? headTableAlias : entryTableAlias).append(" ON ").append(headTableAlias).append(".FID=").append(entryTableAlias).append(".").append(link).append("\r\n");
        return sb.toString();
    }

    public String buildJoinClause(int level) {
        String headTableName = this.getTableName(0, TableTypeEnum.HEAD);
        EntityStructure es = this.getEntryEntityStructure(0);
        String entryTableName = es.getTableName();
        StringBuffer sb = new StringBuffer();
        sb.append("FROM ").append(headTableName).append(" ").append("head").append("\r\n");
        if (entryTableName != null) {
            sb.append("INNER JOIN ").append(entryTableName).append(" ").append("entry").append(" ON ").append("head").append(".FID=").append("entry").append(".").append(es.getLinkToParent()).append("\r\n");
        }
        if (level == 0) {
            return sb.toString();
        }
        this.buildJoinClauseForWriteBack(level, sb);
        return sb.toString();
    }

    public String buildJoinClauseFor2Level() {
        return this.buildJoinClauseFor2Level(this.level, null);
    }

    private String buildJoinClauseFor2Level(int level, String tableAlias) {
        StringBuffer sb = new StringBuffer();
        if (tableAlias == null) {
            tableAlias = this.getRelationTableAlias(level);
        }
        EntityStructure es = this.getEntryEntityStructure(1);
        sb.append("INNER JOIN ").append(es.getTableName()).append(" ").append(tableAlias).append(" ON ").append("entry").append(".").append(es.getRelation()).append("=").append(tableAlias).append(".FID ").append("\r\n");
        return sb.toString();
    }

    private void buildJoinClauseForWriteBack(int level, StringBuffer sb) {
        String entryAlias = this.getRelationTableAlias(level);
        if (level > 1) {
            sb.append(this.buildJoinClauseFor2Level());
        }
        EntityStructure es = this.getEntryEntityStructure(level);
        EntityStructure headEs = this.getHeadEntityStructure(level);
        if (es != null) {
            sb.append("INNER JOIN ").append(es.getTableName()).append(" ").append("srce").append(" ON ");
            sb.append(entryAlias);
            sb.append(".").append(es.getRelation()).append("=").append("srce").append(".FID ").append("\r\n");
            sb.append("INNER JOIN ").append(headEs.getTableName()).append(" ").append("src").append(" ON ");
            sb.append("srce");
            sb.append(".").append(es.getLinkToParent()).append("=").append("src").append(".FID ").append("\r\n");
        } else {
            sb.append("INNER JOIN ").append(headEs.getTableName()).append(" ").append("src").append(" ON ");
            sb.append(entryAlias);
            sb.append(".").append(headEs.getRelation()).append("=").append("src").append(".FID ").append("\r\n");
        }
    }

    public String buildJoinClauseForAlerting(String oldIdField) {
        String headTableName = this.getTableName(0, TableTypeEnum.HEAD);
        String entryTableName = this.getTableName(0, TableTypeEnum.ENTRY);
        StringBuffer sb = new StringBuffer();
        sb.append("INNER JOIN ").append(entryTableName).append(" ").append("oentry").append(" ON ").append("oentry").append(".").append(oldIdField).append("=").append("entry").append(".FID ").append("\r\n");
        sb.append("INNER JOIN ").append(headTableName).append(" ").append("ohead").append(" ON ").append("ohead").append(".FID=").append("oentry").append(".FParentID AND ").append("ohead").append(".FVersion=").append("head").append(".FVersion-1").append("\r\n");
        return sb.toString();
    }

    public String buildLockSourceTableSql() throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE ");
        sb.append(this.getTableName(this.level, TableTypeEnum.ENTRY));
        sb.append("\r\n");
        sb.append("SET FID=FID WHERE FID IN (");
        sb.append("???");
        sb.append(")");
        return sb.toString();
    }

    public String buildObtainSrcIdSelectSql(boolean hasFSourceBillTypeIdColumn) throws BOSException {
        String entryAlias = null;
        entryAlias = this.getLevel() == 1 ? "entry" : "src0e";
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ").append(entryAlias).append(".").append(this.getRelationField(TableTypeEnum.HEAD)).append(", ").append(entryAlias).append(".");
        sb.append(this.getRelationField(TableTypeEnum.ENTRY)).append("\r\n").append(", ");
        sb.append(this.getLevel() == 1 ? "head" : "entry");
        sb.append(".FID");
        if (this.getLevel() > 1) {
            sb.append(", ");
            sb.append("entry");
            sb.append(".FSrc0EntryID");
        }
        sb.append("\r\n");
        if (this.getLevel() == 1) {
            sb.append(this.buildJoinClause(0));
        } else {
            sb.append("FROM ");
            sb.append("@IDTABLE");
            sb.append(" ");
            sb.append("entry");
            sb.append("\r\n");
        }
        if (this.getLevel() > 1 || !hasFSourceBillTypeIdColumn) {
            sb.append(this.buildJoinClauseFor2Level(0, this.getRelationTableAlias2(this.level)));
        }
        return sb.toString();
    }

    private String getRelationTableAlias2(int level) {
        EntityStructure es = this.getEntryEntityStructure(level);
        String entryAlias = level == 1 ? (TableTypeEnum.ENTRY.equals(es.getRalationTable()) ? "srce" : "src") : (TableTypeEnum.ENTRY.equals(es.getRalationTable()) ? "src0e" : "src0");
        return entryAlias;
    }

    public void mergeStructure(BusinessObjectStructure other) {
        if (other == null) {
            return;
        }
        for (int i = 0; i < other.structures.length; ++i) {
            if (other.structures[i] == null) continue;
            this.structures[i] = other.structures[i];
        }
    }

    public BusinessObjectStructure(LevelStructure[] structures) {
        this.structures = structures;
    }

    public static class EntityStructure {
        private String name;
        private String alias;
        private String bosType;
        private String linkToParent;
        private TableTypeEnum ralationTable;
        private String relation;
        private String tableName;
        private EntityStructure[] entries;

        public TableTypeEnum getRalationTable() {
            return this.ralationTable;
        }

        public void setRalationTable(TableTypeEnum ralationTable) {
            this.ralationTable = ralationTable;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public String getBosType() {
            return this.bosType;
        }

        public void setBosType(String bosType) {
            this.bosType = bosType;
        }

        public String getLinkToParent() {
            return this.linkToParent;
        }

        public void setLinkToParent(String link) {
            this.linkToParent = link;
        }

        public String getRelation() {
            return this.relation;
        }

        public void setRelation(String relation) {
            this.relation = relation;
        }

        public String getTableName() {
            return this.tableName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public EntityStructure[] getEntries() {
            return this.entries;
        }

        public void setEntries(EntityStructure[] entries) {
            this.entries = entries;
        }
    }

    public static class LevelStructure {
        private int level = 0;
        private EntityStructure entity;
        private String billTypeId;

        public String getBillTypeId() {
            return this.billTypeId;
        }

        public void setBillTypeId(String billTypeId) {
            this.billTypeId = billTypeId;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public EntityStructure getEntity() {
            return this.entity;
        }

        public void setEntity(EntityStructure entity) {
            this.entity = entity;
        }
    }
}

