/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.config;

import com.kingdee.eas.dynbusiness.ColumnDataType;
import com.kingdee.eas.dynbusiness.condition.ColumnItem;
import com.kingdee.eas.dynbusiness.condition.ConditionItem;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.dynbusiness.condition.ILevelFrom;
import com.kingdee.eas.dynbusiness.condition.ITableSQLBuild;
import com.kingdee.eas.dynbusiness.config.BusinessResource;
import com.kingdee.eas.dynbusiness.util.ArrayUtils;

public class ColumnPair
implements ILevelFrom {
    private String srcColumn;
    private ConditionItem dstColumn;
    private ColumnDataType type;
    private String calculation;
    private ColumnItem transFromColumn;
    private Conditions conditions;
    private String verificationColumn;
    private BusinessResource resource;
    private Conditions ifConditions;
    private String elseCalculation;

    public String[] getDstColumnNames(int levelFrom, boolean withAlias, boolean isAlerting) {
        if (this.dstColumn instanceof ITableSQLBuild) {
            String[] cols = ((ITableSQLBuild)((Object)this.dstColumn)).getColumnNames(levelFrom, withAlias);
            if (this.isTransformByUnit()) {
                cols = ArrayUtils.mergeArray(cols, this.transFromColumn.getColumnNames(levelFrom, withAlias));
            }
            boolean isAddAlerting = withAlias && isAlerting;
            StringBuffer sb = new StringBuffer();
            if (isAddAlerting) {
                for (int i = 0; i < cols.length; ++i) {
                    sb.append(cols[i]).append(this.getAlertingCalculation()).append(this.getAlertingExpresion(cols[i]));
                    cols[i] = sb.toString();
                    sb.setLength(0);
                }
            }
            if (this.ifConditions != null) {
                String[] ifCols = this.ifConditions.getColumnNames(levelFrom, withAlias);
                cols = ArrayUtils.mergeArray(cols, ifCols);
            }
            if (this.conditions != null) {
                String[] condCols = this.conditions.getColumnNames(levelFrom, withAlias);
                cols = ArrayUtils.mergeArray(cols, condCols);
            }
            return cols;
        }
        return new String[0];
    }

    public boolean isTransformByUnit() {
        return this.transFromColumn != null && ColumnDataType.QTY.equals(this.type);
    }

    public String[] getGroupByFields(int levelFrom) {
        if (this.dstColumn instanceof ITableSQLBuild) {
            String[] cols = new String[]{};
            if (levelFrom == 0) {
                if (this.ifConditions != null) {
                    cols = this.ifConditions.getGroupByFields(0);
                }
                if (this.conditions != null) {
                    String[] condCols = this.conditions.getGroupByFields(0);
                    cols = ArrayUtils.mergeArray(cols, condCols);
                }
            }
            cols = ArrayUtils.mergeArray(cols, ((ITableSQLBuild)((Object)this.dstColumn)).getGroupByFields(levelFrom));
            return cols;
        }
        return new String[0];
    }

    private String getDstExprInSelColList(String fldUnitId, boolean isAlerting) {
        StringBuffer sb = new StringBuffer();
        if (this.type.equals(ColumnDataType.QTY) || this.type.equals(ColumnDataType.AMOUNT) || this.type.equals(ColumnDataType.INT)) {
            String expr;
            if (this.getDstColumn() instanceof ITableSQLBuild) {
                String[] stringArray;
                ITableSQLBuild iTableSQLBuild = (ITableSQLBuild)((Object)this.dstColumn);
                if (this.isTransformByUnit()) {
                    String[] stringArray2 = new String[2];
                    stringArray2[0] = this.transFromColumn.getName();
                    stringArray = stringArray2;
                    stringArray2[1] = fldUnitId;
                } else {
                    stringArray = null;
                }
                expr = iTableSQLBuild.buildConditon(true, stringArray);
            } else {
                expr = this.dstColumn.getExpression();
            }
            if (isAlerting) {
                sb.append(this.getAlertingExpresion(expr));
            } else {
                sb.append(expr);
            }
        } else {
            sb.append(this.dstColumn.getExpression());
        }
        return sb.toString();
    }

    private String getAlertingExpresion(String expr) {
        return expr.replaceAll("entry\\.", "oentry.");
    }

    private String getAlertingCalculation() {
        return this.calculation.equals("+") ? "-" : "+";
    }

    public String buildPailColList(String fldUnitId, boolean isAlerting, boolean isDebug, boolean isElse) {
        boolean hasCondition;
        StringBuffer sb = new StringBuffer();
        boolean bl = hasCondition = this.conditions != null;
        if (!this.calculation.equals("=")) {
            sb.append("srce");
            sb.append(".");
            sb.append(this.srcColumn);
        }
        if (isDebug) {
            if (this.calculation.equals("=")) {
                sb.append("srce");
                sb.append(".");
                sb.append(this.srcColumn);
            }
            return sb.toString();
        }
        if (!this.calculation.equals("=")) {
            sb.append(" ").append(!isElse ? this.calculation : this.elseCalculation).append(" ");
        }
        if (hasCondition) {
            sb.append(" CASE WHEN ");
            sb.append(this.conditions.buildConditon(true, null));
            sb.append(" THEN ");
            sb.append("\r\n");
        }
        sb.append(this.getDstExprInSelColList(fldUnitId, false));
        if (isAlerting) {
            sb.append(this.getAlertingCalculation());
            sb.append(this.getDstExprInSelColList(fldUnitId, true));
        }
        if (hasCondition) {
            sb.append(" ELSE ");
            if (!this.calculation.equals("=")) {
                sb.append("0");
            } else {
                sb.append("srce");
                sb.append(".");
                sb.append(this.srcColumn);
            }
            sb.append(" END ");
        }
        return sb.toString();
    }

    public Conditions getIfConditions() {
        return this.ifConditions;
    }

    public void setIfConditions(Conditions ifConditions) {
        this.ifConditions = ifConditions;
    }

    public String getElseCalculation() {
        return this.elseCalculation;
    }

    public void setElseCalculation(String elseCalculation) {
        this.elseCalculation = elseCalculation;
    }

    public ColumnItem getTransFromColumn() {
        return this.transFromColumn;
    }

    public void setTransFromColumn(ColumnItem transFromColumn) {
        this.transFromColumn = transFromColumn;
    }

    public String getCalculation() {
        return this.calculation;
    }

    public void setCalculation(String calculation) {
        this.calculation = calculation.trim();
        if (!("+".equals(this.calculation) || "-".equals(this.calculation) || "=".equals(this.calculation))) {
            throw new IllegalArgumentException("The calculation must be +/-/= in xml.");
        }
    }

    public ConditionItem getDstColumn() {
        return this.dstColumn;
    }

    public void setDstColumn(ConditionItem dstColumn) {
        this.dstColumn = dstColumn;
    }

    public String getSrcColumn() {
        return this.srcColumn;
    }

    public void setSrcColumn(String srcColumn) {
        this.srcColumn = srcColumn;
    }

    public ColumnDataType getType() {
        return this.type;
    }

    public void setType(ColumnDataType type) {
        this.type = type;
        if (this.dstColumn instanceof ITableSQLBuild) {
            ((ITableSQLBuild)((Object)this.dstColumn)).setDataType(type);
        }
        if (this.transFromColumn != null && this.transFromColumn instanceof ITableSQLBuild) {
            this.transFromColumn.setDataType(type);
        }
    }

    public Conditions getConditions() {
        return this.conditions;
    }

    public void setConditions(Conditions conditions) {
        this.conditions = conditions;
    }

    public BusinessResource getResource() {
        return this.resource;
    }

    public void setResource(BusinessResource resource) {
        this.resource = resource;
    }

    public String getVerificationColumn() {
        return this.verificationColumn;
    }

    public void setVerificationColumn(String verificationColumn) {
        this.verificationColumn = verificationColumn;
    }

    @Override
    public boolean hasLevelGreaterZero(String alias) {
        return false;
    }

    @Override
    public boolean hasLevelZero(String alias) {
        if (this.ifConditions != null) {
            return this.ifConditions.hasLevelZero(alias);
        }
        return false;
    }

    public String buildJoin() {
        String join;
        if (this.dstColumn instanceof ITableSQLBuild && (join = ((ITableSQLBuild)((Object)this.dstColumn)).buildJoin()) != null) {
            return join;
        }
        return "";
    }
}

