/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.expression;

import com.kingdee.eas.dynbusiness.expression.ExpressionExecutor;
import com.kingdee.eas.dynbusiness.expression.IllegalExpressionException;
import com.kingdee.eas.dynbusiness.expression.VariableContainer;
import com.kingdee.eas.dynbusiness.expression.datameta.Constant;
import com.kingdee.eas.dynbusiness.expression.datameta.Variable;
import java.text.ParseException;
import java.util.Collection;
import java.util.List;

public class ExpressionEvaluator {
    public static String compile(String expression) throws IllegalExpressionException {
        return ExpressionEvaluator.compile(expression, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String compile(String expression, Collection variables) throws IllegalExpressionException {
        if (expression == null) {
            throw new RuntimeException("\u8868\u8fbe\u5f0f\u4e3a\u7a7a");
        }
        ExpressionExecutor ee = new ExpressionExecutor();
        try {
            if (variables != null && variables.size() > 0) {
                for (Variable var : variables) {
                    VariableContainer.addVariable(var);
                }
            }
            List expTokens = ee.analyze(expression);
            expTokens = ee.compile(expTokens);
            String string = ee.tokensToString(expTokens);
            return string;
        }
        finally {
            VariableContainer.removeVariableMap();
        }
    }

    public static Object evaluate(String expression) {
        return ExpressionEvaluator.evaluate(expression, null);
    }

    public static Object evaluate(String expression, Collection variables) {
        if (expression == null) {
            return null;
        }
        ExpressionExecutor ee = new ExpressionExecutor();
        try {
            if (variables != null && variables.size() > 0) {
                for (Variable var : variables) {
                    VariableContainer.addVariable(var);
                }
            }
            List expTokens = ee.analyze(expression);
            expTokens = ee.compile(expTokens);
            Constant constant = ee.execute(expTokens);
            Object object = constant.toJavaObject();
            return object;
        }
        catch (IllegalExpressionException e) {
            throw new RuntimeException("\u8868\u8fbe\u5f0f\uff1a\"" + expression + "\" \u6267\u884c\u5f02\u5e38");
        }
        catch (ParseException e) {
            throw new RuntimeException("\u8868\u8fbe\u5f0f\uff1a\"" + expression + "\" \u6267\u884c\u5f02\u5e38");
        }
        finally {
            VariableContainer.removeVariableMap();
        }
    }

    public static void addVarible(Variable variable) {
        VariableContainer.addVariable(variable);
    }

    public static void addVaribles(Collection variables) {
        if (variables != null && variables.size() > 0) {
            for (Variable var : variables) {
                VariableContainer.addVariable(var);
            }
        }
    }
}

