/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.expression.function;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FunctionLoader {
    private static final String FILE_NAME = "com/kingdee/eas/dynbusiness/expression/IKExpression.cfg.xml";
    static final Logger logger = Logger.getLogger(FunctionLoader.class);
    private static FunctionLoader single = new FunctionLoader();
    private HashMap functionMap = new HashMap();

    private FunctionLoader() {
        try {
            this.init();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = null;
        InputStream in = null;
        try {
            in = FunctionLoader.class.getClassLoader().getResourceAsStream(FILE_NAME);
            doc = builder.parse(in);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        NodeList rootNodes = doc.getElementsByTagName("function-configuration");
        if (rootNodes.getLength() < 1) {
            return;
        }
        rootNodes = rootNodes.item(0).getChildNodes();
        for (int i = 0; i < rootNodes.getLength(); ++i) {
            Node beanNode = rootNodes.item(i);
            if (!beanNode.getNodeName().equals("bean")) continue;
            String className = beanNode.getAttributes().getNamedItem("class").getNodeValue();
            Class<?> _class = Class.forName(className);
            NodeList subNodes = beanNode.getChildNodes();
            List constructorArgs = null;
            HashSet<Function> functions = new HashSet<Function>();
            for (int j = 0; j < subNodes.getLength(); ++j) {
                Node subNode = subNodes.item(j);
                if (subNode.getNodeName().equals("constructor-args") && constructorArgs == null) {
                    constructorArgs = this.parseConstructorArgs(subNode);
                    continue;
                }
                if (!subNode.getNodeName().equals("function") || functions.add(this.parseFunctions(subNode))) continue;
                throw new SAXException("\u65b9\u6cd5\u540d\u4e0d\u80fd\u91cd\u590d");
            }
            if (functions.size() <= 0) continue;
            Object ins = null;
            if (constructorArgs == null || constructorArgs.size() <= 0) {
                ins = _class.newInstance();
            } else {
                Class[] cs = this.getParameterTypes(constructorArgs);
                Object[] ps = this.getParameterValues(constructorArgs);
                Constructor<?> c = _class.getConstructor(cs);
                ins = c.newInstance(ps);
            }
            for (Function f : functions) {
                Method m = _class.getMethod(f.methodName, this.getParameterTypes(f.types));
                this.functionMap.put(f.name, new FunctionInvoker(m, ins));
            }
        }
    }

    private List parseConstructorArgs(Node argRootNode) {
        NodeList argsNode = argRootNode.getChildNodes();
        ArrayList<Parameter> args = new ArrayList<Parameter>();
        for (int i = 0; i < argsNode.getLength(); ++i) {
            Node argNode = argsNode.item(i);
            if (!argNode.getNodeName().equals("constructor-arg")) continue;
            String type = argNode.getAttributes().getNamedItem("type").getNodeValue();
            String value = argNode.getNodeValue();
            args.add(new Parameter(type, value));
        }
        return args;
    }

    private Function parseFunctions(Node funRootNode) {
        String name = funRootNode.getAttributes().getNamedItem("name").getNodeValue();
        String methodName = funRootNode.getAttributes().getNamedItem("method").getNodeValue();
        Function f = new Function(name, methodName);
        NodeList argsNode = funRootNode.getChildNodes();
        for (int i = 0; i < argsNode.getLength(); ++i) {
            Node argNode = argsNode.item(i);
            if (!argNode.getNodeName().equals("parameter-type")) continue;
            f.addType(argNode.getFirstChild().getNodeValue());
        }
        return f;
    }

    private Class[] getParameterTypes(List parameters) {
        if (parameters == null) {
            return null;
        }
        Class[] types = new Class[parameters.size()];
        for (int i = 0; i < parameters.size(); ++i) {
            types[i] = ((Parameter)parameters.get((int)i)).type;
        }
        return types;
    }

    private Object[] getParameterValues(List parameters) {
        if (parameters == null) {
            return null;
        }
        Object[] values = new Object[parameters.size()];
        for (int i = 0; i < parameters.size(); ++i) {
            values[i] = ((Parameter)parameters.get((int)i)).value;
        }
        return values;
    }

    public static void addFunction(String functionName, Object instance, Method method) {
        if (functionName == null || instance == null || method == null) {
            return;
        }
        HashMap hashMap = FunctionLoader.single.functionMap;
        FunctionLoader functionLoader = single;
        functionLoader.getClass();
        hashMap.put(functionName, functionLoader.new FunctionInvoker(method, instance));
    }

    public static Method loadFunction(String functionName) throws NoSuchMethodException {
        FunctionInvoker f = (FunctionInvoker)FunctionLoader.single.functionMap.get(functionName);
        if (f == null) {
            throw new NoSuchMethodException();
        }
        return f.method;
    }

    public static Object invokeFunction(String functionName, Object[] parameters) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        FunctionInvoker f = (FunctionInvoker)FunctionLoader.single.functionMap.get(functionName);
        if (f == null) {
            throw new NoSuchMethodException();
        }
        return f.invoke(parameters);
    }

    private class FunctionInvoker {
        Method method;
        Object instance;

        public FunctionInvoker(Method m, Object i) {
            this.method = m;
            this.instance = i;
        }

        public Object invoke(Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
            return this.method.invoke(this.instance, args);
        }
    }

    private class Function {
        String name;
        String methodName;
        List types;

        public Function(String _name, String _methodName) {
            if (_name == null || _methodName == null) {
                throw new IllegalArgumentException();
            }
            this.name = _name;
            this.methodName = _methodName;
            this.types = new ArrayList();
        }

        public void addType(String type) {
            this.types.add(new Parameter(type));
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Function other = (Function)obj;
            return this.name.equals(other.name);
        }
    }

    private class Parameter {
        Class type;
        Object value;

        public Parameter(String _type, String _value) {
            try {
                this.type = this.getTypeClass(_type);
                Constructor c = this.type.getConstructor(String.class);
                this.value = c.newInstance(_value);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }

        public Parameter(String _type) {
            try {
                this.type = this.getTypeClass(_type);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }

        private Class getTypeClass(String _type) throws ClassNotFoundException {
            if ("boolean".equals(_type)) {
                return Boolean.TYPE;
            }
            if ("byte".equals(_type)) {
                return Byte.TYPE;
            }
            if ("char".equals(_type)) {
                return Character.TYPE;
            }
            if ("double".equals(_type)) {
                return Double.TYPE;
            }
            if ("float".equals(_type)) {
                return Float.TYPE;
            }
            if ("int".equals(_type)) {
                return Integer.TYPE;
            }
            if ("long".equals(_type)) {
                return Long.TYPE;
            }
            if ("short".equals(_type)) {
                return Short.TYPE;
            }
            return Class.forName(_type);
        }
    }
}

