/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IPurchaseOrgUnit;
import com.kingdee.eas.basedata.org.IQualityOrgUnit;
import com.kingdee.eas.basedata.org.ISaleOrgUnit;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.ITransportOrgUnit;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitCollection;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.QualityOrgUnitCollection;
import com.kingdee.eas.basedata.org.QualityOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitCollection;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.TransportOrgUnitCollection;
import com.kingdee.eas.basedata.org.TransportOrgUnitFactory;
import com.kingdee.eas.basedata.org.service.OrgCommonUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.apache.log4j.Logger;

public final class OrgUnitUtil {
    static final Logger logger = Logger.getLogger(OrgUnitUtil.class);

    public static boolean isCallerGuiClient(int callerNodeType) {
        return 1 == callerNodeType;
    }

    public static boolean isAppServer(int callerNodeType) {
        return 3 == callerNodeType;
    }

    public static OrgUnitCollection getAuthOrgByPermItem(Context context, OrgType orgType, String permItem) throws BOSException, EASBizException {
        int callNodeType = context == null ? 1 : 3;
        return OrgUnitUtil.getAuthOrgByPermItem(context, orgType, permItem, callNodeType);
    }

    public static OrgUnitCollection getAuthOrgByPermItem(Context context, OrgType orgType, String permItem, int nodeType) throws BOSException, EASBizException {
        FullOrgUnitInfo fullInfo = null;
        OrgUnitCollection collection = new OrgUnitCollection();
        if (orgType == null) {
            return null;
        }
        ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)orgType));
        IPermission permission = (IPermission)BusinessProcessUtil.getBizInterface((Context)(OrgUnitUtil.isAppServer(nodeType) ? context : null), PermissionFactory.class);
        Object userPK = OrgUnitUtil.isCallerGuiClient(nodeType) ? new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()) : context.getCaller();
        FullOrgUnitCollection result = permission.getAuthorizedOrg(userPK, orgType, (IObjectPK)treePK, permItem);
        for (int i = 0; i < result.size(); ++i) {
            fullInfo = result.get(i);
            collection.add((OrgUnitInfo)fullInfo);
        }
        return collection;
    }

    public static OrgUnitCollection getOrgUnitInfosByType(Context ctx, OrgUnitCollection orgs, OrgType orgType, int nodeType) {
        OrgUnitCollection results = new OrgUnitCollection();
        if (orgs == null || orgs.size() == 0) {
            return null;
        }
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (int i = 0; i < orgs.size(); ++i) {
            keys.add(orgs.get(i).getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", keys, CompareType.INCLUDE));
        if (!orgType.equals((Object)OrgType.Admin)) {
            filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Boolean(true), CompareType.EQUALS));
        }
        view.setFilter(filter);
        try {
            switch (orgType.getValue()) {
                case 0: {
                    IAdminOrgUnit iAdmin = (IAdminOrgUnit)BusinessProcessUtil.getBizInterface((Context)(OrgUnitUtil.isAppServer(nodeType) ? ctx : null), AdminOrgUnitFactory.class);
                    AdminOrgUnitCollection collection = iAdmin.getAdminOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        for (int i = 0; i < collection.size(); ++i) {
                            results.add((OrgUnitInfo)collection.get(i));
                        }
                    }
                    return results;
                }
                case 1: {
                    ICompanyOrgUnit iCompany = (ICompanyOrgUnit)BusinessProcessUtil.getBizInterface((Context)(OrgUnitUtil.isAppServer(nodeType) ? ctx : null), CompanyOrgUnitFactory.class);
                    CompanyOrgUnitCollection collection = iCompany.getCompanyOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        for (int i = 0; i < collection.size(); ++i) {
                            results.add((OrgUnitInfo)collection.get(i));
                        }
                    }
                    return results;
                }
                case 2: {
                    ISaleOrgUnit iSale = (ISaleOrgUnit)BusinessProcessUtil.getBizInterface((Context)(OrgUnitUtil.isAppServer(nodeType) ? ctx : null), SaleOrgUnitFactory.class);
                    SaleOrgUnitCollection collection = iSale.getSaleOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        for (int i = 0; i < collection.size(); ++i) {
                            results.add((OrgUnitInfo)collection.get(i));
                        }
                    }
                    return results;
                }
                case 3: {
                    IPurchaseOrgUnit iPurchase = (IPurchaseOrgUnit)BusinessProcessUtil.getBizInterface((Context)(OrgUnitUtil.isAppServer(nodeType) ? ctx : null), PurchaseOrgUnitFactory.class);
                    PurchaseOrgUnitCollection collection = iPurchase.getPurchaseOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        for (int i = 0; i < collection.size(); ++i) {
                            results.add((OrgUnitInfo)collection.get(i));
                        }
                    }
                    return results;
                }
                case 4: {
                    IStorageOrgUnit iStorage = (IStorageOrgUnit)BusinessProcessUtil.getBizInterface((Context)(OrgUnitUtil.isAppServer(nodeType) ? ctx : null), StorageOrgUnitFactory.class);
                    StorageOrgUnitCollection collection = iStorage.getStorageOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        for (int i = 0; i < collection.size(); ++i) {
                            results.add((OrgUnitInfo)collection.get(i));
                        }
                    }
                    return results;
                }
                case 24: {
                    ITransportOrgUnit iTransport = (ITransportOrgUnit)BusinessProcessUtil.getBizInterface((Context)(OrgUnitUtil.isAppServer(nodeType) ? ctx : null), TransportOrgUnitFactory.class);
                    TransportOrgUnitCollection collection = iTransport.getTransportOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        for (int i = 0; i < collection.size(); ++i) {
                            results.add((OrgUnitInfo)collection.get(i));
                        }
                    }
                    return results;
                }
                case 32: {
                    IQualityOrgUnit iQuality = (IQualityOrgUnit)BusinessProcessUtil.getBizInterface((Context)(OrgUnitUtil.isAppServer(nodeType) ? ctx : null), QualityOrgUnitFactory.class);
                    QualityOrgUnitCollection collection = iQuality.getQualityOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        for (int i = 0; i < collection.size(); ++i) {
                            results.add((OrgUnitInfo)collection.get(i));
                        }
                    }
                    return results;
                }
            }
            Iterator iter = keys.iterator();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("*");
            while (iter.hasNext()) {
                String orgId = (String)iter.next();
                results.add(OrgCommonUtils.getOrgUnitInfo((Context)(OrgUnitUtil.isAppServer(nodeType) ? ctx : null), (String)orgId, (OrgType)orgType, (SelectorItemCollection)selector));
            }
            return results;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    public static OrgUnitCollection getOrgUnitInfosByType(Context ctx, OrgUnitCollection orgs, OrgType orgType) {
        OrgUnitCollection results = new OrgUnitCollection();
        if (orgs == null || orgs.size() == 0) {
            return null;
        }
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (int i = 0; i < orgs.size(); ++i) {
            keys.add(orgs.get(i).getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", keys, CompareType.INCLUDE));
        if (!orgType.equals((Object)OrgType.Admin)) {
            filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Boolean(true), CompareType.EQUALS));
        }
        view.setFilter(filter);
        try {
            switch (orgType.getValue()) {
                case 0: {
                    IAdminOrgUnit iAdmin = (IAdminOrgUnit)BusinessProcessUtil.getBizInterface(ctx, AdminOrgUnitFactory.class);
                    AdminOrgUnitCollection collection = iAdmin.getAdminOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        for (int i = 0; i < collection.size(); ++i) {
                            results.add((OrgUnitInfo)collection.get(i));
                        }
                    }
                    return results;
                }
                case 1: {
                    ICompanyOrgUnit iCompany = (ICompanyOrgUnit)BusinessProcessUtil.getBizInterface(ctx, CompanyOrgUnitFactory.class);
                    CompanyOrgUnitCollection collection = iCompany.getCompanyOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        for (int i = 0; i < collection.size(); ++i) {
                            results.add((OrgUnitInfo)collection.get(i));
                        }
                    }
                    return results;
                }
                case 2: {
                    ISaleOrgUnit iSale = (ISaleOrgUnit)BusinessProcessUtil.getBizInterface(ctx, SaleOrgUnitFactory.class);
                    SaleOrgUnitCollection collection = iSale.getSaleOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        for (int i = 0; i < collection.size(); ++i) {
                            results.add((OrgUnitInfo)collection.get(i));
                        }
                    }
                    return results;
                }
                case 3: {
                    IPurchaseOrgUnit iPurchase = (IPurchaseOrgUnit)BusinessProcessUtil.getBizInterface(ctx, PurchaseOrgUnitFactory.class);
                    PurchaseOrgUnitCollection collection = iPurchase.getPurchaseOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        for (int i = 0; i < collection.size(); ++i) {
                            results.add((OrgUnitInfo)collection.get(i));
                        }
                    }
                    return results;
                }
                case 4: {
                    IStorageOrgUnit iStorage = (IStorageOrgUnit)BusinessProcessUtil.getBizInterface(ctx, StorageOrgUnitFactory.class);
                    StorageOrgUnitCollection collection = iStorage.getStorageOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        for (int i = 0; i < collection.size(); ++i) {
                            results.add((OrgUnitInfo)collection.get(i));
                        }
                    }
                    return results;
                }
                case 24: {
                    ITransportOrgUnit iTransport = (ITransportOrgUnit)BusinessProcessUtil.getBizInterface(ctx, TransportOrgUnitFactory.class);
                    TransportOrgUnitCollection collection = iTransport.getTransportOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        for (int i = 0; i < collection.size(); ++i) {
                            results.add((OrgUnitInfo)collection.get(i));
                        }
                    }
                    return results;
                }
                case 32: {
                    IQualityOrgUnit iQuality = (IQualityOrgUnit)BusinessProcessUtil.getBizInterface(ctx, QualityOrgUnitFactory.class);
                    QualityOrgUnitCollection collection = iQuality.getQualityOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        for (int i = 0; i < collection.size(); ++i) {
                            results.add((OrgUnitInfo)collection.get(i));
                        }
                    }
                    return results;
                }
            }
            Iterator iter = keys.iterator();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("*");
            while (iter.hasNext()) {
                String orgId = (String)iter.next();
                results.add(OrgCommonUtils.getOrgUnitInfo((Context)ctx, (String)orgId, (OrgType)orgType, (SelectorItemCollection)selector));
            }
            return results;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

